# -*- coding: utf-8 -*- 
import json 
import os  
from io_utils import sclear, sinput, sprint

def load_game_data(filename):     
    """Загрузка данных игры из JSON файла"""     
    try:         
        with open(filename, 'r', encoding='utf-8') as file:             
            data = json.load(file)         # Преобразуем список в словарь для быстрого доступа по ключу         
            game_data = {}         
            for item in data:             
                if len(item) >= 2:                 
                    key = item[0]                 
                    content = item[1]                 
                    game_data[key] = content         
            return game_data
    except FileNotFoundError:         
        sprint(f"❌ Файл {filename} не найден!")         
        return {}     
    except json.JSONDecodeError:         
        sprint(f"❌ Ошибка чтения JSON файла {filename}!")         
        return {}  
        
def display_paragraph(paragraph_data):     
    """Отображение параграфа с заголовком и содержанием"""     
    if not paragraph_data:         
        return 
    title = paragraph_data.get('title', '')     
    content = paragraph_data.get('content', '')          
    if title:         
        sprint(f"{'='*50}")         
        sprint(f"📖 {title}")         
        sprint(f"{'='*50}")          
    if content:         
        sprint(f"{content}")  
        
def get_available_choices(paragraph_data):     
    """Получение доступных вариантов выбора из параграфа"""     
    choices = []     
    links = paragraph_data.get('links', [])          
    for i, link in enumerate(links):         
        if len(link) >= 2:             
            link_type = link[0]             
            link_data = link[1]             
            title = link_data.get('title', f'Вариант {i+1}')             
            target = link_data.get('target', '')             
            choices.append((i+1, title, target))          
    return choices  
            
def show_choices(choices):     
    """Отображение вариантов выбора"""     
    if not choices:         
        sprint("⚠️ Нет доступных вариантов выбора.")         
        return          
    sprint(f"{'─'*30}")     
    sprint("📝 Варианты:")     
    for num, title, target in choices:         
        sprint(f"  [{num}] {title}.")     
    sprint(f"{'─'*30}")  
        
special_menu = ['exit','save','load']
        
def get_user_choice(choices):     
    """Получение выбора от пользователя"""     
    if not choices:         
        return None          
    while True:         
        try:             
            choice = sinput("🎮 Ваш выбор (номер или 'exit'): ").strip().lower()
            if choice in special_menu:                 
                return choice                          
            if choice.isdigit():                 
                choice_num = int(choice)                 
                if 1 <= choice_num <= len(choices):                     
                    return choices[choice_num - 1][2]  # Возвращаем target                 
                else:                     
                    sprint(f"⚠️ Пожалуйста, введите число от 1 до {len(choices)}")             
            else:                 # Проверяем, может быть пользователь ввел ключевое слово                 
                for num, title, target in choices:                     
                    if choice in title.lower():                         
                        return target                 
                    sprint("⚠️ Введите номер варианта или 'exit'")                          
        except KeyboardInterrupt:             
            sprint("👋 Выход из игры...")             
            return 'exit'         
        except Exception as e:             
            sprint(f"⚠️ Ошибка: {e}")  