﻿import sys
import json
import argparse
from story_player import load_game_data, display_paragraph, get_available_choices, show_choices, get_user_choice  
from spider import SpiderRobotSimulator  
from io_utils import sclear, sinput, sprint, init_sumulator, finish_gameio
from pathlib import Path

#Основной скрипт запуска игры.
curr_dir = str(Path(__file__).parent)

# Состояние игры
game_state = {
    "current_key": "start",
    "score": 0
}

# 1. Сохранение
def save_game(state, filename=curr_dir+"/user/savegame.json"):
    with open(filename, 'w', encoding='utf-8') as f: # 'w' - запись
        json.dump(state, f) # Сохраняем словарь в файл
    print(f"Игра сохранена в {filename}")

# 2. Загрузка
def load_game(filename=curr_dir+"/user/savegame.json"):
    try:
        with open(filename, 'r', encoding='utf-8') as f: # 'r' - чтение
            state = json.load(f) # Загружаем данные из файла
        print(f"Игра загружена из {filename}")
        return state
    except FileNotFoundError:
        print("Файл сохранения не найден, начинаем новую игру.")
        return None # Возвращаем None, если файла нет

def play_game(game_data, start_key='start'):     
    """Основной игровой цикл"""     
    current_key = start_key          
    sprint("🚀 Запуск игры...")     
    sprint("Введите `exit` для выхода, `save`/`load` для сохранения и загрузки")
    sinput("Нажмите ввод для продолжения")
    special_menu = ['exit','save','load']
    while True:         # Получаем данные текущего параграфа         
        paragraph_data = game_data.get(current_key)
        game_state["current_key"] = current_key
        if not paragraph_data:             
            sprint(f"❌ Параграф '{current_key}' не найден!")             
            break                  # Очищаем консоль и показываем параграф         
        sclear()         
        
        if '_game' in current_key:
            while True:
                simulator = SpiderRobotSimulator(paragraph_data["content"])
                res_game = simulator.run_session()
                if res_game:
                    break
                else:
                    sinput(f"Нажмите ВВОД, чтобы повторить попытку...")
        else:
            display_paragraph(paragraph_data)                  
        # Проверяем, есть ли контент (если нет - это может быть конец)         
        if not paragraph_data.get('content', '').strip():             
            sprint("🎉 Конец истории!")             
            break                  
        # Получаем доступные варианты         
        choices = get_available_choices(paragraph_data)                  
        # Если нет вариантов - конец игры         
        if not choices:             
            sprint("🏁 История завершена!")             
            break                  
        # Показываем варианты и получаем выбор         
        show_choices(choices)         
        next_key = get_user_choice(choices)                  
        # Обработка выхода         
        if next_key in special_menu:
            if next_key == 'exit':             
                sprint("👋 Выход из игры...")             
                break
            elif next_key == 'save':             
                sprint("Сохранение игры...")
                save_game(game_state)    
                sinput(f"Нажмите ВВОД для продолжения")
                continue
            elif next_key == 'load':             
                sprint("Загрузка игры...")
                new_game_state = load_game()   
                current_key = new_game_state["current_key"]               
                sinput(f"Нажмите ВВОД для продолжения")
                continue
        # Переход к следующему параграфу         
        if next_key in game_data:             
            current_key = next_key         
        else:
            sprint(game_data)            
            sprint(f"⚠️ Параграф '{next_key}' не найден!")             
        #Возвращаемся к текущему параграфу             
        #input("Нажмите Enter для продолжения...")

def main():  
    parser = argparse.ArgumentParser(description='Нейромастер. Часть 2')
    print(f"Нейромастер. Часть 2")
    
    
    # Optional argument with a default value
    parser.add_argument('--plain', action='store_true', help='Использовать простую консоль')
    parser.add_argument('--wx', action='store_true', help='Использовать wx-виджеты')
    
    args = parser.parse_args()
    
    try:  
        # Инициализация ввода-вывода  
        init_sumulator(args.plain,False,True,args.wx,curr_dir+"/user/")
        # Название файла с данными игры     
        game_file = curr_dir+"/gen/story.mdg.model2.json"          
        # Загружаем данные игры     
        sprint(f"📂 Загрузка игры из файла: {game_file}")     
        game_data = load_game_data(game_file)
        if not game_data:         
            sprint("❌ Не удалось загрузить данные игры.")         
            return          
        sprint(f"✅ Загружено {len(game_data)} параграфов")          
        # Запускаем игру     
        play_game(game_data)          
        sinput("🎮 Спасибо за игру! Нажмите ввод для завершения" );
        finish_gameio()
        
    except Exception as e:  
        print(f"Ошибка запуска игры: {e}")  
        sys.exit(1)

if __name__ == "__main__":  
    main()  