--luacheck: no self
local lang = require "morph/lang-ru"
require "parser/mp"
require "parser/mplib"
local mp = _'@metaparser'

std.mod_init(
function()
mp:init(lang)
end)
game.dsc = function()
p ([[МЕТАПАРСЕР3 Версія: ]]..mp.version.."^")
p [[http://instead-hub.github.io^^
Калі вам патрэбна даведка пра гульню, набярыце "дапамога".
^]]
end
-- local utf = mp.utf

_'@all'.word = -"ўсё|усё/~од"

_'@darkness'.word = -"цемра,цямрэча,цемрадзь"
_'@darkness'.before_Any = "Поўная, абсалютная цемрадзь."
_'@darkness':attr 'persist'

_'@n_to'.word = -"поўнач";
_'@ne_to'.word = -"паўночны ўсход";
_'@e_to'.word = -"усход,ўсход";
_'@se_to'.word = -"паўднёвы ўсход";
_'@s_to'.word = -"поўдзень";
_'@sw_to'.word = -"паўднёвы захад";
_'@w_to'.word = -"захад";
_'@nw_to'.word = -"паўночны захад";
_'@u_to'.word = -"наверх,уверх,ўверх,верх,угору,ўгору,угару,ўгару,дагары";
_'@d_to'.word = -"уніз,ўніз,ніз,долу";
_'@out_to'.word = -"вонкі,выхад,выйсці,выйсце,назад";
_'@in_to'.word = -"усярэдзіну,ўсярэдзіну,уваход,ўваход,увайсці,ўвайсці"

mp.shorten = {
["н"] = "поўнач";
["пн"] = "поўнач";
["у"] = "усход";
["ус"] = "усход";
["з"] = "захад";
["зах"] = "захад";
["д"] = "поўдзень";
["пд"] = "поўдзень";
["ну"] = "паўночны ўсход";
["пну"] = "паўночны ўсход";
["ду"] = "паўднёвы ўсход";
["пду"] = "паўднёвы ўсход";
["дз"] = "паўднёвы захад";
["пдз"] = "паўднёвы захад";
["нз"] = "паўночны захад";
["ун"] = "уніз";
["ув"] = "уверх";
["уг"] = "угору";
}

mp.shorten_expert = {
["і"] = "інвентар";
["інв"] = "інвентар";
["ч"] = "чакаць";
["чак"] = "чакаць";
["агл"] = "агледзець";
["укл"] = "уключыць";
["выкл"] = "выключыць";
["гл"] = "глядзець";
["ува"] = "увайсці";
["вы"] = "выйсці";
}

function mp:skip_filter(w)
for _, v in ipairs(w) do
if v == 'не' or v == 'акрамя' or v == 'замест' then
return false
end
end
return true
end

local function endswith(w, t)
return not not w:find(t..'$')
end

function mp:verb_filter(w)
if #w > 1 then
return true
end
local utf = mp.utf
local verb = w[1]
local t = utf.chars(w[1])
if endswith(verb, 'ся') or endswith(verb, 'сь') or endswith(verb, 'те') then
local len = #verb
len = len - utf.bb(verb, len)
len = len - utf.bb(verb, len)
verb = verb:sub(1, len)
end
if endswith(verb, 'и') or endswith(verb, 'ь') then
return true
end
local t = utf.chars(verb)
local a = { ['а'] = true, ['е'] = true, ['и'] = true,
['о'] = true, ['у'] = true, ['ы'] = true,
['ю'] = true, ['я'] = true };
local len = #t
if len >= 2 and a[t[len - 1]] and t[len] == 'й' then -- or a[t[len]] then
return true
end
return false
end

_'@compass'.before_Default = function()
p('"{#First}" гэта кірунак. {#Firstit/вн} нельга ', mp.parsed[1], ".")
end

function mp.msg.SCORE(d)
if d > 0 then
pn ("{$fmt em|(Рахунак павялічыўся на ", d, ")}")
else
pn ("{$fmt em|(Рахунак павялічыўся на ", d, ")}")
end
end
mp.door.word = -"дзверы/мн";
mp.msg.TITLE_SCORE = function()
if mp.maxscore then
pr ("Рахунак: ", mp.score, "/", mp.maxscore)
else
pr ("Рахунак: ", mp.score)
end
end
mp.msg.TITLE_TURNS = function()
pr ("Хады: ", game:time() - 1)
end
mp.msg.YES = "Так"
mp.msg.WHEN_DARK = "Поўная цемра."
mp.msg.UNKNOWN_THEDARK = "Магчыма, гэта таму, што ў цемры нічога не відно?"
mp.msg.COMPASS_NOWAY = "Гэты шлях недаступны."
mp.msg.COMPASS_EXAM_NO = "У гэтым кірунку не бачна нічога незвычайнага."
mp.msg.ENUM = "шт."
mp.msg.CUTSCENE_HELP = "Для працягу націсніце <увод> альбо набярыце {$fmt em|далей}."
if instead.tiny then
mp.msg.CUTSCENE_MORE = "^{$fmt em|(далей)}"
end
mp.msg.DLG_HELP = "Для выбару фразы ўвядзіце лічбу."
mp.msg.NO_ALL = "Гэтае дзеянне нельга ўжыць на ўсё."
mp.msg.DROPPING_ALL = function(w)
pn (iface:em("(кінуць "..w:noun'вн'..")"))
end
mp.msg.TAKING_ALL = function(w)
pn (iface:em("(узяць "..w:noun'вн'..")"))
end
mp.msg.TAKE_BEFORE = function(w)
pn (iface:em("(спачатку ўзяўшы "..w:noun'вн'..")"))
end
mp.msg.DISROBE_BEFORE = function(w)
pn (iface:em("(спачатку зняўшы "..w:noun'вн'..")"))
end

mp.msg.CLOSE_BEFORE = function(w)
pn (iface:em("(спачатку зачыніўшы "..w:noun'вн'..")"))
end

--"знаходзіцца"
mp.msg.SCENE = "{#Me} {#word/знаходзіцца,#me,нст} {#if_has/#here,supporter,на,ў} {#here/пр,2}.";
mp.msg.INSIDE_SCENE = "{#Me} {#word/знаходзіцца,#me,нст} {#if_has/#where,supporter,на,ў} {#where/пр,2}.";
mp.msg.TITLE_INSIDE = "{#if_has/#where,supporter,на,у} {#where/пр,2}";

mp.msg.COMPASS_EXAM = function(dir, ob)
if dir == 'u_to' then
p "Уверсе"
elseif dir == 'd_to' then
p "Унізе"
elseif dir == 'out_to' or dir == 'in_to' then
p "У гэтым кірунку"
else
p "На {#first/пр,2}"
end
if ob:hint'plural' then
p "знаходзяцца"
else
p "знаходзіцца"
end
p (ob:noun(),".")
end

mp.msg.enter = "<увод>"
mp.msg.EMPTY = 'Прабачце?'
mp.msg.UNKNOWN_VERB = function(w)
p ("Незразумелы дзеяслоў ", iface:em(w), ".")
end
mp.msg.UNKNOWN_VERB_HINT = function(w)
p ("Самае падобнае слова: ", iface:em(w), ".")
end
mp.msg.INCOMPLETE = "Трэба дапоўніць сказ."
mp.msg.INCOMPLETE_NOUN = function(w)
if w then
p('Да чаго вы хочаце ўжыць каманду "',w, '"?')
else
p"Да чаго вы хочаце ўжыць каманду?"
end
end

mp.msg.INCOMPLETE_SECOND_NOUN = function(w)
p ('Удакладніце каманду: "',w,'"?')
end

mp.msg.UNKNOWN_OBJ = function(w)
if not w then
p "Пра гэтую рэч тут нічога невядома."
else
p "Пра гэтую рэч тут нічога невядома "
p ("(",w,").")
end
end
mp.msg.NOTHING_OBJ = "Нічога прыдатнага няма."
mp.msg.UNKNOWN_WORD = function(w)
if not w then
p "Фраза не распазнаная."
else
p "Фраза не распазнаная "
p ("(",w,"?).")
end
end
mp.msg.HINT_WORDS = "Імаверна"
mp.msg.AND = "і"
mp.msg.OR = "або"
mp.msg.MULTIPLE = "Тут ёсць"
mp.msg.LIVE_ACTION = function(w)
p (w:It'дт'," гэта не спадабаецца.")
end
mp.msg.NO_LIVE_ACTION = "Дзеянне можна ўжыць толькі да адушаўлёных аб'ектаў."

mp.msg.NOTINV = function(t)
p (lang.cap(t:noun'вн') .. " спачатку трэба ўзяць.")
end
--"апрануты"
mp.msg.HAS_WORN = function(w)
local hint = w:gram().hint
return mp.mrd:word('апрануты/' .. hint)
end
--"адчынены"
mp.msg.HAS_OPEN = function(w)
local hint = w:gram().hint
return mp.mrd:word('адчынены/' .. hint)
end
--"уключаны"
mp.msg.HAS_ON = function(w)
local hint = w:gram().hint
return mp.mrd:word('уключаны/' .. hint)
end
--"свеціцца"
mp.msg.HAS_LIGHT = function(w)
local hint = w:gram().hint
return mp.mrd:word('свеціцца/' .. hint)
end

mp.msg.EXITBEFORE = "Магчыма, {#me/дт} трэба спачатку "..
"{#if_has/#where,supporter,злезці {#so/{#where/рд}}.,пакінуць {#where/вн}.}"

mp.default_Event = "Exam"
mp.default_Verb = "агледзець"

--"даступны"
mp.msg.ACCESS1 = "{#First} адсюль не{#word/даступны,#first}."
mp.msg.ACCESS2 = "{#Second} адсюль не{#word/даступны,#second}."

mp.msg.Look.HEREIS = "Тут знаходзіцца"
mp.msg.Look.HEREARE = "Тут знаходзяцца"
mp.msg.NOROOM = function(w)
if w == std.me() then
p ("У {#me/рд} зашмат рэчаў.")
elseif w:has'supporter' then
p ("На ", w:noun'пр,2', " больш няма месца.")
else
p ("У ", w:noun'пр,2', " больш няма месца.")
end
end
--"уключан"
--"выключан"
mp.msg.Exam.SWITCHSTATE = "{#First} зараз {#if_has/#first,on,{#word/уключан,#first},{#word/выключан,#first}}."

mp.msg.Exam.NOTHING = function(w)
if w:has 'supporter' then
mp:pnoun (w, "На {#first/пр,2}")
else
mp:pnoun (w, "У {#first/пр,2}")
end
p "нічога няма."
end

mp.msg.Exam.CONTENT = function(w, oo)
local single = #oo == 1 and not oo[1]:hint 'plural'
if std.me():where() == w or std.here() == w then
if false then
if single then
p "Тут знаходзіцца"
else
p "Тут знаходзяцца"
end
mp:multidsc(oo)
else
p "{#Me} {#word/бачыць,#me,нст} тут";
mp:multidsc(oo, 'вн')
end
p "."
return
end
if w:has 'supporter' then
mp:pnoun (w, "На {#first/пр,2}")
else
mp:pnoun (w, "У {#first/пр,2}")
end
if single then
p "знаходзіцца"
else
p "знаходзяцца"
end
mp:multidsc(oo)
p "."
end

--"бачыць"
mp.msg.Exam.DEFAULT = "{#Me} не {#word/бачыць,#me,нст} {#vo/{#first/пр}} нічога незвычайнага.";
mp.msg.Exam.SELF = "{#Me} не {#word/бачыць,#me,нст} у сабе нічога незвычайнага.";

--"адчынены"
mp.msg.Exam.OPENED = "{#First} {#word/адчынены,нст,#first}."
--"зачынены"
mp.msg.Exam.CLOSED = "{#First} {#word/зачынены,нст,#first}."
--"знаходзіць"
mp.msg.LookUnder.NOTHING = "{#Me} не {#word/знаходзіць,нст,#me} пад {#first/тв} нічога цікавага."
--"магу"
--"зачынены"
--"трымаць"
--"залазіць"
mp.msg.Enter.ALREADY = "{#Me} ужо {#if_has/#first,supporter,на,ў} {#first/пр,2}."
mp.msg.Enter.INV = "{#Me} не {#word/магчы,#me,нст} зайсці ў тое, что {#word/трымаць,#me,нст} у руках."
mp.msg.Enter.IMPOSSIBLE = "Але ў/на {#first/вн} немагчыма ўвайсці, устаць, сесці ці легчы."
mp.msg.Enter.CLOSED = "{#First} {#word/зачынены,#first}, і {#me} не {#word/магчы,#me,нст} зайсці туды."
mp.msg.Enter.ENTERED = "{#Me} {#word/залазіць,нст,#me} {#if_has/#first,supporter,на,у} {#first/вн}."
mp.msg.Enter.DOOR_NOWHERE = "{#First} нікуды не вядзе."
--"зачынены"
mp.msg.Enter.DOOR_CLOSED = "{#First} {#word/зачынены,#first}."

mp.msg.Walk.ALREADY = mp.msg.Enter.ALREADY
mp.msg.Walk.WALK = "Але {#first} і так знаходзіцца тут."
mp.msg.Walk.NOWHERE = "Куды менавіта?"
mp.msg.Walk.INV = "Але {#first} у {#me/рд} з сабой."

mp.msg.Enter.EXITBEFORE = "Спачатку трэба {#if_has/#where,supporter,злезці {#so/{#where/рд}}.,пакінуць {#where/вн}.}"

mp.msg.Exit.NOTHERE = "Але {#me} зараз не {#if_has/#first,supporter,на,у} {#first/пр,2}."
mp.msg.Exit.NOWHERE = "Але {#me/дт} няма куды выходзіць."
mp.msg.Exit.CLOSED = "Але {#first} {#word/зачынены,#first}."

--"пакідаць"
--"злазіць"
mp.msg.Exit.EXITED = "{#Me} {#if_has/#first,supporter,{#word/злазіць,#me,нст} {#so/{#first/рд}},"..
"{#word/пакідаць,#me,нст} {#first/вн}}."

mp.msg.GetOff.NOWHERE = "Але {#me/дт} няма з чаго злазіць."

mp.msg.Inv.NOTHING = "У {#me/рд} з сабой нічога няма."
mp.msg.Inv.INV = "У {#me/рд} з сабой"

--"адчыняць"
mp.msg.Open.OPEN = "{#Me} {#word/адчыняць,нст,#me} {#first/вн}."
mp.msg.Open.NOTOPENABLE = "{#First/вн} немагчыма адчыніць."
--"адчынены"
mp.msg.Open.WHENOPEN = "{#First/} ужо {#word/адчынены,#first}."
--"замкнёны"
mp.msg.Open.WHENLOCKED = "Падобна, што {#first/} {#word/замкнёны,#first}."

--"зачыняць"
mp.msg.Close.CLOSE = "{#Me} {#word/зачыняць,нст,#me} {#first/вн}."
mp.msg.Close.NOTOPENABLE = "{#First/вн} немагчыма зачыніць."
--"зачыніць"
mp.msg.Close.WHENCLOSED = "{#First/} ужо {#word/зачыніць,#first}."

mp.msg.Lock.IMPOSSIBLE = "{#First/вн} немагчыма замкнуць."
--"зачынены"
mp.msg.Lock.LOCKED = "{#First} ужо {#word/зачынены,#first}."
--"зачыніць"
mp.msg.Lock.OPEN = "Спачатку трэба зачыніць {#first/вн}."
--"падыходзіць"
mp.msg.Lock.WRONGKEY = "{#Second} не {#word/падыходзіць,#second} да замка."
--"замыкаць"
mp.msg.Lock.LOCK = "{#Me} {#word/замыкаць,#me,нст} {#first/вн}."

mp.msg.Unlock.IMPOSSIBLE = "{#First/вн} немагчыма адамкнуць."
--"замкнёны"
mp.msg.Unlock.NOTLOCKED = "{#First} не {#word/замкнёны,#first}."
--"падыходзіць"
mp.msg.Unlock.WRONGKEY = "{#Second} не {#word/падыходзіць,нст,#second} да замка."
--"адмыкаць"
mp.msg.Unlock.UNLOCK = "{#Me} {#word/адмыкаць,#me,нст} {#first/вн}."

mp.msg.Take.HAVE = "У {#me/вн} і так {#firstit} ужо ёсць."
mp.msg.Take.TAKE = "{#Me} {#verb/take} {#first/вн}."
mp.msg.Take.SELF = "{#Me} ёсць у {#me/рд}."
--"знаходзіцца"
mp.msg.Take.WHERE = "Нельга ўзяць тое, {#if_hint/#where,supporter,на,у} чым {#me} {#word/знаходзіцца,#me}."

mp.msg.Take.LIFE = "{#First/дт} гэта наўрадці спадабаецца."
--"замацаваны"
mp.msg.Take.STATIC = "{#First} трывала {#word/замацаваны,#first}."
mp.msg.Take.SCENERY = "{#First/вн} немагчыма ўзяць."

--"апрануць"
mp.msg.Take.WORN = "{#First} {#word/апрануць,#first} на {#firstwhere/вн}."
mp.msg.Take.PARTOF = "{#First} {#if_hint/#first,plural,з'яўляюцца,з'яўляецца} часткай {#firstwhere/рд}."

mp.msg.Remove.WHERE = "{#First} не {#word/знаходзіцца,#first,нст} {#if_has/#second,supporter,на,в} {#second/пр,2}."
--"падняць"
--"выцягнуты"
mp.msg.Remove.REMOVE = "{#First} {#if_has/#second,supporter,{#word/поднят с,#first},"..
"{#word/выцягнуты з,#first}} {#second/рд}."

mp.msg.Drop.SELF = "У {#me/рд} не хопіць спрыту."
mp.msg.Drop.WORN = "{#First/вн} спачатку трэба зняць."
--"змяшчаць"
mp.msg.Insert.INSERT = "{#Me} {#word/змяшчаць,нст,#me} {#first/вн} ў {#second/вн}."
mp.msg.Insert.CLOSED = "{#Second} {#word/зачынены,#second}."
mp.msg.Insert.NOTCONTAINER = "{#Second} не {#if_hint/#second,plural,могуць,можа} што-небудзь змяшчаць."
mp.msg.Insert.WHERE = "Нельга змясціць {#first/вн} ўнутр сябе."
mp.msg.Insert.ALREADY = "Але {#first} ужо і так {#word/знаходзіцца,#first} там."
mp.msg.PutOn.NOTSUPPORTER = "Класці что-небудзь на {#second/вн} бессэнсоўна."
--"класці"
mp.msg.PutOn.PUTON = "{#Me} {#word/класці,нст,#me} {#first/вн} на {#second/вн}."
mp.msg.PutOn.WHERE = "Нельга змясціць {#first/вн} на сябе."

--"кінуты"
mp.msg.Drop.DROP = "{#First} {#word/кінуты,#first}."

mp.msg.ThrowAt.NOTLIFE = "Кідаць {#first/вн} у {#second/вн} бессэнсоўна."
mp.msg.ThrowAt.THROW = "У {#me/рд} не хапае рашучасці кінуць {#first/вн} у {#second/вн}."


mp.msg.Wear.NOTCLOTHES = "Апрануць {#first/вн} немагчыма."
mp.msg.Wear.WORN = "{#First} ужо на {#me/дт}."
--"апранаць"
mp.msg.Wear.WEAR = "{#Me} {#word/апранаць,#me,нст} {#first/вн}."

mp.msg.Disrobe.NOTWORN = "{#First} не на {#me/дт}."
--"здымаць"
mp.msg.Disrobe.DISROBE = "{#Me} {#word/здымаць,#me,нст} {#first/вн}."

mp.msg.SwitchOn.NONSWITCHABLE = "{#First/вн} немагчыма ўключыць."
--"уключаны"
mp.msg.SwitchOn.ALREADY = "{#First} ужо {#word/уключаны,#first}."
--"уключаць"
mp.msg.SwitchOn.SWITCHON = "{#Me} {#word/уключаць,#me,нст} {#first/вн}."

mp.msg.SwitchOff.NONSWITCHABLE = "{#First/вн} немагчыма выключыць."
--"выключаны"
mp.msg.SwitchOff.ALREADY = "{#First} ужо {#word/выключаны,#first}."
--"выключаць"
mp.msg.SwitchOff.SWITCHOFF = "{#Me} {#word/выключаць,#me,нст} {#first/вн}."

--"ядомы"
mp.msg.Eat.NOTEDIBLE = "{#First} не {#word/ядом,#first}, нельга з'есці."
mp.msg.Taste.TASTE = "Ніякага незвычайнага смаку няма."

--"з'ядаць"
mp.msg.Eat.EAT = "{#Me} {#word/з'ядаць,нст,#me} {#first/вн}."
mp.msg.Drink.IMPOSSIBLE = "Выпіць {#first/вн} немагчыма."

mp.msg.Push.STATIC = "{#First/вн} цяжка зрушыць з месца."
mp.msg.Push.SCENERY = "{#First/вн} рухаць немагчыма."
mp.msg.Push.PUSH = "Нічога не адбылося."

mp.msg.Pull.STATIC = "{#First/вн} цяжка зрушыць з месца."
mp.msg.Pull.SCENERY = "{#First/вн} рухаць немагчыма."
mp.msg.Pull.PULL = "Нічога не адбылося."

mp.msg.Turn.STATIC = "{#First/вн} цяжка зрушыць з месца."
mp.msg.Turn.SCENERY = "{#First/вн} рухаць немагчыма."
mp.msg.Turn.TURN = "Нічога не адбылося."

mp.msg.Wait.WAIT = "Мінае трохі часу."

mp.msg.Touch.LIVE = "Не варта даваць волі рукам."
mp.msg.Touch.TOUCH = "Ніякіх незвычайных адчуванняў няма."
mp.msg.Touch.MYSELF = "{#Me} на месцы."

mp.msg.Rub.RUB = "Церці {#first/вн} бессэнсоўна."
mp.msg.Sing.SING = "З такім слыхам і голасам, як у {#me/рд} гэтага лепей не рабіць."

mp.msg.Give.MYSELF = "{#First} и так у {#me/рд} есть."
mp.msg.Give.GIVE = "{#Second/вн} это не заинтересовало."
mp.msg.Show.SHOW = "{#Second/вн} это не впечатлило."

mp.msg.Burn.BURN = "Падпальваць {#first/вн} бессэнсоўна."
mp.msg.Burn.BURN2 = "Падпальваць {#first/вн} {#second/тв} бессэнсоўна."
--"павер"
mp.msg.Wake.WAKE = "Гэта не сон, а ява."
mp.msg.WakeOther.WAKE = "Будзіць {#first/вн} не варта."
mp.msg.WakeOther.NOTLIVE = "Бессэнсоўна будзіць {#first/вн}."

mp.msg.PushDir.PUSH = "Перасоўваць гэта не мае сэнсу."

mp.msg.Kiss.NOTLIVE = "Дзіўнае жаданне."
mp.msg.Kiss.KISS = "{#Firstit/дт} гэта можа не спадабацца."
mp.msg.Kiss.MYSELF = "Ну ўжо не."

mp.msg.Think.THINK = "Выдатная ідэя!"
mp.msg.Smell.SMELL = "Ніякага незвычайнага паху няма."
mp.msg.Smell.SMELL2 = "Пахне як {#first}."

mp.msg.Listen.LISTEN = "Ніякіх незвычайных гукаў няма."
--"прыслухацца"
mp.msg.Listen.LISTEN2 = "{#Me} {#word/прыслухацца,#me,прш} да {#first/дт}. Ніякіх незвычайных гукаў няма."

--"выкапаць"
mp.msg.Dig.DIG = "{#Me} нічога не {#word/выкапаць,#me,прш}."
mp.msg.Dig.DIG2 = "Капаць {#first/вн} бессэнсоўна."
mp.msg.Dig.DIG3 = "Капаць {#first/вн} {#second/тв} бессэнсоўна."

mp.msg.Cut.CUT = "Рэзаць {#first/вн} бессэнсоўна."
mp.msg.Cut.CUT2 = "Рэзаць {#first/вн} {#second/тв} бессэнсоўна."

mp.msg.Tear.TEAR = "ірваць {#first/вн} бессэнсоўна."

mp.msg.Tie.TIE = "Прывязваць {#first/вн} бесэнсоўна."
mp.msg.Tie.TIE2 = "Прывязваць {#first/вн} да {#second/рд} бессэнсоўна."

mp.msg.Blow.BLOW = "Дуць на/у {#first/вн} бессэнсоўна."

mp.msg.Attack.LIFE = "Агрэсія да {#first/рд} неапраўданая."
mp.msg.Attack.ATTACK = "Зух сярод мух, так?"
--"хацець"
mp.msg.Sleep.SLEEP = "{#Me} не {#word/хацець,#me,нст} спаць."
mp.msg.Swim.SWIM = "Для гэтага тут недастаткова вады."
mp.msg.Fill.FILL = "Напаўняць {#first/вн} бессэнсоўна."
--"падскокваць"
mp.msg.Jump.JUMP = "{#Me} дурнавата {#word/падскокваць,#me,нст}."
mp.msg.JumpOver.JUMPOVER = "Скакаць праз {#first/вн} бессэнсоўна."

--"знаходзіць"
mp.msg.Consult.CONSULT = "{#Me} не {#word/знаходзіць,#me,нст} нічога прыдатнага."

--"памахаць"
mp.msg.WaveHands.WAVE = "{#Me} дурнавата {#word/памахаць,прш,#me} рукамі."
mp.msg.Wave.WAVE = "{#Me} дурнавата {#word/памахаць,прш,#me} {#first/тв}."

mp.msg.Talk.SELF = "Гутаркі не атрымалася."
--"ўмець"
mp.msg.Talk.NOTLIVE = "{#First} не {#word/ўмець,#first,нст} размаўляць."
--"адрэагаваць"
mp.msg.Talk.LIVE = "{#First} ніяк не {#word/адрэагаваць,#first}."

mp.msg.Tell.SELF = "Гутаркі не атрымалася."

--"нямы"
mp.msg.Tell.NOTLIVE = "{#First} {#word/нямы,#first}."
--"адрэагаваць"
mp.msg.Tell.LIVE = "{#First} ніяк не {#word/адрэагаваць,#first}."
--"знайшоў"
mp.msg.Tell.EMPTY = "{#Me} не {#word/знайшоў,#me,прш} што сказаць."

--"адказваць"
mp.msg.Ask.NOTLIVE = "Адказу няма."
--"адказаць"
mp.msg.Ask.LIVE = "{#First} не {#word/адказаць,прш,#first}."
--"прыдумаць"
mp.msg.Ask.EMPTY = "{#Me} не {#word/прыдумаць,#me,прш} пра што запытацца."
mp.msg.Ask.SELF = "Добрае пытанне."

--"адказваць"
mp.msg.Answer.NOTLIVE = "Адказу няма."
--"адказаць"
mp.msg.Answer.LIVE = "{#First} не {#word/адказаць,прш,#first}."
--"прыдумаць"
mp.msg.Answer.EMPTY = "{#Me} не {#word/прыдумаць,#me,прш} што адказаць."
mp.msg.Answer.SELF = "Добры адказ."

mp.msg.Yes.YES = "Пытанне было рытарычным."

mp.msg.Use.USE = "Як менавіта?"

--"прадавацца"
mp.msg.Buy.BUY = "{#First} не {#word/прадавацца,нст,#first}."

mp.keyboard_space = '<прабел>'
mp.keyboard_backspace = '<выдаліць>'

mp.msg.verbs.take = -"браць,#me,нст"

mp.msg.GAMEOVER_HELP = [[Каб распачаць гульню яшчэ раз, набярыце рестарт.]];

local function dict(t, hint)
local g = std.split(hint, ",")
for _, v in ipairs(g) do
if t[v] then
return t[v]
end
end
end

function mp:myself(_, hint)
local ww = dict({
["вн"] = { "сябе" };
["дт"] = { "сабе" };
["тв"] = {"сабой" };
["пр"] = { "сабе" };
["рд"] = { "сябе" };
 }, hint)
return ww
end

function mp:it(w, hint)
hint = hint or ''
if w:hint'plural' then
return mp.mrd:noun(-"яны/"..hint)
elseif w:hint'neuter' then
return mp.mrd:noun(-"яно/"..hint)
elseif w:hint'female' then
return mp.mrd:noun(-"яна/"..hint)
end
return mp.mrd:noun(-"ён/"..hint)
end

function mp:synonyms(w, hint)
local nt = {
['яго'] = 'няго';
['ёй'] = 'ёю';
['іх'] = 'іхніх';
}
local t = self:it(w, hint)
return { t, nt[t] }
end

mp.keyboard = {
'А','Б','В','Г','Д','Е','Ё','Ж','З','І','Й',
'К','Л','М','Н','О','П','Р','О','С','Т','У','Ф',
'Х','Ц','Ч','Ш','Ў','Ь','Ы','Ъ','Э','Ю','Я'
}

local function hints(w)
local h = std.split(w, ",")
local ret = {}
for _, v in ipairs(h) do
ret[v] = true
end
return ret
end

function mp:err_noun(noun)
if noun == '*' then return "{$fmt em|<любое слова>}" end
local hint = std.split(noun, "/")
local rc = "{$fmt em|"
if #hint == 2 then
local h = hints(hint[2])
local acc = 'хто/што'
if h["им"] then
acc = 'хто/што'
elseif h["рд"] then
acc = 'каго/чаго'
elseif h["дт"] then
acc = 'каму/чаму'
elseif h["вн"] then
acc = 'каго/што'
elseif h["тв"] then
acc = 'кім/чым'
elseif h["пр"] or h["пр2"] then
acc = 'аб кім/аб чым'
end
rc = rc ..  acc
else
rc = rc .. "хто/што"
end
rc = rc .. "}"
return rc
end

function mp.shortcut.vo(hint)
local w = std.split(mp.mrd.lang.norm(hint))
local utf = mp.utf
local vow = lang.is_vowel
local char = utf.char
local excl = {
["льве"] = true,
["львах"] = true,
["льду"] = true,
["льдах"] = true,
["льне"] = true,
["льнах"] = true,
["лбу"] = true,
["лбах"] = true,
["лжи"] = true,
["лжах"] = true,
["мху"] = true,
["мхах"] = true,
["рву"] = true,
["рвах"] = true,
["ржи"] = true,
["ржах"] = true,
["рту"] = true,
["ртах"] = true,
["мне"] = true,
["что"] = true,
}
w = w[#w]
if mp.utf.len(w) > 2 and
(vow(char(w, 1) == 'у' or vow(char(w, 1) == 'ф') and
not vow(char(w, 2)))) or excl[w] then
return "ува ".. hint
end
return "у ".. hint
end

function mp.shortcut.so(hint)
local so = {
["с"] = true,
["з"] = true,
["ш"] = true,
["ж"] = true,
["л"] = true,
["р"] = true,
["м"] = true,
}

local w = std.split(mp.mrd.lang.norm(hint))
local utf = mp.utf
w = w[#w]
if utf.len(w) > 2 and
((so[utf.char(w, 1)] and
not lang.is_vowel(utf.char(w, 2))) or utf.char(w, 1) == 'щ') then
return "са ".. hint
end
if utf.len(w) > 2 and utf.char(w, 1) == 'л' and utf.char(w, 2) == 'ь' and
not lang.is_vowel(utf.char(w, 2)) then
return "са ".. hint
end
return "з ".. hint
end

function mp:before_Enter(w)
if mp:compass_dir(w) then
mp:xaction("Walk", w)
return
end
return false
end

mp.msg.HELP = function()
p [[{$fmt b|ЯК ГУЛЯЦЬ?}^^

Друкуйце вашы дзеянні ў выглядзе простых сказаў тыпу: дзеяслоў -- назоўнік. Напрыклад:^
> адчыніць дзверы^
> адамкнуць дзверы ключом^
> ісці на поўнач^
> узяць капялюш^
^
Каб зноў убачыць апісанне абстаноўкі, набярыце "агледзець", "агл" або проста націсніце "увод".^
^
Каб агледзець прадмет, набярыце "агледзець кнігу" або проста "кніга".^
^
Паспрабуйце "агледзець сябе" і даведацца, хто вы.^
^
Каб даведацца якія рэчы ў вас з сабой, набярыце "інвентар" або "інв".^
^
Для руху выкарыстоўвайце бакі свету, напрыклад: "ісці на поўнач" або "поўнач" або проста "н" і г.д.
^
Логіка скарачэння поўначы і поўдня такая: поўнач -- ноч, поўдзень -- дзень. Астатняе і так зразумела
^
Вось іншыя скароты для перасоўвання па свеце. Пераважна яны адналітарныя: 
^
"паўночны ўсход" або "ну", "усход" або "у", 
^
"паўднёвы ўсход" або "ду", "поўдзень" або "д", 
^
"паўднёвы захад" або "дз", "захад" або "з", 
^
"паўночны захад" або "нз". 
^
Акрамя бакоў свету можна рухацца "уверх" або "ув" і "уніз" або "ун", "усярэдзіну" і "вонкі".
^
Калі правілы граматыкі вымагаюць напісаць слова на "У" праз у кароткае -- смела рабіце гэта. Гульня вас зразумее. Ну, прынамсі, паспрабуе. 
]]
if not instead.tiny then
p [[^^Вы можаце скарыстацца клавішай "TAB" для аўтадапаўнення ўводу.]]
else
p [[^^Вы можаце скарачаць назвы аб'ектаў.]]
p [[^^Каб захоўваць і загружаць гульню выкарыстоўвайце "захаваць" і "загрузіць".]]
if instead.tiny then
p [[Напрыклад, "захаваць 1".]]
end
p [[Пачаць нанова: "нанова".]]
if instead.reinstead then
p [[^^Таксама даступныя каманды: !restart, !quit, !info, !save, !load і !font <памер>.]]
end
end
end

function mp.token.compass1(_)
return "{noun_obj}/@n_to,compass|{noun_obj}/@ne_to,compass|"..
"{noun_obj}/@e_to,compass|{noun_obj}/@se_to,compass|"..
"{noun_obj}/@s_to,compass|{noun_obj}/@sw_to,compass|"..
"{noun_obj}/@w_to,compass|{noun_obj}/@nw_to,compass"
end

function mp.token.compass2(_)
return "{noun_obj}/@u_to,compass|{noun_obj}/@d_to,compass|{noun_obj}/@in_to,compass|{noun_obj}/@out_to,compass"
end

function mp.shortcut.pref1()
return '[па|пады|за|ува|пра]'
end

function mp.shortcut.pref2()
return '[па|пад|за|у|пра]'
end

function mp.shortcut.pref3()
return 'па|падъ|за|уъ|пра'
end

std.mod_init(function(_)
--акляк. Базавы слоўнік дзеясловаў
Verb { "#Walk",
"ісці,{#pref1}йсці,{#pref1}йдзі,ідзі,бегчы,{#pref2}бегчы,бяж/ы,{#pref2}бяж/ы,іду,йду,устаю,ўстаю,кладуся,саджуся,сядаю,улёгся,уляглося,уляглася,улягліся,усесціся,усеўся,уселася,уселіся,[у|ў|уз|ўз]лез/ці,стаць,увай/сці,увай/дзі,ўвай/сці,ўвай/дзі,пайду"..
"[|{#pref3}]ехаць,едзь,сесці,сядзь,легчы,ляг,кладзіся,улегчыся,ўлегчыся[|у|ў]стаць,[|у|ў]стань[|це],ідзі,бяжы,устань,ўстань,уставай,ўставай,станавіся,кладзіся,садзіся,сядай,укладвайся,ўкладвайся,усаджвайся,ўсаджвайся,[у|ў|уз|ўз]лазь,уваходзь,пайдзі,едзь",
"на {compass1} : Walk",
"на|у|ў|ува|ўва {noun}/вн,scene,enterable : Enter",
"унутр|ўнутр|усярэдзіну|ўсярэдзіну|у сярэдзіну|ў сярэдзіну {noun}/рд,scene,enterable : Enter",
"да {noun}/рд,scene : Walk",
"{compass2}: Walk" }

Verb { "#Exit",
"вый[сці|дзі|ду],сыдзі,сысці,вылез/ці,выха/дзіць,выходзь,зваротна,назад,выбрацца,выбярыся,выбірайся,выбірацца,выходжу,выходзіць,выбіраюся,выбіраецца,[вы|сы]ходзь,вылазь,выбірайся",
"з|са {noun}/рд,scene : Exit",
"у|ў|праз|на {noun}/вн,scene,enterable : Enter",
"?вонкі : Exit" }

Verb { "#Exam",
"[а|раз|пры|пад|па|на]глед[зець|зь|зеў|зься|жу|зім],[|а|па|пры|пра]гляд[зець|зеў|зела|зелі|жу|зім|зі|зіце],зірн[уць|уў|ула|улі|і|іце],агл",
"?на {noun}/вн : Exam",
"?да {noun}/рд : Exam",
" : Look",
"інвентар : Inv",
"~ пад {noun}/тв : LookUnder",
"~ пад {noun}/вн : LookUnder",
"~ у|ў|ува|ўва|на {noun}/пр,2 : Search",
"~ усярэдзін/е|ўсярэдзін/е|унутры|ўнутры {noun}/рд : Search",
"~ у|ў|ува|ўва {noun}/вн : Search",
"~ у|ў|ува|ўва {noun}/пр,2 ?а|?аб|?аба|?пра * : Consult",
"~ ?а|?аб|?аба|?пра * у|ў|ува|ўва {noun}/пр,2 : Consult reverse",
}

Verb { "#Search",
"[|па]шукаць,абшукаць,[|па]шук/ай,абшук/ай,[|па]вывуч/аць,[|па]даслед/ваць,[|па|аб]шныр/ыць,[|па|аб]шнар/ыць,абмац/аць,абшукваю,абшуквае,абшукваюць,вывучаю,вывучае,вывучаюць,даследую,даследуе,даследуюць,абмацваю",
"{noun}/вн : Search",
"у|ў|ува|ўва|на {noun}/пр,2 : Search",
"пад {noun}/тв : LookUnder",
"~ у|ува {noun}/пр,2 ?аб|?аб|?аба|?пра * : Consult",
"~ ?а|?аб|?аба|?пра * в|во {noun}/пр,2 : Consult reverse",
}

Verb { "#Open",
"[|ад|пра|пры|рас|паад|папаад]чын/іць,[|ад|пра|пры|рас|паад|папаад]чын/яць,[|ад|пра|пры|рас|паад|папаад]чын/іў,[|ад|пра|пры|рас|паад|папаад]чын/іла,[|ад|пра|пры|рас|паад|папаад]чын/ілі,[|ад|пра|пры|рас|паад|папаад]чын/яю,[|ад|пра|пры|рас|паад|папаад]чын/яем,[|ад|пра|пры|рас|паад|папаад]чын/яе,[|ад|пра|пры|рас|паад|папаад]чын/яюць,[|ад|пра|пры|рас|паад|папаад]чын/ю,[|ад|пра|пры|рас|паад|папаад]чын/ім,[|пры]адкрыць,[|пры]адкріў,[|пры]адкрыла,[|пры]адкрылі,[|пры]адкрываю,[|пры]адкрываем,[|пры]адкрывае,[|пры]адкрываюць,расхінуць,расхінуў,расхінула,расхінулі,расхінаю,расхінае,расхінаюць,расхіну,расхіне,расхінем,[|раз|ад]гарнуць,[|раз|ад]гарнуў,[|раз|ад]гарнула,[|раз|ад]гарнулі,[|раз|ад]гортваю,[|раз|ад]гортвае,[|раз|ад]гортваюць,[|раз|ад]гортваем,[|раз|ад]гарну,[|раз|ад]горне,[|раз|ад]горнуць,[|раз|ад]горнем,раскрыць,раскрыў,раскрыла,раскрылі,раскрываю,раскрывае,раскрываюць,раскрываем,раскрыю,раскрые,раскрыюць,раскрыем,разнасцежыць,разнасцежыў,разнасцежыла,разнасцежылі,разнасцежваю,разнасцежвае,разнасцежваюць,разнасцежваем,разнасцежу,разнасцежаць,разнасцежым,расплюшчыць,расплюшчыў,расплюшчыла,расплюшчылі,расплюшчваю,расплюшчвае,расплюшчаць,расплюшчым,адплюшчыць,адплюшчыў,адплюшчыла,адплюшчылі,адплюшчваю,адплюшчвае,адплюшчваюць,адплюшчваем,[|ад|пра|пры|рас|паад|папаад]чыняй,[|пры]адкрый,[|пры]адкрывай,расхіні,расхінай,[|раз|ад]гарні,[|раз|ад]гортвай,раскрый,раскрывай,разнасцеж,разнасцежвай,расплюшчы,расплюшчвай,адплюшчы,адплюшчвай",
"{noun}/вн : Open",
"{noun}/вн {noun}/тв,held : Unlock",
"~ {noun}/тв,held {noun}/вн : Unlock reverse",
}

Verb { "#Unlock",
"адамкнуць,адамкнуў,адамкнула,адамкнулі,адмыкаю,адмыкае,адмыкаюць,адмыкаем,адамкну,адамкне,адамкнем,адамкні,адмыкай",
"{noun}/вн {noun}/тв,held : Unlock",
"~ {noun}/тв,held {noun}/вн : Unlock reverse",
}

Verb { "#Close",
"[за|пры]чыніць,[за|пры]чыніў,[за|пры]чыніла,[за|пры]чынілі,[за|пры]чыняю,[за|пры]чыняе,[за|пры]чыняюць,[за|пры]чыняем,[за|пры]чыню,[за|пры]чыняць,[за|пры]чынім,[за|пры]крыць,[за|пры]крыў,[за|пры]крыла,[за|пры]крылі,[за|пры]крываю,[за|пры]крывае,[за|пры]крываюць,[за|пры]крываем,[за|пры]крыю,[за|пры]крые,[за|пры]крыюць,[за|пры]крыем,[з|за]гарнуць,[з|за]гарнуў,[з|за]гарнула,[з|за]гарнулі,[з|за]гортваю,[з|за]гортвае,[з|за]гортваюць,[з|за]гортваем,[з|за]гарну,[з|за]горне,[з|за]горнуць,[з|за]горнем,захінуць,захінуў,захінула,захінулі,захінаю,захінае,захінаюць,захінаем,захіну,захіне,захінем,[з|за]гортваў,[з|за]гортвала,[з|за]гортвалі,[з|за]гортваю,[з|за]гортвае,[з|за]гортваюць,[з|за]гортваем,[з|за]гарну,[з|за]горне,[з|за]горнуць,заплюшчыць,заплюшчыў,заплюшчыла,заплюшчылі,заплюшчваю,заплюшчвае,заплюшчваюць,заплюшчваем,заплюшчу,заплюшчыць,заплюшчым,заплюшчаць,заплюшчваў,заплюшчвала,заплюшчвалі,заплюшчваю,заплюшчвае,заплюшчваюць,заплюшчваем,[за|пры]чыні,[за|пры]чыняй,[за|пры]крый,[за|пры]крывай,[з|за]гарні,[з|за]гортвай,захіні,захінай,заплюшчы,заплюшчвай",
"{noun}/вн : Close",
"{noun}/вн {noun}/тв,held : Lock",
"~ {noun}/вн на {noun}/вн,held : Lock",
"~ {noun}/тв,held {noun}/вн : Lock reverse",
}

Verb { "#Lock",
"замкнуў,замкнула,замкнулі,замыкаю,замыкае,замыкаюць,замыкаем,замкну,замкне,замкнуцць,замкнем,замкнём,замкні,замыкай",
"{noun}/вн {noun}/тв,held : Lock",
"~ {noun}/вн на {noun}/вн,held : Lock",
"~ {noun}/тв,held {noun}/вн : Lock reverse",
}

Verb { "#Inv",
"інвентар/,з сабой",
"Inv" }

function mp.shortcut.pref4()
return '[ |за|пада]'
end

function mp.shortcut.pref5()
return '[ |за|пад]'
end

Verb { "#Take",
"узяць,узяў,узяла,узялі,ўзяў,ўзяла,ўзялі,бяру,бярэ,бяруць,вазьму,возме,возьмуць,возьмем,бяры,вазьміце,ўзяць,ўзяў,ўзяла,ўзялі,бяры,вазьмі,бярэш,дастаць,дастаў,дастала,дасталі,дастаю,дастае,дастаюцць,дастану,дастане,дастануць,дастань,даставай,схапіць,схапіў,схапіла,схапілі,хапаю,хапае,хапаюць,хапаем,схаплю,схопіць,схопяць,схопім,хапай,скрасці,скраў,скрала,скралі,краду,крадзе,крадуць,крадзем,скраду,скрадзе,скрадуць,скрадзем,крадзі,выцягнуць,выцягнуў,выцягнула,выцягнулі,выцягваю,выцягвае,выцягваюць,выцягваем,выцягну,выцягне,выцягнуць,выцягнем,цягні,выцягвай,выбавіць,выбавіў,выбавіла,выбавілі,выбаўляю,выбаўляе,выбаўляюць,выбаўляем,выбаўлю,выбавяць,выбавім,выбаві,выбаўляй,прыхапіць,прыхапіў,прыхапіла,прыхапілі,прыхопліваю,прыхоплівае,прыхопліваюць,прыхопліваем,прыхоплівай",
"{noun}/вн,scene : Take",
"{noun}/вн,scene з|са|у|ў {noun}/рд,inside,holder: Remove",
"~ з|са|у|ў {noun}/рд,inside,holder {noun}/вн,scene: Remove reverse",
}

Verb { "#Insert",
"[у|ў]ваткнуць,[у|ў]ваткнуў,[у|ў]ваткнула,[у|ў]ваткнулі,[у|ў]тыкаў,[у|ў]тыкала,[у|ў]тыкалі,[у|ў]тыкаю,[у|ў]тыкае,[у|ў]тыкаюць,[у|ў]тыкаем,[у|ў]ваткну,[у|ў]ваткне,[у|ў]ваткнуць,[у|ў]ваткнем,[у|ў]тыкай,[у|ў]ставіць,[у|ў]стаўляў,[у|ў]стаўляла,[у|ў]стаўлялі,[у|ў]стаўляю,[у|ў]стаўляе,[у|ў]стаўляюць,[у|ў]стаўляем,[у|ў]стаўлю,[у|ў]ставяць,[у|ў]ставім,[у|ў]стаўляй,[у|ў]класці,[у|ў]кладваў,[у|ў]кладвала,[у|ў]кладвалі,[у|ў]кладваю,[у|ў]кладвае,[у|ў]кладваюць,[у|ў]кладваем,[у|ў]кладу,[у|ў]кладзе,[у|ў]кладуць,[у|ў]кладзем,[у|ў]кладзі,[у|ў]кладвай,[|пра|за]сунуць,[|пра|за]сунуў,[|пра|за]сунула,[|пра|за]сунулі,[|пра|за]соўваю,[|пра|за]соўвае,[|пра|за]соўваюць,[|пра|за]соўваем,[|пра|за]суну,[|пра|за]суне,[|пра|за]сунем,[|пра|за]сунь,[|пра|за]соўвай",
"{noun}/вн,held у|ў|ува|ўва {noun}/вн,inside : Insert",
"~ {noun}/вн,held усярэдзіну {noun}/рд : Insert",
"~ у|ў|ува|ўва {noun}/вн {noun}/вн : Insert reverse",
"~ усярэдзіну {noun}/рд {noun}/вн : Insert reverse",
}

Verb { "#Drop",
"[|па|с]класці,[|па|с]клаў,[|па|с]клала,[|па|с]клалі,[|па|с]кладвалі,кладу,складваю,кладзе,складвае,кладуць,складваюць,кладзем,складваем,кладу,складваю,кладзе,складвае,кладуць,складваюц,кладзем,складваем,пакладу,паскладваю,пакладзе,паскладвае,пакладуць,паскладваюць,пакладзем,паскладваем,кладзі,складвай,[|у|ў|па]ставіў,[|у|ў|па]ставіла,[|у|ў|па]ставілі,[|у|ў]стаўляю,[|у|ў]стаўляе,[|у|ў]стаўляюць,[|у|ў]стаўляем,[|у|ў|па]стаўлю,[|у|ў|па]ставіць,[|у|ў|па]ставяць,[|у|ў|па]ставім,стаў,стаўляй,[|па]садзіў,саджаў,[|па]садзіла,саджала,[|па]садзілі,саджалі,саджаю,саджае,саджаюць,саджаем,[|па]саджу,[|па]садзіць,[|па]садзяць,[|па]садзім,саджай,змясціў,змяшчаў,змясціла,змяшчала,змясцілі,змяшчалі,змяшчаю,змяшчае,змяшчаюць,змяшчаем,змяшчу,змесціць,змесцяць,змесцім,змяшчай,змяшчайце",
"{noun}/вн,held : Drop",
"{noun}/вн,held у|ў|ува|ўва {noun}/вн,inside : Insert",
"~ {noun}/вн,held ўсярэдзіну {noun}/рд : Insert",
"{noun}/вн,held на {noun}/вн : PutOn",
"~ у|ў|ува|ўва {noun}/вн {noun}/вн : Insert reverse",
"~ ўсярэдзіну {noun}/рд {noun}/вн : Insert reverse",
"~ на {noun}/вн {noun}/вн : PutOn reverse",
}

Verb {
"#ThrowAt",
"[|вы]кінуць,[|вы]кідаў,[|вы]кідала,[|вы]кідалі,[|вы]кідаю,[|вы]кідае,[|вы]кідаюць,[|вы]кідаем,[|вы]кіну,[|вы]кіне,[|вы]кінем,[|вы]кідвай,[|вы]кідваў,[|вы]кідвала,[|вы]кідвалі,[|вы]кідваю,[|вы]кідввае,[|вы]кідваюць,[|вы]кідваем,[|вы]кідвайце,[|вы]кідаць,[|вы]кідаў,[|вы]кідала,[|вы]кідалі,[|вы]кідаю,[|вы]кідае,[|вы]кідаюць,[|вы]кідаем,[|вы|за]шпурнуць,[|вы|за]шпурнуў,[|вы|за]шпурнула,[|вы|за]шпурнулі,шпурляю,шпурляе,шпурляюць,шпурляем,[|вы|за]шпурну,[|вы|за]шпурне,[|вы|за]шпурнем,шпурляў,шпурляла,шпурлялі,шпурляй",
"{noun}/вн,held : Drop",
"{noun}/вн,held у|ў|ува|ўва|на {noun}/вн : ThrowAt",
"~ у|ў|ува|ўва|на {noun}/вн {noun}/вн : ThrowAt reverse",
"~ {noun}/вн {noun}/дт : ThrowAt",
"~ {noun}/дт {noun}/вн : ThrowAt reverse",

}

Verb {
"#Wear",
"[|пры]апрануць,[|пры]апранаў,[|пры]апранала,[|пры]апраналі,[|пры]апранаю,[|пры]апранае,[|пры]апранаюць,[|пры]апранаем,[|пры]апрану,[|пры]апране,[|пры]апранем,[|пры]апрані,[|пры]апранай,[на|уз|ўз]дзяваць,[на|уз|ўз]дзяваў,[на|уз|ўз]дзявала,[на|уз|ўз]дзявалі,[на|уз|ўз]дзяваю,[на|уз|ўз]дзявае,[на|уз|ўз]дзяваюць,[на|уз|ўз]дзяваем,[на|уз|ўз]дзець,[на|уз|ўз]дзеў,[на|уз|ўз]дзела,[на|уз|ўз]дзелі,[на|уз|ўз]дзену,[на|уз|ўз]дзене,[на|уз|ўз]дзенуць,[на|уз|ўз]дзенем,[на|уз|ўз]дзень,[на|уз|ўз]дзявай,[а|уз|ўз]буць,[а|уз|ўз]буў,[а|уз|ўз]була,[а|уз|ўз]булі,[а|уз|ўз]буну,[а|уз|ўз]буе,[а|уз|ўз]бунем,[а|уз|ўз]буваў,[а|уз|ўз]бувала,[а|уз|ўз]бувалі,[а|уз|ўз]буваю,[а|уз|ўз]бувае,[а|уз|ўз]буваюць,[а|уз|ўз]буваем,[а|уз|ўз]буну,[а|уз|ўз]буне,[а|уз|ўз]бунуць,[а|уз|ўз]бунем,[а|уз|ўз]буй,[а|уз|ўз]бувай",
"{noun}/вн,held : Wear",
}

Verb {
"#Disrobe",
"зняць,здымаў,зняў,здымала,зняла,здымалі,знялі,здымаю,знімаю,здымае,знімае,здымаюць,знімаюць,знімаем,здымаем,зніму,здыму,здыме,зніме,здымуць,знімуць,знімі,здымай,знімі,знімай,распрануць,распранаў,распрануў,распранала,распранула,распраналі,распранулі,распранаю,распранае,распранаюць,распрану,распране,распранем,распрані,распранай,разуць,разуваў,разуў,разувала,разула,разувалі,разулі,разуваю,разувае,разуваюць,разуваем,разуну,разуе,разунем,разунь,разуй,разувай",
"{noun}/вн,worn : Disrobe",
"~ {noun}/вн з|са {noun}/рд : Remove",
"~ з|са {noun}/рд {noun}/вн : Remove reverse"
}

Verb {
"#SwitchOn",
"уключ/ыць,увамкн/уць,уруб/іць,актыв/аваць",
"{noun}/вн : SwitchOn",
}

Verb {
"#SwitchOff",
"выключ/ыць,вымкн/уць,выруб/іць,дэактыв/аваць,адключ/ыць",
"{noun}/вн : SwitchOff",
}

Verb {
"#Eat",
"[|з'|пад']есці,[|пад]сілк/авацца,зжэрці,жэрці,жары,еш",
"{noun}/вн,held : Eat",
}

Verb {
"#Taste",
"лізаць,лізн/уць,ліжы,пакашт/аваць,палі/заць,смактаць,пасмактаць,ссаць,ссі",
"{noun}/вн : Taste"
}

Verb {
"#Drink",
"піць,выпіць,выпі,вып'ю,п'ю,[|вы]жлухці/ць",
"{noun}/вн,held : Drink",
}

function mp.shortcut.pref6()
return 'з|па|пера|за'
end

Verb {
"#Push",
"штурх/нуць,[|на]ціс/нуць,націсн/уў,рухаць,рухай,рухаю,зрушыць,зрушыў,зрушваю"..
"запхн/уць,ссун/уць",
"?на {noun}/вн : Push",
"{noun}/вн на|у|ў|ува|ўва {noun}/вн : Transfer",
"~ {noun}/вн да {noun}/дт : Transfer",
"{noun}/вн {compass2} : Transfer",
"~ на|у|ў|ува|ўва {noun}/вн {noun}/вн : Transfer reverse",
"~ {compass2} {noun}/вн : Transfer reverse"
}

Verb {
"#Pull",
"[|вы|па|пад|да|за]цягн/уць,цягаць,[|па|пра|да|за]валач/ыць,[|па]вала/чыць,торгн/уць,тарган/уць",
"?за {noun}/вн : Pull",
"{noun}/вн на|у|ў|ува|ўва {noun}/вн : Transfer",
"~ {noun}/вн да {noun}/дт : Transfer",
"{noun}/вн {compass2} : Transfer",
"~ на|у|ў|ува|ўва {noun}/вн {noun}/вн : Transfer reverse",
"~ {compass2} {noun}/вн : Transfer reverse"
}

Verb {
"#Turn",
"[па|да]вярн/уць,[за|пад|па|пры|]круц/іць",
"{noun}/вн : Turn"
}

Verb {
"#Wait",
"чакаць,чакай,пачак/аць,перачак/аць,счак/аць",
"Wait"
}

function mp.shortcut.pref7()
return 'за|па|пра|пера|вы'
end

Verb {
"#Rub",
"[|{#pref7}]церці,[|{#pref7}]тры/,[{#pref7}]ціра/ць,",
"{noun}/вн : Rub"
}

Verb {
"#Sing",
"[|за|пра]спява/ць",
"Sing"
}

Verb {
"#Touch",
"[|па]крата/ць,кран/уць,дакран/уцца,[|па|пра|на]мац/аць,[|па|пры]гладз/іць",
"{noun}/вн : Touch",
"~ да {noun}/рд : Touch",
"~ да {noun}/дт : Touch",
"~ {noun}/рд : Touch",
}

Verb {
"#Give",
"даць,адд/аць,прапанав/аць,прапаноўв/аць,дазім,даю,даём",
"{noun}/вн,held {noun}/дт,live : Give",
"~ {noun}/дт,live {noun}/вн,held : Give reverse",
}

Verb {
"#Show",
"паказ/аць,пакаж/ы",
"{noun}/вн,held {noun}/дт,live : Show",
"~ {noun}/дт,live {noun}/вн,held : Show reverse",
}

Verb {
"#Burn",
"[|пад|за|рас]пал/іць",
"{noun}/вн : Burn",
"{noun}/вн {noun}/тв,held : Burn",
"~ {noun}/тв,held {noun}/вн : Burn reverse",
}

Verb {
"#Wake",
"[|раз|па]будз/іць,прачн/уцца,буджу,[|рас]катурх/аць",
"{noun}/вн,live : WakeOther",
"Wake",
}

Verb {
"#Kiss",
"[|па|рас]цалав/аць,цмокн/уць,цмокні,абдым/аць,абн/яць,цалуй,бусь/нуць,жамкн/уць,жмякн/уць,[|па|пры]лашч/ыць,[|на|па]гладж/ваць",
"{noun}/вн,live : Kiss"
}

Verb {
"#Think",
"дума/ць,падум/аць,мысл/іць,разваж/аць,паразваж/аць,мерк/аваць,памерк/аваць",
"Think"
}

Verb {
"#Smell",
"нюха/ць,панюха/ць,занюх/аць,нюхн/уць,прынюх/ацца",
"Smell",
"{noun}/вн : Smell"
}

Verb {
"#Listen",
"слуха/ць,паслуха/ць,прыслуха/цца,чу/ць,слух/",
"Listen",
"{noun}/вн : Listen",
"~ к {noun}/дт : Listen",
}

Verb {
"#Dig",
"капа/ць,выкапа/ць,выры/ць,рыць,рый,вырый",
"Dig",
"{noun}/вн,scene : Dig",
"{noun}/вн,scene {noun}/тв,held : Dig",
"~ {noun}/тв,held {noun}/вн,scene : Dig reverse",
}

function mp.shortcut.pref8()
return '[|раз|на|па|ад|пера|вы]'
end

Verb {
"#Cut",
"{#pref8}рэз/аць,{#pref8}рэж/",
"{noun}/вн : Cut",
"{noun}/вн {noun}/тв,held: Cut",
"~ {noun}/тв,held {noun}/вн: Cut reverse"
}

function mp.shortcut.pref9()
return '[ |па|раза|са]'
end

Verb {
"#Tear",
"{#pref9}ірваць,{#pref9}ірві/,{#pref9}ірву",
"{noun}/вн : Tear",
}

Verb {
"#Tie",
"[пры|з]вяз/аць,[пры|з]вяж/ы",
"{noun}/вн : Tie",
"{noun}/вн да {noun}/рд : Tie",
"~ {noun}/вн з|са {noun}/тв : Tie",
"~ да {noun}/дт {noun}/вн : Tie reverse",
"~ з|са {noun}/тв {noun}/рд : Tie reverse",
}

Verb {
"#Blow",
"дуць,дуй/,дун/ь,заду/ць,задун/ь,задуй/,дзьм/уць,задзьм/уць,дзьмухн/уць,задзьмух/нуцць,хукн/уць",
"у|ў|ува|ўва|на {noun}/вн : Blow",
"~ {noun}/вн : Blow", -- задуць
}

Verb {
"#Attack",
"атак/аваць,[|у|ў|вы|раз|па|вышы]біць,[|па|раз]бі/,удар/ыць,выця/ць"..
"[|раз|па|вы|уз|ўз]лама/ць,злама/ць,паруш/ыць,руйнаваць/,руйнуй/,крыш/ыць,напасці/,напад/аць,піхн/уць,пхн/уць,штурхн/уць,выцяць/",
"?на {noun}/вн : Attack"
}

Verb {
"#Sleep",
"спаць,засн/уць,прысн/уць,дрым/аць,кімар/ыць",
"Sleep",
}

Verb {
"#Swim",
"плыць,плав/аць,ныра/ць,адплы/сці,паплы/ць,нырн/уць,[ |вы]купа/цца",
"Swim",
}

Verb {
"#Consult",
"[|пра|па|рас]чыта/ць",
"у|ў|ува|ўва {noun}/пр,2 аб|пра * : Consult",
"~ аб|аба|пра * у|ў|ува {noun}/пр,2 : Consult reverse",
"~ {noun}/вн : Exam",
}

Verb {
"#Fill",
"напоўн/іць,налі/ць",
"?у {noun}/вн : Fill",
"~ усярэдзінуь {noun}/рд : Fill"
}

Verb {
"#Jump",
"скак/аць,[|пера|пад]скоч/ыц,[|пера|пад]скокн/уць",
"Jump",
"праз {noun}/вн,scene : JumpOver",
"~ у {noun}/вн,scene : Enter",
"~ на {noun}/вн,scene : Climb",
"~ з|со {noun}/рд,scene : GetOff",
"~ {compass2} : Walk",
"~ +праз {noun}/вн,scene : JumpOver",
}

Verb {
"#Wave",
"[|па]мах/аць,узмахн/уць,памаш/ы",
"WaveHands",
"~ рукамі: WaveHands",
"{noun}/тв,held : Wave"
}

Verb {
"#Climb"
,"[|за|па|пра|у|ў|уз|ўз]лез/ці,[|ус|ўс|пра]караста/цца,[|ус|ўс|пра]караска/цца,[уз|ўз|пра|за]брацца,[уз|ўз|пра|за]бірацца,[уз|ўз|пра|за]бірайся,[уз|ўз|пра|за]бярыся,заскочыць,заскокн/уць,заскоква/й",
"на {noun}/вн,scene : Climb",
"па {noun}/дт,scene : Climb",
"~ ўсярэдзіну {noun}/рд,scene : Enter",
"~ у|ў|ува|ўва|ва {noun}/вн,scene : Enter",
"{compass2}: Walk",
}

Verb {
"#GetOff",
"злез/ці,спусці/цца,[у|ў]стаць,[у|ў]стан/ь,саскочыць,саскокн/уць,саскоква/й",
"GetOff",
"{compass2}: Walk",
"з|са {noun}/рд,scene : GetOff",
}

Verb {
"#Buy",
"купи/ть,покупать",
"{noun}/вн,scene : Buy"
}

Verb {
"#Talk",
"[|па]гавар/ыць,[|па]гутар/ыць,[|па]размаўля/ць",
"з|са {noun}/тв,live : Talk"

}

Verb {
"#Tell",
"сказаць,паведам/іць,паведам/лю,раска/заць,раскаж/ыце,[а|распа]весці,[а|распа]вяд/дзі",
"{noun}/дт,live а|аб|аба|пра * : Tell",
"~ * {noun}/дт,live : Tell reverse",
"~ {noun}/дт * : Tell"
}

Verb {
"#Ask",
"спыта/ць,распыта/ць",
"{noun}/вн,live а|аб|аба|пра * : Ask",
"~ у {noun}/рд,live а|аб|аба|пра * : Ask",
"~ а|аб|аба|пра * у {noun}/рд,live : Ask reverse",
}

Verb {
"#AskFor",
"папрасі/ць,выпрасі/ць,угавары/ць,прасі/ць,папраш/у,выпраш/у",
"у|ў {noun}/рд,live * : AskFor",
"* у|ў {noun}/рд,live : AskFor reverse",
"~ {noun}/вн,live * : AskTo",
}

Verb {
"#Answer",
"адказ/аць,адказв/аць",
"{noun}/дт,live * : Answer",
"~ * {noun}/дт,live : Answer reverse",
}

Verb {
"#Yes",
"так,але",
"Yes",
}

Verb {
"#No",
"не",
"No",
}

Verb {
    "~ выкарыст/аць,скарыста/цца",
    "{noun}/вн : Use",
    "{noun}/тв : Use",
}

if DEBUG then

function mp:MetaForm(w)
if not w then return end
local t, hint
w = w:gsub("_", "/")
if w:find "/" then
hint = true
end
for _, f in ipairs { "им", "рд", "дт", "вн", "тв", "пр", "пр,2" } do
local ww = w
if hint then
ww = ww .. ','.. f
else
ww = ww .. '/' .. f
end
t = self.mrd:word(ww)
pn(t, " (", f, ")")
end
end

MetaVerb {
"#MetaWord",
"~_слова",
"* : MetaWord"
}
MetaVerb {
"#MetaNoun",
"~_наз/оўнік",
"* : MetaNoun"
}
MetaVerb {
"#MetaTrace",
"~_трасіроўка",
"так : MetaTraceOn",
"не : MetaTraceOff",
}
MetaVerb {
"#MetaDump",
"~_дамп",
"MetaDump"
}
MetaVerb {
"#МетаForm",
"~_форм/ы",
"* :MetaForm"
}
end
mp.msg.MetaTranscript.ON = function(file)
p ("Запіс транскрыпту распачаўся: ", file)
end

mp.msg.MetaTranscript.OFF = function(file)
p ("Транскрыпт спынены: ", file)
end

mp.msg.MetaTranscript.FILE = function(file)
p ("Файл транскрыпта: ", file)
end

MetaVerb {
"#MetaTranscript",
"~транскрыпт",
"так : MetaTranscriptOn",
"не : MetaTranscriptOff",
"MetaTranscript",
}

MetaVerb {
"#MetaExpert",
"~парсер",
"эксперт так : MetaExpertOn",
"эксперт не : MetaExpertOff",
"дзеясловы : MetaVerbs",
"версія : MetaVersion",
}

MetaVerb {
"#MetaSave",
"~захава/ць",
"MetaSave"
}
MetaVerb {
"#MetaLoad",
"~загрузі/ць",
"MetaLoad"
}

if DEBUG then
MetaVerb {
"#MetaAutoplay",
"~аўтаскрыпт",
"MetaAutoplay"
}
end

mp.msg.MetaRestart.RESTART = "Пачаць нанова?";

MetaVerb {
"#MetaRestart",
"~нанова,~рестарт",
"MetaRestart"
}
MetaVerb {
"#MetaHelp",
"~дапамога,дапамажы/це,давед/ка",
"MetaHelp",
}
end, 1)

std.mod_start(function()
if mp.undo > 0 then
mp.msg.MetaUndo.EMPTY = "Скасоўваць няма чаго."
MetaVerb {
"#MetaUndo",
"~скас/аваць",
"MetaUndo",
}
end
if mp.score then
MetaVerb {
"~ рахунак",
"MetaScore",
}
end
end)
-- Dialog
std.phr.default_Event = "Exam"

Verb ({"~ сказаць", "{select} : Exam" }, std.dlg)
Verb ({'#Next', "далей", "Next" }, mp.cutscene)
Verb ({'#Exam', "~ агледзець", "Look" }, std.dlg)

mp.cutscene.default_Verb = "далей"
mp.cutscene.help = fmt.em "<далей>";

std.dlg.default_Verb = "агледзець"
std.player.word = -"ты/мр,2л"
--акляк. Пашыраны карыстальніцкі слоўнік

game:dict {
["апранаць"] = {
"апранаеш/2л,нст";
"апранае/3л,нст"
}}
game:dict {
["здымаць"] = {
"здымаеш/2л,нст";
"здымае/3л,нст"
}}
game:dict {
["адмыкаць"] = {
"адмыкаеш/2л,нст";
"адмыкае/3л,нст"
}}
game:dict {
["адчыняць"] = {
"адчыняеш/2л,нст";
"адчыняе/3л,нст"
}}
game:dict {
["бачыць"] = {
"бачу/1л,ед,нст";
"бачыш/2л,ед,нст";
"бачыце/2л,мн,нст";
"бачыць/3л,ед,нст"
}}
game:dict {
["зачыняць"] = {
"зачыняеш/2л,нст";
"зачыняе/3л,нст"
}}
game:dict {
["замыкаць"] = {
"замыкаеш/2л,нст";
"замыкае/3л,нст"
}}
game:dict {
["змяшчаць"] = {
"змяшчаеш/2л,нст";
"змяшчае/3л,нст"
}}
game:dict {
["класці"] = {
"кладзеш/2л,нст";
"кладзе/3л,нст"
}}
game:dict {
["знаходзіцца"] = {
"знаходзішся/2л,ед,нст";
"знаходзіцца/3л,ед,нст";
}}

game:dict {
["замацаваны"] = {
"замацаваны/мр,пр";
"замацаваная/жр,пр";
"замацаванае/ср,пр";
"замацаваныя/мн,пр";
}}

game:dict {
["адамкнёны"] = {
"адамкнёны/мр,ед";
"адамкнёная/жр,ед";
"адамкнёнае/ср,ед";
"адамкнёныя/мн"
}}

game:dict {
["адчынены"] = {
"адчынены/мр,ед";
"адчыненая/жр,ед";
"адчыненае/ср,ед";
"адчыненыя/мн"
}}

game:dict {
["зачынены"] = {
"зачынены/мр,ед";
"зачыненая/жр,ед";
"зачыненае/ср,ед";
"зачыненыя/мн"
}}

game:dict {
["замкнёны"] = {
"замкнёны/мр,ед";
"замкнёная/жр,ед";
"замкнёнае/ср,ед";
"замкнёныя/мн"
}}

game:dict {
["апрануты"] = {
"апрануты/мр,ед";
"апранутая/жр,ед";
"апранутае/ср,ед";
"апранутыя/мн"
}}
game:dict {
["злазіць"] = {
"злажу/1л,нст";
"злазіш/2л,нст";
"злазіць/3л,нст"
}}
game:dict {
["пакідаць"] = {
"пакідаю/1л,нст";
"пакідаеш/2л,нст"
}}
game : dict {
["ключ/рд"] = "ключа";
["ключ/вн"] = "ключ";
["ключ/дт"] = "ключу";
["ключ/тв"] = "ключом";
["ключ/пр"] = "ключы";
}
game:dict {
["магчы"] = {
"можаш/2л,нст"
}}
game:dict {
["трымаць"] = {
"трымаеш/2л,нст"
}}
game:dict {
["хацець"] = {
"хочаш/2л,нст"
}}
game:dict {
["кінуты"] = {
"кінуты/3л,мр";
"кінутая/3л,жр";
"кінутае/3л,ср";
"кінутыя/3л,мн"
}}
game:dict {
["уключан"] = {
"уключаны/3л,мр";
"уключаная/3л,жр";
"уключанае/3л,ср";
"уключаныя/3л,мн"
}}
game:dict {
["выключан"] = {
"выключаны/3л,мр";
"выключаная/3л,жр";
"выключанае/3л,ср";
"выключаныя/3л,мн"
}}
game:dict {
["ядом"] = {
"ядомы/3л,мр";
"ядомая/3л,жр";
"ядомае/3л,ср";
"ядомыя/3л,мн"
}}
game:dict {
["прыслухацца"] = {
"прыслухоўваешся/2л,нст";
"прыслухоўваецца/3л,мр,нст";
"прыслухоўваецца/3л,жр,нст";
"прыслухоўваецца/3л,ср,нст";
"прыслухоўваюцца/3л,мн,нст"
}}
game : dict {
["ты/рд"] = "цябе";
["ты/вн"] = "цябе";
["ты/дт"] = "табе";
["ты/тв"] = "табой";
["ты/пр"] = "табе";
}
game:dict {
["замацаваны"] = {
"замацаваны/мр";
"замацаваная/жр";
"замацаванае/ср";
"замацаваныя/мн";
}}
--акляз
game : dict {
["ложак/рд"] = "ложка";
["ложак/вн"] = "ложак";
["ложак/дт"] = "ложку";
["ложак/тв"] = "ложкам";
["ложак/пр"] = "ложку";
}
game : dict {
["сасна/рд"] = "сасны";
["сасна/вн"] = "сасну";
["сасна/дт"] = "сасне";
["сасна/тв"] = "сасной";
["сасна/пр"] = "сасне";
}
game : dict {
["гасцёўня/рд"] = "гасцёўні";
["гасцёўня/вн"] = "гасцёўню";
["гасцёўня/дт"] = "гасцёўні";
["гасцёўня/тв"] = "гасцёўняй";
["гасцёўня/пр"] = "гасцёўні";
}
game : dict {
["спальня/рд"] = "спальні";
["спальня/вн"] = "спальню";
["спальня/дт"] = "спальні";
["спальня/тв"] = "спальняй";
["спальня/пр"] = "спальні";
}
game : dict {
["канапа/рд"] = "канапы";
["канапа/вн"] = "канапу";
["канапа/дт"] = "канапе";
["канапа/тв"] = "канапай";
["канапа/пр"] = "канапе";
}
game : dict {
["прыбіральня/рд"] = "прыбіральні";
["прыбіральня/вн"] = "прыбіральню";
["прыбіральня/дт"] = "прыбіральні";
["прыбіральня/тв"] = "прыбіральняй";
["прыбіральня/пр"] = "прыбіральні";
}
game : dict {
["гадзіннік/рд"] = "гадзінніка";
["гадзіннік/вн"] = "гадзіннік";
["гадзіннік/дт"] = "гадзінніку";
["гадзіннік/тв"] = "гадзіннікам";
["гадзіннік/пр"] = "гадзінніку";
}
game : dict {
["ён/рд"] = "яго";
["ён/вн"] = "яго";
["ён/дт"] = "яму";
["ён/тв"] = "ім";
["ён/пр"] = "ім";
}
game:dict {
["ён"] = {
"яны/мн";
"ён/3л,мр";
"яна/3л,жр";
"яно/3л,ср";
}}

game : dict {
["яна/рд"] = "яе";
["яна/вн"] = "яе";
["яна/дт"] = "ёй";
["яна/тв"] = "ёй";
["яна/пр"] = "ёй";
}
game : dict {
["яно/рд"] = "яго";
["яно/вн"] = "яго";
["яно/дт"] = "яму";
["яно/тв"] = "ім";
["яно/пр"] = "ім";
}
game : dict {
["яны/рд"] = "іх";
["яны/вн"] = "іх";
["яны/дт"] = "ім";
["яны/тв"] = "імі";
["яны/пр"] = "іх";
}
game : dict {
["ён/рд"] = "яго";
["ён/вн"] = "яго";
["ён/дт"] = "яму";
["ён/тв"] = "ім";
["ён/пр"] = "ім";
}
game : dict {
["компас/рд"] = "компаса";
["компас/вн"] = "компас";
["компас/дт"] = "компасу";
["компас/тв"] = "компасам";
["компас/пр"] = "компасе";
}
game:dict {
["выключан"] = {
"выключаны/мр";
"выключаная/жр";
"выключанае/ср";
"выключаныя/мн";
}}
game:dict {
["уключан"] = {
"уключаны/мр";
"уключаная/жр";
"уключанае/ср";
"уключаныя/мн";
}}
game:dict {
["уключаць"] = {
"уключаеш/2л,нст"
}}
game:dict {
["выключаць"] = {
"выключаеш/2л,нст"
}}
game:dict {
["адключаць"] = {
"адключаеш/2л,нст"
}}
game : dict {
["майка/рд"] = "майкі";
["майка/вн"] = "майку";
["майка/дт"] = "майцы";
["майка/тв"] = "майкай";
["майка/пр"] = "майцы";
}
game : dict {
["адзенне/рд"] = "адзення";
["адзенне/вн"] = "адзенне";
["адзенне/дт"] = "адзенню";
["адзенне/тв"] = "адзеннем";
["адзенне/пр"] = "адзенні";
}
game : dict {
["шорты/рд"] = "шортаў";
["шорты/вн"] = "шорты";
["шорты/дт"] = "шортам";
["шорты/тв"] = "шортамі";
["шорты/пр"] = "шортах";
}
game : dict {
["фіранка/рд"] = "фіранкі";
["фіранка/вн"] = "фіранку";
["фіранка/дт"] = "фіранцы";
["фіранка/тв"] = "фіранкай";
["фіранка/пр"] = "фіранцы";
}
game : dict {
["люстэрка/рд"] = "люстэрка";
["люстэрка/вн"] = "люстэрка";
["люстэрка/дт"] = "люстэрку";
["люстэрка/тв"] = "люстэркам";
["люстэрка/пр"] = "люстэрку";
}
game : dict {
["тэлевізар/рд"] = "тэлевізара";
["тэлевізар/вн"] = "тэлевізар";
["тэлевізар/дт"] = "тэлевізару";
["тэлевізар/тв"] = "тэлевізарам";
["тэлевізар/пр"] = "тэлевізары";
}
game : dict {
["ніткі/рд"] = "нітак";
["ніткі/вн"] = "ніткі";
["ніткі/дт"] = "ніткам";
["ніткі/тв"] = "ніткамі";
["ніткі/пр"] = "нітках";
}
game : dict {
["маток/рд"] = "матка";
["маток/вн"] = "маток";
["маток/дт"] = "матку";
["маток/тв"] = "матком";
["маток/пр"] = "матку";
}
game : dict {
["нітка/рд"] = "ніткі";
["нітка/вн"] = "нітку";
["нітка/дт"] = "нітку";
["нітка/тв"] = "ніткай";
["нітка/пр"] = "нітцы";
}
game : dict {
["страла/рд"] = "стралы";
["страла/вн"] = "стралу";
["страла/дт"] = "страле";
["страла/тв"] = "стралой";
["страла/пр"] = "страле";
}
game : dict {
["стол/рд"] = "стала";
["стол/вн"] = "стол";
["стол/дт"] = "сталу";
["стол/тв"] = "сталом";
["стол/пр"] = "стале";
}
game : dict {
["сталы/рд"] = "сталоў";
["сталы/вн"] = "сталы";
["сталы/дт"] = "сталам";
["сталы/тв"] = "сталамі";
["сталы/пр"] = "сталах";
}
game : dict {
["столік/рд"] = "століка";
["столік/вн"] = "столік";
["столік/дт"] = "століку";
["столік/тв"] = "столікам";
["столік/пр"] = "століку";
}
game : dict {
["столікі/рд"] = "столікаў";
["столікі/вн"] = "столікі";
["столікі/дт"] = "столікам";
["столікі/тв"] = "столікамі";
["столікі/пр"] = "століках";
}
game : dict {
["газета/рд"] = "газеты";
["газета/вн"] = "газету";
["газета/дт"] = "газеце";
["газета/тв"] = "газетай";
["газета/пр"] = "газеце";
}
game : dict {
["шуфляда/рд"] = "шуфляды";
["шуфляда/вн"] = "шуфляду";
["шуфляда/дт"] = "шуфлядзе";
["шуфляда/тв"] = "шуфлядай";
["шуфляда/пр"] = "шуфлядзе";
}
game:dict {
["знаходзіць"] = {
"знаходзіш/2л,нст";
"знаходзіць/3л,нст";
"знаходзяць/3л,мн,нст";
}}
game : dict {
["скрэпка/рд"] = "скрэпкі";
["скрэпка/вн"] = "скрэпку";
["скрэпка/дт"] = "скрэпцы";
["скрэпка/тв"] = "скрэпкай";
["скрэпка/пр"] = "скрэпцы";
}
game : dict {
["піражок/рд"] = "піражка";
["піражок/вн"] = "піражок";
["піражок/дт"] = "піражку";
["піражок/тв"] = "піражком";
["піражок/пр"] = "піражку";
}
game : dict {
["бабуля/рд"] = "бабулі";
["бабуля/вн"] = "бабулю";
["бабуля/дт"] = "бабулі";
["бабуля/тв"] = "бабуляй";
["бабуля/пр"] = "бабулі";
}
game : dict {
["вудачка/рд"] = "вудачкі";
["вудачка/вн"] = "вудачку";
["вудачка/дт"] = "вудачцы";
["вудачка/тв"] = "вудачкай";
["вудачка/пр"] = "вудачцы";
}
game : dict {
["вудзільна/рд"] = "вудзільна";
["вудзільна/вн"] = "вудзільна";
["вудзільна/дт"] = "вудзільну";
["вудзільна/тв"] = "вудзільнам";
["вудзільна/пр"] = "вудзільне";
}
game : dict {
["палка/рд"] = "палкі";
["палка/вн"] = "палку";
["палка/дт"] = "палцы";
["палка/тв"] = "палкай";
["палка/пр"] = "палцы";
}
game : dict {
["лобзік/рд"] = "лобзіка";
["лобзік/вн"] = "лобзік";
["лобзік/дт"] = "лобзіку";
["лобзік/тв"] = "лобзікам";
["лобзік/пр"] = "лобзіку";
}
game : dict {
["піла/рд"] = "пілы";
["піла/вн"] = "пілу";
["піла/дт"] = "піле";
["піла/тв"] = "пілой";
["піла/пр"] = "піле";
}
game : dict {
["канюшына/рд"] = "канюшыны";
["канюшына/вн"] = "канюшыну";
["канюшына/дт"] = "канюшыне";
["канюшына/тв"] = "канюшынай";
["канюшына/пр"] = "канюшыне";
}
game : dict {
["кветка/рд"] = "кветкі";
["кветка/вн"] = "кветку";
["кветка/дт"] = "кветцы";
["кветка/тв"] = "кветкай";
["кветка/пр"] = "кветцы";
}
game : dict {
["кветкі/рд"] = "кветак";
["кветкі/вн"] = "кветкі";
["кветкі/дт"] = "кветкам";
["кветкі/тв"] = "кветкамі";
["кветкі/пр"] = "кветках";
}
game : dict {
["запалка/рд"] = "запалкі";
["запалка/вн"] = "запалку";
["запалка/дт"] = "запалцы";
["запалка/тв"] = "запалкай";
["запалка/пр"] = "запалцы";
}
game : dict {
["запалкі/рд"] = "запалак";
["запалкі/вн"] = "запалкі";
["запалкі/дт"] = "запалкам";
["запалкі/тв"] = "запалкамі";
["запалкі/пр"] = "запалках";
}
game : dict {
["сярніца/рд"] = "сярніцы";
["сярніца/вн"] = "сярніцу";
["сярніца/дт"] = "сярніцы";
["сярніца/тв"] = "сярніцай";
["сярніца/пр"] = "сярніцы";
}
game : dict {
["сярнічка/рд"] = "сярнічкі";
["сярнічка/вн"] = "сярнічку";
["сярнічка/дт"] = "сярнічцы";
["сярнічка/тв"] = "сярнічкай";
["сярнічка/пр"] = "сярнічцы";
}
game : dict {
["запальніца/рд"] = "запальніцы";
["запальніца/вн"] = "запальніцу";
["запальніца/дт"] = "запальніцы";
["запальніца/тв"] = "запальніцай";
["запальніца/пр"] = "запальніцы";
}
game : dict {
["запальнічка/рд"] = "запальнічкі";
["запальнічка/вн"] = "запальнічку";
["запальнічка/дт"] = "запальнічцы";
["запальнічка/тв"] = "запальнічкай";
["запальнічка/пр"] = "запальнічцы";
}
game : dict {
["лук/рд"] = "лука";
["лук/вн"] = "лук";
["лук/дт"] = "луку";
["лук/тв"] = "лукам";
["лук/пр"] = "луку";
}
game : dict {
["скрыня/рд"] = "скрыні";
["скрыня/вн"] = "скрыню";
["скрыня/дт"] = "скрыні";
["скрыня/тв"] = "скрыняй";
["скрыня/пр"] = "скрыні";
}
game : dict {
["пацук/рд"] = "пацука";
["пацук/вн"] = "пацука";
["пацук/дт"] = "пацуку";
["пацук/тв"] = "пацуком";
["пацук/пр"] = "пацуку";
}
game : dict {
["пачвара/рд"] = "пачвары";
["пачвара/вн"] = "пачвару";
["пачвара/дт"] = "пачвары";
["пачвара/тв"] = "пачварай";
["пачвара/пр"] = "пачвары";
}
game : dict {
["падвал/рд"] = "падвала";
["падвал/вн"] = "падвал";
["падвал/дт"] = "падвалу";
["падвал/тв"] = "падвалам";
["падвал/пр"] = "падвале";
}
game : dict {
["памяшканне/рд"] = "памяшкання";
["памяшканне/вн"] = "памяшканне";
["памяшканне/дт"] = "памяшканню";
["памяшканне/тв"] = "памяшканнем";
["памяшканне/пр"] = "памяшканні";
}
game : dict {
["дзеці/рд"] = "дзяцей";
["дзеці/вн"] = "дзяцей";
["дзеці/дт"] = "дзецям";
["дзеці/тв"] = "дзяцьмі";
["дзеці/пр"] = "дзецях";
}
game : dict {
["дзятва/рд"] = "дзятвы";
["дзятва/вн"] = "дзятву";
["дзятва/дт"] = "дзятве";
["дзятва/тв"] = "дзятвой";
["дзятва/пр"] = "дзятве";
}
game : dict {
["бялізна/рд"] = "бялізны";
["бялізна/вн"] = "бялізну";
["бялізна/дт"] = "бялізне";
["бялізна/тв"] = "бялізнай";
["бялізна/пр"] = "бялізне";
}
game : dict {
["Света/рд"] = "Светы";
["Света/вн"] = "Свету";
["Света/дт"] = "Свеце";
["Света/тв"] = "Светай";
["Света/пр"] = "Свеце";
}
game : dict {
["дзяўчынка/рд"] = "дзяўчынкі";
["дзяўчынка/вн"] = "дзяўчынку";
["дзяўчынка/дт"] = "дзяўчынцы";
["дзяўчынка/тв"] = "дзяўчынкай";
["дзяўчынка/пр"] = "дзяўчынцы";
}
game : dict {
["Макс/рд"] = "Макса";
["Макс/вн"] = "Макса";
["Макс/дт"] = "Максу";
["Макс/тв"] = "Максам";
["Макс/пр"] = "Максе";
}
game : dict {
["Руслан/рд"] = "Руслана";
["Руслан/вн"] = "Руслана";
["Руслан/дт"] = "Руслану";
["Руслан/тв"] = "Русланам";
["Руслан/пр"] = "Руслане";
}
game : dict {
["Рома/рд"] = "Ромы";
["Рома/вн"] = "Рому";
["Рома/дт"] = "Рому";
["Рома/тв"] = "Ромам";
["Рома/пр"] = "Роме";
}
game : dict {
["вяроўка/рд"] = "вяроўкі";
["вяроўка/вн"] = "вяроўку";
["вяроўка/дт"] = "вяроўцы";
["вяроўка/тв"] = "вяроўкай";
["вяроўка/пр"] = "вяроўцы";
}
game : dict {
["люк/рд"] = "люка";
["люк/вн"] = "люк";
["люк/дт"] = "люку";
["люк/тв"] = "люкам";
["люк/пр"] = "люку";
}
game : dict {
["скафандр/рд"] = "скафандра";
["скафандр/вн"] = "скафандр";
["скафандр/дт"] = "скафандру";
["скафандр/тв"] = "скафандрам";
["скафандр/пр"] = "скафандры";
}
game : dict {
["візар/рд"] = "візара";
["візар/вн"] = "візар";
["візар/дт"] = "візару";
["візар/тв"] = "візарам";
["візар/пр"] = "візары";
}
game : dict {
["ліхтар/рд"] = "ліхтара";
["ліхтар/вн"] = "ліхтар";
["ліхтар/дт"] = "ліхтару";
["ліхтар/тв"] = "ліхтаром";
["ліхтар/пр"] = "ліхтары";
}
game : dict {
["рацыя/рд"] = "рацыі";
["рацыя/вн"] = "рацыю";
["рацыя/дт"] = "рацыі";
["рацыя/тв"] = "рацыяй";
["рацыя/пр"] = "рацыі";
}
game : dict {
["святло/рд"] = "святла";
["святло/вн"] = "святло";
["святло/дт"] = "святлу";
["святло/тв"] = "святлом";
["святло/пр"] = "святле";
}
game : dict {
["дзеўчына/рд"] = "дзеўчыны";
["дзеўчына/вн"] = "дзеўчыну";
["дзеўчына/дт"] = "дзеўчыне";
["дзеўчына/тв"] = "дзеўчынай";
["дзеўчына/пр"] = "дзеўчыне";
}
game : dict {
["дзяўчына/рд"] = "дзяўчыны";
["дзяўчына/вн"] = "дзяўчыну";
["дзяўчына/дт"] = "дзяўчыне";
["дзяўчына/тв"] = "дзяўчынай";
["дзяўчына/пр"] = "дзяўчыне";
}
game : dict {
["неба/рд"] = "неба";
["неба/вн"] = "неба";
["неба/дт"] = "небу";
["неба/тв"] = "небам";
["неба/пр"] = "небе";
}
game : dict {
["сонца/рд"] = "сонца";
["сонца/вн"] = "сонца";
["сонца/дт"] = "сонцу";
["сонца/тв"] = "сонцам";
["сонца/пр"] = "сонцы";
}
--сонца з вялікай літары
game : dict {
["Сонца/рд"] = "Сонца";
["Сонца/вн"] = "Сонца";
["Сонца/дт"] = "Сонцу";
["Сонца/тв"] = "Сонцам";
["Сонца/пр"] = "Сонцы";
}
game : dict {
["сонейка/рд"] = "сонейка";
["сонейка/вн"] = "сонейка";
["сонейка/дт"] = "сонейку";
["сонейка/тв"] = "сонейкам";
["сонейка/пр"] = "сонейку";
}
game : dict {
["зорка/рд"] = "зоркі";
["зорка/вн"] = "зорку";
["зорка/дт"] = "зорцы";
["зорка/тв"] = "зоркай";
["зорка/пр"] = "зорцы";
}
game : dict {
["зоркі/рд"] = "зорак";
["зоркі/вн"] = "зоркі";
["зоркі/дт"] = "зоркам";
["зоркі/тв"] = "зоркамі";
["зоркі/пр"] = "зорках";
}
game : dict {
["гара/рд"] = "гары";
["гара/вн"] = "гару";
["гара/дт"] = "гары";
["гара/тв"] = "гарой";
["гара/пр"] = "гары";
}
game : dict {
["горы/рд"] = "гор";
["горы/вн"] = "горы";
["горы/дт"] = "гарам";
["горы/тв"] = "гарамі";
["горы/пр"] = "гарах";
}
game : dict {
["модуль/рд"] = "модуля";
["модуль/вн"] = "модуль";
["модуль/дт"] = "модулю";
["модуль/тв"] = "модулем";
["модуль/пр"] = "модулі";
}
game : dict {
["модулі/рд"] = "модуляў";
["модулі/вн"] = "модулі";
["модулі/дт"] = "модулям";
["модулі/тв"] = "модулямі";
["модулі/пр"] = "модулях";
}
game : dict {
["бакі/рд"] = "бакаў";
["бакі/вн"] = "бакі";
["бакі/дт"] = "бакам";
["бакі/тв"] = "бакамі";
["бакі/пр"] = "баках";
}
game : dict {
["база/рд"] = "базы";
["база/вн"] = "базу";
["база/дт"] = "базе";
["база/тв"] = "базай";
["база/пр"] = "базе";
}
game : dict {
["скала/рд"] = "скалы";
["скала/вн"] = "скалу";
["скала/дт"] = "скале";
["скала/тв"] = "скалой";
["скала/пр"] = "скале";
}
game : dict {
["скалы/рд"] = "скалаў";
["скалы/вн"] = "скалы";
["скалы/дт"] = "скалам";
["скалы/тв"] = "скаламі";
["скалы/пр"] = "скалах";
}
game : dict {
["абломкі/рд"] = "абломкаў";
["абломкі/вн"] = "абломкі";
["абломкі/дт"] = "абломкам";
["абломкі/тв"] = "абломкамі";
["абломкі/пр"] = "абломках";
}
game : dict {
["арка/рд"] = "аркі";
["арка/вн"] = "арку";
["арка/дт"] = "арцы";
["арка/тв"] = "аркай";
["арка/пр"] = "арцы";
}
game : dict {
["пячора/рд"] = "пячоры";
["пячора/вн"] = "пячору";
["пячора/дт"] = "пячоры";
["пячора/тв"] = "пячорай";
["пячора/пр"] = "пячоры";
}
game : dict {
["адтуліна/рд"] = "адтуліны";
["адтуліна/вн"] = "адтуліну";
["адтуліна/дт"] = "адтуліне";
["адтуліна/тв"] = "адтулінай";
["адтуліна/пр"] = "адтуліне";
}
game : dict {
["дзірка/рд"] = "дзіркі";
["дзірка/вн"] = "дзірку";
["дзірка/дт"] = "дзірцы";
["дзірка/тв"] = "дзіркай";
["дзірка/пр"] = "дзірцы";
}
game : dict {
["пройма/рд"] = "проймы";
["пройма/вн"] = "пройму";
["пройма/дт"] = "пройме";
["пройма/тв"] = "проймай";
["пройма/пр"] = "пройме";
}
game : dict {
["праём/рд"] = "праёму";
["праём/вн"] = "праём";
["праём/дт"] = "праёму";
["праём/тв"] = "праёмам";
["праём/пр"] = "праёме";
}
game : dict {
["праход/рд"] = "праходу";
["праход/вн"] = "праход";
["праход/дт"] = "праходу";
["праход/тв"] = "праходам";
["праход/пр"] = "праходзе";
}
game : dict {
["выхад/рд"] = "выхаду";
["выхад/вн"] = "выхад";
["выхад/дт"] = "выхаду";
["выхад/тв"] = "выхадам";
["выхад/пр"] = "выхадзе";
}
game : dict {
["дол/рд"] = "долу";
["дол/вн"] = "дол";
["дол/дт"] = "долу";
["дол/тв"] = "долам";
["дол/пр"] = "доле";
}
game : dict {
["падлога/рд"] = "падлогі";
["падлога/вн"] = "падлогу";
["падлога/дт"] = "падлозе";
["падлога/тв"] = "падлогай";
["падлога/пр"] = "падлозе";
}
game : dict {
["паверхня/рд"] = "паверхні";
["паверхня/вн"] = "паверхню";
["паверхня/дт"] = "паверхні";
["паверхня/тв"] = "паверхняй";
["паверхня/пр"] = "паверхні";
}
game : dict {
["сцяна/рд"] = "сцяны";
["сцяна/вн"] = "сцяну";
["сцяна/дт"] = "сцяне";
["сцяна/тв"] = "сцяной";
["сцяна/пр"] = "сцяне";
}
game : dict {
["сцены/рд"] = "сценаў";
["сцены/вн"] = "сцены";
["сцены/дт"] = "сценам";
["сцены/тв"] = "сценамі";
["сцены/пр"] = "сценах";
}
game : dict {
["парода/рд"] = "пароды";
["парода/вн"] = "пароду";
["парода/дт"] = "пародзе";
["парода/тв"] = "пародай";
["парода/пр"] = "пародзе";
}
game : dict {
["расколіна/рд"] = "расколіны";
["расколіна/вн"] = "расколіну";
["расколіна/дт"] = "расколіне";
["расколіна/тв"] = "расколінай";
["расколіна/пр"] = "расколіне";
}
game : dict {
["расколіны/рд"] = "расколінаў";
["расколіны/вн"] = "расколіны";
["расколіны/дт"] = "расколіне";
["расколіны/тв"] = "расколінай";
["расколіны/пр"] = "расколіне";
}
game : dict {
["трэшчына/рд"] = "трэшчыны";
["трэшчына/вн"] = "трэшчыну";
["трэшчына/дт"] = "трэшчыне";
["трэшчына/тв"] = "трэшчынай";
["трэшчына/пр"] = "трэшчыне";
}
game : dict {
["трэшчыны/рд"] = "трэшчынаў";
["трэшчыны/вн"] = "трэшчыны";
["трэшчыны/дт"] = "трэшчынам";
["трэшчыны/тв"] = "трэшчынамі";
["трэшчыны/пр"] = "трэшчынах";
}
game : dict {
["мора/рд"] = "мора";
["мора/вн"] = "мора";
["мора/дт"] = "мору";
["мора/тв"] = "морам";
["мора/пр"] = "моры";
}
game : dict {
["вада/рд"] = "вады";
["вада/вн"] = "ваду";
["вада/дт"] = "вадзе";
["вада/тв"] = "вадой";
["вада/пр"] = "вадзе";
}
game : dict {
["хвалі/рд"] = "хваляў";
["хвалі/вн"] = "хвалі";
["хвалі/дт"] = "хвалям";
["хвалі/тв"] = "хвалямі";
["хвалі/пр"] = "хвалях";
}
game : dict {
["маяк/рд"] = "маяка";
["маяк/вн"] = "маяк";
["маяк/дт"] = "маяку";
["маяк/тв"] = "маяком";
["маяк/пр"] = "маяку";
}
game : dict {
["уцёс/рд"] = "уцёсу";
["уцёс/вн"] = "уцёс";
["уцёс/дт"] = "уцёсу";
["уцёс/тв"] = "уцёсам";
["уцёс/пр"] = "уцёсе";
}
--уцёс праз у нескладовае
game : dict {
["ўцёс/рд"] = "ўцёсу";
["ўцёс/вн"] = "ўцёс";
["ўцёс/дт"] = "ўцёсу";
["ўцёс/тв"] = "ўцёсам";
["ўцёс/пр"] = "ўцёсе";
}
game : dict {
["вежа/рд"] = "вежы";
["вежа/вн"] = "вежу";
["вежа/дт"] = "вежы";
["вежа/тв"] = "вежай";
["вежа/пр"] = "вежы";
}
game : dict {
["выступ/рд"] = "выступу";
["выступ/вн"] = "выступ";
["выступ/дт"] = "выступу";
["выступ/тв"] = "выступам";
["выступ/пр"] = "выступе";
}
game : dict {
["пясок/рд"] = "пяска";
["пясок/вн"] = "пясок";
["пясок/дт"] = "пяску";
["пясок/тв"] = "пяском";
["пясок/пр"] = "пяску";
}
game : dict {
["бераг/рд"] = "берага";
["бераг/вн"] = "бераг";
["бераг/дт"] = "берагу";
["бераг/тв"] = "берагам";
["бераг/пр"] = "беразе";
}
game : dict {
["пляж/рд"] = "пляжа";
["пляж/вн"] = "пляж";
["пляж/дт"] = "пляжу";
["пляж/тв"] = "пляжам";
["пляж/пр"] = "пляжы";
}
game : dict {
["камень/рд"] = "каменя";
["камень/вн"] = "камень";
["камень/дт"] = "каменю";
["камень/тв"] = "каменем";
["камень/пр"] = "камені";
}
game : dict {
["каменьчык/рд"] = "каменьчыка";
["каменьчык/вн"] = "каменьчык";
["каменьчык/дт"] = "каменьчыку";
["каменьчык/тв"] = "каменьчыкам";
["каменьчык/пр"] = "каменьчыку";
}
game : dict {
["камні/рд"] = "камней";
["камні/вн"] = "камні";
["камні/дт"] = "камням";
["камні/тв"] = "камнямі";
["камні/пр"] = "камнях";
}
game : dict {
["камяні/рд"] = "камянёў";
["камяні/вн"] = "камяні";
["камяні/дт"] = "камяням";
["камяні/тв"] = "камянямі";
["камяні/пр"] = "камянях";
}
game : dict {
["каменьчыкі/рд"] = "каменьчыкаў";
["каменьчыкі/вн"] = "каменьчыкі";
["каменьчыкі/дт"] = "каменьчыкам";
["каменьчыкі/тв"] = "каменьчыкамі";
["каменьчыкі/пр"] = "каменьчыках";
}
game : dict {
["калона/рд"] = "калоны";
["калона/вн"] = "калону";
["калона/дт"] = "калоне";
["калона/тв"] = "калонай";
["калона/пр"] = "калоне";
}
game : dict {
["свяцільня/рд"] = "свяцільні";
["свяцільня/вн"] = "свяцільню";
["свяцільня/дт"] = "свяцільні";
["свяцільня/тв"] = "свяцільняй";
["свяцільня/пр"] = "свяцільні";
}
game : dict {
["свяцільні/рд"] = "свяцільняў";
["свяцільні/вн"] = "свяцільні";
["свяцільні/дт"] = "свяцільням";
["свяцільні/тв"] = "свяцільнямі";
["свяцільні/пр"] = "свяцільнях";
}
game : dict {
["лямпа/рд"] = "лямпы";
["лямпа/вн"] = "лямпу";
["лямпа/дт"] = "лямпе";
["лямпа/тв"] = "лямпай";
["лямпа/пр"] = "лямпе";
}
game : dict {
["акно/рд"] = "акна";
["акно/вн"] = "акно";
["акно/дт"] = "акну";
["акно/тв"] = "акном";
["акно/пр"] = "акне";
}
game : dict {
["вокны/рд"] = "вокнаў";
["вокны/вн"] = "вокны";
["вокны/дт"] = "вокнам";
["вокны/тв"] = "вокнамі";
["вокны/пр"] = "вокнах";
}
game : dict {
["вакно/рд"] = "вакна";
["вакно/вн"] = "вакно";
["вакно/дт"] = "вакну";
["вакно/тв"] = "вакном";
["вакно/пр"] = "вакне";
}
game : dict {
["лесвіца/рд"] = "лесвіцы";
["лесвіца/вн"] = "лесвіцу";
["лесвіца/дт"] = "лесвіцы";
["лесвіца/тв"] = "лесвіцай";
["лесвіца/пр"] = "лесвіцы";
}
game : dict {
["сходы/рд"] = "сходаў";
["сходы/вн"] = "сходы";
["сходы/дт"] = "сходам";
["сходы/тв"] = "сходамі";
["сходы/пр"] = "сходах";
}
game : dict {
["усходы/рд"] = "усходаў";
["усходы/вн"] = "усходы";
["усходы/дт"] = "усходам";
["усходы/тв"] = "усходамі";
["усходы/пр"] = "усходах";
}
game : dict {
["ўсходы/рд"] = "ўсходаў";
["ўсходы/вн"] = "ўсходы";
["ўсходы/дт"] = "ўсходам";
["ўсходы/тв"] = "ўсходамі";
["ўсходы/пр"] = "ўсходах";
}
game : dict {
["прыступкі/рд"] = "прыступак";
["прыступкі/вн"] = "прыступкі";
["прыступкі/дт"] = "прыступкам";
["прыступкі/тв"] = "прыступкамі";
["прыступкі/пр"] = "прыступках";
}
game : dict {
["прыбор/рд"] = "прыбора";
["прыбор/вн"] = "прыбор";
["прыбор/дт"] = "прыбору";
["прыбор/тв"] = "прыборам";
["прыбор/пр"] = "прыборы";
}
game : dict {
["апарат/рд"] = "апарату";
["апарат/вн"] = "апарат";
["апарат/дт"] = "апарату";
["апарат/тв"] = "апаратам";
["апарат/пр"] = "апараце";
}
game : dict {
["бацька/рд"] = "бацькі";
["бацька/вн"] = "бацьку";
["бацька/дт"] = "бацьку";
["бацька/тв"] = "бацькам";
["бацька/пр"] = "бацьку";
}
game : dict {
["мужчына/рд"] = "мужчыны";
["мужчына/вн"] = "мужчыну";
["мужчына/дт"] = "мужчыне";
["мужчына/тв"] = "мужчынам";
["мужчына/пр"] = "мужчыне";
}
game : dict {
["стары/рд"] = "старога";
["стары/вн"] = "старога";
["стары/дт"] = "старому";
["стары/тв"] = "старым";
["стары/пр"] = "старым";
}
game : dict {
["старэча/рд"] = "старэчы";
["старэча/вн"] = "старэчу";
["старэча/дт"] = "старэчы";
["старэча/тв"] = "старэчам";
["старэча/пр"] = "старэчы";
}
game : dict {
["тэлескоп/рд"] = "тэлескопа";
["тэлескоп/вн"] = "тэлескоп";
["тэлескоп/дт"] = "тэлескопу";
["тэлескоп/тв"] = "тэлескопам";
["тэлескоп/пр"] = "тэлескопе";
}
game : dict {
["дарожка/рд"] = "дарожкі";
["дарожка/вн"] = "дарожку";
["дарожка/дт"] = "дарожцы";
["дарожка/тв"] = "дарожкай";
["дарожка/пр"] = "дарожцы";
}
game : dict {
["дыван/рд"] = "дывана";
["дыван/вн"] = "дыван";
["дыван/дт"] = "дывану";
["дыван/тв"] = "дыванам";
["дыван/пр"] = "дыване";
}
game : dict {
["пара/рд"] = "пары";
["пара/вн"] = "пару";
["пара/дт"] = "пары";
["пара/тв"] = "парай";
["пара/пр"] = "пары";
}
game : dict {
["туман/рд"] = "туману";
["туман/вн"] = "туман";
["туман/дт"] = "туману";
["туман/тв"] = "туманам";
["туман/пр"] = "тумане";
}
game : dict {
["газ/рд"] = "газа";
["газ/вн"] = "газ";
["газ/дт"] = "газу";
["газ/тв"] = "газам";
["газ/пр"] = "газе";
}
game : dict {
["трон/рд"] = "трона";
["трон/вн"] = "трон";
["трон/дт"] = "трону";
["трон/тв"] = "тронам";
["трон/пр"] = "троне";
}
game : dict {
["сталец/рд"] = "стальца";
["сталец/вн"] = "сталец";
["сталец/дт"] = "стальцу";
["сталец/тв"] = "стальцом";
["сталец/пр"] = "стальцы";
}
game : dict {
["серп/рд"] = "серпа";
["серп/вн"] = "серп";
["серп/дт"] = "серпу";
["серп/тв"] = "серпам";
["серп/пр"] = "серпе";
}
game : dict {
["клубы/рд"] = "клубоў";
["клубы/вн"] = "клубы";
["клубы/дт"] = "клубам";
["клубы/тв"] = "клубамі";
["клубы/пр"] = "клубах";
}
game : dict {
["карона/рд"] = "кароны";
["карона/вн"] = "карону";
["карона/дт"] = "кароне";
["карона/тв"] = "каронай";
["карона/пр"] = "кароне";
}
game : dict {
["сукенка/рд"] = "сукенкі";
["сукенка/вн"] = "сукенку";
["сукенка/дт"] = "сукенцы";
["сукенка/тв"] = "сукенкай";
["сукенка/пр"] = "сукенцы";
}
game : dict {
["сукня/рд"] = "сукні";
["сукня/вн"] = "сукню";
["сукня/дт"] = "сукні";
["сукня/тв"] = "сукняй";
["сукня/пр"] = "сукні";
}
game : dict {
["строй/рд"] = "строя";
["строй/вн"] = "строй";
["строй/дт"] = "строю";
["строй/тв"] = "строем";
["строй/пр"] = "строі";
}
game : dict {
["убор/рд"] = "убору";
["убор/вн"] = "убор";
["убор/дт"] = "убору";
["убор/тв"] = "уборам";
["убор/пр"] = "уборы";
}
game : dict {
["ўбор/рд"] = "ўбору";
["ўбор/вн"] = "ўбор";
["ўбор/дт"] = "ўбору";
["ўбор/тв"] = "ўборам";
["ўбор/пр"] = "ўборы";
}
game : dict {
["прынцэса/рд"] = "прынцэсы";
["прынцэса/вн"] = "прынцэсу";
["прынцэса/дт"] = "прынцэсе";
["прынцэса/тв"] = "прынцэсай";
["прынцэса/пр"] = "прынцэсе";
}
game : dict {
["Ларыса/рд"] = "Ларысы";
["Ларыса/вн"] = "Ларысу";
["Ларыса/дт"] = "Ларысе";
["Ларыса/тв"] = "Ларысай";
["Ларыса/пр"] = "Ларысе";
}
game : dict {
["жонка/рд"] = "жонкі";
["жонка/вн"] = "жонку";
["жонка/дт"] = "жонцы";
["жонка/тв"] = "жонкай";
["жонка/пр"] = "жонцы";
}
game : dict {
["вочы/рд"] = "вачэй";
["вочы/вн"] = "вочы";
["вочы/дт"] = "вачам";
["вочы/тв"] = "вачамі";
["вочы/пр"] = "вачах";
}
game : dict {
["адлюстраванне/рд"] = "адлюстравання";
["адлюстраванне/вн"] = "адлюстраванне";
["адлюстраванне/дт"] = "адлюстраванню";
["адлюстраванне/тв"] = "адлюстраваннем";
["адлюстраванне/пр"] = "адлюстраванні";
}
game : dict {
["паляна/рд"] = "паляны";
["паляна/вн"] = "паляну";
["паляна/дт"] = "паляне";
["паляна/тв"] = "палянай";
["паляна/пр"] = "паляне";
}
game : dict {
["палянка/рд"] = "палянкі";
["палянка/вн"] = "палянку";
["палянка/дт"] = "палянцы";
["палянка/тв"] = "палянкай";
["палянка/пр"] = "палянцы";
}
game : dict {
["трава/рд"] = "травы";
["трава/вн"] = "траву";
["трава/дт"] = "траве";
["трава/тв"] = "травой";
["трава/пр"] = "траве";
}
game : dict {
["пакой/рд"] = "пакоя";
["пакой/вн"] = "пакой";
["пакой/дт"] = "пакою";
["пакой/тв"] = "пакоем";
["пакой/пр"] = "пакоі";
}
game : dict {
["тэлефон/рд"] = "тэлефона";
["тэлефон/вн"] = "тэлефон";
["тэлефон/дт"] = "тэлефону";
["тэлефон/тв"] = "тэлефонам";
["тэлефон/пр"] = "тэлефоне";
}
game : dict {
["мабільны/рд"] = "мабільнага";
["мабільны/вн"] = "мабільны";
["мабільны/дт"] = "мабільнаму";
["мабільны/тв"] = "мабільным";
["мабільны/пр"] = "мабільным";
}
game : dict {
["слухаўка/рд"] = "слухаўкі";
["слухаўка/вн"] = "слухаўку";
["слухаўка/дт"] = "слухаўцы";
["слухаўка/тв"] = "слухаўкай";
["слухаўка/пр"] = "слухаўцы";
}
game : dict {
["труба/рд"] = "трубы";
["труба/вн"] = "трубу";
["труба/дт"] = "трубе";
["труба/тв"] = "трубой";
["труба/пр"] = "трубе";
}
game : dict {
["трубка/рд"] = "трубкі";
["трубка/вн"] = "трубку";
["трубка/дт"] = "трубцы";
["трубка/тв"] = "трубкай";
["трубка/пр"] = "трубцы";
}
game : dict {
["рамяні/рд"] = "рамянёў";
["рамяні/вн"] = "рамяні";
["рамяні/дт"] = "рамяням";
["рамяні/тв"] = "рамянямі";
["рамяні/пр"] = "рамянях";
}
game : dict {
["рэмень/рд"] = "рэменя";
["рэмень/вн"] = "рэмень";
["рэмень/дт"] = "рэменю";
["рэмень/тв"] = "рэменем";
["рэмень/пр"] = "рэмені";
}
game : dict {
["пас/рд"] = "паса";
["пас/вн"] = "пас";
["пас/дт"] = "пасу";
["пас/тв"] = "пасам";
["пас/пр"] = "пасе";
}
game : dict {
["адсек/рд"] = "адсека";
["адсек/вн"] = "адсек";
["адсек/дт"] = "адсеку";
["адсек/тв"] = "адсекам";
["адсек/пр"] = "адсеку";
}
game : dict {
["світанак/рд"] = "світанка";
["світанак/вн"] = "світанак";
["світанак/дт"] = "світанку";
["світанак/тв"] = "світанкам";
["світанак/пр"] = "світанку";
}
game : dict {
["зара/рд"] = "зары";
["зара/вн"] = "зару";
["зара/дт"] = "зары";
["зара/тв"] = "зарой";
["зара/пр"] = "зары";
}
game : dict {
["крэсла/рд"] = "крэсла";
["крэсла/вн"] = "крэсла";
["крэсла/дт"] = "крэслу";
["крэсла/тв"] = "крэслам";
["крэсла/пр"] = "крэсле";
}
game : dict {
["крэслы/рд"] = "крэслаў";
["крэслы/вн"] = "крэслы";
["крэслы/дт"] = "крэслам";
["крэслы/тв"] = "крэсламі";
["крэслы/пр"] = "крэслах";
}
game : dict {
["фатэль/рд"] = "фатэля";
["фатэль/вн"] = "фатэль";
["фатэль/дт"] = "фатэлю";
["фатэль/тв"] = "фатэлем";
["фатэль/пр"] = "фатэлі";
}
game : dict {
["Сяргей/рд"] = "Сяргея";
["Сяргей/вн"] = "Сяргея";
["Сяргей/дт"] = "Сяргею";
["Сяргей/тв"] = "Сяргеем";
["Сяргей/пр"] = "Сяргеі";
}
game : dict {
["Сярожа/рд"] = "Сярожы";
["Сярожа/вн"] = "Сярожу";
["Сярожа/дт"] = "Сярожу";
["Сярожа/тв"] = "Сярожам";
["Сярожа/пр"] = "Сярожы";
}
game : dict {
["замок/рд"] = "замка";
["замок/вн"] = "замок";
["замок/дт"] = "замку";
["замок/тв"] = "замком";
["замок/пр"] = "замку";
}
game : dict {
["замкі/рд"] = "замкоў";
["замкі/вн"] = "замкі";
["замкі/дт"] = "замкам";
["замкі/тв"] = "замкамі";
["замкі/пр"] = "замках";
}
game : dict {
["механізм/рд"] = "механізма";
["механізм/вн"] = "механізм";
["механізм/дт"] = "механізму";
["механізм/тв"] = "механізмам";
["механізм/пр"] = "механізме";
}
game : dict {
["кнопка/рд"] = "кнопкі";
["кнопка/вн"] = "кнопку";
["кнопка/дт"] = "кнопцы";
["кнопка/тв"] = "кнопкай";
["кнопка/пр"] = "кнопцы";
}
game : dict {
["ручка/рд"] = "ручкі";
["ручка/вн"] = "ручку";
["ручка/дт"] = "ручцы";
["ручка/тв"] = "ручкай";
["ручка/пр"] = "ручцы";
}
game : dict {
["ручкі/рд"] = "ручак";
["ручкі/вн"] = "ручкі";
["ручкі/дт"] = "ручкам";
["ручкі/тв"] = "ручках";
["ручкі/пр"] = "ручках";
}
game : dict {
["стойка/рд"] = "стойкі";
["стойка/вн"] = "стойку";
["стойка/дт"] = "стойцы";
["стойка/тв"] = "стойкай";
["стойка/пр"] = "стойцы";
}
game : dict {
["стойкі/рд"] = "стоек";
["стойкі/вн"] = "стойкі";
["стойкі/дт"] = "стойкам";
["стойкі/тв"] = "стойкамі";
["стойкі/пр"] = "стойках";
}
game : dict {
["адвёртка/рд"] = "адвёрткі";
["адвёртка/вн"] = "адвёртку";
["адвёртка/дт"] = "адвёртцы";
["адвёртка/тв"] = "адвёрткай";
["адвёртка/пр"] = "адвёртцы";
}
game : dict {
["болцік/рд"] = "болціка";
["болцік/вн"] = "болцік";
["болцік/дт"] = "болціку";
["болцік/тв"] = "болцікам";
["болцік/пр"] = "болціку";
}
game : dict {
["рычаг/рд"] = "рычага";
["рычаг/вн"] = "рычаг";
["рычаг/дт"] = "рычагу";
["рычаг/тв"] = "рычагом";
["рычаг/пр"] = "рычагу";
}
game : dict {
["дзверы/рд"] = "дзвярэй";
["дзверы/вн"] = "дзверы";
["дзверы/дт"] = "дзвярам";
["дзверы/тв"] = "дзвярамі";
["дзверы/пр"] = "дзвярах";
}
game : dict {
["абсталяванне/рд"] = "абсталявання";
["абсталяванне/вн"] = "абсталяванне";
["абсталяванне/дт"] = "абсталяванню";
["абсталяванне/тв"] = "абсталяваннем";
["абсталяванне/пр"] = "абсталяванні";
}
game : dict {
["запчастка/рд"] = "запчасткі";
["запчастка/вн"] = "запчастку";
["запчастка/дт"] = "запчастцы";
["запчастка/тв"] = "запчасткай";
["запчастка/пр"] = "запчастцы";
}
game : dict {
["кантролер/рд"] = "кантролера";
["кантролер/вн"] = "кантролер";
["кантролер/дт"] = "кантролеру";
["кантролер/тв"] = "кантролерам";
["кантролер/пр"] = "кантролеры";
}
game : dict {
["радыёмаяк/рд"] = "радыёмаяка";
["радыёмаяк/вн"] = "радыёмаяк";
["радыёмаяк/дт"] = "радыёмаяку";
["радыёмаяк/тв"] = "радыёмаяком";
["радыёмаяк/пр"] = "радыёмаяку";
}
game : dict {
["трансмітэр/рд"] = "трансмітэра";
["трансмітэр/вн"] = "трансмітэр";
["трансмітэр/дт"] = "трансмітэру";
["трансмітэр/тв"] = "трансмітэрам";
["трансмітэр/пр"] = "трансмітэры";
}
game : dict {
["касманаўт/рд"] = "касманаўта";
["касманаўт/вн"] = "касманаўта";
["касманаўт/дт"] = "касманаўту";
["касманаўт/тв"] = "касманаўтам";
["касманаўт/пр"] = "касманаўце";
}
game : dict {
["Зямля/рд"] = "Зямлі";
["Зямля/вн"] = "Зямлю";
["Зямля/дт"] = "Зямлі";
["Зямля/тв"] = "Зямлёй";
["Зямля/пр"] = "Зямлі";
}
game : dict {
["зямля/рд"] = "зямлі";
["зямля/вн"] = "зямлю";
["зямля/дт"] = "зямлі";
["зямля/тв"] = "зямлёй";
["зямля/пр"] = "зямлі";
}
game : dict {
["грунт/рд"] = "грунта";
["грунт/вн"] = "грунт";
["грунт/дт"] = "грунту";
["грунт/тв"] = "грунтам";
["грунт/пр"] = "грунце";
}
game : dict {
["Месяц/рд"] = "Месяца";
["Месяц/вн"] = "Месяц";
["Месяц/дт"] = "Месяцу";
["Месяц/тв"] = "Месяцам";
["Месяц/пр"] = "Месяцы";
}
game : dict {
["месяцаход/рд"] = "месяцахода";
["месяцаход/вн"] = "месяцаход";
["месяцаход/дт"] = "месяцаходу";
["месяцаход/тв"] = "месяцаходам";
["месяцаход/пр"] = "месяцаходзе";
}
game : dict {
["плакат/рд"] = "плаката";
["плакат/вн"] = "плакат";
["плакат/дт"] = "плакату";
["плакат/тв"] = "плакатам";
["плакат/пр"] = "плакаце";
}
game : dict {
["постэр/рд"] = "постэра";
["постэр/вн"] = "постэр";
["постэр/дт"] = "постэру";
["постэр/тв"] = "постэрам";
["постэр/пр"] = "постэры";
}
game : dict {
["бутэрброд/рд"] = "бутэрброда";
["бутэрброд/вн"] = "бутэрброд";
["бутэрброд/дт"] = "бутэрброду";
["бутэрброд/тв"] = "бутэрбродам";
["бутэрброд/пр"] = "бутэрбродзе";
}
game : dict {
["хлеб/рд"] = "хлеба";
["хлеб/вн"] = "хлеб";
["хлеб/дт"] = "хлебу";
["хлеб/тв"] = "хлебам";
["хлеб/пр"] = "хлебе";
}
game : dict {
["сыр/рд"] = "сыра";
["сыр/вн"] = "сыр";
["сыр/дт"] = "сыру";
["сыр/тв"] = "сырам";
["сыр/пр"] = "сыры";
}
game : dict {
["цмок/рд"] = "цмока";
["цмок/вн"] = "цмока";
["цмок/дт"] = "цмоку";
["цмок/тв"] = "цмокам";
["цмок/пр"] = "цмоку";
}
game : dict {
["пульт/рд"] = "пульта";
["пульт/вн"] = "пульт";
["пульт/дт"] = "пульту";
["пульт/тв"] = "пультам";
["пульт/пр"] = "пульце";
}
game : dict {
["кампутар/рд"] = "кампутара";
["кампутар/вн"] = "кампутар";
["кампутар/дт"] = "кампутару";
["кампутар/тв"] = "кампутарам";
["кампутар/пр"] = "кампутары";
}
game : dict {
["чмель/рд"] = "чмяля";
["чмель/вн"] = "чмяля";
["чмель/дт"] = "чмялю";
["чмель/тв"] = "чмялём";
["чмель/пр"] = "чмялі";
}
game : dict {
["мятлік/рд"] = "мятліка";
["мятлік/вн"] = "мятліка";
["мятлік/дт"] = "мятліку";
["мятлік/тв"] = "мятлікам";
["мятлік/пр"] = "мятліку";
}
game : dict {
["валасы/рд"] = "валасоў";
["валасы/вн"] = "валасы";
["валасы/дт"] = "валасам";
["валасы/тв"] = "валасамі";
["валасы/пр"] = "валасах";
}
game : dict {
["гай/рд"] = "гая";
["гай/вн"] = "гай";
["гай/дт"] = "гаю";
["гай/тв"] = "гаем";
["гай/пр"] = "гаі";
}
game : dict {
["голуб/рд"] = "голуба";
["голуб/вн"] = "голуба";
["голуб/дт"] = "голубу";
["голуб/тв"] = "голубам";
["голуб/пр"] = "голубе";
}
game : dict {
["дрэль/рд"] = "дрэлі";
["дрэль/вн"] = "дрэль";
["дрэль/дт"] = "дрэлі";
["дрэль/тв"] = "дрэллю";
["дрэль/пр"] = "дрэлі";
}
game : dict {
["шрубавёрт/рд"] = "шрубавёрта";
["шрубавёрт/вн"] = "шрубавёрт";
["шрубавёрт/дт"] = "шрубавёрту";
["шрубавёрт/тв"] = "шрубавёртам";
["шрубавёрт/пр"] = "шрубавёрце";
}
game : dict {
["насякомыя/рд"] = "насякомых";
["насякомыя/вн"] = "насякомых";
["насякомыя/дт"] = "насякомым";
["насякомыя/тв"] = "насякомымі";
["насякомыя/пр"] = "насякомых";
}
game : dict {
["жамяра/рд"] = "жамяры";
["жамяра/вн"] = "жамяру";
["жамяра/дт"] = "жамяры";
["жамяра/тв"] = "жамярай";
["жамяра/пр"] = "жамяры";
}
game : dict {
["апоры/рд"] = "апораў";
["апоры/вн"] = "апоры";
["апоры/дт"] = "апорам";
["апоры/тв"] = "апорамі";
["апоры/пр"] = "апорах";
}
game : dict {
["пыл/рд"] = "пылу";
["пыл/вн"] = "пыл";
["пыл/дт"] = "пылу";
["пыл/тв"] = "пылам";
["пыл/пр"] = "пыле";
}
game : dict {
["тросы/рд"] = "тросаў";
["тросы/вн"] = "тросы";
["тросы/дт"] = "тросам";
["тросы/тв"] = "тросамі";
["тросы/пр"] = "тросах";
}
game : dict {
["балты/рд"] = "балтоў";
["балты/вн"] = "балты";
["балты/дт"] = "балтам";
["балты/тв"] = "балтамі";
["балты/пр"] = "балтах";
}
game : dict {
["станцыя/рд"] = "станцыі";
["станцыя/вн"] = "станцыю";
["станцыя/дт"] = "станцыі";
["станцыя/тв"] = "станцыяй";
["станцыя/пр"] = "станцыі";
}
game : dict {
["электрастанцыя/рд"] = "электрастанцыі";
["электрастанцыя/вн"] = "электрастанцыю";
["электрастанцыя/дт"] = "электрастанцыі";
["электрастанцыя/тв"] = "электрастанцыяй";
["электрастанцыя/пр"] = "электрастанцыі";
}
game : dict {
["акумулятар/рд"] = "акумулятара";
["акумулятар/вн"] = "акумулятар";
["акумулятар/дт"] = "акумулятару";
["акумулятар/тв"] = "акумулятарам";
["акумулятар/пр"] = "акумулятары";
}
game : dict {
["батарэя/рд"] = "батарэі";
["батарэя/вн"] = "батарэю";
["батарэя/дт"] = "батарэі";
["батарэя/тв"] = "батарэяй";
["батарэя/пр"] = "батарэі";
}
game : dict {
["батарэі/рд"] = "батарэяў";
["батарэі/вн"] = "батарэі";
["батарэі/дт"] = "батарэям";
["батарэі/тв"] = "батарэямі";
["батарэі/пр"] = "батарэях";
}
game : dict {
["колба/рд"] = "колбы";
["колба/вн"] = "колбу";
["колба/дт"] = "колбе";
["колба/тв"] = "колбай";
["колба/пр"] = "колбе";
}
game : dict {
["шафа/рд"] = "шафы";
["шафа/вн"] = "шафу";
["шафа/дт"] = "шафе";
["шафа/тв"] = "шафай";
["шафа/пр"] = "шафе";
}
game : dict {
["шафка/рд"] = "шафкі";
["шафка/вн"] = "шафку";
["шафка/дт"] = "шафцы";
["шафка/тв"] = "шафкай";
["шафка/пр"] = "шафцы";
}
game : dict {
["шафкі/рд"] = "шафак";
["шафкі/вн"] = "шафкі";
["шафкі/дт"] = "шафкам";
["шафкі/тв"] = "шафкамі";
["шафкі/пр"] = "шафках";
}
game : dict {
["асколкі/рд"] = "асколкаў";
["асколкі/вн"] = "асколкі";
["асколкі/дт"] = "асколкам";
["асколкі/тв"] = "асколкамі";
["асколкі/пр"] = "асколках";
}
game : dict {
["аскепкі/рд"] = "аскепкаў";
["аскепкі/вн"] = "аскепкі";
["аскепкі/дт"] = "аскепкам";
["аскепкі/тв"] = "аскепкамі";
["аскепкі/пр"] = "аскепках";
}
game : dict {
["беркут/рд"] = "беркута";
["беркут/вн"] = "беркута";
["беркут/дт"] = "беркуту";
["беркут/тв"] = "беркутам";
["беркут/пр"] = "беркуце";
}
game : dict {
["ястраб/рд"] = "ястраба";
["ястраб/вн"] = "ястраба";
["ястраб/дт"] = "ястрабу";
["ястраб/тв"] = "ястрабам";
["ястраб/пр"] = "ястрабе";
}
game:dict {
["ўмець"] = {
"ўмее/нст"
}}
game : dict {
["Аляксандр/рд"] = "Аляксандра";
["Аляксандр/вн"] = "Аляксандра";
["Аляксандр/дт"] = "Аляксандру";
["Аляксандр/тв"] = "Аляксандрам";
["Аляксандр/пр"] = "Аляксандры";
}
game:dict {
["прыдумаць"] = {
"прыдумаў/прш"
}}
game:dict {
["зачыніць"] = {
"зачыненыя/3л,мн,нст"
}}
game : dict {
["антэна/рд"] = "антэны";
["антэна/вн"] = "антэну";
["антэна/дт"] = "антэне";
["антэна/тв"] = "антэнай";
["антэна/пр"] = "антэне";
}
game : dict {
["цемра/рд"] = "цемры";
["цемра/вн"] = "цемру";
["цемра/дт"] = "цемры";
["цемра/тв"] = "цемрай";
["цемра/пр"] = "цемры";
}
game : dict {
["кашуля/рд"] = "кашулі";
["кашуля/вн"] = "кашулю";
["кашуля/дт"] = "кашулі";
["кашуля/тв"] = "кашуляй";
["кашуля/пр"] = "кашулі";
}
game : dict {
["спадніца/рд"] = "спадніцы";
["спадніца/вн"] = "спадніцу";
["спадніца/дт"] = "спадніцы";
["спадніца/тв"] = "спадніцай";
["спадніца/пр"] = "спадніцы";
}
game : dict {
["паліца/рд"] = "паліцы";
["паліца/вн"] = "паліцу";
["паліца/дт"] = "паліцы";
["паліца/тв"] = "паліцай";
["паліца/пр"] = "паліцы";
}
game : dict {
["каралева/рд"] = "каралевы";
["каралева/вн"] = "каралеву";
["каралева/дт"] = "каралеве";
["каралева/тв"] = "каралевай";
["каралева/пр"] = "каралеве";
}
game : dict {
["дошка/рд"] = "дошкі";
["дошка/вн"] = "дошку";
["дошка/дт"] = "дошцы";
["дошка/тв"] = "дошкай";
["дошка/пр"] = "дошцы";
}
game : dict {
["кацянё/рд"] = "кацяняці";
["кацянё/вн"] = "кацянё";
["кацянё/дт"] = "кацяняці";
["кацянё/тв"] = "кацянём";
["кацянё/пр"] = "кацяняці";
}
game : dict {
["чорнае/рд"] = "чорнага";
["чорнае/вн"] = "чорнае";
["чорнае/дт"] = "чорнаму";
["чорнае/тв"] = "чорным";
["чорнае/пр"] = "чорным";
}
game : dict {
["чорная/рд"] = "чорнай";
["чорная/вн"] = "чорную";
["чорная/дт"] = "чорнай";
["чорная/тв"] = "чорнай";
["чорная/пр"] = "чорнай";
}
game : dict {
["белае/рд"] = "белага";
["белае/вн"] = "белае";
["белае/дт"] = "беламу";
["белае/тв"] = "белым";
["белае/пр"] = "белым";
}
game : dict {
["камін/рд"] = "каміна";
["камін/вн"] = "камін";
["камін/дт"] = "каміну";
["камін/тв"] = "камінам";
["камін/пр"] = "каміне";
}
game : dict {
["агонь/рд"] = "агню";
["агонь/вн"] = "агонь";
["агонь/дт"] = "агню";
["агонь/тв"] = "агнём";
["агонь/пр"] = "агні";
}
game : dict {
["рашотка/рд"] = "рашоткі";
["рашотка/вн"] = "рашотку";
["рашотка/дт"] = "рашотцы";
["рашотка/тв"] = "рашоткай";
["рашотка/пр"] = "рашотцы";
}
game : dict {
["шыба/рд"] = "шыбы";
["шыба/вн"] = "шыбу";
["шыба/дт"] = "шыбе";
["шыба/тв"] = "шыбай";
["шыба/пр"] = "шыбе";
}
game : dict {
["сняжынкі/рд"] = "сняжынак";
["сняжынкі/вн"] = "сняжынкі";
["сняжынкі/дт"] = "сняжынкам";
["сняжынкі/тв"] = "сняжынкамі";
["сняжынкі/пр"] = "сняжынках";
}
game : dict {
["клубок/рд"] = "клубка";
["клубок/вн"] = "клубок";
["клубок/дт"] = "клубку";
["клубок/тв"] = "клубком";
["клубок/пр"] = "клубку";
}
game : dict {
["клубочак/рд"] = "клубочка";
["клубочак/вн"] = "клубочак";
["клубочак/дт"] = "клубочку";
["клубочак/тв"] = "клубочкам";
["клубочак/пр"] = "клубочку";
}
game : dict {
["птушаня/рд"] = "птушаняці";
["птушаня/вн"] = "птушаня";
["птушаня/дт"] = "птушаняці";
["птушаня/тв"] = "птушаняці";
["птушаня/пр"] = "птушаняці";
}
game : dict {
["гняздо/рд"] = "гнязда";
["гняздо/вн"] = "гняздо";
["гняздо/дт"] = "гнязду";
["гняздо/тв"] = "гняздом";
["гняздо/пр"] = "гняздзе";
}
game : dict {
["сук/рд"] = "сука";
["сук/вн"] = "сук";
["сук/дт"] = "суку";
["сук/тв"] = "сукам";
["сук/пр"] = "суку";
}
game : dict {
["галіна/рд"] = "галіны";
["галіна/вн"] = "галіну";
["галіна/дт"] = "галіне";
["галіна/тв"] = "галінай";
["галіна/пр"] = "галіне";
}
game : dict {
["акенца/рд"] = "акенца";
["акенца/вн"] = "акенца";
["акенца/дт"] = "акенцу";
["акенца/тв"] = "акенцам";
["акенца/пр"] = "акенцы";
}
game : dict {
["стул/рд"] = "стула";
["стул/вн"] = "стул";
["стул/дт"] = "стулу";
["стул/тв"] = "стулам";
["стул/пр"] = "стуле";
}
game : dict {
["карціна/рд"] = "карціны";
["карціна/вн"] = "карціну";
["карціна/дт"] = "карціне";
["карціна/тв"] = "карцінай";
["карціна/пр"] = "карціне";
}
game : dict {
["карціны/рд"] = "карцінаў";
["карціны/вн"] = "карціны";
["карціны/дт"] = "карцінам";
["карціны/тв"] = "карцінамі";
["карціны/пр"] = "карцінах";
}
game : dict {
["папера/рд"] = "паперы";
["папера/вн"] = "паперу";
["папера/дт"] = "паперы";
["папера/тв"] = "паперай";
["папера/пр"] = "паперы";
}
game : dict {
["паперы/рд"] = "папер";
["паперы/вн"] = "паперы";
["паперы/дт"] = "паперам";
["паперы/тв"] = "паперамі";
["паперы/пр"] = "паперах";
}
game : dict {
["накіды/рд"] = "накідаў";
["накіды/вн"] = "накіды";
["накіды/дт"] = "накідам";
["накіды/тв"] = "накідамі";
["накіды/пр"] = "накідах";
}
game : dict {
["накідкі/рд"] = "накідкаў";
["накідкі/вн"] = "накідкі";
["накідкі/дт"] = "накідкам";
["накідкі/тв"] = "накідкамі";
["накідкі/пр"] = "накідках";
}
game : dict {
["абрыўкі/рд"] = "абрыўкаў";
["абрыўкі/вн"] = "абрыўкі";
["абрыўкі/дт"] = "абрыўкам";
["абрыўкі/тв"] = "абрыўкамі";
["абрыўкі/пр"] = "абрыўках";
}
game : dict {
["шматкі/рд"] = "шматкоў";
["шматкі/вн"] = "шматкі";
["шматкі/дт"] = "шматкам";
["шматкі/тв"] = "шматкамі";
["шматкі/пр"] = "шматках";
}
game : dict {
["палатно/рд"] = "палатна";
["палатно/вн"] = "палатно";
["палатно/дт"] = "палатну";
["палатно/тв"] = "палатном";
["палатно/пр"] = "палатне";
}
game : dict {
["мальберт/рд"] = "мальберта";
["мальберт/вн"] = "мальберт";
["мальберт/дт"] = "мальберту";
["мальберт/тв"] = "мальбертам";
["мальберт/пр"] = "мальберце";
}
game : dict {
["фарбы/рд"] = "фарбаў";
["фарбы/вн"] = "фарбы";
["фарбы/дт"] = "фарбам";
["фарбы/тв"] = "фарбамі";
["фарбы/пр"] = "фарбах";
}
game : dict {
["фарба/рд"] = "фарбы";
["фарба/вн"] = "фарбу";
["фарба/дт"] = "фарбе";
["фарба/тв"] = "фарбай";
["фарба/пр"] = "фарбе";
}
game : dict {
["пэндзаль/рд"] = "пэндзаля";
["пэндзаль/вн"] = "пэндзаль";
["пэндзаль/дт"] = "пэндзлю";
["пэндзаль/тв"] = "пэндзлем";
["пэндзаль/пр"] = "пэндзлі";
}
game : dict {
["пэндзлік/рд"] = "пэндзліка";
["пэндзлік/вн"] = "пэндзлік";
["пэндзлік/дт"] = "пэндзліку";
["пэндзлік/тв"] = "пэндзлікам";
["пэндзлік/пр"] = "пэндзліку";
}
game : dict {
["зэдлік/рд"] = "зэдліка";
["зэдлік/вн"] = "зэдлік";
["зэдлік/дт"] = "зэдліку";
["зэдлік/тв"] = "зэдлікам";
["зэдлік/пр"] = "зэдліку";
}
game:dict {
["залазіць"] = {
"залажу/1л,нст";
"залазіш/2л,нст";
"залазіць/3л,нст"
}}
game:dict {
["браць"] = {
"бяру/1л,нст";
"бярэш/2л,нст";
"бярэь/3л,нст"
}}
game : dict {
["я/рд"] = "мяне";
["я/вн"] = "мяне";
["я/дт"] = "мне";
["я/тв"] = "мной";
["я/пр"] = "мне";
}
game:dict {
["знаходзіцца"] = {
"знаходжуся/1л,нст";
"знаходзішся/2л,нст";
"знаходзіцца/3л,нст";
}}
game : dict {
["сілуэт/рд"] = "сілуэта";
["сілуэт/вн"] = "сілуэт";
["сілуэт/дт"] = "сілуэту";
["сілуэт/тв"] = "сілуэтам";
["сілуэт/пр"] = "сілуэце";
}
game : dict {
["чалавек/рд"] = "чалавека";
["чалавек/вн"] = "чалавека";
["чалавек/дт"] = "чалавеку";
["чалавек/тв"] = "чалавекам";
["чалавек/пр"] = "чалавеку";
}
game : dict {
["постаць/рд"] = "постаці";
["постаць/вн"] = "постаць";
["постаць/дт"] = "постаці";
["постаць/тв"] = "постаццю";
["постаць/пр"] = "постаці";
}
game : dict {
["майстэрня/рд"] = "майстэрні";
["майстэрня/вн"] = "майстэрню";
["майстэрня/дт"] = "майстэрні";
["майстэрня/тв"] = "майстэрняй";
["майстэрня/пр"] = "майстэрні";
}
game : dict {
["дах/рд"] = "даху";
["дах/вн"] = "дах";
["дах/дт"] = "даху";
["дах/тв"] = "дахам";
["дах/пр"] = "даху";
}
game : dict {
["паддашак/рд"] = "паддашка";
["паддашак/вн"] = "паддашак";
["паддашак/дт"] = "паддашку";
["паддашак/тв"] = "паддашкам";
["паддашак/пр"] = "паддашку";
}
game : dict {
["лава/рд"] = "лавы";
["лава/вн"] = "лаву";
["лава/дт"] = "лаве";
["лава/тв"] = "лавай";
["лава/пр"] = "лаве";
}
game : dict {
["лаўка/рд"] = "лаўкі";
["лаўка/вн"] = "лаўку";
["лаўка/дт"] = "лаўцы";
["лаўка/тв"] = "лаўкай";
["лаўка/пр"] = "лаўцы";
}
game : dict {
["лавачка/рд"] = "лавачкі";
["лавачка/вн"] = "лавачку";
["лавачка/дт"] = "лавачцы";
["лавачка/тв"] = "лавачкай";
["лавачка/пр"] = "лавачцы";
}
game : dict {
["парк/рд"] = "парка";
["парк/вн"] = "парк";
["парк/дт"] = "парку";
["парк/тв"] = "паркам";
["парк/пр"] = "парку";
}
game : dict {
["лісце/рд"] = "лісця";
["лісце/вн"] = "лісце";
["лісце/дт"] = "лісцю";
["лісце/тв"] = "лісцем";
["лісце/пр"] = "лісці";
}
game : dict {
["лістота/рд"] = "лістоты";
["лістота/вн"] = "лістоту";
["лістота/дт"] = "лістоце";
["лістота/тв"] = "лістотай";
["лістота/пр"] = "лістоце";
}
game : dict {
["дрэва/рд"] = "дрэва";
["дрэва/вн"] = "дрэва";
["дрэва/дт"] = "дрэву";
["дрэва/тв"] = "дрэвам";
["дрэва/пр"] = "дрэве";
}
game : dict {
["дрэвы/рд"] = "дрэваў";
["дрэвы/вн"] = "дрэвы";
["дрэвы/дт"] = "дрэвам";
["дрэвы/тв"] = "дрэвамі";
["дрэвы/пр"] = "дрэвах";
}
game : dict {
["аблокі/рд"] = "аблокаў";
["аблокі/вн"] = "аблокі";
["аблокі/дт"] = "аблокам";
["аблокі/тв"] = "аблокамі";
["аблокі/пр"] = "аблоках";
}
game : dict {
["хмары/рд"] = "хмараў";
["хмары/вн"] = "хмары";
["хмары/дт"] = "хмарам";
["хмары/тв"] = "хмарамі";
["хмары/пр"] = "хмарах";
}
game : dict {
["хмаркі/рд"] = "хмарак";
["хмаркі/вн"] = "хмаркі";
["хмаркі/дт"] = "хмаркам";
["хмаркі/тв"] = "хмаркамі";
["хмаркі/пр"] = "хмарках";
}
game : dict {
["хмурынкі/рд"] = "хмурынак";
["хмурынкі/вн"] = "хмурынкі";
["хмурынкі/дт"] = "хмурынкам";
["хмурынкі/тв"] = "хмурынкамі";
["хмурынкі/пр"] = "хмурынках";
}
game : dict {
["нябёсы/рд"] = "нябёсаў";
["нябёсы/вн"] = "нябёсы";
["нябёсы/дт"] = "нябёсам";
["нябёсы/тв"] = "нябёсамі";
["нябёсы/пр"] = "нябёсах";
}
game : dict {
["наведнікі/рд"] = "наведнікаў";
["наведнікі/вн"] = "наведнікаў";
["наведнікі/дт"] = "наведнікам";
["наведнікі/тв"] = "наведнікамі";
["наведнікі/пр"] = "наведніках";
}
game : dict {
["мінакі/рд"] = "мінакоў";
["мінакі/вн"] = "мінакоў";
["мінакі/дт"] = "мінакам";
["мінакі/тв"] = "мінакамі";
["мінакі/пр"] = "мінаках";
}
game : dict {
["прахожыя/рд"] = "прахожых";
["прахожыя/вн"] = "прахожых";
["прахожыя/дт"] = "прахожым";
["прахожыя/тв"] = "прахожымі";
["прахожыя/пр"] = "прахожых";
}
game : dict {
["людзі/рд"] = "людзей";
["людзі/вн"] = "людзей";
["людзі/дт"] = "людзям";
["людзі/тв"] = "людзьмі";
["людзі/пр"] = "людзях";
}
game : dict {
["хлопчык/рд"] = "хлопчыка";
["хлопчык/вн"] = "хлопчыка";
["хлопчык/дт"] = "хлопчыку";
["хлопчык/тв"] = "хлопчыкам";
["хлопчык/пр"] = "хлопчыку";
}
game : dict {
["хлопец/рд"] = "хлопца";
["хлопец/вн"] = "хлопца";
["хлопец/дт"] = "хлопцу";
["хлопец/тв"] = "хлопцам";
["хлопец/пр"] = "хлопцы";
}
game : dict {
["хлапчышка/рд"] = "хлапчышкі";
["хлапчышка/вн"] = "хлапчышку";
["хлапчышка/дт"] = "хлапчышку";
["хлапчышка/тв"] = "хлапчышкам";
["хлапчышка/пр"] = "хлапчышку";
}
game : dict {
["малы/рд"] = "малога";
["малы/вн"] = "малога";
["малы/дт"] = "малому";
["малы/тв"] = "малым";
["малы/пр"] = "малым";
}
game : dict {
["малец/рд"] = "мальца";
["малец/вн"] = "мальца";
["малец/дт"] = "мальцу";
["малец/тв"] = "мальцом";
["малец/пр"] = "мальцы";
}
game : dict {
["пацан/рд"] = "пацана";
["пацан/вн"] = "пацана";
["пацан/дт"] = "пацану";
["пацан/тв"] = "пацаном";
["пацан/пр"] = "пацане";
}
game : dict {
["дзіця/рд"] = "дзіцяці";
["дзіця/вн"] = "дзіця";
["дзіця/дт"] = "дзіцяці";
["дзіця/тв"] = "дзіцём";
["дзіця/пр"] = "дзіцяці";
}
game : dict {
["дзіцёнак/рд"] = "дзіцёнка";
["дзіцёнак/вн"] = "дзіцёнка";
["дзіцёнак/дт"] = "дзіцёнку";
["дзіцёнак/тв"] = "дзіцёнкам";
["дзіцёнак/пр"] = "дзіцёнку";
}
game : dict {
["брама/рд"] = "брамы";
["брама/вн"] = "браму";
["брама/дт"] = "браме";
["брама/тв"] = "брамай";
["брама/пр"] = "браме";
}
game : dict {
["вароты/рд"] = "варотаў";
["вароты/вн"] = "вароты";
["вароты/дт"] = "варотам";
["вароты/тв"] = "варотамі";
["вароты/пр"] = "варотах";
}
game : dict {
["горад/рд"] = "горада";
["горад/вн"] = "горад";
["горад/дт"] = "гораду";
["горад/тв"] = "горадам";
["горад/пр"] = "горадзе";
}
game : dict {
["вуліца/рд"] = "вуліцы";
["вуліца/вн"] = "вуліцу";
["вуліца/дт"] = "вуліцы";
["вуліца/тв"] = "вуліцай";
["вуліца/пр"] = "вуліцы";
}
game : dict {
["дарога/рд"] = "дарогі";
["дарога/вн"] = "дарогу";
["дарога/дт"] = "дарозе";
["дарога/тв"] = "дарогай";
["дарога/пр"] = "дарозе";
}
game : dict {
["сцежка/рд"] = "сцежкі";
["сцежка/вн"] = "сцежку";
["сцежка/дт"] = "сцежцы";
["сцежка/тв"] = "сцежкай";
["сцежка/пр"] = "сцежцы";
}
game : dict {
["сцяжынка/рд"] = "сцяжынкі";
["сцяжынка/вн"] = "сцяжынку";
["сцяжынка/дт"] = "сцяжынцы";
["сцяжынка/тв"] = "сцяжынкай";
["сцяжынка/пр"] = "сцяжынцы";
}
game : dict {
["сцежачка/рд"] = "сцежачкі";
["сцежачка/вн"] = "сцежачку";
["сцежачка/дт"] = "сцежачцы";
["сцежачка/тв"] = "сцежачкай";
["сцежачка/пр"] = "сцежачцы";
}
game : dict {
["возера/рд"] = "возера";
["возера/вн"] = "возера";
["возера/дт"] = "возеру";
["возера/тв"] = "возерам";
["возера/пр"] = "возеры";
}
game : dict {
["азярына/рд"] = "азярыны";
["азярына/вн"] = "азярыну";
["азярына/дт"] = "азярыне";
["азярына/тв"] = "азярынай";
["азярына/пр"] = "азярыне";
}
game : dict {
["азярынка/рд"] = "азярынкі";
["азярынка/вн"] = "азярынку";
["азярынка/дт"] = "азярынцы";
["азярынка/тв"] = "азярынкай";
["азярынка/пр"] = "азярынцы";
}
game : dict {
["сажалка/рд"] = "сажалкі";
["сажалка/вн"] = "сажалку";
["сажалка/дт"] = "сажалцы";
["сажалка/тв"] = "сажалкай";
["сажалка/пр"] = "сажалцы";
}
game : dict {
["галька/рд"] = "галькі";
["галька/вн"] = "гальку";
["галька/дт"] = "гальцы";
["галька/тв"] = "галькай";
["галька/пр"] = "гальцы";
}
game : dict {
["каменне/рд"] = "камення";
["каменне/вн"] = "каменне";
["каменне/дт"] = "каменню";
["каменне/тв"] = "каменнем";
["каменне/пр"] = "каменні";
}
game : dict {
["сад/рд"] = "сада";
["сад/вн"] = "сад";
["сад/дт"] = "саду";
["сад/тв"] = "садам";
["сад/пр"] = "садзе";
}
game : dict {
["яблыкі/рд"] = "яблыкаў";
["яблыкі/вн"] = "яблыкі";
["яблыкі/дт"] = "яблыкам";
["яблыкі/тв"] = "яблыкамі";
["яблыкі/пр"] = "яблыках";
}
game : dict {
["дамы/рд"] = "дамоў";
["дамы/вн"] = "дамы";
["дамы/дт"] = "дамам";
["дамы/тв"] = "дамамі";
["дамы/пр"] = "дамах";
}
game : dict {
["гмахі/рд"] = "гмахаў";
["гмахі/вн"] = "гмахі";
["гмахі/дт"] = "гмахам";
["гмахі/тв"] = "гмахамі";
["гмахі/пр"] = "гмахах";
}
game : dict {
["будынкі/рд"] = "будынкаў";
["будынкі/вн"] = "будынкі";
["будынкі/дт"] = "будынкам";
["будынкі/тв"] = "будынкамі";
["будынкі/пр"] = "будынках";
}
game : dict {
["шматпавярховікі/рд"] = "шматпавярховікаў";
["шматпавярховікі/вн"] = "шматпавярховікі";
["шматпавярховікі/дт"] = "шматпавярховікам";
["шматпавярховікі/тв"] = "шматпавярховікамі";
["шматпавярховікі/пр"] = "шматпавярховіках";
}
game : dict {
["яма/рд"] = "ямы";
["яма/вн"] = "яму";
["яма/дт"] = "яме";
["яма/тв"] = "ямай";
["яма/пр"] = "яме";
}
game : dict {
["ямы/рд"] = "ямаў";
["ямы/вн"] = "ямы";
["ямы/дт"] = "ямам";
["ямы/тв"] = "ямамі";
["ямы/пр"] = "ямах";
}
game : dict {
["яміны/рд"] = "ямінаў";
["яміны/вн"] = "яміны";
["яміны/дт"] = "ямінам";
["яміны/тв"] = "ямінамі";
["яміны/пр"] = "ямінах";
}
game : dict {
["выбоіны/рд"] = "выбоінаў";
["выбоіны/вн"] = "выбоіны";
["выбоіны/дт"] = "выбоінам";
["выбоіны/тв"] = "выбоінамі";
["выбоіны/пр"] = "выбоінах";
}
game : dict {
["слуп/рд"] = "слупа";
["слуп/вн"] = "слуп";
["слуп/дт"] = "слупу";
["слуп/тв"] = "слупам";
["слуп/пр"] = "слупе";
}
game : dict {
["рэпрадуктар/рд"] = "рэпрадуктара";
["рэпрадуктар/вн"] = "рэпрадуктар";
["рэпрадуктар/дт"] = "рэпрадуктару";
["рэпрадуктар/тв"] = "рэпрадуктарам";
["рэпрадуктар/пр"] = "рэпрадуктары";
}
game : dict {
["конус/рд"] = "конуса";
["конус/вн"] = "конус";
["конус/дт"] = "конусу";
["конус/тв"] = "конусам";
["конус/пр"] = "конусе";
}
game : dict {
["варонка/рд"] = "варонкі";
["варонка/вн"] = "варонку";
["варонка/дт"] = "варонцы";
["варонка/тв"] = "варонкай";
["варонка/пр"] = "варонцы";
}
game : dict {
["пераход/рд"] = "перахода";
["пераход/вн"] = "пераход";
["пераход/дт"] = "пераходу";
["пераход/тв"] = "пераходам";
["пераход/пр"] = "пераходзе";
}
game : dict {
["зала/рд"] = "залы";
["зала/вн"] = "залу";
["зала/дт"] = "зале";
["зала/тв"] = "залай";
["зала/пр"] = "зале";
}
game : dict {
["лесвіцы/рд"] = "лесвіцаў";
["лесвіцы/вн"] = "лесвіцы";
["лесвіцы/дт"] = "лесвіцам";
["лесвіцы/тв"] = "лесвіцамі";
["лесвіцы/пр"] = "лесвіцах";
}
game : dict {
["лямпы/рд"] = "лямпаў";
["лямпы/вн"] = "лямпы";
["лямпы/дт"] = "лямпам";
["лямпы/тв"] = "лямпамі";
["лямпы/пр"] = "лямпах";
}
game : dict {
["ліхтары/рд"] = "ліхтароў";
["ліхтары/вн"] = "ліхтары";
["ліхтары/дт"] = "ліхтарам";
["ліхтары/тв"] = "ліхтарамі";
["ліхтары/пр"] = "ліхтарах";
}
game : dict {
["салдат/рд"] = "салдата";
["салдат/вн"] = "салдата";
["салдат/дт"] = "салдату";
["салдат/тв"] = "салдатам";
["салдат/пр"] = "салдаце";
}
game : dict {
["жаўнер/рд"] = "жаўнера";
["жаўнер/вн"] = "жаўнера";
["жаўнер/дт"] = "жаўнеру";
["жаўнер/тв"] = "жаўнерам";
["жаўнер/пр"] = "жаўнеры";
}
game : dict {
["вайсковец/рд"] = "вайскоўца";
["вайсковец/вн"] = "вайскоўца";
["вайсковец/дт"] = "вайскоўцу";
["вайсковец/тв"] = "вайскоўцам";
["вайсковец/пр"] = "вайскоўцы";
}
game : dict {
["кабура/рд"] = "кабуры";
["кабура/вн"] = "кабуру";
["кабура/дт"] = "кабуры";
["кабура/тв"] = "кабурой";
["кабура/пр"] = "кабуры";
}
game : dict {
["пісталет/рд"] = "пісталета";
["пісталет/вн"] = "пісталет";
["пісталет/дт"] = "пісталету";
["пісталет/тв"] = "пісталетам";
["пісталет/пр"] = "пісталеце";
}
game : dict {
["плітка/рд"] = "пліткі";
["плітка/вн"] = "плітку";
["плітка/дт"] = "плітцы";
["плітка/тв"] = "пліткай";
["плітка/пр"] = "плітцы";
}
game : dict {
["кафля/рд"] = "кафлі";
["кафля/вн"] = "кафлю";
["кафля/дт"] = "кафлі";
["кафля/тв"] = "кафляй";
["кафля/пр"] = "кафлі";
}
game : dict {
["мужчыны/рд"] = "мужчынаў";
["мужчыны/вн"] = "мужчынаў";
["мужчыны/дт"] = "мужчынам";
["мужчыны/тв"] = "мужчынамі";
["мужчыны/пр"] = "мужчынах";
}
game : dict {
["жанчыны/рд"] = "жанчын";
["жанчыны/вн"] = "жанчын";
["жанчыны/дт"] = "жанчынам";
["жанчыны/тв"] = "жанчынамі";
["жанчыны/пр"] = "жанчынах";
}
game : dict {
["старыя/рд"] = "старых";
["старыя/вн"] = "старых";
["старыя/дт"] = "старым";
["старыя/тв"] = "старымі";
["старыя/пр"] = "старых";
}
game : dict {
["лавы/рд"] = "лаваў";
["лавы/вн"] = "лавы";
["лавы/дт"] = "лавам";
["лавы/тв"] = "лавамі";
["лавы/пр"] = "лавах";
}
game : dict {
["лаўкі/рд"] = "лавак";
["лаўкі/вн"] = "лаўкі";
["лаўкі/дт"] = "лаўкам";
["лаўкі/тв"] = "лаўкамі";
["лаўкі/пр"] = "лаўках";
}
game : dict {
["лавачкі/рд"] = "лавачак";
["лавачкі/вн"] = "лавачкі";
["лавачкі/дт"] = "лавачкам";
["лавачкі/тв"] = "лавачкамі";
["лавачкі/пр"] = "лавачках";
}
game : dict {
["ямка/рд"] = "ямкі";
["ямка/вн"] = "ямку";
["ямка/дт"] = "ямцы";
["ямка/тв"] = "ямкай";
["ямка/пр"] = "ямцы";
}
game : dict {
["яміна/рд"] = "яміны";
["яміна/вн"] = "яміну";
["яміна/дт"] = "яміне";
["яміна/тв"] = "ямінай";
["яміна/пр"] = "яміне";
}
game : dict {
["лунка/рд"] = "лункі";
["лунка/вн"] = "лунку";
["лунка/дт"] = "лунцы";
["лунка/тв"] = "лункай";
["лунка/пр"] = "лунцы";
}
game : dict {
["вадасцёк/рд"] = "вадасцёку";
["вадасцёк/вн"] = "вадасцёк";
["вадасцёк/дт"] = "вадасцёку";
["вадасцёк/тв"] = "вадасцёкам";
["вадасцёк/пр"] = "вадасцёку";
}
game : dict {
["край/рд"] = "края";
["край/вн"] = "край";
["край/дт"] = "краю";
["край/тв"] = "краем";
["край/пр"] = "краі";
}
game : dict {
["жанчына/рд"] = "жанчыны";
["жанчына/вн"] = "жанчыну";
["жанчына/дт"] = "жанчыне";
["жанчына/тв"] = "жанчынай";
["жанчына/пр"] = "жанчыне";
}
game : dict {
["рука/рд"] = "рукі";
["рука/вн"] = "руку";
["рука/дт"] = "руцэ";
["рука/тв"] = "рукой";
["рука/пр"] = "руцэ";
}
game : dict {
["вентыляцыя/рд"] = "вентыляцыі";
["вентыляцыя/вн"] = "вентыляцыю";
["вентыляцыя/дт"] = "вентыляцыі";
["вентыляцыя/тв"] = "вентыляцыяй";
["вентыляцыя/пр"] = "вентыляцыі";
}
game : dict {
["брыль/рд"] = "брыля";
["брыль/вн"] = "брыль";
["брыль/дт"] = "брылю";
["брыль/тв"] = "брылём";
["брыль/пр"] = "брылі";
}
game : dict {
["самалёты/рд"] = "самалётаў";
["самалёты/вн"] = "самалёты";
["самалёты/дт"] = "самалётам";
["самалёты/тв"] = "самалётамі";
["самалёты/пр"] = "самалётах";
}
game : dict {
["самалёт/рд"] = "самалёта";
["самалёт/вн"] = "самалёт";
["самалёт/дт"] = "самалёту";
["самалёт/тв"] = "самалётам";
["самалёт/пр"] = "самалёце";
}
game : dict {
["бомбы/рд"] = "бомбаў";
["бомбы/вн"] = "бомбы";
["бомбы/дт"] = "бомбам";
["бомбы/тв"] = "бомбамі";
["бомбы/пр"] = "бомбах";
}
game : dict {
["бомба/рд"] = "бомбы";
["бомба/вн"] = "бомбу";
["бомба/дт"] = "бомбе";
["бомба/тв"] = "бомбай";
["бомба/пр"] = "бомбе";
}
game : dict {
["аркуш/рд"] = "аркуша";
["аркуш/вн"] = "аркуш";
["аркуш/дт"] = "аркушу";
["аркуш/тв"] = "аркушам";
["аркуш/пр"] = "аркушы";
}
game : dict {
["малюнак/рд"] = "малюнка";
["малюнак/вн"] = "малюнак";
["малюнак/дт"] = "малюнку";
["малюнак/тв"] = "малюнкам";
["малюнак/пр"] = "малюнку";
}
game : dict {
["сабака/рд"] = "сабакі";
["сабака/вн"] = "сабаку";
["сабака/дт"] = "сабаку";
["сабака/тв"] = "сабакам";
["сабака/пр"] = "сабаку";
}
game : dict {
["дварняк/рд"] = "дварняка";
["дварняк/вн"] = "дварняка";
["дварняк/дт"] = "дварняку";
["дварняк/тв"] = "дварняком";
["дварняк/пр"] = "дварняку";
}
game : dict {
["дваранін/рд"] = "двараніна";
["дваранін/вн"] = "двараніна";
["дваранін/дт"] = "двараніну";
["дваранін/тв"] = "дваранінам";
["дваранін/пр"] = "двараніне";
}
game : dict {
["барбос/рд"] = "барбоса";
["барбос/вн"] = "барбоса";
["барбос/дт"] = "барбосу";
["барбос/тв"] = "барбосам";
["барбос/пр"] = "барбосе";
}
game : dict {
["кацяня/рд"] = "кацяняці";
["кацяня/вн"] = "кацяня";
["кацяня/дт"] = "кацяняці";
["кацяня/тв"] = "кацянём";
["кацяня/пр"] = "кацяняці";
}
game : dict {
["каток/рд"] = "катка";
["каток/вн"] = "катка";
["каток/дт"] = "катку";
["каток/тв"] = "катком";
["каток/пр"] = "катку";
}
game : dict {
["коцік/рд"] = "коціка";
["коцік/вн"] = "коціка";
["коцік/дт"] = "коціку";
["коцік/тв"] = "коцікам";
["коцік/пр"] = "коціку";
}
game : dict {
["кот/рд"] = "ката";
["кот/вн"] = "ката";
["кот/дт"] = "кату";
["кот/тв"] = "катом";
["кот/пр"] = "каце";
}
game : dict {
["пажылыя/рд"] = "пажылых";
["пажылыя/вн"] = "пажылых";
["пажылыя/дт"] = "пажылым";
["пажылыя/тв"] = "пажылымі";
["пажылыя/пр"] = "пажылых";
}
game : dict {
["сужонцы/рд"] = "сужонцаў";
["сужонцы/вн"] = "сужонцаў";
["сужонцы/дт"] = "сужонцам";
["сужонцы/тв"] = "сужонцамі";
["сужонцы/пр"] = "сужонцах";
}
--гульня_"Завіруха"
game : dict {
["скрыпка/рд"] = "скрыпкі";
["скрыпка/вн"] = "скрыпку";
["скрыпка/дт"] = "скрыпцы";
["скрыпка/тв"] = "скрыпкай";
["скрыпка/пр"] = "скрыпцы";
}
game : dict {
["бранзалет/рд"] = "бранзалета";
["бранзалет/вн"] = "бранзалет";
["бранзалет/дт"] = "бранзалету";
["бранзалет/тв"] = "бранзалетам";
["бранзалет/пр"] = "бранзалеце";
}
game : dict {
["машына/рд"] = "машыны";
["машына/вн"] = "машыну";
["машына/дт"] = "машыне";
["машына/тв"] = "машынай";
["машына/пр"] = "машыне";
}
game : dict {
["руль/рд"] = "руля";
["руль/вн"] = "руль";
["руль/дт"] = "рулю";
["руль/тв"] = "рулём";
["руль/пр"] = "рулі";
}
game : dict {
["стырно/рд"] = "стырна";
["стырно/вн"] = "стырно";
["стырно/дт"] = "стырну";
["стырно/тв"] = "стырном";
["стырно/пр"] = "стырне";
}
game : dict {
["мама/рд"] = "мамы";
["мама/вн"] = "маму";
["мама/дт"] = "маме";
["мама/тв"] = "мамай";
["мама/пр"] = "маме";
}
game : dict {
["маці/рд"] = "маці";
["маці/вн"] = "маці";
["маці/дт"] = "маці";
["маці/тв"] = "маці";
["маці/пр"] = "маці";
}
game : dict {
["бардачок/рд"] = "бардачка";
["бардачок/вн"] = "бардачок";
["бардачок/дт"] = "бардачку";
["бардачок/тв"] = "бардачком";
["бардачок/пр"] = "бардачку";
}
game : dict {
["завіруха/рд"] = "завірухі";
["завіруха/вн"] = "завіруху";
["завіруха/дт"] = "завірусе";
["завіруха/тв"] = "завірухай";
["завіруха/пр"] = "завірусе";
}
game : dict {
["завея/рд"] = "завеі";
["завея/вн"] = "завею";
["завея/дт"] = "завеі";
["завея/тв"] = "завеяй";
["завея/пр"] = "завеі";
}
game : dict {
["бура/рд"] = "буры";
["бура/вн"] = "буру";
["бура/дт"] = "буры";
["бура/тв"] = "бурай";
["бура/пр"] = "буры";
}
game : dict {
["віхура/рд"] = "віхуры";
["віхура/вн"] = "віхуру";
["віхура/дт"] = "віхуры";
["віхура/тв"] = "віхурай";
["віхура/пр"] = "віхуры";
}
game : dict {
["віхор/рд"] = "віхора";
["віхор/вн"] = "віхор";
["віхор/дт"] = "віхору";
["віхор/тв"] = "віхорам";
["віхор/пр"] = "віхоры";
}
game : dict {
["смерч/рд"] = "смерча";
["смерч/вн"] = "смерч";
["смерч/дт"] = "смерчу";
["смерч/тв"] = "смерчам";
["смерч/пр"] = "смерчы";
}
game : dict {
["смуга/рд"] = "смугі";
["смуга/вн"] = "смугу";
["смуга/дт"] = "смузе";
["смуга/тв"] = "смугой";
["смуга/пр"] = "смузе";
}
game : dict {
["шыбіна/рд"] = "шыбіны";
["шыбіна/вн"] = "шыбіну";
["шыбіна/дт"] = "шыбіне";
["шыбіна/тв"] = "шыбінай";
["шыбіна/пр"] = "шыбіне";
}
game : dict {
["запраўка/рд"] = "запраўкі";
["запраўка/вн"] = "запраўку";
["запраўка/дт"] = "запраўцы";
["запраўка/тв"] = "запраўкай";
["запраўка/пр"] = "запраўцы";
}
game : dict {
["дзверцы/рд"] = "дзверцаў";
["дзверцы/вн"] = "дзверцы";
["дзверцы/дт"] = "дзверцам";
["дзверцы/тв"] = "дзверцамі";
["дзверцы/пр"] = "дзверцах";
}
game : dict {
["скрынка/рд"] = "скрынкі";
["скрынка/вн"] = "скрынку";
["скрынка/дт"] = "скрынцы";
["скрынка/тв"] = "скрынкай";
["скрынка/пр"] = "скрынцы";
}
game : dict {
["снег/рд"] = "снегу";
["снег/вн"] = "снег";
["снег/дт"] = "снегу";
["снег/тв"] = "снегам";
["снег/пр"] = "снезе";
}
game : dict {
["воблака/рд"] = "воблака";
["воблака/вн"] = "воблака";
["воблака/дт"] = "воблаку";
["воблака/тв"] = "воблакам";
["воблака/пр"] = "воблаку";
}
game : dict {
["поле/рд"] = "поля";
["поле/вн"] = "поле";
["поле/дт"] = "полю";
["поле/тв"] = "полем";
["поле/пр"] = "полі";
}
game : dict {
["прагал/рд"] = "прагала";
["прагал/вн"] = "прагал";
["прагал/дт"] = "прагалу";
["прагал/тв"] = "прагалам";
["прагал/пр"] = "прагале";
}
game : dict {
["лес/рд"] = "леса";
["лес/вн"] = "лес";
["лес/дт"] = "лесу";
["лес/тв"] = "лесам";
["лес/пр"] = "лесе";
}
game : dict {
["хвойнік/рд"] = "хвойніка";
["хвойнік/вн"] = "хвойнік";
["хвойнік/дт"] = "хвойніку";
["хвойнік/тв"] = "хвойнікам";
["хвойнік/пр"] = "хвойніку";
}
game : dict {
["гушчар/рд"] = "гушчару";
["гушчар/вн"] = "гушчар";
["гушчар/дт"] = "гушчару";
["гушчар/тв"] = "гушчаром";
["гушчар/пр"] = "гушчары";
}
game : dict {
["бор/рд"] = "бору";
["бор/вн"] = "бор";
["бор/дт"] = "бору";
["бор/тв"] = "борам";
["бор/пр"] = "бары";
}
game : dict {
["сосны/рд"] = "соснаў";
["сосны/вн"] = "сосны";
["сосны/дт"] = "соснам";
["сосны/тв"] = "соснамі";
["сосны/пр"] = "соснах";
}
game : dict {
["хвоі/рд"] = "хвояў";
["хвоі/вн"] = "хвоі";
["хвоі/дт"] = "хвоям";
["хвоі/тв"] = "хвоямі";
["хвоі/пр"] = "хвоях";
}
game : dict {
["хвойка/рд"] = "хвоек";
["хвойка/вн"] = "хвойкі";
["хвойка/дт"] = "хвойкам";
["хвойка/тв"] = "хвойкамі";
["хвойка/пр"] = "хвойках";
}
game : dict {
["елкі/рд"] = "елак";
["елкі/вн"] = "елкі";
["елкі/дт"] = "елкам";
["елкі/тв"] = "елкамі";
["елкі/пр"] = "елках";
}
game : dict {
["кола/рд"] = "кола";
["кола/вн"] = "кола";
["кола/дт"] = "колу";
["кола/тв"] = "колам";
["кола/пр"] = "коле";
}
game : dict {
["колы/рд"] = "колаў";
["колы/вн"] = "колы";
["колы/дт"] = "колам";
["колы/тв"] = "коламі";
["колы/пр"] = "колах";
}
game : dict {
["алень/рд"] = "аленя";
["алень/вн"] = "аленя";
["алень/дт"] = "аленю";
["алень/тв"] = "аленем";
["алень/пр"] = "алені";
}
game : dict {
["сава/рд"] = "савы";
["сава/вн"] = "саву";
["сава/дт"] = "саве";
["сава/тв"] = "савой";
["сава/пр"] = "саве";
}
game : dict {
["звер/рд"] = "звера";
["звер/вн"] = "звера";
["звер/дт"] = "зверу";
["звер/тв"] = "зверам";
["звер/пр"] = "зверы";
}
game : dict {
["птушка/рд"] = "птушкі";
["птушка/вн"] = "птушку";
["птушка/дт"] = "птушцы";
["птушка/тв"] = "птушкай";
["птушка/пр"] = "птушцы";
}
game : dict {
["ручай/рд"] = "ручая";
["ручай/вн"] = "ручай";
["ручай/дт"] = "ручаю";
["ручай/тв"] = "ручаём";
["ручай/пр"] = "ручаі";
}
game : dict {
["пяро/рд"] = "пяра";
["пяро/вн"] = "пяро";
["пяро/дт"] = "пяру";
["пяро/тв"] = "пяром";
["пяро/пр"] = "пяры";
}
game : dict {
["перца/рд"] = "перца";
["перца/вн"] = "перца";
["перца/дт"] = "перцу";
["перца/тв"] = "перцам";
["перца/пр"] = "перцы";
}
game : dict {
["свячэнне/рд"] = "свячэння";
["свячэнне/вн"] = "свячэнне";
["свячэнне/дт"] = "свячэнню";
["свячэнне/тв"] = "свячэннем";
["свячэнне/пр"] = "свячэнні";
}
game : dict {
["ззянне/рд"] = "ззяння";
["ззянне/вн"] = "ззянне";
["ззянне/дт"] = "ззянню";
["ззянне/тв"] = "ззяннем";
["ззянне/пр"] = "ззянні";
}
game : dict {
["сяйво/рд"] = "сяйва";
["сяйво/вн"] = "сяйво";
["сяйво/дт"] = "сяйву";
["сяйво/тв"] = "сяйвом";
["сяйво/пр"] = "сяйве";
}
game : dict {
["крышталь/рд"] = "крышталя";
["крышталь/вн"] = "крышталь";
["крышталь/дт"] = "крышталю";
["крышталь/тв"] = "крышталём";
["крышталь/пр"] = "крышталі";
}
game : dict {
["крышталі/рд"] = "крышталёў";
["крышталі/вн"] = "крышталі";
["крышталі/дт"] = "крышталям";
["крышталі/тв"] = "крышталямі";
["крышталі/пр"] = "крышталях";
}
game : dict {
["асколак/рд"] = "асколка";
["асколак/вн"] = "асколак";
["асколак/дт"] = "асколку";
["асколак/тв"] = "асколкам";
["асколак/пр"] = "асколку";
}
game : dict {
["аскепак/рд"] = "аскепка";
["аскепак/вн"] = "аскепак";
["аскепак/дт"] = "аскепку";
["аскепак/тв"] = "аскепкам";
["аскепак/пр"] = "аскепку";
}
game : dict {
["кавалкі/рд"] = "кавалкаў";
["кавалкі/вн"] = "кавалкі";
["кавалкі/дт"] = "кавалкам";
["кавалкі/тв"] = "кавалкамі";
["кавалкі/пр"] = "кавалках";
}
game : dict {
["кавалачкі/рд"] = "кавалачкаў";
["кавалачкі/вн"] = "кавалачкі";
["кавалачкі/дт"] = "кавалачкам";
["кавалачкі/тв"] = "кавалачкамі";
["кавалачкі/пр"] = "кавалачках";
}
game : dict {
["друзачкі/рд"] = "друзачкаў";
["друзачкі/вн"] = "друзачкі";
["друзачкі/дт"] = "друзачкам";
["друзачкі/тв"] = "друзачкамі";
["друзачкі/пр"] = "друзачках";
}
game : dict {
["абрыў/рд"] = "абрыва";
["абрыў/вн"] = "абрыў";
["абрыў/дт"] = "абрыву";
["абрыў/тв"] = "абрывам";
["абрыў/пр"] = "абрыве";
}
game : dict {
["разрыў/рд"] = "разрыва";
["разрыў/вн"] = "разрыў";
["разрыў/дт"] = "разрыву";
["разрыў/тв"] = "разрывам";
["разрыў/пр"] = "разрыве";
}
game : dict {
["разлом/рд"] = "разлома";
["разлом/вн"] = "разлом";
["разлом/дт"] = "разлому";
["разлом/тв"] = "разломам";
["разлом/пр"] = "разломе";
}
game : dict {
["правал/рд"] = "правала";
["правал/вн"] = "правал";
["правал/дт"] = "правалу";
["правал/тв"] = "правалам";
["правал/пр"] = "правале";
}
game : dict {
["прорва/рд"] = "прорвы";
["прорва/вн"] = "прорву";
["прорва/дт"] = "прорве";
["прорва/тв"] = "прорвай";
["прорва/пр"] = "прорве";
}
game : dict {
["расколіна/рд"] = "расколіны";
["расколіна/вн"] = "расколіну";
["расколіна/дт"] = "расколіне";
["расколіна/тв"] = "расколінай";
["расколіна/пр"] = "расколіне";
}
game : dict {
["бездань/рд"] = "бездані";
["бездань/вн"] = "бездань";
["бездань/дт"] = "бездані";
["бездань/тв"] = "безданню";
["бездань/пр"] = "бездані";
}
game : dict {
["кажан/рд"] = "кажана";
["кажан/вн"] = "кажана";
["кажан/дт"] = "кажану";
["кажан/тв"] = "кажаном";
["кажан/пр"] = "кажане";
}
game : dict {
["кажаны/рд"] = "кажаноў";
["кажаны/вн"] = "кажаноў";
["кажаны/дт"] = "кажанам";
["кажаны/тв"] = "кажанамі";
["кажаны/пр"] = "кажанах";
}
game : dict {
["адтуліны/рд"] = "адтулінаў";
["адтуліны/вн"] = "адтуліны";
["адтуліны/дт"] = "адтулінам";
["адтуліны/тв"] = "адтулінамі";
["адтуліны/пр"] = "адтулінах";
}
game : dict {
["дзіркі/рд"] = "дзірак";
["дзіркі/вн"] = "дзіркі";
["дзіркі/дт"] = "дзіркам";
["дзіркі/тв"] = "дзіркамі";
["дзіркі/пр"] = "дзірках";
}
game : dict {
["дзіры/рд"] = "дзіраў";
["дзіры/вн"] = "дзіры";
["дзіры/дт"] = "дзірам";
["дзіры/тв"] = "дзірамі";
["дзіры/пр"] = "дзірах";
}
game : dict {
["столь/рд"] = "столі";
["столь/вн"] = "столь";
["столь/дт"] = "столі";
["столь/тв"] = "столлю";
["столь/пр"] = "столі";
}
game : dict {
["статуя/рд"] = "статуі";
["статуя/вн"] = "статую";
["статуя/дт"] = "статуі";
["статуя/тв"] = "статуяй";
["статуя/пр"] = "статуі";
}
game : dict {
["галем/рд"] = "галема";
["галем/вн"] = "галема";
["галем/дт"] = "галему";
["галем/тв"] = "галемам";
["галем/пр"] = "галеме";
}
game : dict {
["полымя/рд"] = "полымя";
["полымя/вн"] = "полымя";
["полымя/дт"] = "полымю";
["полымя/тв"] = "полымем";
["полымя/пр"] = "полымі";
}
game : dict {
["ліхтарык/рд"] = "ліхтарыка";
["ліхтарык/вн"] = "ліхтарык";
["ліхтарык/дт"] = "ліхтарыку";
["ліхтарык/тв"] = "ліхтарыкам";
["ліхтарык/пр"] = "ліхтарыку";
}
game : dict {
["шкло/рд"] = "шкла";
["шкло/вн"] = "шкло";
["шкло/дт"] = "шклу";
["шкло/тв"] = "шклом";
["шкло/пр"] = "шкле";
}
game : dict {
["плато/рд"] = "плато";
["плато/вн"] = "плато";
["плато/дт"] = "плато";
["плато/тв"] = "плато";
["плато/пр"] = "плато";
}
game : dict {
["замак/рд"] = "замка";
["замак/вн"] = "замак";
["замак/дт"] = "замку";
["замак/тв"] = "замкам";
["замак/пр"] = "замку";
}
game : dict {
["палац/рд"] = "палаца";
["палац/вн"] = "палац";
["палац/дт"] = "палацу";
["палац/тв"] = "палацам";
["палац/пр"] = "палацы";
}
game : dict {
["вяршыні/рд"] = "вяршыняў";
["вяршыні/вн"] = "вяршыні";
["вяршыні/дт"] = "вяршыням";
["вяршыні/тв"] = "вяршынямі";
["вяршыні/пр"] = "вяршынях";
}
game : dict {
["шчыліна/рд"] = "шчыліны";
["шчыліна/вн"] = "шчыліну";
["шчыліна/дт"] = "шчыліне";
["шчыліна/тв"] = "шчылінай";
["шчыліна/пр"] = "шчыліне";
}
game : dict {
["уваход/рд"] = "увахода";
["уваход/вн"] = "уваход";
["уваход/дт"] = "уваходу";
["уваход/тв"] = "уваходам";
["уваход/пр"] = "уваходзе";
}
game : dict {
["ўваход/рд"] = "ўвахода";
["ўваход/вн"] = "ўваход";
["ўваход/дт"] = "ўваходу";
["ўваход/тв"] = "ўваходам";
["ўваход/пр"] = "ўваходзе";
}
game : dict {
["рукі/рд"] = "рук";
["рукі/вн"] = "рукі";
["рукі/дт"] = "рукам";
["рукі/тв"] = "рукамі";
["рукі/пр"] = "руках";
}
game : dict {
["ногі/рд"] = "ног";
["ногі/вн"] = "ногі";
["ногі/дт"] = "нагам";
["ногі/тв"] = "нагамі";
["ногі/пр"] = "нагах";
}
game : dict {
["галава/рд"] = "галавы";
["галава/вн"] = "галаву";
["галава/дт"] = "галаве";
["галава/тв"] = "галавой";
["галава/пр"] = "галаве";
}
game : dict {
["твар/рд"] = "твару";
["твар/вн"] = "твар";
["твар/дт"] = "твару";
["твар/тв"] = "тварам";
["твар/пр"] = "твары";
}
game : dict {
["аблічча/рд"] = "аблічча";
["аблічча/вн"] = "аблічча";
["аблічча/дт"] = "абліччу";
["аблічча/тв"] = "абліччам";
["аблічча/пр"] = "абліччы";
}
game : dict {
["паліцы/рд"] = "паліцаў";
["паліцы/вн"] = "паліцы";
["паліцы/дт"] = "паліцам";
["паліцы/тв"] = "паліцамі";
["паліцы/пр"] = "паліцах";
}
game : dict {
["падручнікі/рд"] = "падручнікаў";
["падручнікі/вн"] = "падручнікі";
["падручнікі/дт"] = "падручнікам";
["падручнікі/тв"] = "падручнікамі";
["падручнікі/пр"] = "падручніках";
}
game : dict {
["сшыткі/рд"] = "сшыткаў";
["сшыткі/вн"] = "сшыткі";
["сшыткі/дт"] = "сшыткам";
["сшыткі/тв"] = "сшыткамі";
["сшыткі/пр"] = "сшытках";
}
game : dict {
["казкі/рд"] = "казак";
["казкі/вн"] = "казкі";
["казкі/дт"] = "казкам";
["казкі/тв"] = "казкамі";
["казкі/пр"] = "казках";
}
game : dict {
["кніга/рд"] = "кнігі";
["кніга/вн"] = "кнігу";
["кніга/дт"] = "кнізе";
["кніга/тв"] = "кнігай";
["кніга/пр"] = "кнізе";
}
game : dict {
["шруба/рд"] = "шрубы";
["шруба/вн"] = "шрубу";
["шруба/дт"] = "шрубе";
["шруба/тв"] = "шрубай";
["шруба/пр"] = "шрубе";
}
game : dict {
["мэбля/рд"] = "мэблі";
["мэбля/вн"] = "мэблю";
["мэбля/дт"] = "мэблі";
["мэбля/тв"] = "мэбляй";
["мэбля/пр"] = "мэблі";
}
game : dict {
["калоны/рд"] = "калонаў";
["калоны/вн"] = "калоны";
["калоны/дт"] = "калонам";
["калоны/тв"] = "калонамі";
["калоны/пр"] = "калонах";
}
game : dict {
["скляпенне/рд"] = "скляпення";
["скляпенне/вн"] = "скляпенне";
["скляпенне/дт"] = "скляпенню";
["скляпенне/тв"] = "скляпеннем";
["скляпенне/пр"] = "скляпенні";
}
game : dict {
["люстэркі/рд"] = "люстэркаў";
["люстэркі/вн"] = "люстэркі";
["люстэркі/дт"] = "люстэркам";
["люстэркі/тв"] = "люстэркамі";
["люстэркі/пр"] = "люстэрках";
}
game : dict {
["вецер/рд"] = "ветру";
["вецер/вн"] = "вецер";
["вецер/дт"] = "ветру";
["вецер/тв"] = "ветрам";
["вецер/пр"] = "ветры";
}
game:dict {
["зачыніць"] = {
"зачынены/мр,нст";
"зачыненая/жр,нст";
"зачыненае/ср,нст";
"зачыненыя/мн,нст"
}}
game:dict {
["махаць"] = {
"машаш/2л,нст";
"памахаў/2л,мр,пр";
"памахала/2л,жр,пр";
"памахала/2л,ср,пр";
"памахалі/3л,мн,пр"
}}
game : dict {
["крыніца/рд"] = "крыніцы";
["крыніца/вн"] = "крыніцу";
["крыніца/дт"] = "крыніцы";
["крыніца/тв"] = "крыніцай";
["крыніца/пр"] = "крыніцы";
}
game : dict {
["ледзяны/рд"] = "ледзянога";
["ледзяны/вн"] = "ледзянога";
["ледзяны/дт"] = "ледзяному";
["ледзяны/тв"] = "ледзяным";
["ледзяны/пр"] = "ледзяным";
}
--словы з гульні "Урзі"
game : dict {
["кіпцюры/рд"] = "кіпцюроў";
["кіпцюры/вн"] = "кіпцюры";
["кіпцюры/дт"] = "кіпцюрам";
["кіпцюры/тв"] = "кіпцюрамі";
["кіпцюры/пр"] = "кіпцюрах";
}
game : dict {
["кіпці/рд"] = "кіпцяў";
["кіпці/вн"] = "кіпці";
["кіпці/дт"] = "кіпцям";
["кіпці/тв"] = "кіпцямі";
["кіпці/пр"] = "кіпцях";
}
game : dict {
["кіпцікі/рд"] = "кіпцікаў";
["кіпцікі/вн"] = "кіпцікі";
["кіпцікі/дт"] = "кіпцікам";
["кіпцікі/тв"] = "кіпцікамі";
["кіпцікі/пр"] = "кіпціках";
}
game : dict {
["пазюры/рд"] = "пазюроў";
["пазюры/вн"] = "пазюры";
["пазюры/дт"] = "пазюрам";
["пазюры/тв"] = "пазюрамі";
["пазюры/пр"] = "пазюрах";
}
game : dict {
["кокці/рд"] = "кокцяў";
["кокці/вн"] = "кокці";
["кокці/дт"] = "кокцям";
["кокці/тв"] = "кокцямі";
["кокці/пр"] = "кокцях";
}
game : dict {
["кіпцюр/рд"] = "кіпцюра";
["кіпцюр/вн"] = "кіпцюр";
["кіпцюр/дт"] = "кіпцюру";
["кіпцюр/тв"] = "кіпцюром";
["кіпцюр/пр"] = "кіпцюры";
}
game : dict {
["кіпцік/рд"] = "кіпціка";
["кіпцік/вн"] = "кіпцік";
["кіпцік/дт"] = "кіпціку";
["кіпцік/тв"] = "кіпцікам";
["кіпцік/пр"] = "кіпціку";
}
game : dict {
["пазюр/рд"] = "пазюра";
["пазюр/вн"] = "пазюр";
["пазюр/дт"] = "пазюру";
["пазюр/тв"] = "пазюром";
["пазюр/пр"] = "пазюры";
}
game : dict {
["кокаць/рд"] = "кокця";
["кокаць/вн"] = "кокаць";
["кокаць/дт"] = "кокцю";
["кокаць/тв"] = "кокцем";
["кокаць/пр"] = "кокці";
}
game : dict {
["лапы/рд"] = "лап";
["лапы/вн"] = "лапы";
["лапы/дт"] = "лапам";
["лапы/тв"] = "лапамі";
["лапы/пр"] = "лапах";
}
game : dict {
["лапкі/рд"] = "лапак";
["лапкі/вн"] = "лапкі";
["лапкі/дт"] = "лапкам";
["лапкі/тв"] = "лапкамі";
["лапкі/пр"] = "лапках";
}
game : dict {
["лапа/рд"] = "лапы";
["лапа/вн"] = "лапу";
["лапа/дт"] = "лапе";
["лапа/тв"] = "лапай";
["лапа/пр"] = "лапе";
}
game : dict {
["лапка/рд"] = "лапкі";
["лапка/вн"] = "лапку";
["лапка/дт"] = "лапцы";
["лапка/тв"] = "лапкай";
["лапка/пр"] = "лапцы";
}
game : dict {
["хвост/рд"] = "хваста";
["хвост/вн"] = "хвост";
["хвост/дт"] = "хвасту";
["хвост/тв"] = "хвастом";
["хвост/пр"] = "хвасце";
}
game : dict {
["хвосцік/рд"] = "хвосціка";
["хвосцік/вн"] = "хвосцік";
["хвосцік/дт"] = "хвосціку";
["хвосцік/тв"] = "хвосцікам";
["хвосцік/пр"] = "хвосціку";
}
game : dict {
["зубы/рд"] = "зубоў";
["зубы/вн"] = "зубы";
["зубы/дт"] = "зубам";
["зубы/тв"] = "зубамі";
["зубы/пр"] = "зубах";
}
game : dict {
["зуб/рд"] = "зуба";
["зуб/вн"] = "зуб";
["зуб/дт"] = "зубу";
["зуб/тв"] = "зубам";
["зуб/пр"] = "зубе";
}
game : dict {
["светлы/рд"] = "светлага";
["светлы/вн"] = "светлы";
["светлы/дт"] = "светламу";
["светлы/тв"] = "светлым";
["светлы/пр"] = "светлым";
}
game : dict {
["доўгі/рд"] = "доўгага";
["доўгі/вн"] = "доўгі";
["доўгі/дт"] = "доўгаму";
["доўгі/тв"] = "доўгім";
["доўгі/пр"] = "доўгім";
}
game : dict {
["мокры/рд"] = "мокрага";
["мокры/вн"] = "мокры";
["мокры/дт"] = "мокраму";
["мокры/тв"] = "мокрым";
["мокры/пр"] = "мокрым";
}
game : dict {
["галоўны/рд"] = "галоўнага";
["галоўны/вн"] = "галоўны";
["галоўны/дт"] = "галоўнаму";
["галоўны/тв"] = "галоўным";
["галоўны/пр"] = "галоўным";
}
game : dict {
["белы/рд"] = "белага";
["белы/вн"] = "белы";
["белы/дт"] = "беламу";
["белы/тв"] = "белым";
["белы/пр"] = "белым";
}
game : dict {
["мяккая/рд"] = "мяккай";
["мяккая/вн"] = "мяккую";
["мяккая/дт"] = "мяккай";
["мяккая/тв"] = "мяккай";
["мяккая/пр"] = "мяккай";
}
game : dict {
["высокі/рд"] = "высокага";
["высокі/вн"] = "высокі";
["высокі/дт"] = "высокаму";
["высокі/тв"] = "высокім";
["высокі/пр"] = "высокім";
}
game : dict {
["смачнае/рд"] = "смачнага";
["смачнае/вн"] = "смачнае";
["смачнае/дт"] = "смачнаму";
["смачнае/тв"] = "смачным";
["смачнае/пр"] = "смачным";
}
game : dict {
["мяч/рд"] = "мяча";
["мяч/вн"] = "мяч";
["мяч/дт"] = "мячу";
["мяч/тв"] = "мячом";
["мяч/пр"] = "пячы";
}
game : dict {
["мячык/рд"] = "мячыка";
["мячык/вн"] = "мячык";
["мячык/дт"] = "мячыку";
["мячык/тв"] = "мячыкам";
["мячык/пр"] = "мячыку";
}
game : dict {
["міска/рд"] = "міскі";
["міска/вн"] = "міску";
["міска/дт"] = "місцы";
["міска/тв"] = "міскай";
["міска/пр"] = "місцы";
}
game : dict {
["міса/рд"] = "місы";
["міса/вн"] = "місу";
["міса/дт"] = "місе";
["міса/тв"] = "місай";
["міса/пр"] = "місе";
}
game : dict {
["ежа/рд"] = "ежы";
["ежа/вн"] = "ежу";
["ежа/дт"] = "ежы";
["ежа/тв"] = "ежай";
["ежа/пр"] = "ежы";
}
game : dict {
["кружка/рд"] = "кружкі";
["кружка/вн"] = "кружку";
["кружка/дт"] = "кружцы";
["кружка/тв"] = "кружкай";
["кружка/пр"] = "кружцы";
}
--акляк. слоўнік гульні "Фарбы сакавіка"
game : dict {
["пейзаж/рд"] = "пейзажу";
["пейзаж/вн"] = "пейзаж";
["пейзаж/дт"] = "пейзажу";
["пейзаж/тв"] = "пейзажам";
["пейзаж/пр"] = "пейзажы";
}

game : dict {
["цюбік/рд"] = "цюбіка";
["цюбік/вн"] = "цюбік";
["цюбік/дт"] = "цюбіку";
["цюбік/тв"] = "цюбікам";
["цюбік/пр"] = "цюбіку";
}

game : dict {
["цюбікі/рд"] = "цюбікаў";
["цюбікі/вн"] = "цюбікі";
["цюбікі/дт"] = "цюбікам";
["цюбікі/тв"] = "цюбікамі";
["цюбікі/пр"] = "цюбіках";
}

game : dict {
["сподачак/рд"] = "сподачкаў";
["сподачак/вн"] = "сподачкі";
["сподачак/дт"] = "сподачкам";
["сподачак/тв"] = "сподачкамі";
["сподачак/пр"] = "сподачках";
}

game : dict {
["сподачкі/рд"] = "сподачкаў";
["сподачкі/вн"] = "сподачкі";
["сподачкі/дт"] = "сподачкам";
["сподачкі/тв"] = "сподачкамі";
["сподачкі/пр"] = "сподачках";
}

game : dict {
["поўнач/рд"] = "поўначы";
["поўнач/вн"] = "поўнач";
["поўнач/дт"] = "поўначы";
["поўнач/тв"] = "поўначчу";
["поўнач/пр"] = "поўначы";
}

game : dict {
["дахі/рд"] = "дахаў";
["дахі/вн"] = "дахі";
["дахі/дт"] = "дахам";
["дахі/тв"] = "дахамі";
["дахі/пр"] = "дахах";
}

game : dict {
["вершаліны/рд"] = "вершалінаў";
["вершаліны/вн"] = "вершаліны";
["вершаліны/дт"] = "вершалінам";
["вершаліны/тв"] = "вершалінамі";
["вершаліны/пр"] = "вершалінах";
}

game : dict {
["падваконне/рд"] = "падваконня";
["падваконне/вн"] = "падваконне";
["падваконне/дт"] = "падваконню";
["падваконне/тв"] = "падваконнем";
["падваконне/пр"] = "падваконні";
}

game : dict {
["палітра/рд"] = "палітры";
["палітра/вн"] = "палітру";
["палітра/дт"] = "палітры";
["палітра/тв"] = "палітрай";
["палітра/пр"] = "палітры";
}

game : dict {
["куртка/рд"] = "курткі";
["куртка/вн"] = "куртку";
["куртка/дт"] = "куртцы";
["куртка/тв"] = "курткай";
["куртка/пр"] = "куртцы";
}

game : dict {
["ліловы/рд"] = "ліловага";
["ліловы/вн"] = "ліловы";
["ліловы/дт"] = "ліловаму";
["ліловы/тв"] = "ліловым";
["ліловы/пр"] = "ліловым";
}

game : dict {
["ліловая/рд"] = "ліловай";
["ліловая/вн"] = "ліловую";
["ліловая/дт"] = "ліловай";
["ліловая/тв"] = "ліловай";
["ліловая/пр"] = "ліловай";
}

game : dict {
["ліловае/рд"] = "ліловага";
["ліловае/вн"] = "ліловае";
["ліловае/дт"] = "ліловаму";
["ліловае/тв"] = "ліловым";
["ліловае/пр"] = "ліловым";
}

game : dict {
["галіны/рд"] = "галінаў";
["галіны/вн"] = "галіны";
["галіны/дт"] = "галінам";
["галіны/тв"] = "галінамі";
["галіны/пр"] = "галінах";
}

game : dict {
["галінка/рд"] = "галінкі";
["галінка/вн"] = "галінку";
["галінка/дт"] = "галінцы";
["галінка/тв"] = "галінкай";
["галінка/пр"] = "галінцы";
}

game : dict {
["галінкі/рд"] = "галінак";
["галінкі/вн"] = "галінкі";
["галінкі/дт"] = "галінкам";
["галінкі/тв"] = "галінкамі";
["галінкі/пр"] = "галінках";
}

game : dict {
["шаты/рд"] = "шатаў";
["шаты/вн"] = "шаты";
["шаты/дт"] = "шатам";
["шаты/тв"] = "шатамі";
["шаты/пр"] = "шатах";
}

game : dict {
["лісцё/рд"] = "лісця";
["лісцё/вн"] = "лісцё";
["лісцё/дт"] = "лісцю";
["лісцё/тв"] = "лісцём";
["лісцё/пр"] = "лісці";
}

game : dict {
["пралескі/рд"] = "пралесак";
["пралескі/вн"] = "пралескі";
["пралескі/дт"] = "пралескам";
["пралескі/тв"] = "пралескамі";
["пралескі/пр"] = "пралесках";
}

game : dict {
["няскончаная/рд"] = "няскончанай";
["няскончаная/вн"] = "няскончаную";
["няскончаная/дт"] = "няскончанай";
["няскончаная/тв"] = "няскончанай";
["няскончаная/пр"] = "няскончанай";
}

game : dict {
["сумесь/рд"] = "сумесі";
["сумесь/вн"] = "сумесь";
["сумесь/дт"] = "сумесі";
["сумесь/тв"] = "сумессю";
["сумесь/пр"] = "сумесі";
}

game : dict {
["паперчыны/рд"] = "паперчын";
["паперчыны/вн"] = "паперчыны";
["паперчыны/дт"] = "паперчынам";
["паперчыны/тв"] = "паперчынамі";
["паперчыны/пр"] = "паперчынах";
}

game : dict {
["накіды/рд"] = "накідаў";
["накіды/вн"] = "накіды";
["накіды/дт"] = "накідам";
["накіды/тв"] = "накідамі";
["накіды/пр"] = "накідах";
}

game : dict {
["накідкі/рд"] = "накідкаў";
["накідкі/вн"] = "накідкі";
["накідкі/дт"] = "накідкам";
["накідкі/тв"] = "накідкамі";
["накідкі/пр"] = "накідках";
}

game : dict {
["эскізы/рд"] = "эскізаў";
["эскізы/вн"] = "эскізы";
["эскізы/дт"] = "эскізам";
["эскізы/тв"] = "эскізамі";
["эскізы/пр"] = "эскізах";
}

game : dict {
["эцюды/рд"] = "эцюдаў";
["эцюды/вн"] = "эцюды";
["эцюды/дт"] = "эцюдам";
["эцюды/тв"] = "эцюдамі";
["эцюды/пр"] = "эцюдах";
}

game : dict {
["гуашавыя/рд"] = "гуашавых";
["гуашавыя/вн"] = "гуашавыя";
["гуашавыя/дт"] = "гуашавым";
["гуашавыя/тв"] = "гуашавымі";
["гуашавыя/пр"] = "гуашавых";
}

game : dict {
["акварэльных/рд"] = "акварэльных";
["акварэльных/вн"] = "акварэльныя";
["акварэльных/дт"] = "акварэльным";
["акварэльных/тв"] = "акварэльнымі";
["акварэльных/пр"] = "акварэльных";
}

game : dict {
["купа/рд"] = "купы";
["купа/вн"] = "купу";
["купа/дт"] = "купе";
["купа/тв"] = "купай";
["купа/пр"] = "купе";
}

game : dict {
["купы/рд"] = "купаў";
["купы/вн"] = "купы";
["купы/дт"] = "купам";
["купы/тв"] = "купамі";
["купы/пр"] = "купах";
}

game : dict {
["палотны/рд"] = "палотнаў";
["палотны/вн"] = "палотны";
["палотны/дт"] = "палотнам";
["палотны/тв"] = "палотнамі";
["палотны/пр"] = "палотнах";
}

game : dict {
["Танюша/рд"] = "Танюшы";
["Танюша/вн"] = "Танюшу";
["Танюша/дт"] = "Танюшы";
["Танюша/тв"] = "Танюшай";
["Танюша/пр"] = "Танюшы";
}

game : dict {
["глеба/рд"] = "глебы";
["глеба/вн"] = "глебу";
["глеба/дт"] = "глебе";
["глеба/тв"] = "глебай";
["глеба/пр"] = "глебе";
}
--акляк. Слоўнік гульні "На рыбалку"
game : dict {
["двор/рд"] = "двара";
["двор/вн"] = "двор";
["двор/дт"] = "двары";
["двор/тв"] = "дваром";
["двор/пр"] = "двары";
}
game : dict {
["падворак/рд"] = "падворка";
["падворак/вн"] = "падворак";
["падворак/дт"] = "падворку";
["падворак/тв"] = "падворкам";
["падворак/пр"] = "падворку";
}
game : dict {
["поплаў/рд"] = "поплава";
["поплаў/вн"] = "поплаў";
["поплаў/дт"] = "поплаву";
["поплаў/тв"] = "поплавам";
["поплаў/пр"] = "поплаве";
}
game : dict {
["луг/рд"] = "луга";
["луг/вн"] = "луг";
["луг/дт"] = "лугу";
["луг/тв"] = "лугам";
["луг/пр"] = "лузе";
}
game : dict {
["выпас/рд"] = "выпасу";
["выпас/вн"] = "выпас";
["выпас/дт"] = "выпасу";
["выпас/тв"] = "выпасам";
["выпас/пр"] = "выпасе";
}
game : dict {
["пуня/рд"] = "пуні";
["пуня/вн"] = "пуню";
["пуня/дт"] = "пуні";
["пуня/тв"] = "пуняй";
["пуня/пр"] = "пуні";
}
game : dict {
["хлеў/рд"] = "хлева";
["хлеў/вн"] = "хлеў";
["хлеў/дт"] = "хлеву";
["хлеў/тв"] = "хлевам";
["хлеў/пр"] = "хлеве";
}
game : dict {
["хляўчук/рд"] = "хляўчука";
["хляўчук/вн"] = "хляўчук";
["хляўчук/дт"] = "хляўчуку";
["хляўчук/тв"] = "хляўчуком";
["хляўчук/пр"] = "хляўчуку";
}
game : dict {
["вядро/рд"] = "вядра";
["вядро/вн"] = "вядро";
["вядро/дт"] = "вядру";
["вядро/тв"] = "вядром";
["вядро/пр"] = "вядры";
}
game : dict {
["бляшаная/рд"] = "бляшанай";
["бляшаная/вн"] = "бляшаную";
["бляшаная/дт"] = "бляшанай";
["бляшаная/тв"] = "бляшанай";
["бляшаная/пр"] = "бляшанай";
}
game : dict {
["банка/рд"] = "банкі";
["банка/вн"] = "банку";
["банка/дт"] = "банцы";
["банка/тв"] = "банкай";
["банка/пр"] = "банцы";
}
game : dict {
["бляшанка/рд"] = "бляшанкі";
["бляшанка/вн"] = "бляшанку";
["бляшанка/дт"] = "бляшанцы";
["бляшанка/тв"] = "бляшанкай";
["бляшанка/пр"] = "бляшанцы";
}
game : dict {
["вуда/рд"] = "вуды";
["вуда/вн"] = "вуду";
["вуда/дт"] = "вудзе";
["вуда/тв"] = "вудай";
["вуда/пр"] = "вудзе";
}
game : dict {
["рыдлёўка/рд"] = "рыдлёўку";
["рыдлёўка/вн"] = "рыдлёўку";
["рыдлёўка/дт"] = "рыдлёўцы";
["рыдлёўка/тв"] = "рыдлёўкай";
["рыдлёўка/пр"] = "рыдлёўцы";
}
game : dict {
["лязо/рд"] = "ляза";
["лязо/вн"] = "лязо";
["лязо/дт"] = "лязу";
["лязо/тв"] = "лязом";
["лязо/пр"] = "лязе";
}
game : dict {
["дзяржальна/рд"] = "дзяржальна";
["дзяржальна/вн"] = "дзяржальна";
["дзяржальна/дт"] = "дзяржальну";
["дзяржальна/тв"] = "дзяржальнам";
["дзяржальна/пр"] = "дзяржальне";
}
game : dict {
["плот/рд"] = "плоту";
["плот/вн"] = "плот";
["плот/дт"] = "плоту";
["плот/тв"] = "плотам";
["плот/пр"] = "плоце";
}
game : dict {
["частакол/рд"] = "частаколу";
["частакол/вн"] = "частакол";
["частакол/дт"] = "частаколу";
["частакол/тв"] = "частаколам";
["частакол/пр"] = "частаколе";
}
game : dict {
["папярочына/рд"] = "папярочыны";
["папярочына/вн"] = "папярочыну";
["папярочына/дт"] = "папярочыне";
["папярочына/тв"] = "папярочынай";
["папярочына/пр"] = "папярочыне";
}
game : dict {
["чарвяк/рд"] = "чарвяка";
["чарвяк/вн"] = "чарвяка";
["чарвяк/дт"] = "чарвяку";
["чарвяк/тв"] = "чарвяком";
["чарвяк/пр"] = "чарвяку";
}
game : dict {
["чарвякі/рд"] = "чарвякоў";
["чарвякі/вн"] = "чарвякоў";
["чарвякі/дт"] = "чарвякам";
["чарвякі/тв"] = "чарвякамі";
["чарвякі/пр"] = "чарвяках";
}
game : dict {
["трава/рд"] = "травы";
["трава/вн"] = "траву";
["трава/дт"] = "траве";
["трава/тв"] = "травой";
["трава/пр"] = "траве";
}
game : dict {
["мурог/рд"] = "мурагу";
["мурог/вн"] = "мурог";
["мурог/дт"] = "мурагу";
["мурог/тв"] = "мурагом";
["мурог/пр"] = "мурагу";
}
game : dict {
["рака/рд"] = "ракі";
["рака/вн"] = "раку";
["рака/дт"] = "рацэ";
["рака/тв"] = "ракой";
["рака/пр"] = "рацэ";
}
game : dict {
["плынь/рд"] = "плыні";
["плынь/вн"] = "плынь";
["плынь/дт"] = "плыні";
["плынь/тв"] = "плынню";
["плынь/пр"] = "плыні";
}
game : dict {
["ракіта/рд"] = "ракіты";
["ракіта/вн"] = "ракіту";
["ракіта/дт"] = "ракіце";
["ракіта/тв"] = "ракітай";
["ракіта/пр"] = "ракіце";
}
game : dict {
["вярба/рд"] = "вярбы";
["вярба/вн"] = "вярбу";
["вярба/дт"] = "вярбе";
["вярба/тв"] = "вярбой";
["вярба/пр"] = "вярбе";
}
game : dict {
["галіны/рд"] = "галін";
["галіны/вн"] = "галіны";
["галіны/дт"] = "галінам";
["галіны/тв"] = "галінамі";
["галіны/пр"] = "галінах";
}
game : dict {
["лісты/рд"] = "лістоў";
["лісты/вн"] = "лісты";
["лісты/дт"] = "лістам";
["лісты/тв"] = "лістамі";
["лісты/пр"] = "лістах";
}
game : dict {
["дзьмухаўцы/рд"] = "дзьмухаўцоў";
["дзьмухаўцы/вн"] = "дзьмухаўцы";
["дзьмухаўцы/дт"] = "дзьмухаўцам";
["дзьмухаўцы/тв"] = "дзьмухаўцамі";
["дзьмухаўцы/пр"] = "дзьмухаўцах";
}
game : dict {
["краскі/рд"] = "красак";
["краскі/вн"] = "краскі";
["краскі/дт"] = "краскам";
["краскі/тв"] = "краскамі";
["краскі/пр"] = "красках";
}
game : dict {
["кашкі/рд"] = "кашак";
["кашкі/вн"] = "кашкі";
["кашкі/дт"] = "кашкам";
["кашкі/тв"] = "кашкамі";
["кашкі/пр"] = "кашках";
}
game : dict {
["краснапёрка/рд"] = "краснапёркі";
["краснапёрка/вн"] = "краснапёрку";
["краснапёрка/дт"] = "краснапёрцы";
["краснапёрка/тв"] = "краснапёркай";
["краснапёрка/пр"] = "краснапёрцы";
}
game : dict {
["рыба/рд"] = "рыбы";
["рыба/вн"] = "рыбу";
["рыба/дт"] = "рыбе";
["рыба/тв"] = "рыбай";
["рыба/пр"] = "рыбе";
}
game : dict {
["рыбіна/рд"] = "рыбіны";
["рыбіна/вн"] = "рыбіну";
["рыбіна/дт"] = "рыбіне";
["рыбіна/тв"] = "рыбінай";
["рыбіна/пр"] = "рыбіне";
}
game : dict {
["рыбка/рд"] = "рыбкі";
["рыбка/вн"] = "рыбку";
["рыбка/дт"] = "рыбцы";
["рыбка/тв"] = "рыбкай";
["рыбка/пр"] = "рыбцы";
}
game : dict {
["рыбінка/рд"] = "рыбінкі";
["рыбінка/вн"] = "рыбінку";
["рыбінка/дт"] = "рыбінцы";
["рыбінка/тв"] = "рыбінкай";
["рыбінка/пр"] = "рыбінцы";
}
game : dict {
["залацісты/рд"] = "залацістага";
["залацісты/вн"] = "залацістага";
["залацісты/дт"] = "залацістаму";
["залацісты/тв"] = "залацістым";
["залацісты/пр"] = "залацістым";
}
game : dict {
["карасік/рд"] = "карасіка";
["карасік/вн"] = "карасіка";
["карасік/дт"] = "карасіку";
["карасік/тв"] = "карасікам";
["карасік/пр"] = "карасіку";
}
game : dict {
["карась/рд"] = "карася";
["карась/вн"] = "карася";
["карась/дт"] = "карасю";
["карась/тв"] = "карасём";
["карась/пр"] = "карасі";
}
game : dict {
["вялікі/рд"] = "вялікага";
["вялікі/вн"] = "вялікага";
["вялікі/дт"] = "вялікаму";
["вялікі/тв"] = "вялікім";
["вялікі/пр"] = "вялікім";
}
game : dict {
["лёска/рд"] = "лёскі";
["лёска/вн"] = "лёску";
["лёска/дт"] = "лёсцы";
["лёска/тв"] = "лёскай";
["лёска/пр"] = "лёсцы";
}
game : dict {
["кручок/рд"] = "кручка";
["кручок/вн"] = "кручок";
["кручок/дт"] = "кручку";
["кручок/тв"] = "кручком";
["кручок/пр"] = "кручку";
}

--словы з гульні "Дождж месяцовы ізноў завітаў у мой сад"
game : dict {
["гасцёўня/рд"] = "гасцёўні";
["гасцёўня/вн"] = "гасцёўню";
["гасцёўня/дт"] = "гасцёўні";
["гасцёўня/тв"] = "гасцёўняй";
["гасцёўня/пр"] = "гасцёўні";
}

game : dict {
["кабінет/рд"] = "кабінета";
["кабінет/вн"] = "кабінет";
["кабінет/дт"] = "кабінету";
["кабінет/тв"] = "кабінетам";
["кабінет/пр"] = "кабінеце";
}

game : dict {
["калідор/рд"] = "калідора";
["калідор/вн"] = "калідор";
["калідор/дт"] = "калідору";
["калідор/тв"] = "калідорам";
["калідор/пр"] = "калідоры";
}

game : dict {
["піяніна/рд"] = "піяніна";
["піяніна/вн"] = "піяніна";
["піяніна/дт"] = "піяніна";
["піяніна/тв"] = "піяніна";
["піяніна/пр"] = "піяніна";
}

game : dict {
["фартэпіяна/рд"] = "фартэпіяна";
["фартэпіяна/вн"] = "фартэпіяна";
["фартэпіяна/дт"] = "фартэпіяна";
["фартэпіяна/тв"] = "фартэпіяна";
["фартэпіяна/пр"] = "фартэпіяна";
}

game : dict {
["раяль/рд"] = "раяля";
["раяль/вн"] = "раяль";
["раяль/дт"] = "раялю";
["раяль/тв"] = "раялем";
["раяль/пр"] = "раялі";
}

game : dict {
["інструмент/рд"] = "інструмента";
["інструмент/вн"] = "інструмент";
["інструмент/дт"] = "інструменту";
["інструмент/тв"] = "інструментам";
["інструмент/пр"] = "інструменце";
}

game : dict {
["папараць/рд"] = "папараці";
["папараць/вн"] = "папараць";
["папараць/дт"] = "папараці";
["папараць/тв"] = "папараццю";
["папараць/пр"] = "папараці";
}

game : dict {
["кветнік/рд"] = "кветніка";
["кветнік/вн"] = "кветнік";
["кветнік/дт"] = "кветніку";
["кветнік/тв"] = "кветнікам";
["кветнік/пр"] = "кветніку";
}

game : dict {
["закуток/рд"] = "закутка";
["закуток/вн"] = "закуток";
["закуток/дт"] = "закутку";
["закуток/тв"] = "закутком";
["закуток/пр"] = "закутку";
}

game : dict {
["альтанка/рд"] = "альтанкі";
["альтанка/вн"] = "альтанку";
["альтанка/дт"] = "альтанцы";
["альтанка/тв"] = "альтанкай";
["альтанка/пр"] = "альтанцы";
}

game : dict {
["пабудова/рд"] = "пабудовы";
["пабудова/вн"] = "пабудову";
["пабудова/дт"] = "пабудове";
["пабудова/тв"] = "пабудовай";
["пабудова/пр"] = "пабудове";
}

game : dict {
["пляцоўка/рд"] = "пляцоўкі";
["пляцоўка/вн"] = "пляцоўку";
["пляцоўка/дт"] = "пляцоўцы";
["пляцоўка/тв"] = "пляцоўкай";
["пляцоўка/пр"] = "пляцоўцы";
}

game : dict {
["лугавіна/рд"] = "лугавіны";
["лугавіна/вн"] = "лугавіну";
["лугавіна/дт"] = "лугавіне";
["лугавіна/тв"] = "лугавінай";
["лугавіна/пр"] = "лугавіне";
}

game : dict {
["лугавінка/рд"] = "лугавінкі";
["лугавінка/вн"] = "лугавінку";
["лугавінка/дт"] = "лугавінцы";
["лугавінка/тв"] = "лугавінкай";
["лугавінка/пр"] = "лугавінцы";
}

game : dict {
["лужок/рд"] = "лужка";
["лужок/вн"] = "лужок";
["лужок/дт"] = "лужку";
["лужок/тв"] = "лужком";
["лужок/пр"] = "лужку";
}

game : dict {
["лісток/рд"] = "лістка";
["лісток/вн"] = "лісток";
["лісток/дт"] = "лістку";
["лісток/тв"] = "лістком";
["лісток/пр"] = "лістку";
}

game : dict {
["ком/рд"] = "кома";
["ком/вн"] = "ком";
["ком/дт"] = "кому";
["ком/тв"] = "комам";
["ком/пр"] = "коме";
}

game : dict {
["камяк/рд"] = "камяка";
["камяк/вн"] = "камяк";
["камяк/дт"] = "камяку";
["камяк/тв"] = "камяком";
["камяк/пр"] = "камяку";
}

game : dict {
["шыбы/рд"] = "шыбаў";
["шыбы/вн"] = "шыбы";
["шыбы/дт"] = "шыбам";
["шыбы/тв"] = "шыбамі";
["шыбы/пр"] = "шыбах";
}

game : dict {
["абрус/рд"] = "абруса";
["абрус/вн"] = "абрус";
["абрус/дт"] = "абрусу";
["абрус/тв"] = "абрусам";
["абрус/пр"] = "абрусе";
}

game : dict {
["сукно/рд"] = "сукна";
["сукно/вн"] = "сукно";
["сукно/дт"] = "сукну";
["сукно/тв"] = "сукном";
["сукно/пр"] = "сукне";
}

game : dict {
["шафы/рд"] = "шафаў";
["шафы/вн"] = "шафы";
["шафы/дт"] = "шафам";
["шафы/тв"] = "шафамі";
["шафы/пр"] = "шафах";
}

game : dict {
["кнігі/рд"] = "кніг";
["кнігі/вн"] = "кнігі";
["кнігі/дт"] = "кнігам";
["кнігі/тв"] = "кнігамі";
["кнігі/пр"] = "кнігах";
}

game : dict {
["ліпа/рд"] = "ліпы";
["ліпа/вн"] = "ліпу";
["ліпа/дт"] = "ліпе";
["ліпа/тв"] = "ліпай";
["ліпа/пр"] = "ліпе";
}

game : dict {
["чарніліца/рд"] = "чарніліцы";
["чарніліца/вн"] = "чарніліцу";
["чарніліца/дт"] = "чарніліцы";
["чарніліца/тв"] = "чарніліцай";
["чарніліца/пр"] = "чарніліцы";
}

game : dict {
["ратуша/рд"] = "ратушы";
["ратуша/вн"] = "ратушу";
["ратуша/дт"] = "ратушы";
["ратуша/тв"] = "ратушай";
["ратуша/пр"] = "ратушы";
}

game : dict {
["царква/рд"] = "царквы";
["царква/вн"] = "царкву";
["царква/дт"] = "царкве";
["царква/тв"] = "царквой";
["царква/пр"] = "царкве";
}

game : dict {
["сінагога/рд"] = "сінагогі";
["сінагога/вн"] = "сінагогу";
["сінагога/дт"] = "сінагозе";
["сінагога/тв"] = "сінагогай";
["сінагога/пр"] = "сінагозе";
}

game : dict {
["прадмесці/рд"] = "прадмесцяў";
["прадмесці/вн"] = "прадмесці";
["прадмесці/дт"] = "прадмесцям";
["прадмесці/тв"] = "прадмесцямі";
["прадмесці/пр"] = "прадмесцях";
}

game : dict {
["вулкі/рд"] = "вулак";
["вулкі/вн"] = "вулкі";
["вулкі/дт"] = "вулкам";
["вулкі/тв"] = "вулкамі";
["вулкі/пр"] = "вулках";
}

game : dict {
["прысады/рд"] = "прысадаў";
["прысады/вн"] = "прысады";
["прысады/дт"] = "прысадам";
["прысады/тв"] = "прысадамі";
["прысады/пр"] = "прысадах";
}

game : dict {
["касцёл/рд"] = "касцёла";
["касцёл/вн"] = "касцёл";
["касцёл/дт"] = "касцёлу";
["касцёл/тв"] = "касцёлам";
["касцёл/пр"] = "касцёле";
}

game : dict {
["адбітак/рд"] = "адбітка";
["адбітак/вн"] = "адбітак";
["адбітак/дт"] = "адбітку";
["адбітак/тв"] = "адбіткам";
["адбітак/пр"] = "адбітку";
}

game : dict {
["клавіятура/рд"] = "клавіятуры";
["клавіятура/вн"] = "клавіятуру";
["клавіятура/дт"] = "клавіятуры";
["клавіятура/тв"] = "клавіятурай";
["клавіятура/пр"] = "клавіятуры";
}

game : dict {
["клавішы/рд"] = "клавішаў";
["клавішы/вн"] = "клавішы";
["клавішы/дт"] = "клавішам";
["клавішы/тв"] = "клавішамі";
["клавішы/пр"] = "клавішах";
}

game : dict {
["шыбкі/рд"] = "шыбак";
["шыбкі/вн"] = "шыбкі";
["шыбкі/дт"] = "шыбкам";
["шыбкі/тв"] = "шыбкамі";
["шыбкі/пр"] = "шыбках";
}

game : dict {
["карніз/рд"] = "карніза";
["карніз/вн"] = "карніз";
["карніз/дт"] = "карнізу";
["карніз/тв"] = "карнізам";
["карніз/пр"] = "карнізе";
}

game : dict {
["бляха/рд"] = "бляхі";
["бляха/вн"] = "бляху";
["бляха/дт"] = "блясе";
["бляха/тв"] = "бляхай";
["бляха/пр"] = "блясе";
}

game : dict {
["кроплі/рд"] = "кропель";
["кроплі/вн"] = "кроплі";
["кроплі/дт"] = "кроплям";
["кроплі/тв"] = "кроплямі";
["кроплі/пр"] = "кроплях";
}

game : dict {
["дажджынкі/рд"] = "дажджынак";
["дажджынкі/вн"] = "дажджынкі";
["дажджынкі/дт"] = "дажджынкам";
["дажджынкі/тв"] = "дажджынкамі";
["дажджынкі/пр"] = "дажджынках";
}

game : dict {
["поўня/рд"] = "поўні";
["поўня/вн"] = "поўню";
["поўня/дт"] = "поўні";
["поўня/тв"] = "поўняй";
["поўня/пр"] = "поўні";
}

game : dict {
["голле/рд"] = "голля";
["голле/вн"] = "голле";
["голле/дт"] = "голлю";
["голле/тв"] = "голлем";
["голле/пр"] = "голлі";
}

game : dict {
["квецень/рд"] = "квецені";
["квецень/вн"] = "квецень";
["квецень/дт"] = "квецені";
["квецень/тв"] = "квеценню";
["квецень/пр"] = "квецені";
}

game : dict {
["дождж/рд"] = "дажджу";
["дождж/вн"] = "дождж";
["дождж/дт"] = "дажджу";
["дождж/тв"] = "дажджом";
["дождж/пр"] = "дажджы";
}

game : dict {
["дожджык/рд"] = "дожджыку";
["дожджык/вн"] = "дожджык";
["дожджык/дт"] = "дожджыку";
["дожджык/тв"] = "дожджыкам";
["дожджык/пр"] = "дожджыку";
}

game : dict {
["слівы/рд"] = "сліў";
["слівы/вн"] = "слівы";
["слівы/дт"] = "слівам";
["слівы/тв"] = "слівамі";
["слівы/пр"] = "слівах";
}

game : dict {
["дрэўцы/рд"] = "дрэўцаў";
["дрэўцы/вн"] = "дрэўцы";
["дрэўцы/дт"] = "дрэўцам";
["дрэўцы/тв"] = "дрэўцамі";
["дрэўцы/пр"] = "дрэўцах";
}

game : dict {
["сшытак/рд"] = "сшытка";
["сшытак/вн"] = "сшытак";
["сшытак/дт"] = "сшытку";
["сшытак/тв"] = "сшыткам";
["сшытак/пр"] = "сшытку";
}

game : dict {
["ноты/рд"] = "нот";
["ноты/вн"] = "ноты";
["ноты/дт"] = "нотам";
["ноты/тв"] = "нотамі";
["ноты/пр"] = "нотах";
}

game : dict {
["Казімір/рд"] = "Казіміра";
["Казімір/вн"] = "Казіміра";
["Казімір/дт"] = "Казіміру";
["Казімір/тв"] = "Казімірам";
["Казімір/пр"] = "Казіміры";
}

game : dict {
["Казік/рд"] = "Казіка";
["Казік/вн"] = "Казіка";
["Казік/дт"] = "Казіку";
["Казік/тв"] = "Казікам";
["Казік/пр"] = "Казіку";
}

game : dict {
["муж/рд"] = "мужа";
["муж/вн"] = "мужа";
["муж/дт"] = "мужу";
["муж/тв"] = "мужам";
["муж/пр"] = "мужы";
}

game : dict {
["музыкант/рд"] = "музыканта";
["музыкант/вн"] = "музыканта";
["музыкант/дт"] = "музыканту";
["музыкант/тв"] = "музыкантам";
["музыкант/пр"] = "музыканце";
}

game : dict {
["аловак/рд"] = "алоўка";
["аловак/вн"] = "аловак";
["аловак/дт"] = "алоўку";
["аловак/тв"] = "алоўкам";
["аловак/пр"] = "алоўку";
}

game : dict {
["дом/рд"] = "дома";
["дом/вн"] = "дом";
["дом/дт"] = "дому";
["дом/тв"] = "домам";
["дом/пр"] = "доме";
}

game : dict {
["дарожкі/рд"] = "дарожак";
["дарожкі/вн"] = "дарожкі";
["дарожкі/дт"] = "дарожкам";
["дарожкі/тв"] = "дарожкамі";
["дарожкі/пр"] = "дарожках";
}

game : dict {
["клумбы/рд"] = "клумбаў";
["клумбы/вн"] = "клумбы";
["клумбы/дт"] = "клумбам";
["клумбы/тв"] = "клумбамі";
["клумбы/пр"] = "клумбах";
}

game : dict {
["расліна/рд"] = "раслін";
["расліна/вн"] = "расліны";
["расліна/дт"] = "раслінам";
["расліна/тв"] = "раслінамі";
["расліна/пр"] = "раслінах";
}

game : dict {
["сцябліны/рд"] = "сцяблін";
["сцябліны/вн"] = "сцябліны";
["сцябліны/дт"] = "сцяблінам";
["сцябліны/тв"] = "сцяблінамі";
["сцябліны/пр"] = "сцяблінах";
}

game : dict {
["вайі/рд"] = "вайяў";
["вайі/вн"] = "вайі";
["вайі/дт"] = "вайям";
["вайі/тв"] = "вайямі";
["вайі/пр"] = "вайях";
}

game : dict {
["ліст/рд"] = "ліста";
["ліст/вн"] = "ліст";
["ліст/дт"] = "лісту";
["ліст/тв"] = "лістом";
["ліст/пр"] = "лісце";
}

game : dict {
["шаль/рд"] = "шалі";
["шаль/вн"] = "шаль";
["шаль/дт"] = "шалі";
["шаль/тв"] = "шаллю";
["шаль/пр"] = "шалі";
}

game : dict {
["падрамнік/рд"] = "падрамніка";
["падрамнік/вн"] = "падрамнік";
["падрамнік/дт"] = "падрамніку";
["падрамнік/тв"] = "падрамнікам";
["падрамнік/пр"] = "падрамніку";
}

game : dict {
["эцюднік/рд"] = "эцюдніка";
["эцюднік/вн"] = "эцюднік";
["эцюднік/дт"] = "эцюдніку";
["эцюднік/тв"] = "эцюднікам";
["эцюднік/пр"] = "эцюдніку";
}

game : dict {
["слоікі/рд"] = "слоікаў";
["слоікі/вн"] = "слоікі";
["слоікі/дт"] = "слоікам";
["слоікі/тв"] = "слоікамі";
["слоікі/пр"] = "слоіках";
}

game : dict {
["слоічкі/рд"] = "слоічкаў";
["слоічкі/вн"] = "слоічкі";
["слоічкі/дт"] = "слоічкам";
["слоічкі/тв"] = "слоічкамі";
["слоічкі/пр"] = "слоічках";
}

game : dict {
["рэчы/рд"] = "рэчаў";
["рэчы/вн"] = "рэчы";
["рэчы/дт"] = "рэчам";
["рэчы/тв"] = "рэчамі";
["рэчы/пр"] = "рэчах";
}

game : dict {
["драбяза/рд"] = "драбязы";
["драбяза/вн"] = "драбязу";
["драбяза/дт"] = "драбязе";
["драбяза/тв"] = "драбязой";
["драбяза/пр"] = "драбязе";
}

game : dict {
["сцізорык/рд"] = "сцізорыка";
["сцізорык/вн"] = "сцізорык";
["сцізорык/дт"] = "сцізорыку";
["сцізорык/тв"] = "сцізорыкам";
["сцізорык/пр"] = "сцізорыку";
}

game : dict {
["ножык/рд"] = "ножыка";
["ножык/вн"] = "ножык";
["ножык/дт"] = "ножыку";
["ножык/тв"] = "ножыкам";
["ножык/пр"] = "ножыку";
}

game : dict {
["нож/рд"] = "нажа";
["нож/вн"] = "нож";
["нож/дт"] = "нажу";
["нож/тв"] = "нажом";
["нож/пр"] = "нажы";
}

game : dict {
["стос/рд"] = "стоса";
["стос/вн"] = "стос";
["стос/дт"] = "стосу";
["стос/тв"] = "стосам";
["стос/пр"] = "стосе";
}

game : dict {
["чарнавікі/рд"] = "чарнавікоў";
["чарнавікі/вн"] = "чарнавікі";
["чарнавікі/дт"] = "чарнавікам";
["чарнавікі/тв"] = "чарнавікамі";
["чарнавікі/пр"] = "чарнавіках";
}

game : dict {
["малюнкі/рд"] = "малюнкаў";
["малюнкі/вн"] = "малюнкі";
["малюнкі/дт"] = "малюнкам";
["малюнкі/тв"] = "малюнкамі";
["малюнкі/пр"] = "малюнках";
}

game : dict {
["плямы/рд"] = "плям";
["плямы/вн"] = "плямы";
["плямы/дт"] = "плямам";
["плямы/тв"] = "плямамі";
["плямы/пр"] = "плямах";
}

game : dict {
["промні/рд"] = "промняў";
["промні/вн"] = "промні";
["промні/дт"] = "промням";
["промні/тв"] = "промнямі";
["промні/пр"] = "промнях";
}

game : dict {
["жвір/рд"] = "жвіра";
["жвір/вн"] = "жвір";
["жвір/дт"] = "жвіру";
["жвір/тв"] = "жвірам";
["жвір/пр"] = "жвіры";
}

game : dict {
["кроны/рд"] = "кронаў";
["кроны/вн"] = "кроны";
["кроны/дт"] = "кронам";
["кроны/тв"] = "кронамі";
["кроны/пр"] = "кронах";
}

game : dict {
["засень/рд"] = "засені";
["засень/вн"] = "засень";
["засень/дт"] = "засені";
["засень/тв"] = "засенню";
["засень/пр"] = "засені";
}

game : dict {
["цень/рд"] = "ценю";
["цень/вн"] = "цень";
["цень/дт"] = "ценю";
["цень/тв"] = "ценем";
["цень/пр"] = "цені";
}

game : dict {
["паўзмрок/рд"] = "паўзмроку";
["паўзмрок/вн"] = "паўзмрок";
["паўзмрок/дт"] = "паўзмроку";
["паўзмрок/тв"] = "паўзмрокам";
["паўзмрок/пр"] = "паўзмроку";
}

game : dict {
["лісточак/рд"] = "лісточка";
["лісточак/вн"] = "лісточак";
["лісточак/дт"] = "лісточку";
["лісточак/тв"] = "лісточкам";
["лісточак/пр"] = "лісточку";
}

game : dict {
["зайчык/рд"] = "зайчыка";
["зайчык/вн"] = "зайчыка";
["зайчык/дт"] = "зайчыку";
["зайчык/тв"] = "зайчыкам";
["зайчык/пр"] = "зайчыку";
}

game : dict {
["комель/рд"] = "комля";
["комель/вн"] = "комель";
["комель/дт"] = "комлю";
["комель/тв"] = "комлем";
["комель/пр"] = "комлі";
}

game : dict {
["ствол/рд"] = "ствала";
["ствол/вн"] = "ствол";
["ствол/дт"] = "ствалу";
["ствол/тв"] = "ствалом";
["ствол/пр"] = "ствале";
}

game : dict {
["кара/рд"] = "кары";
["кара/вн"] = "кару";
["кара/дт"] = "кары";
["кара/тв"] = "карой";
["кара/пр"] = "кары";
}

game : dict {
["трэшчынка/рд"] = "трэшчынкі";
["трэшчынка/вн"] = "трэшчынку";
["трэшчынка/дт"] = "трэшчынцы";
["трэшчынка/тв"] = "трэшчынкай";
["трэшчынка/пр"] = "трэшчынцы";
}

game : dict {
["шчылінка/рд"] = "шчылінкі";
["шчылінка/вн"] = "шчылінку";
["шчылінка/дт"] = "шчылінцы";
["шчылінка/тв"] = "шчылінкай";
["шчылінка/пр"] = "шчылінцы";
}

game : dict {
["вязы/рд"] = "вязаў";
["вязы/вн"] = "вязы";
["вязы/дт"] = "вязам";
["вязы/тв"] = "вязамі";
["вязы/пр"] = "вязах";
}

game : dict {
["алея/рд"] = "алеі";
["алея/вн"] = "алею";
["алея/дт"] = "алеі";
["алея/тв"] = "алеяй";
["алея/пр"] = "алеі";
}

game : dict {
["аблачынкі/рд"] = "аблачынак";
["аблачынкі/вн"] = "аблачынкі";
["аблачынкі/дт"] = "аблачынкам";
["аблачынкі/тв"] = "аблачынкамі";
["аблачынкі/пр"] = "аблачынках";
}

game : dict {
["аблачынка/рд"] = "аблачынкі";
["аблачынка/вн"] = "аблачынку";
["аблачынка/дт"] = "аблачынцы";
["аблачынка/тв"] = "аблачынкай";
["аблачынка/пр"] = "аблачынцы";
}

game : dict {
["хмурынка/рд"] = "хмурынкі";
["хмурынка/вн"] = "хмурынку";
["хмурынка/дт"] = "хмурынцы";
["хмурынка/тв"] = "хмурынкай";
["хмурынка/пр"] = "хмурынцы";
}

game : dict {
["свяціла/рд"] = "свяціла";
["свяціла/вн"] = "свяціла";
["свяціла/дт"] = "свяцілу";
["свяціла/тв"] = "свяцілам";
["свяціла/пр"] = "свяціле";
}

game : dict {
["дзірван/рд"] = "дзірвану";
["дзірван/вн"] = "дзірван";
["дзірван/дт"] = "дзірвану";
["дзірван/тв"] = "дзірваном";
["дзірван/пр"] = "дзірване";
}

game : dict {
["будынак/рд"] = "будынка";
["будынак/вн"] = "будынак";
["будынак/дт"] = "будынку";
["будынак/тв"] = "будынкам";
["будынак/пр"] = "будынку";
}

game : dict {
["сядзіба/рд"] = "сядзібы";
["сядзіба/вн"] = "сядзібу";
["сядзіба/дт"] = "сядзібе";
["сядзіба/тв"] = "сядзібай";
["сядзіба/пр"] = "сядзібе";
}

game : dict {
["гаспода/рд"] = "гасподы";
["гаспода/вн"] = "гасподу";
["гаспода/дт"] = "гасподзе";
["гаспода/тв"] = "гасподай";
["гаспода/пр"] = "гасподзе";
}

game : dict {
["чарапіца/рд"] = "чарапіцы";
["чарапіца/вн"] = "чарапіцу";
["чарапіца/дт"] = "чарапіцы";
["чарапіца/тв"] = "чарапіцай";
["чарапіца/пр"] = "чарапіцы";
}

game : dict {
["гліна/рд"] = "гліны";
["гліна/вн"] = "гліну";
["гліна/дт"] = "гліне";
["гліна/тв"] = "глінай";
["гліна/пр"] = "гліне";
}

game : dict {
["комін/рд"] = "коміна";
["комін/вн"] = "комін";
["комін/дт"] = "коміну";
["комін/тв"] = "комінам";
["комін/пр"] = "коміне";
}

game : dict {
["шалёўка/рд"] = "шалёўкі";
["шалёўка/вн"] = "шалёўку";
["шалёўка/дт"] = "шалёўцы";
["шалёўка/тв"] = "шалёўкай";
["шалёўка/пр"] = "шалёўцы";
}

game : dict {
["плюшч/рд"] = "плюшчу";
["плюшч/вн"] = "плюшч";
["плюшч/дт"] = "плюшчу";
["плюшч/тв"] = "плюшчам";
["плюшч/пр"] = "плюшчы";
}

game : dict {
["пераплёт/рд"] = "пераплёту";
["пераплёт/вн"] = "пераплёт";
["пераплёт/дт"] = "пераплёту";
["пераплёт/тв"] = "пераплётам";
["пераплёт/пр"] = "пераплёце";
}

game : dict {
["крона/рд"] = "кроны";
["крона/вн"] = "крону";
["крона/дт"] = "кроне";
["крона/тв"] = "кронай";
["крона/пр"] = "кроне";
}
game : dict {
["карабель/рд"] = "карабля";
["карабель/вн"] = "карабель";
["карабель/дт"] = "караблю";
["карабель/тв"] = "караблём";
["карабель/пр"] = "караблі";
}


game : dict {
["сцежкі/рд"] = "сцежак";
["сцежкі/вн"] = "сцежкі";
["сцежкі/дт"] = "сцежкам";
["сцежкі/тв"] = "сцежкамі";
["сцежкі/пр"] = "сцежках";
}

game : dict {
["астры/рд"] = "астраў";
["астры/вн"] = "астры";
["астры/дт"] = "астрам";
["астры/тв"] = "астрамі";
["астры/пр"] = "астрах";
}

game : dict {
["касачы/рд"] = "касачоў";
["касачы/вн"] = "касачы";
["касачы/дт"] = "касачам";
["касачы/тв"] = "касачамі";
["касачы/пр"] = "касачах";
}

game : dict {
["рамонкі/рд"] = "рамонкаў";
["рамонкі/вн"] = "рамонкі";
["рамонкі/дт"] = "рамонкам";
["рамонкі/тв"] = "рамонкамі";
["рамонкі/пр"] = "рамонках";
}

game : dict {
["веранда/рд"] = "веранды";
["веранда/вн"] = "веранду";
["веранда/дт"] = "верандзе";
["веранда/тв"] = "верандай";
["веранда/пр"] = "верандзе";
}

game : dict {
["тэраса/рд"] = "тэрасы";
["тэраса/вн"] = "тэрасу";
["тэраса/дт"] = "тэрасе";
["тэраса/тв"] = "тэрасай";
["тэраса/пр"] = "тэрасе";
}

game : dict {
["ганак/рд"] = "ганка";
["ганак/вн"] = "ганак";
["ганак/дт"] = "ганку";
["ганак/тв"] = "ганкам";
["ганак/пр"] = "ганку";
}

game : dict {
["збудаванне/рд"] = "збудавання";
["збудаванне/вн"] = "збудаванне";
["збудаванне/дт"] = "збудаванню";
["збудаванне/тв"] = "збудаваннем";
["збудаванне/пр"] = "збудаванні";
}

game : dict {
["кусты/рд"] = "кустоў";
["кусты/вн"] = "кусты";
["кусты/дт"] = "кустам";
["кусты/тв"] = "кустамі";
["кусты/пр"] = "кустах";
}

game : dict {
["зарасці/рд"] = "зарасцяў";
["зарасці/вн"] = "зарасці";
["зарасці/дт"] = "зарасцям";
["зарасці/тв"] = "зарасцямі";
["зарасці/пр"] = "зарасцях";
}

game : dict {
["бэз/рд"] = "бэзу";
["бэз/вн"] = "бэз";
["бэз/дт"] = "бэзу";
["бэз/тв"] = "бэзам";
["бэз/пр"] = "бэзе";
}

game : dict {
["зараснік/рд"] = "зарасніку";
["зараснік/вн"] = "зараснік";
["зараснік/дт"] = "зарасніку";
["зараснік/тв"] = "зараснікам";
["зараснік/пр"] = "зарасніку";
}

game : dict {
["кустоўе/рд"] = "кустоўя";
["кустоўе/вн"] = "кустоўе";
["кустоўе/дт"] = "кустоўю";
["кустоўе/тв"] = "кустоўем";
["кустоўе/пр"] = "кустоўі";
}

game : dict {
["слупы/рд"] = "слупоў";
["слупы/вн"] = "слупы";
["слупы/дт"] = "слупам";
["слупы/тв"] = "слупамі";
["слупы/пр"] = "слупах";
}

game : dict {
["балюстрада/рд"] = "балюстрады";
["балюстрада/вн"] = "балюстраду";
["балюстрада/дт"] = "балюстрадзе";
["балюстрада/тв"] = "балюстрадай";
["балюстрада/пр"] = "балюстрадзе";
}

game : dict {
["поручні/рд"] = "поручняў";
["поручні/вн"] = "поручні";
["поручні/дт"] = "поручням";
["поручні/тв"] = "поручнямі";
["поручні/пр"] = "поручнях";
}

game : dict {
["парэнчы/рд"] = "парэнчаў";
["парэнчы/вн"] = "парэнчы";
["парэнчы/дт"] = "парэнчам";
["парэнчы/тв"] = "парэнчамі";
["парэнчы/пр"] = "парэнчах";
}

game : dict {
["белая/рд"] = "белай";
["белая/вн"] = "белую";
["белая/дт"] = "белай";
["белая/тв"] = "белай";
["белая/пр"] = "белай";
}

game : dict {
["кветачкі/рд"] = "кветачак";
["кветачкі/вн"] = "кветачкі";
["кветачкі/дт"] = "кветачкам";
["кветачкі/тв"] = "кветачкамі";
["кветачкі/пр"] = "кветачках";
}

game : dict {
["суквецці/рд"] = "суквеццяў";
["суквецці/вн"] = "суквецці";
["суквецці/дт"] = "суквеццям";
["суквецці/тв"] = "суквеццямі";
["суквецці/пр"] = "суквеццях";
}

game : dict {
["барбарыс/рд"] = "барбарысу";
["барбарыс/вн"] = "барбарыс";
["барбарыс/дт"] = "барбарысу";
["барбарыс/тв"] = "барбарысам";
["барбарыс/пр"] = "барбарысе";
}

game : dict {
["разнатраўе/рд"] = "разнатраўя";
["разнатраўе/вн"] = "разнатраўе";
["разнатраўе/дт"] = "разнатраўю";
["разнатраўе/тв"] = "разнатраўем";
["разнатраўе/пр"] = "разнатраўі";
}

game : dict {
["травы/рд"] = "траў";
["травы/вн"] = "травы";
["травы/дт"] = "травам";
["травы/тв"] = "травамі";
["травы/пр"] = "травах";
}

game : dict {
["слоік/рд"] = "слоіка";
["слоік/вн"] = "слоік";
["слоік/дт"] = "слоіку";
["слоік/тв"] = "слоікам";
["слоік/пр"] = "слоіку";
}

game : dict {
["слоічак/рд"] = "слоічка";
["слоічак/вн"] = "слоічак";
["слоічак/дт"] = "слоічку";
["слоічак/тв"] = "слоічкам";
["слоічак/пр"] = "слоічку";
}

