--$Name: Лунный дождь опять пришёл в мой сад…$
--$Version: 1.3$
--$Author: Uladzimir$
--$Info: Настоящий творец в порыве вдохновения способен на немыслимые вещи$

--Абавязковая ініцыялізацыя неабходных модуляў
require "parser/mp-ru"
require "fmt"
fmt.dash = true
fmt.quotes = true

function init()
move(pl, 'intro')
pl.description = "Александре тридцать лет. Она хозяйка одноэтажной усадьбы с домом и садом, любовь и муза мужа-композитора и, самое главное, художница. Она, говорят, родилась с кисточкой в руках. Наверное не врут. У неё светлые волосы, которые к тому же выгорают на солнце во время постоянных этюдов на свежем воздухе. На красивых щеках время от времени гостят мазки краски, то зелёной, то голубой. Муж говорит, что это ей очень идёт. И листочки липы в кудрях -- тоже."
pl.word = -"Александра/жр,3л,нст"

end

--пакой для прайгравання стартавага інтра
room {
nam = "start";

before_Look = function() move (pl, "intro") end;
}

--аб'ект-катсцэна з уступам
cutscene {
nam = 'intro',
title = "";
text = {
[[От автора ^Особенности этой игры: при первом посещении любой комнаты вам показывается его длинное описание. При следующих посещениях вы будете видеть короткие описания. Чтобы ещё раз прочитать полное описание комнаты, например гостиной или площадки перед верандой, вам надо, находясь в комнате,  набрать команду: "осмотреть гостиную" или просто "гостиная" и "осмотреть площадку" или просто "площадка". В остальных местах логика такая же. Обратите внимание на заголовок комнаты и подберите подходящее слово. ^Успехов вам!]];
[[Тихий семейный вечер. Александра сидит в кресле, слушает дождь. Муж сидит подле пианино, грезит о чём-то. Пальцы задумчиво гуляют по клавишам. Так хорошо просто быть рядом и смотреть в окно! ]];
[[Глаза молодой женщины изучают заоконный пейзаж. В душе осторожной рыбкой плавает какая-то смутная идея, но не получается её поймать. Шевельнётся, мелькнёт на краю мысли и снова спрячется. Остаётся замереть и смотреть, внимать. Может так удастся понять -- что это: тема для новой картины, или, может, для нового стихотворения? И в чём её суть? ]];
};
next_to = 'kresla';
}
--пакой з інтра скончаны

--лакацыі дома
--кабінет 
room {
nam = "kabinet";
title = "Кабинет";
init_dsc = "Стены этой комнаты часто полнятся звуками рояля. Отсюда композитор отправляется в свои музыкальные полёты. На севере дверь в коридор.";
dsc = "На севере дверь в коридор.";
n_to = 'kalidor';
}

--аб'ект для доўгага апісання пакоя
obj {
-"кабинет/мр|комната/жр|помещение/ср";
description = "Стены этой комнаты часто полнятся звуками рояля. Отсюда композитор отправляется в свои музыкальные полёты. На севере дверь в коридор.";
found_in = 'kabinet';
}:attr 'scenery'

--калідор
room {
nam = "kalidor";
title = "Коридор";
init_dsc = "Коридор тянется с севера на юг. В дневное время немного света попадает с севера, через застеклённую дверь веранды, а так же через арочный вход в гостиную на западе. На востоке дверь мастерской. На юге коридор замыкает глухая дверь Казимирова кабинета.";
dsc = "На юге дверь кабинета, на западе арочный проход в гостиную, на востоке дверь мастерской, на севере выход на веранду.";
s_to = 'u_kabinet';
e_to = 'maysternya';
w_to = 'gascyounya';
n_to = 'veranda2';

--робім функцыю, каб гулец мог выйсці камандай "вонкі"
out_to = function(s)
if here() ^ "kalidor" and _'dzen_drugi':hasnt'visited' then
pn "Александре не хочется выходить из дома. Лучше побыть в гостиной вместе с мужем и дождём за окном.";
elseif here() ^ "kalidor" and _'dzen_drugi':has'visited' and not have ('shal') then
pn "После ночного дождя в саду слишком свежо. Нужно накинуть шаль.";
elseif here() ^ "kalidor" and _'dzen_drugi':has'visited' and have ('shal') then
pn "Пройдя сквозь веранду, Александра сбежала по ступеням и очутилась на улице.";
walk 'sad_i_vyazy'
end
end;

}

--аб'ект для доўгага апісання пакоя
obj {
-"коридор/мр";
description = "Коридор тянется с севера на юг. Немного света попадает с севера, через застеклённую дверь веранды, а так же через арочный вход в гостиную на западе. На востоке дверь мастерской. На юге коридор замыкает глухая дверь Казимирова кабинета.";
found_in = 'kalidor';
}:attr 'scenery'

--праход у кабінет. каб забараніць гульцу заходзіць у другі дзень
door {
nam = "u_kabinet";
found_in = 'kalidor';
door_to = function(s)
if _'dzen_drugi':has'visited' and not _'arkush'.fragment5 then
pn "Казимир работает. За дверью не смолкает рояль. Не надо мешать.";
else
walk 'kabinet'
end
end;
}:attr 'static, open, concealed';

--гасцёўня
room {
nam = "gascyounya";
title = "Гостиная";

before_Listen = function(s, w)
if _'dzen_drugi':hasnt'visited' and 
w ^ 'piyanina' then
pn "Александра вслушивается в прохладные звуки пианино.";
else
pn "Пианино молчит.";
end
end;

padkazka2 = false;
--дэман у гасцёўні, які ў залежнасці ад ужо пабачаных аб'ектаў запускае жаданне пісаць
daemon = function(s)
--пяты крок. скончылі верш. Казімір папрасіў прачытаць
if here() ^ "gascyounya" and _'arkush'.fragment5 then
pn "Надо дать листок Казимиру. Что он скажет?";
end
--чацвёрты крок. Пасля размалёўвання карнізаў гульня падказвае дапісаць верш
if _'razmalyavala_karniz':has'visited' and not s.padkazka2 then
s.padkazka2 = true;
p [["Теперь можно и дописать стихотворение…"]]
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
end
--трэці крок. бачым кроплі, карніз і шкло
if here() ^ "gascyounya" and 
(_'karniz1'.bachyu or _'gascyounya_i_kropli'.bachyu or _'gascyounya_i_shklo'.bachyu) 
and not _'arkush'.fragment3 
then
_'nathnenne'.pisham3 = true;
pn "Александра задумчиво кусает губы и кивает своим мыслям. Это нужно записать.";
end
--другі крок. бачым поўню і голле
if here() ^ "gascyounya" and 
(_'gascyounya_i_pounya'.bachyu or _'gascyounya_i_golle'.bachyu)
and not _'arkush'.fragment2 
then
_'nathnenne'.pisham2 = true;
pn "Александра довольно улыбается. Ей нравится идея, пришедшая в голову. Нужно записать.";
end
--першы крок. бачым дождж і сад. без прыладаў
if here() ^ "gascyounya" and 
(_'gascyounya_i_dojdj'.bachyu or _'gascyounya_i_sad'.bachyu)
and not _'arkush'.fragment1 
then
_'nathnenne'.pisham1 = true;
pn "Александра чувствует в душе знакомое дуновение нездешнего ветра: строки просятся на бумагу. Нужно скорее найти чистый лист и карандаш.";
end
end;

init_dsc = "Большой квадратный зал с двумя окнами, выходящими на запад.";
dsc = "Выход в коридор на востоке.";
e_to = 'u_kalidor';
}

--аб'ект для доўгага апісання пакоя
obj {
-"гостиная/жр|зал/мр|помещение/ср";
description = "Большой квадратный зал с двумя окнами, выходящими на запад.";
found_in = 'gascyounya';
}:attr 'scenery'

--праход у калідор, каб забараніць гульцу выхад пасля таго, як ён размалюе карнізы
door {
nam = "u_kalidor";
found_in = 'gascyounya';
door_to = function(s)
if _'arkush'.fragment5 then
pn "Александре совсем не хочется покидать гостиную.";

elseif _'razmalyavala_karniz':has'visited' 
--bl and not s.fragment5 
and have ('gazeta') 
then
pn "Нет-нет, нужно дописать стихотворение.";
else
walk 'kalidor'
end
end;
}:attr 'static, open, concealed';

--майстэрня
room {
nam = "maysternya";
title = "Мастерская";
init_dsc = "Светлое помещение. С первого взгляда понятно, что тут владения художника. Выход на западе.";
dsc = "Светлая комната. Выход на западе.";
w_to = 'kalidor';

padkazka = false;
--дэман у майстэрні. --дэман і майстэрня
daemon = function(s)
--задаем задачу гульцу у пачатку другога дня
if here() ^ "maysternya" and not s.padkazka then
s.padkazka = true;
pn [["Надо взять в этюднике белую и чёрную краски и отправляться на улицу -- карнизы ждут не дождутся."]];
DaemonStop('maysternya') -- падказку зрабілі, спыняем дэмана
end
end;


}

--аб'ект для доўгага апісання пакоя
obj {
-"мастерская,комната/жр|помещение/ср";
description = "Просторное уютное помещение со стенами, выкрашенными в светлый цвет.";
found_in = 'maysternya';
}:attr 'scenery'

--лакацыі саду
--сад і ліпа
room {
nam = "sad_i_lipa";
title = "Цветник под липой";
init_dsc = "Открытый живописный участок сада. Во все стороны разбегаются узенькие дорожки, по обеим сторонам которых пестрят разными красками клумбы, зеленеет ровно скошеная травка. ^Аллея старых деревьев на северо-запад отсюда; на юго-западе из-за кустов выглядывает лёгкое строение.";
dsc = "Аллея старых деревьев на северо-запад отсюда; на юго-западе из-за кустов выглядывает лёгкое строение.";
nw_to = 'sad_i_vyazy';
sw_to = 'sad_i_altanka';
}

--аб'ект для доўгага апісання пакоя
obj {
-"цветник, сад/мр";
description = "Открытый живописный участок сада. Во все стороны разбегаются узенькие дорожки, по обеим сторонам которых пестрят разными красками клумбы, зеленеет ровно скошеная травка. ^Аллея старых деревьев на северо-запад отсюда; на юго-западе из-за кустов выглядывает лёгкое строение.";
found_in = 'sad_i_lipa';
}:attr 'scenery'

--сад і альтанка
room {
nam = "sad_i_altanka";
title = "Закуток подле беседки";
init_dsc = "Здесь, в южном конце сада, самое укромное место. ^На северо-востоке липа, на северо-западе сливовый сад.";
dsc = "На северо-востоке цветник и липа, на северо-западе сливовый сад.";
ne_to = 'sad_i_lipa';
nw_to = 'sad_i_slivy';
e_to = 'altanka';

--робім функцыю, каб гулец мог увайсці ў альтанку, калі галінка адсунутая
Enter = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
_'player':move'u_altancy'
pn "Александра переступает через порожец и входит в беседку. ^Ветка с шелестом вернулась на место.";
else
pn "Ветка сирени мешает войти.";
end
end;

--робім функцыю, каб гулец мог увайсці ўнутр
in_to = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
_'player':move'u_altancy'
pn "Александра переступает через порожец и входит в беседку. ^Ветка с шелестом вернулась на место.";
else
pn "Ветка сирени мешает войти.";
end
end;

}

--аб'ект для доўгага апісання пакоя
obj {
-"закуток, сад/мр";
description = "Здесь, в южном конце сада, самое укромное место.";
found_in = 'sad_i_altanka';
}:attr 'scenery'

--у альтанцы
room {
nam = "u_altancy";
title = "В беседке";
init_dsc = "Чрезвычайно уютное местечко, особенно, когда по листьям кустов лопочет дождь, а под покатой крышей беседки уютно и сухо, только душистый ветерок веет. ^ На западе выход.";
dsc = "Выход на западе.";
w_to = 'altanka2';

before_Smell = function(s, w)
if w ^ 'slupy' then
_'pah2':disable()
pn "От столбов беседки пахнет свежей краской.";
else
pn "Пахнет свежей краской.";
end
end;

--робім функцыю, каб гулец мог выйсці з альтанкі
Exit = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
_'player':move'sad_i_altanka'
pn "Александра выходит наружу. ^Ветка с шелестом вернулась на место.";
else
pn "Ветка сирени мешает выйти.";
end
end;

--робім функцыю, каб гулец мог выйсці камандай "вонкі"
out_to = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
_'player':move'sad_i_altanka'
pn "Александра выходит наружу. ^Ветка с шелестом вернулась на место.";
else
pn "Ветка сирени мешает выйти.";
end
end;

}

--аб'ект для доўгага апісання пакоя
obj {
-"беседка/жр|строение/ср";
description = "Чрезвычайно уютное местечко, особенно, когда по листьям кустов лопочет дождь, а под покатой крышей беседки уютно и сухо, только душистый ветерок веет.";
found_in = 'u_altancy';
}:attr 'scenery'

--сад і слівы
room {
nam = "sad_i_slivy";
title = "Сливовый сад";
init_dsc = "Этот участок отдан под сливовый сад. Сейчас, в пору цветения, это самое очаровательное место на свете. ^Заросли сирени на юго-востоке отсюда, аллея вязов на северо-востоке.";
dsc = "Заросли сирени на юго-востоке отсюда, аллея вязов на северо-востоке.";
ne_to = 'sad_i_vyazy';
se_to = 'sad_i_altanka';
}

--аб'ект для доўгага апісання пакоя
obj {
-"сад/мр";
description = "Этот участок отдан под сливовый сад. Сейчас, в пору цветения, это самое очаровательное место на свете.";
found_in = 'sad_i_slivy';
}:attr 'scenery'

--сад і вязы. --алея вязаў
room {
nam = "sad_i_vyazy";
title = "Площадка у веранды";
init_dsc = "Возле входа в дом раскинулась небольшая скошенная лужайка. Свежая густая трава радует взгляд. ^На север тянется аллея вязов. На юго-востоке цветник и липа. На юго-западе белеют сливы.";
dsc = "На север тянется аллея вязов. На юго-востоке цветник и липа. На юго-западе белеют сливы.";

Listen = "Деревья бесконечно шепчут над головой.";

before_Smell = function(s, w)
if w ^ 'lavachka' then
_'pah':disable()
pn "От лавочки пахнет свежей краской.";
else
pn "Пахнет свежей краской.";
end
end;

n_to = 'sad_i_vyazy2';
s_to = 'veranda';
se_to = 'sad_i_lipa';
sw_to = 'sad_i_slivy';

--робім функцыю, каб гулец мог увайсці ўнутр
in_to = function(s)
if here() ^ "sad_i_vyazy" and not have ('shal') then
pn "Поставив ногу на ступеньку, Александра вспомнила, что оставила в саду шаль. Не нужно оставлять любимую вещь лишь бы где: наберётся влаги -- надо забрать с собой.";
elseif here() ^ "sad_i_vyazy" and have ('shal') then
walk 'kalidor'
pn "Александра поднялась по ступеням, прошла сквозь веранду и зашла в дом.";
end
end;




}

--аб'ект для доўгага апісання пакоя
obj {
-"площадка, лужайка, полянка/жр|лужок/мр";
description = "Возле входа в дом раскинулась небольшая скошенная лужайка. Свежая густая трава радует взгляд.";
found_in = 'sad_i_vyazy';
}:attr 'scenery'

--алея. у глыбіні алеі
room {
nam = "sad_i_vyazy2";
title = "В глубине аллеи";
init_dsc = "Могучие деревья с потрескавшейся корой сплетают ветви вверху, создавая сводчатый зелёный тоннель. Лучам удаётся то тут, то там проскользнуть сквозь густую листву, и на дорожке шевелятся пятна света. ^Аллея ведёт с юга на север. Ещё, протиснувшись между стволами, можно пробраться на запад.";
dsc = "Вязы стоят по сторонам дорожки. Аллея ведёт с юга на север. Ещё, протиснувшись между стволами, можно пробраться на запад.";
Smell = "Пахнет влажной землёй и зеленью.";
Listen = "Деревья бесконечно шепчут над головой.";

n_to = 'pa_alei';
s_to = 'sad_i_vyazy';
w_to = 'sad_i_barbarys';
}

--аб'ект для доўгага апісання пакоя
obj {
-"аллея/жр";
description = "Могучие деревья с потрескавшейся корой сплетают ветви вверху, создавая сводчатый зелёный тоннель. Лучам удаётся то тут, то там проскользнуть сквозь густую листву, и на дорожке шевелятся пятна света.";
found_in = 'sad_i_vyazy2';
}:attr 'scenery'

--праход, каб зрабіць бясконцы шпацыр па алеі
door {
nam = "pa_alei";
found_in = 'sad_i_vyazy2';

door_to = function(s)
if _'dzen_drugi':has'visited' then
pn "В этой зелёной тени можно идти и идти целую бесконечность.";
walk 'sad_i_vyazy2'
end
end;
}:attr 'static, open, concealed';

--сад і барбарыс
room {
nam = "sad_i_barbarys";
title = "Лужайка возле аллеи";
init_dsc = "Лужок зарос высокими травами. С востока его обрамляют вязы.";
dsc = "Пойдя на восток, можно выбраться на аллею.";
e_to = 'sad_i_vyazy2';
}

--аб'ект для доўгага апісання пакоя
obj {
-"лужайка/жр|лужок/мр";
description = "Лужок зарос высокими травами. С востока его обрамляют вязы.";
found_in = 'sad_i_barbarys';
}:attr 'scenery'

--аб'екты кабінету
--газета
obj {
-[["Виленский листок",Виленский листок,листок/мр|ком бумаги,ком,комок/мр|газета/жр]];
nam = "gazeta";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
p [[Александра разгладила бумагу. Это номер "Виленского листка" за прошлую неделю. Казик сильно хмурился, когда листал его. Под названием газеты набрано: "9 числа месяца октября".]];
else
p [[Номер "Виленского листка" за прошлую неделю. Под названием газеты набрано: "9 числа месяца октября".]];
end
end;

init_dsc = "Под лавочкой валяется ком бумаги.";
found_in = 'lavachka2';
}:attr 'атрибут':disable()

--акно
obj {
-"окно,стекло/ср|стёкла/мн";
nam = "akno";
before_Touch2 = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "С какой стати?";
else
pn "Александра намерена разрисовать карнизы, а не окна.";
end
end;

before_Take = function () 
p [[Зачем это делать?]] return true end;

description = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Высокое двухстворчатое окно выходит на юг. За окном темно."
return false
elseif _'dzen_drugi':has'visited' then
pn "Высокое двухстворчатое окно выходит на юг. За стёклами видны заросли сирени и крыша беседки, прячущейся за ними."
return false
end
end;

dsc = function(s)
p "";
return false
end;
when_open = "Одна створка окна приоткрыта и в комнату вливается волшебный запах.";
found_in = 'kabinet';
}:attr 'static,container,openable,transparent'

--стол у кабінеце
obj {
-"стол/мр|скатерть/жр|сукно/ср";
nam = "stol";
before_Take = function () 
p [[Зачем это делать?]] return true end;

description = function(s)
pn "Массивный стол, покрытый зелёным сукном."
return false
end;
dsc = function(s)
p "У окна стоит стол.";
end;
found_in = 'kabinet';
}:attr 'static, transparent, supporter, container, open'

--кніжныя шафы --шафы
obj {
-"книжные шкафы, шкафы, книги/мн";
nam = "shafy";
before_Take = function () 
p [[Зачем это делать?]] return true end;

description = function(s)
pn "Полки шкафов прогибаются от тяжести книг."
return false
end;
dsc = function(s)
p "Книжные шкафы громоздятся вдоль стен.";
end;
found_in = 'kabinet';
}:attr '~animate, static, container,transparent,open'

--аркуш --папера
obj {
-"лист бумаги, лист/мр|бумага, бумажка/жр";
nam = "arkush";
fragment1 = false;
fragment2 = false;
fragment3 = false;
fragment4 = false;
fragment5 = false;

--функцыя, каб у другі дзень пакінуць аркуш на стале
before_Take = function (s) 
if _'dzen_drugi':has'visited' 
and not s.fragment5 
then
p [[Пусть пока полежит на столе.]]
else
return false
end
end;

--функцыя, каб даць аркуш Казіміру
before_Give = function(s, w)
if _'arkush'.fragment5 
then
_'arkush':disable()
pn "Александра подала лист мужу. Тот пробежал глазами по строкам, потом ещё раз, глянул поверх бумаги на карниз, покрутил в изумлении головой, широко улыбнулся и сгрёб жену в объятия, чмокнул в пушистую макушку: -- Виват, моя князёвна! Чудесно получилось. Теперь я жду не дождусь следующей непогоды! ";
walk 'dzen_treci'
end
end;

description = function(s)
if s.fragment5 then
p "Лист бумаги с только что законченным стихотворением. ^^*** ^^Лунный дождь опять пришёл в мой сад. ^Сквозь пушистые ветви цветущих слив ^Сияет луна ^И крупные редкие капли падают вниз, ^ стучат по карнизу, ^Играя обрывки какой-то сонаты. ^Чтобы помочь дождю, ^Я нарисовала на этом карнизе когда-то^Белые клавиши. ^^16 числа месяца октября. ";
elseif s.fragment1 or s.fragment2 or s.fragment3 or s.fragment4 then
p "Лист бумаги с недописанным стихотворением.";
else
p "Лист чистой бумаги.";
end
end;

--функцыя пісаць для аркуша
before_Touch2 = function(s, t)
if not here() ^ "gascyounya" then
pn "Нужно вернуться в гостиную.";
elseif not have ('alovak') and not have ('pyaro') then
pn "Нужно найти какой-нибудь инструмент для письма.";
elseif have ('alovak') and have ('pyaro') then
pn "Или перо, или карандаш нужно отложить в сторону.";
elseif have ('alovak') and _'alovak'.zlamausya then
pn "Карандаш сломался. Нужно заточить его.";
elseif s.fragment5 then
pn "Работа закончена. Стихотворение завершено. Можно выдохнуть и наслаждаться моментом.";
--спачатку фрагменты для алоўка
--Аляксандра піша пяты, завяршальны фрагмент
elseif have ('alovak') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham5 and _'gazeta'.bachyu then
_'nathnenne'.pisham5 = false;
s.fragment5 = true;
s.fragment1 = true;
_'kazimir':move'gascyounya'
_'kalidor_i_rayal':disable()
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
pn [[Александра стремительно дописала: "14 дня месяца октября" и поставила жирную точку, продырявив бумагу. ^Словно дождавшись этого момента, в комнату зашёл Казимир и довольно потянулся: ^--Как же я сегодня замечательно поработал! А чем ты занималась, моя князёвна? -- заметил исписанный лист, -- что это у тебя, можно глянуть?]];
--Аляксандра піша чацвёрты, перадапошні фрагмент
elseif have ('alovak') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham4 and not _'gazeta'.bachyu then
_'nathnenne'.pisham4 = false;
s.fragment4 = true;
_'nathnenne'.pisham5 = true;
pn [[Карандаш выводит: ^"Чтобы помочь дождю, ^Я нарисовала на этом карнизе когда-то^Белые клавиши." ^Александра довольно хмыкнула: "Ну вот, наконец-то дописала. Остаётся дату поставить. Какое сегодня число? -- кусает губы. -- М-м-м, не помню, потеряла счёт дням. Где бы это дату подсмотреть? Надо в Казиковых газетах глянуть. Он не так давно почту получал.".]];
--дублірую на выпадак, калі гулец ужо зазіраў у газету
elseif have ('alovak') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham4 and _'gazeta'.bachyu then
_'nathnenne'.pisham4 = false;
s.fragment4 = true;
_'nathnenne'.pisham5 = true;
pn [[Карандаш выводит: ^"Чтобы помочь дождю, ^Я нарисовала на этом карнизе когда-то^Белые клавиши." ^Александра довольно хмыкнула: "Ну вот, наконец-то дописала. Остаётся дату поставить. Какое сегодня число? -- кусает губы. -- М-м-м, не помню, потеряла счёт дням. Где бы это дату подсмотреть? Ага! Я видела недавнюю Казикову газету. Нужно там ещё раз глянуть.".]];
--Аляксандра піша трэці фрагмент
elseif have ('alovak') and 
(_'karniz1'.bachyu or _'gascyounya_i_kropli'.bachyu or _'gascyounya_i_shklo'.bachyu)
and not s.fragment3 
 and _'nathnenne'.pisham3 then
_'nathnenne'.pisham3 = false;
s.fragment3 = true;
_'nathnenne'.pisham4 = true;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
pn [[Карандаш торопливо бежит по бумаге: ^"И крупные редкие капли падают вниз, ^Стучат по карнизу, сбегают по стёклам,^Играя обрывки какой-то сонаты…"]];
--Аляксандра піша другі радок
elseif have ('alovak') and 
(_'gascyounya_i_pounya'.bachyu or _'gascyounya_i_golle'.bachyu) 
and not s.fragment2 
and _'nathnenne'.pisham2 then
_'nathnenne'.pisham2 = false;
s.fragment2 = true;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
_'alovak'.zlamausya = true;
pn [[На бумаге быстро появляются слова: ^"Сквозь пушистые ветви цветущих слив ^Сияет луна…". ^Кончик карандаша с тихим треском обломился. "Ну вот!.. Жаль. Нужно найти перочинный ножик и заточить грифель. И поскорее, пока вдохновение не ушло!"]];
--Аляксандра піша першы радок
elseif have ('alovak') and 
(_'gascyounya_i_dojdj'.bachyu or _'gascyounya_i_sad'.bachyu) 
and not s.fragment1 
and _'nathnenne'.pisham1 then
_'nathnenne'.pisham1 = false;
s.fragment1 = true;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
pn [[Александра торопливо пишет: ^"Лунный дождь опять пришёл в мой сад…"]];
--цяпер радкі функцыі для пяра
elseif have ('pyaro') and not _'pyaro'.abmaknuu then
pn "На кончике пера нет чернил. Прежде чем писать, нужно обмакнуть перо в чернильницу.";
--Аляксандра піша пяты, завяршальны фрагмент
elseif have ('pyaro') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham5 and _'gazeta'.bachyu then
_'nathnenne'.pisham5 = false;
s.fragment5 = true;
_'pyaro'.abmaknuu = false;
_'kazimir':move'gascyounya'
_'kalidor_i_rayal':disable()
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
pn [[Александра стремительно дописала: "14 дня месяца октября" и поставила жирную точку, пробив пером бумагу. ^Словно дождавшись этого момента, в комнату зашёл Казимир и довольно потянулся: ^--Как же я сегодня замечательно поработал! А чем ты занималась, моя князёвна? -- заметил исписанный лист, -- что это у тебя, можно глянуть?]];
--Аляксандра піша чацвёрты, перадапошні фрагмент
elseif have ('pyaro') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham4 and not _'gazeta'.bachyu then
_'nathnenne'.pisham4 = false;
s.fragment4 = true;
_'nathnenne'.pisham5 = true;
_'pyaro'.abmaknuu = false;
pn [[Перо выводит: ^"Чтобы помочь дождю, ^Я нарисовала на этом карнизе когда-то^Белые клавиши." ^Александра довольно хмыкнула: "Ну вот, наконец-то дописала. Остаётся дату поставить. Какое сегодня число? -- кусает губы. -- М-м-м, не помню, потеряла счёт дням. Где бы это дату подсмотреть? Надо в Казиковых газетах глянуть. Он не так давно почту получал.".]];
--дублірую на выпадак, калі гулец ужо зазіраў у газету
elseif have ('pyaro') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham4 and _'gazeta'.bachyu then
_'nathnenne'.pisham4 = false;
s.fragment4 = true;
_'nathnenne'.pisham5 = true;
_'pyaro'.abmaknuu = false;
pn [[Перо выводит: ^"Чтобы помочь дождю, ^Я нарисовала на этом карнизе когда-то^Белые клавиши." ^Александра довольно хмыкнула: "Ну вот, наконец-то дописала. Остаётся дату поставить. Какое сегодня число? -- кусает губы. -- М-м-м, не помню, потеряла счёт дням. Где бы это дату подсмотреть? Ага! Я видела недавнюю Казикову газету. Нужно там ещё раз глянуть.".]];
--Аляксандра піша трэці фрагмент
elseif have ('pyaro') and
(_'karniz1'.bachyu or _'gascyounya_i_kropli'.bachyu or _'gascyounya_i_shklo'.bachyu)
and not s.fragment3 
 and _'nathnenne'.pisham3 then
_'nathnenne'.pisham3 = false;
s.fragment3 = true;
_'nathnenne'.pisham4 = true;
_'pyaro'.abmaknuu = false;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
pn [[Перо выписывает на бумаге: ^"И крупные редкие капли падают вниз, ^Стучат по карнизу, сбегают по стёклам,^Играя обрывки какой-то сонаты…"]];
--Аляксандра піша другі радок
elseif have ('pyaro') and 
(_'gascyounya_i_pounya'.bachyu or _'gascyounya_i_golle'.bachyu)
and not s.fragment2 
 and _'nathnenne'.pisham2 then
_'nathnenne'.pisham2 = false;
s.fragment2 = true;
_'pyaro'.abmaknuu = false;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
pn [[На бумаге под шорох пера появляются слова: ^"Сквозь пушистые ветви цветущих слив ^Сияет луна…".]];
--Аляксандра піша першы радок
elseif have ('pyaro') and 
(_'gascyounya_i_dojdj'.bachyu or _'gascyounya_i_sad'.bachyu)
and not s.fragment1 
 and _'nathnenne'.pisham1 then
_'nathnenne'.pisham1 = false;
s.fragment1 = true;
_'pyaro'.abmaknuu = false;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
pn [[Александра торопливо пишет: ^"Лунный дождь опять пришёл в мой сад…"]];
else
pn "Удачная мысль ещё не посетила Александру. Нужно поискать вдохновения в окне.";
end
end;

found_in = 'palica';

}:attr 'supporter':disable()

--зэдлік
obj {
-"табурет/мр|табуретка/жр";
nam = "zedlik";
Enter = function(s,w)
pn "Александра опустилась на табурет.";
move(me(), 'zedlik');
end;

before_Take = function () p [[Александре это сейчас не нужно.]] return true end;

description = function(s)
pn "Табурет с круглым сиденьем стоит перед роялем."
return false
end;
found_in = 'kabinet';
}:attr 'enterable,supporter,static,transparent'

--пейзаж з садам і ліпай
obj {
-"картина с садом,картина,липа/жр|сад/мр";

['before_Push,Pull'] = function(s)
p [[Александра решила не трогать картину. За ней всё-равно ничего нет кроме стены. Пусть висит себе.]] return true end;

description = "Над роялем висит картина, выписанная ярким июньским днём. Много-много коротких мазков красного, светлого и тёмно-зелёного показывают кусты роз. За ними видна узнаваемая фигура липы. Нигде такой нет. Её посадил прапрадед Александры. Это чудо, а не дерево: почти возле самой земли ствол разделяется на шесть стволов, держащих на сучьях широченную крону. Тень этого царь-дерева осеняет чуть-ли не половину участка.";
dsc = "На стене висит картина.";
found_in = 'kabinet';
}:attr 'static'

--падлога
obj {
-"пол/мр";
nam = "padloga";
before_Take = function () 
p [[Зачем это делать?]] return true end;

description = "Пол сделан из тёмных досок.";
found_in = {'kabinet', 'kalidor', 'gascyounya', 'maysternya'};
}:attr 'scenery'

--пісьмовы прыбор --прыбор
obj {
-"письменный прибор, прибор/мр";
nam = "prybor";
before_Take = function () p [[Александре это сейчас не нужно.]] return true end;


bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'charnilica':enable()
_'pyaro':enable()
pn "Тяжёлый письменный прибор из полированного дуба украшен медными накладками."
return false
else
pn "Тяжёлый письменный прибор из полированного дуба украшен медными накладками."
return false
end
end;

dsc = function(s)
p "На столе стоит письменный прибор.";
return false
end;
found_in = 'stol';
}:attr 'static, open, transparent, container'

--пяро
obj {
-"перо/ср";
nam = "pyaro";
bachyu = false;
abmaknuu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
p "В деревянную ручку вставлено стальное перо для письма. В последнее время такие пёрышки вошли в моду. На диво удобная вещь: затачивать не нужно, почерк получается аккуратным.";
elseif s.abmaknuu then
p "На остром клюве пера темнеют чернила -- можно писать.";
else
p "В деревянную ручку вставлено стальное перо для письма.";
end
end;

found_in = 'prybor';
}:disable()

--каманда. пашыраем спіс дадатковых дзеясловаў для дзеяння уставіць, уваткнуць. для пяра і пэндзліка
VerbExtendWord {"#Insert",
"[|об]мак[нуть|нула|ивает|нёт|ивай],окун[уть|ула|аю|ёт|ет],погру[зить|зила|жает|зит]"
}

--раяль
obj {
-"рояль, музыкальный инструмент, инструмент/мр|клавиши/мн";
nam = "rayal";
before_Take = function () 
p [[Зачем это делать?]] return true end;

description = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Инструмент из тёмного полированного дерева. Панели мягко поблескивают. Клавиши, белые и чёрные, ждут прикосновений."
return false
else
pn "Лакированные панели инструмента мягко поблескивают."
return false
end
end;

before_Touch3 = function(s, w)
if _'dzen_drugi':hasnt'visited' 
then
pn "Александра нажала несколько нот, прислушалась к голосу рояля и решила оставить инструмент в покое.";
else
pn "Александра нажала несколько нот, прислушалась к голосу пианино и решила оставить инструмент в покое.";
end
end;



found_in = 'kabinet';
}:attr 'static, open, openable, supporter'

--столь
obj {
-"потолок/мр";
description = "Высокий белый потолок придаёт больше пространства.";
found_in = {'kabinet', 'kalidor', 'gascyounya', 'maysternya'};
}:attr 'scenery'

--стул
obj {
-"стул/мр";
nam = "stul";
Enter = function(s,w)
pn "Александра немного поёрзала, устраиваясь на не слишком удобном стуле.";
move(me(), 'stul');
end;

before_Take = function () p [[Александре это сейчас не нужно.]] return true end;

description = function(s)
pn "Стул с высокой твёрдой спинкой стоит подле стола."
return false
end;
found_in = 'kabinet';
}:attr 'enterable,supporter,static,transparent'

--сцены кабінета
obj {
-"стены/мн";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
p "От стен словно исходит мягкий тёплый свет. Ближе к углам Александра придала им чуть больше оранжевых и коричневатых оттенков. Эти игры с красками сделали комнату более скруглённой -- как на картине. Вместе с тёмной мебелью всё выглядит очень и очень уютно. ^Александра ничего не хотела слышать ни про каких нанятых мастеров-маляров и раскрасила, разрисовала все стены в доме своими собственными руками.";
else
p "От стен словно исходит тёплый свет. Вместе с тёмной мебелью всё выглядит очень и очень уютно.";
end
end;

found_in = 'kabinet';
}:attr 'scenery'

--чарніліца
obj {
-"фарфоровая чернильница, чернильница, крышечка/жр";
nam = "charnilica";
description = function(s)
pn "Пузатенькая фарфоровая чернильница с откидной крышечкой. Её бока украшены тонкими зеленоватыми узорами. Казимир часто поглаживает эту приятную на ощупь вещицу, когда думает."
return false
end;
-- when_closed = "Крышечка чернилицы закрыта.";
when_open = "Крышечка чернильницы откинута.";
found_in = 'prybor';

--функцыя дазваляе абмакнуць пяро ў чарніліцу, калі тая адкрытая. Усё астатняе абмакваць забараняе
after_Receive = function(s, w)
if not s:attr 'open' then
p "Но чернильница закрыта.";
elseif not s.abmaknuu and w ^ "pyaro" then
_'pyaro':move'player'
_'pyaro'.abmaknuu = true
p "Александра окунула перо в чернильницу.";
elseif s.abmaknuu and w ^ "pyaro" then
pn "Не нужно -- чернила на пере и так есть.";
elseif not w ^ "pyaro" then
 return "Не нужно совать в чернильницу что попало!", true
 end
end

}:attr 'openable, container, transparent':disable()

--аб'екты калідору
--пейзаж з ратушай
obj {
-"картина с ратушей, картина, ратуша, башня, церковь, дымка/жр|предместья, крыши, улочки, колокольни/мн|костёл/мр|зелень/жр";

['before_Push,Pull'] = function(s)
p [[Александра решила не трогать картину. За ней всё-равно ничего нет кроме стены. Пусть висит себе.]] return true end;


description = "Напротив входа в гостиную висит пейзаж с городскими предместьями. Крыши домов ломанными шнурочками тянутся вдаль, размываясь в дымке. Над ними царствует стройный силуэт городской ратуши.";
found_in = 'kalidor';
dsc = "На стене висит картина.";
}:attr 'static'

--аб'екты гасцёўні
--адбітак клавіятуры ў акне. --адлюстраванне клавіятуры
obj {
-"отражение пианино, отражение клавиатуры, отражение/ср|клавиатура/жр|клавиши/мн|руки казимира,руки/мн";
nam = "piyanina_i_shklo";
bachyu = false;
description = function(s)
if not s.bachyu and _'nathnenne'.pisham4 and _'dzen_drugi':hasnt'visited' then
s.bachyu = true;
p [[Взгляд Александры остановился на отражении пианино в окне, точнее, на ряде белых и чёрных клавиш, наложившихся на карниз и её губы растянулись в довольной улыбке: "Чудесно! Так вот к чему всё шло! Такой замечательный стих написался. Теперь понятно, чем его закончить, но искусство не должно лгать. Надо будет завтра нарисовать на карнизе клавиши и дописать стихотворение.]];
walk 'dzen_drugi'
else
p "Пианино отражается в оконном стекле.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--шыбы ў гасцёўні
obj {
-"оконные стёкла, стёкла/мн|стекло/ср";
nam = "gascyounya_i_shklo";
bachyu = false;
description = function(s)
if _'dzen_drugi':hasnt'visited' and not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
p "По стёклам сбегают дорожки дождевой воды. Из-за этого сад выглядит немного нездешним, мистичным. В стекле видно полупрозрачное отражение комнаты, беловатые клавиши и руки Казимира на них.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu then
p "По стёклам сбегают дорожки дождевой воды. Из-за этого сад выглядит немного нездешним, мистичным. В стекле видно полупрозрачное отражение комнаты, беловатые клавиши и руки Казимира на них.";
elseif _'dzen_drugi':has'visited' then
p "Сквозь стёкла виден белый сад.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--карніз у акне
obj {
-"карниз,подоконник/мр|жесть/жр";
nam = "karniz1";
before_Take = function () 
p [[Зачем это делать?]] return true end;
before_Touch2 = [[Карниз находится снаружи. Чтобы разрисовать его, нужно выйти из дома. ]];
bachyu = false;
description = function(s)
if _'dzen_drugi':hasnt'visited' and not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
p "Александра смотрит на карниз сквозь мокрое стекло. На него, словно специально, наложилось отражение клавиатуры и и руки Казимира на ней.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu then
p "Александра смотрит на карниз сквозь мокрое стекло. На него, словно специально, наложилось отражение клавиатуры и и руки Казимира на ней.";
elseif _'dzen_drugi':has'visited' and _'razmalyavala_karniz':has'visited' and not s.bachyu then
s.bachyu = true;
p "Карниз нахально скалится белозубой улыбкой, из конца в конец разрисованный под белые клавиши, между которыми чернеют полутона: Он так и просит, чтобы по этим пальцам побарабанили пальцы. Сразу видно, что это -- дом композитора. У которого даже дождь не просто так стучит, а музыку играет.";
elseif _'razmalyavala_karniz':has'visited' and s.bachyu then
p "Карниз из конца в конец разрисован под белые клавиши, между которыми чернеют полутона.";
else
p "Жестяной карниз выкрашен неброской серой краской, чтобы его не ела ржавчина.";
end
end;
found_in = {'vokny', 'akno2'};
}:attr 'scenery'

--службовы аб'ект. святло поўні для гасцёўні
obj {
nam = "gascyounya_i_pounya2";
bachyu = false;
dsc = function(s)
if not s.bachyu then
s.bachyu = true;
pn "Александра заворожённо смотрит в окно."
else
pn "Свет луны заливает комнату."
end
end;

found_in = 'gascyounya';
}:attr 'static'

--службовы аб'ект. --гукі раяля для калідора
obj {
nam = "kalidor_i_rayal";
dsc = "Из-за двери кабинета доносится приглушённый рокот рояля.";
found_in = 'kalidor';
}:attr 'static':disable()

--рандомныя гукі кропель і піяніна для гасцёўні
obj {
nam = "gascyounya_i_kropli2";
{ -- масіў выпадковых фраз
dyn_part = {
[1] = "Пригоршня капель сыпанула в окно. Стёкла тихонько зазвенели.",
[2] = "Тяжёлая капля гулко бумкнула в карниз.",
[3] = "Капли простучали по карнизу, словно музыкант пробежался пальцами по клавишам.",
[4] = "За окном крупные капли сверкнули, словно расплавленное серебро.",
[5] = "За окном крупные капли сверкнули, словно расплавленное серебро.",
[6] = "Пианино выдало несколько низких нот, словно Казимир повторил следом за каплями.",
[7] = "По комнате пробежалось лёгкое-лёгкое, почти беззвучное стоккато.",
[8] = "Обрывок смутно знакомой музыки зазвучал в комнате. Может, Казимир как-то играл это при Александре, читая со страниц выписанной из-за границы тетради. Лист или что-то такое.",
[9] = "Тяжёлая капля гулко бумкнула в карниз.",
[10] = "Пригоршня капель сыпанула в окно. Стёкла тихонько зазвенели.",
},
};
dsc = function(s) p ""; -- тут мусіў быць тэкст для пакоя
local r = rnd(#s.dyn_part); -- круцім генератар выпадковых лікаў
p(s.dyn_part[r]); --выводзім выпадковую фразу
end;

found_in = 'gascyounya';
}:attr 'static'

--кроплі ў акне
obj {
-"капли дождя, капли, капельки, дождинки/мн";
nam = "gascyounya_i_kropli";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
p "Капли серебрянными падучими звёздочками время от времени срываются вниз.";
else
p "Капли серебрянными падучими звёздочками время от времени срываются вниз.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--поўня ў акне
obj {
-"луна/жр|месяц/мр";
nam = "gascyounya_i_pounya";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
_'nathnenne'.pisham2 = true;
p "Круглая луна плывёт низко-низко над окоёмом. Она громадная и сияющая: дождик незря старался -- отмывал до зеркального блеска.";
else
p "Круглая луна плывёт низко-низко над окоёмом. Она громадная и сияющая : дождик незря старался -- отмывал до зеркального блеска.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--галіны сліў
obj {
-"ветви слив, ветки слив, ветви, ветки,цветы/мн|цвет/мр";
nam = "gascyounya_i_golle";
bachyu = false;
description = function(s)
if _'dzen_drugi':hasnt'visited' and not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
_'nathnenne'.pisham2 = true;
p "Чёрные контуры обсыпанных цветами ветвей на фоне луны выразительные, как на гравюре.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu then
p "Чёрные контуры обсыпанных цветами ветвей на фоне луны выразительные, как на гравюре.";
elseif _'dzen_drugi':has'visited' then
p "Цветов так много, что между ними почти не видно ветвей. От этого кажется, что деревья пышные и лёгкие, как облака.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--натхненне, якое падштурхоўвае пісаць верш. службовы аб'ект
--да гэтага аб'екта нельга звярнуцца, але ў яго ёсць нам і сцяжок для логікі пісання
obj {
nam = "nathnenne";
vee = false;
pisham1 = false;
pisham2 = false;
pisham3 = false;
pisham4 = false;
pisham5 = false;
found_in = 'gascyounya';
}:attr 'scenery'

--дождж
obj {
-"дождь, дождик/мр";
nam = "gascyounya_i_dojdj";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
_'nathnenne'.pisham1 = true;
p "Ласковый майский дождик нет, не идёт -- скорее на пальчиках крадётся по саду. Редкие крупные капли мягко хлопают по карнизу, покачивают ветки деревьев.";
else
p "Ласковый майский дождик нет, не идёт -- скорее на пальчиках крадётся по саду. Редкие крупные капли мягко хлопают по карнизу, покачивают ветки деревьев.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--сад з гасцёўні
obj {
-"сливовый сад, цветущий сад, сад/мр|сливы, деревья, деревца/мн";
nam = "gascyounya_i_sad";
bachyu = false;
description = function(s)
if _'dzen_drugi':hasnt'visited' and not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
_'nathnenne'.pisham1 = true;
p "Цветущие деревья белеют на фоне синих сумерек. А вот если глянуть на луну, то на её фоне они рисуются уже тёмными силуэтами. Интересно.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu then
p "Цветущие деревья белеют на фоне синих сумерек. А вот если глянуть на луну, то на её фоне они рисуются уже тёмными силуэтами. Интересно.";
elseif _'dzen_drugi':has'visited' and s.bachyu then
p "Сад красуется в праздничном наряде, радуется солнцу, ветерку и жизни.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--нотны сшытак
obj {
-"нотная тетрадь, тетрадь/жр|ноты/мн";
nam = "noty";

before_Take = function () p [[Александре это сейчас не нужно.]] return true end;

description = "Нотная тетрадь развёрнута на чистой странице. Александра видит пустые строчки. Казимир намеревался что-то писать, но пока не оставил на линейках ни одной нотки.";
before_Take = function () p [[Не нужно. Пусть лежит, где лежит.]] return true end;
found_in = 'piyanina';
}

--Казімір. --муж
obj {
-"Казимир, Казик, мужчина, муж, музыкант, композитор/мр";
nam = "kazimir";
description = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Лохматая голова Казимира склонена. Он слушает дождь за окном. Пальцы задумчиво перебирают клавиши, ничего не нажимая."
elseif _'dzen_drugi':has'visited' then
pn "Казимир одет в шерстяную рубашку. Он смотрит на жену широко распахнутыми глазами, любуется."
end
end;

dsc = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Казимир сидит за инструментом."
elseif _'dzen_drugi':has'visited' then
pn "Казимир стоит посреди комнаты."
end
end;

['before_Talk,Answer,Ask,AskTo,AskFor,Tell'] = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Не стоит ему мешать."
elseif _'dzen_drugi':has'visited' then
pn "Александра задумалась."
end
end;

before_Touch= function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Александра передумала: не нужно сейчас выдёргивать Казимира из мыслей.";
else
pn "Казимир улыбнулся и обнял Александру в ответ.";
end
end;

before_Kiss = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Хорошо бы, но лучше сейчас от этого воздержаться.";
else
pn "Александра целует мужа.";
end
end;

found_in = 'zedlik2';
}:attr 'animate'

--зэдлік у гасцёўні
obj {
-"табурет/мр|табуретка/жр";
nam = "zedlik2";
Enter = function(s,w)
if _'dzen_drugi':hasnt'visited' then
pn "На табурете сейчас сидит Казимир."
else
pn "Александра опустилась на табурет."
move(me(), 'zedlik2');
end
end;

before_Take = function () p [[Александре это сейчас не нужно.]] return true end;


description = function(s)
pn "Табурет с круглым сиденьем стоит напротив пианино."
return false
end;
found_in = 'gascyounya';
}:attr 'enterable,supporter,static,transparent'

--аловак
obj {
-"карандаш/мр";
nam = "alovak";
description = "Простой карандаш, Ну да, немного погрызенный с незаточенного конца. Ну и что? Время от времени он оказывается за ухом Александры. Даме так поступать не к лицу, но куда его девать, если нужно поработать сангиной, а через минутку он понадобится снова?";
zlamausya = false;

--функцыя рэзаць для нажа, каб завастрыць зламаны аловак
before_Cut = function(s, w)
if _'alovak'.zlamausya then
_'alovak'.zlamausya = false;
pn "Быстрыми движениями лезвия Александра заточила карандаш.";
else
pn "Пока не нужно этого делать.";
end
end;

found_in = 'palica';
}:attr 'атрибут':disable()

--вокны гасцёўні
obj {
-"окна, небеса, сумерки, облака/мн|окно, небо/ср|вечер/мр";
nam = "vokny";
before_Touch2 = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "С какой стати?";
else
pn "Александра намерена разрисовать карнизы, а не окна.";
end
end;

krok = 1; -- пачатковая пераменная
bachyu = false;
description = function(s)
if _'dzen_drugi':hasnt'visited' and not s.bachyu and s.krok==1 then -- дождж сад
s.bachyu = true;
pn "За окнами уже сумерки. Как-то незаметно подкрался дождик. Видимо, облака стоят только над крышей, потому что капли сыплюстся на стёкла и сливы, а дальше видно чистое небо и луна.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu and s.krok==1 then -- дождж сад
pn "За окнами уже сумерки. Как-то незаметно подкрался дождик. Видимо, облака стоят только над крышей, потому что капли сыплюстся на стёкла и сливы, а дальше видно чистое небо и луна.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu and s.krok==2 then -- поўня і слівы
pn "Луна плывёт низко-низко, заглядывая в комнату сквозь пушистые ветви деревьев.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu and s.krok==3 then -- кроплі
pn "Капли серебрянными падучими звёздочками время от времени срываются вниз, тоненько позванивают в стёкла, топают по карнизу.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu and s.krok==4 then -- адлюстраванне
s.krok = 0; -- пераменная скідваецца і лічыльнік пачынае спачатку
pn "В окне отражаются клавиши открытого пианино и руки Казимира на них.";
elseif _'dzen_drugi':has'visited' then 
pn "Окна гостиной смотрят на запад. Там белеют сливы. Высоко-высоко над ними плывут кружевные облака.";
end
s.krok = s.krok+1
return false
end;
dsc = function(s)
p "";
return false
end;
when_open = "Одна створка окна приоткрыта и в комнату вливается волшебный запах.";
found_in = 'gascyounya';
}:attr 'static,container,openable, transparent'

--пейзаж з домам
obj {
-"картина с домом, картина/жр|дом/мр|дорожки, клумбы|мн";

['before_Push,Pull'] = function(s)
p [[Александра решила не трогать картину. За ней всё-равно ничего нет кроме стены. Пусть висит себе.]] return true end;


description = "Александра рассматривает картину. На ней выписан их с Казимиром дом. Одноэтажный, с четырёхскатной черепичной крышей, стены выкрашены в охристый цвет, сквозь зелёные заросли плюща проглядывает переплёт окна, в стёклах отражается небо.";
dsc = "Над инструментом висит картина.";
found_in = 'gascyounya_i_scyana';
}:attr 'static'

--канапа
obj {
-"диван/мр";
nam = "kanapa";
Enter = function(s,w)
pn "Александра устроилась на диване.";
move(me(), 'kanapa');
end;

before_Take = function () 
p [[Зачем это делать?]] return true end;

description = function(s)
pn "Диван изготовлен из вишнёвого дерева. Спинка выгибается полукругом. На сиденье брошено несколько вышитых подушечек для удобства."
return false
end;
found_in = 'gascyounya';
}:attr 'enterable,supporter,static,transparent'

--крэсла
obj {
-"кресло/ср";
nam = "kresla";
Enter = function(s,w)
pn "Александра уселась в кресло.";
move(me(), 'kresla');
end;

before_Take = function () 
p [[Зачем это делать?]] return true end;

description = function(s)
pn "Деревянное кресло с резной спинкой и подлокотниками."
return false
end;

dsc = function(s)
p "";
return false
end;

found_in = 'gascyounya';
}:attr 'static,enterable,supporter,transparent'

--крэслы. службовы аб'ект для адлюстравання ў пакоі
obj {
nam = "kresly";
dsc = "По сторонам столика стоят два кресла.";
found_in = 'gascyounya';
}:attr 'static'

--папараць
obj {
-"папоротник, цветок/мр|растение, растенье/жр|вайи, стебли, листья/мн";
nam = "paparac";

before_Take = function () 
p [[Зачем это делать?]] return true end;
description = "В углу гостиной стоит квадратный деревянный вазон. Целая охапка лапчатых стеблей топорщится во все стороны, плавно клонится книзу. Вайи папоротника похожи на шнурочки улетающих птиц.";
dsc = "В углу растёт папоротник.";
before_Touch = [[Зубчатые зелёные вайи чуть царапают кожу.]];

found_in = 'gascyounya_i_scyana';
}:attr 'static'

--піяніна
obj {
-"пианино, фортепиано, фортепьяно/ср|музыкальный инструмент, инструмент/мр";
nam = "piyanina";

description = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Пианино поблескивает лаком в свете луны. На нём часто музицируют, когда в гостиной устраиваются семейные концерты, собираются гости."
return false
else
pn "Лакированные панели инструмента мягко поблескивают."
return false
end
end;
dsc = function(s)
p "Пианино стоит у стены.";
return true
end;

before_Touch3 = function(s, w)
if _'dzen_drugi':hasnt'visited' 
then
pn "Казимир сейчас за инструментом. Не нужно ему мешать.";
else
pn "Александра нажала несколько нот, прислушалась к голосу пианино и решила оставить инструмент в покое.";
end
end;

before_Take = function () 
p [[Зачем это делать?]] return true end;

found_in = 'gascyounya';
}:attr 'static, open, openable, supporter'

--каманда "іграць" для піяніна
Verb {
"#Touch3",
"игра[ть|й]";
"на {noun}/пр : Touch3",
}

--столік у гасцёўні
obj {
-"журнальный столик, столик, стол/мр";
nam = "stol2";
before_Take = function () 
p [[Зачем это делать?]] return true end;

description = function(s)
pn "Низкий столик с навощёной столешницей."
return false
end;
dsc = function(s)
p "";
end;
found_in = 'gascyounya';
}:attr 'enterable,supporter,static,transparent'

--сцены гасцёўні
obj {
-"стены/мн|стена/жр";
nam = "gascyounya_i_scyana";
description = function(s)
pn "Стены гостиной выкрашены в цвет лаванды."
return false
end;
found_in = 'gascyounya';
}:attr 'enterable,supporter,static, concealed'

--шаль
obj {
-"шаль/жр";
nam = "shal";
description = "Голубая шаль из шерсти.";
init_dsc = "Через подлокотник дивана переброшена шаль.";
found_in = 'kanapa';
}:attr 'worn,clothing':disable()

game : dict {
["Александра/рд"] = "Александры";
["Александра/вн"] = "Александру";
["Александра/дт"] = "Александре";
["Александра/тв"] = "Александрой";
["Александра/пр"] = "Александре";
}

--аб'екты майстэрні
--акно
obj {
-"окно, дерево/ср|цветник/мр|липа/жр";
nam = "akno2";
before_Touch2 = [[Александра намерена разрисовать карнизы, а не окна.]];

description = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Высокое двухстворчатое окно выходит на восток. За окном темно."
return false
elseif _'dzen_drugi':has'visited' then
pn "Высокое двухстворчатое окно выходит на восток. За стёклами виден цветник и высоченное дерево."
return false
end
end;
dsc = function(s)
p "";
return false
end;

when_open = "Одна створка окна приоткрыта и в комнату вливается волшебный запах.";
found_in = 'maysternya';
}:attr 'static,container,openable, transparent'

--мальберт
obj {
-"мольберт, подрамник, холст/мр|полотно/ср";
nam = "malbert";
['before_Push,Pull'] = function(s) p [[Зачем? Александра решила не трогать мольберт.]] return true end;

before_Take = function () p [[Зачем это делать?]] return true end;

description = "Александра планирует написать вид сбоку на аллею вязов. Уже готово несколько акварельных и карандашных зарисовок на бумаге, масляные этюды, но на полотне пока нет даже наброска углём.";
dsc = "Мольберт повёрнут холстом к окну.";
found_in = 'maysternya';
}:attr 'static'

--паліцы --паліца
obj {
-"полка/жр";
nam = "palica";
before_Take = function () p [[Зачем это делать?]] return true end;

bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'arkush':enable()
_'alovak':enable()
pn "Полка для разных вещей и инструментов, нужных в работе живописца."
return false
else
pn "Полка для разных вещей и инструментов, нужных в работе живописца."
return false
end
end;

dsc = function(s)
p "На стене висит полка.";
return false
end;
found_in = 'maysternya';
}:attr 'static, supporter, container, open'

--стул у майстэрні
obj {
-"стул/мр";
nam = "stul2";
Enter = function(s,w)
pn "Александра опустилась на скрипнувший стул.";
move(me(), 'stul2');
end;

before_Take = function () p [[Александре это сейчас не нужно.]] return true end;

description = function(s)
pn "Стул с прямой спинкой. На нём можно посидеть, если ноги устали от долгой работы стоя, или на него можно положить что-нибудь, чтобы под рукой было."
return false
end;

dsc = function(s)
p "Александра видит здесь стул.";
return false
end;

found_in = 'maysternya';
}:attr 'enterable,supporter,static,transparent'

--пэндзлік
obj {
-"кисть, кисточка/жр";
nam = "pendzlik";

--для пэндзліка
abmaknuu = false;
description = function(s)
if s.abmaknuu then
p "На щетине кисти белеет краска. Можно разрисовывать карниз.";
else
p "Кисть из грубой свиной щетины. Инструмент для не слишком тонкой работы.";
end
end;

found_in = 'ecyudnik';
}

--эцюднік
obj {
-"этюдник/мр";
nam = "ecyudnik";
description = function(s)
pn "Деревянный ящик с крышкой и кожаной лямкой, перекидывающейся через плечо."
return false
end;
init_dsc = "В углу лежит этюдник.";
before_Take = function () p [[Этюдник Александре не нужен.]] return true end;
found_in = 'maysternya';
}:attr '~animate, container,openable'

--фарбы ў эцюдніку
obj {
-"краски, банки, баночки, вещи,мелочи, инструменты/мн";
nam = "farby";
bachyu = false;
description = function(s)
if not _'piyanina_i_shklo'.bachyu then
p "В этюднике можно найти всё, что только может понадобиться художнику на свежем воздухе -- стоит только хорошенько поискать.";
elseif _'piyanina_i_shklo'.bachyu and _'dzen_drugi':has'visited' and not s.bachyu then
s.bachyu = true;
p [[Александра обводит взглядом краски: "Хм, а белой осталось не так и много. На то, чтобы разрисовать карнизы не хватит, -- озабоченно хмурится, размышляя, потом лицо её светлеет. -- Знаю что делать. Семён собирался на днях освежить кое-что в саду. Надо взять краску у него, если ему без надобности! А чёрной в ящике вообще нет. Где я ей пользовалась в последний раз? Наверное, там и оставила.".]];
elseif s.bachyu then
p "В этюднике можно найти всё, что только может понадобиться художнику на свежем воздухе -- стоит только хорошенько поискать.";
end
end;

dsc = "В этюднике лежат баночки с масляными красками и разные мелочи.";

before_Take = function () p [[В этюднике нет нужных красок.]] return true end;

--функцыя абшукаць, каб можна было знайсці ў фарбах сцізорык
znayshou_scizoryk = false;
['Search,LookUnder'] = function(s)
if not s.znayshou_scizoryk then
s.znayshou_scizoryk = true;
_'noj':enable()
pn "Александра порылась в этюднике и нашла перочинный ножик."
else
pn "Ничего полезного здесь больше нет.";
end
end;

found_in = 'ecyudnik';
}:attr 'static'

--сцізорык --ножык
obj {
-"перочинный ножик, перочинный нож, перочинный, ножик, нож/мр";
nam = "noj";
description = "Ножик с пожелтевшей костяной рукояткой и острым лезвием.";
init_dsc = "Между баночек с краской лежит, поблескивает небольшой ножик.";
found_in = 'ecyudnik';
}:attr 'атрибут':disable()

--пашыраем спіс дадатковых дзеясловаў для дзеяння рэзаць
VerbExtendWord {"#Cut",
"[|на|за]остр[ить|ила|и|ю],[|за]точ[ить|ила|у|и],ре[зать|зала|жу|жь]"
}

--стос карцін
obj {
-"стопка картин, стопка/жр|картины/мн";
nam = "stos";
before_Take = function () p [[Александре это сейчас не нужно.]] return true end;

['before_Push,Pull'] = function(s)
p [[За картинами ничего нет. Пусть стоят себе.]] return true end;

description = "Готовые картины на лёгких подрамниках составлены в стопку. На них преимущественно пейзажи, окружающие усадьбу, виды городских улочек, есть несколько натюрмортов.";
dsc = "К стене прислонена стопка картин.";
found_in = 'maysternya';
}:attr 'static'

--чарнавікі
obj {
-"куча черновиков, куча/жр|черновики, наброски, рисунки, этюды, зарисовки/мн";
nam = "kupa";
before_Take = function () p [[Александре это сейчас не нужно.]] return true end;

bachyu = false;
description = function(s)
--калі гулец разглядаў фарбы ў эцюдніку і ў першы раз глядзіць на купу чарнавікоў
if _'farby'.bachyu and not s.bachyu then
s.bachyu = true;
p "Целая куча набросков, сделанных карандашом, акварельные зарисовки, небольшенькие масляные этюды на картонках. ^На самом верхнем этюде показан вид на подъездную аллею. На рисунке много зелёного и чёрного. Александра отрабатывала сочетания зелёной листвы и теней в глубине крон. Вот где, скорее всего, чёрная краска потерялась! Нужно сходить туда и поискать.";
else
p "Целая куча набросков, сделанных карандашом, акварельные зарисовки, небольшенькие масляные этюды на картонках. ^На самом верхнем этюде показан вид на подъездную аллею. На рисунке много зелёного и чёрного.";
end
end;
dsc = "На полке лежит куча черновиков и этюдов.";
found_in = 'palica';
}:attr 'static'

--сцены майстэрні і калідора
obj {
-"стены/мн";
description = "Стены выкрашены в светлые тона.";
found_in = {'maysternya', 'kalidor'};
}:attr 'scenery'

--аб'екты алеі. лакацыі сад і вязы
obj {
-"пятна света, пятна, лучи/мн";
description = "Расплывчатые желтоватые пятна света появляются и исчезают, ползают по затенённой дорожке, послушные настроению листвы, шевелящейся вверху.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"дорожка/жр|песок/мр";
description = "Дорожка аллеи посыпана крупным песком, поскрипывающим под ногами.";
Touch = "Песок влажный и зернистый.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"небо/ср";
description = "Голубое небо на секундочку проглядывает в просвете неспокойной листвы и тут же исчезает, каб з'явіцца ў іншым месцы.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"листва, тень, полутень/жр|листья, кроны,тени, ветви, сучья/мн|полумрак/мр";
description = "Вверху тянутся и переплетаются тени сучьев. Листва вязов настолько густая, что лучам трудно добраться до земли. Всё вокруг тонет в зелёном полумраке, словно на дне озера.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"лист, листок, листочек|мр";
description = "Листья зубчатые по краям.";
Touch = "Лист вяза плотный прохладный наощупь. Зубчатые края слегка царапают ладонь.";
found_in = {'sad_i_vyazy', 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"солнечный зайчик, зайчик/мр|ствол дерева, ствол/мр|кора, трещина, трещинка, щель, щёлка/жр|стволы/мн";
description = "Солнечный зайчик ползёт по стволу вниз, высвечивая каждую трещинку в серой коре.";
Touch = "Кора дерева очень жёсткая и грубая на ощупь. Солнечный зайчик мгновенно перепрыгнул на ладонь. Александра наслаждается ласковым теплом.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"трава/жр";
description = "Трава под деревьями очень высокая и густая.";
Touch = "Трава упругая и влажная на ощупь.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"вязы,деревья/мн";
description = "Эти деревья, а ещё липа-богатырь на юго-востоке, самые старые жители этой усадьбы, старше дома даже. От былого дома предков ничего не осталось, кроме каменного фундамента. Он пошёл дымом сто лет назад, когда город спалили казаки.";
found_in = {'sad_i_vyazy', 'sad_i_vyazy2'} ;
}:attr 'scenery'

--аб'екты саду. Спачатку універсальныя
--дрэвы
obj {
-"деревья/мн";
description = "Зелень по-майски яркая и свежая.";
found_in = {'sad_i_lipa', 'sad_i_altanka'};
}:attr 'scenery'

obj {
-"небо/ср|облако, облачко/ср|облака, облачка,тучки,хмуринки/мн|хмуринка/жр";
description = "Небо затянуто пеленой почти прозрачных облаков. То тут, то там сияет кусочек синевы. Солнце выглядывает на минутку и тут-же прячется. Не сказать что тепло, скорее прохладно. Поэтому лучше набросить что-нибудь на плечи, тогда совсем хорошо.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy', 'sad_i_barbarys' };
}:attr 'scenery'

--сонца
obj {
-"солнце, солнышко, светило/ср";
description = "Солнце почти всегда прячется за высокими кружевными облаками.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy', 'sad_i_barbarys' };
}:attr 'scenery'

obj {
-"земля, почва/жр|дол/мр";
description = "Земля сероватая, тёмная от влаги.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy', 'sad_i_barbarys' };
}:attr 'scenery'

obj {
-"дёрн, мурог/мр|трава/жр";
description = "Трава аккуратно подкошена. Зелень выглядит свежо и радует взгляд.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

--дом знадворку
obj {
-"дом/мр|усадьба/жр|строение/ср";
nam = "dom";
description = function(s)
pn "Одноэтажный дом с черепичной крышей. Обшитые планками стены заросли плющом. В оконных стёклах отражается небо."
return false
end;
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'enterable,supporter,static, concealed'

obj {
-"крыша дома, крыша/жр";
description = "Покатая четырёхскатная крыша покрыта тёмно-красной черепицей.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"черепица, глина/жр";
description = "У черепицы замечательный тёмно-красный цвет, который очень хорошо смотрится на фоне неба.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"трубы/мн|труба/жр";
description = "Из крыши торчат четыре трубы.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"стены, планки/мн";
description = "Стены дома обшиты деревянными планками, выкрашенными в охристый цвет.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"плюшч/мр|";
description = "Зелёные сердечки листьев плюща шевелятся под ветром.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"окно/ср|рама/жр|переплёт/мр";
description = "Окно взято в прямоугольный двухстворчатый переплёт на шесть стёкол.";
before_Touch2 = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "С какой стати?";
else
pn "Александра намерена разрисовать карнизы, а не окна.";
end
end;

found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"оконные стёкла, стёкла/мн|стекло/ср";
description = "В стёклах отражаются облака и совсем немного чистой синевы.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

--карніз знадворку
obj {
-"карниз,подоконник/мр|жесть/жр";
nam = "karniz2";
before_Take = function () p [[Зачем это делать?]] return true end;

bachyu = false;
description = function(s)
if _'razmalyavala_karniz':has'visited' and not s.bachyu then
s.bachyu = true;
p "Карниз нахально скалится белозубой улыбкой, из конца в конец разрисованный под белые клавиши, между которыми чернеют полутона: Он так и просит, чтобы по этим пальцам побарабанили пальцы. Сразу видно, что это -- дом композитора. У которого даже дождь не просто так стучит, а музыку играет.";
elseif _'razmalyavala_karniz':has'visited' and s.bachyu then
p "Карниз из конца в конец разрисован под белые клавиши, между которыми чернеют полутона.";
else
p "Жестяной карниз выкрашен неброской серой краской, чтобы его не ела ржавчина.";
end
end;

dsc = "Александра видит здесь карниз.";
nanyos_beluyu = false;
Touch2 = function(s, t)
if not have ('pendzlik') or not have ('belaya') or not have ('chornaya') then
pn "Для работы нужна кисть, а так же белая и чёрная краски.";
elseif not _'pendzlik'.abmaknuu then
pn "Сначала нужно обмакнуть кисть в краску.";
elseif _'pendzlik'.abmaknuu and not s.nanyos_beluyu then
s.nanyos_beluyu = true
walk 'razmalyavala_karniz'
end
end;

found_in = {'dom' };
}:attr 'static'

obj {
-"аллея/жр|вязы/мн";
description = "Два ряда деревьев уходят на север, постепенно уменьшаясь. Александра много раз рисовала их. На вязах аллеи хорошо практиковаться в рисовании перспективы.";
found_in = { 'sad_i_lipa', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"беседка, постройка/жр";
description = "На юг отсюда, и немного правей -- диковатые кусты сирени, за которыми белеет стройная беседка.";
found_in = { 'sad_i_lipa' };
}:attr 'scenery'

--ліпа ў кветніку
obj {
-"липа, крона/жр|ствол/мр|дерево/ср";
nam = "lipa";
before_Take = function () p [[Зачем это делать?]] return true end;

dsc = "Липа заслоняет половину неба.";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
pn "Обычно липы не такие, а эта - просто царь-дерево. Крона большая и пышная, как зелёное облако. От самой земли ствол разделяется на шесть стволов, которые постепенно расходятся во все стороны. Отец говорил, что эту липу посадили ещё при его прадеде."
return false
else
pn "Крона липы большая и пышная, как зелёное облако. От самой земли ствол разделяется на шесть стволов, которые постепенно расходятся во все стороны."
return false
end
end;
found_in = { 'sad_i_lipa' };
}:attr 'enterable,supporter,static'

--лавачка пад ліпай
obj {
-"лавочка,лавка,скамья,скамейка/жр";
nam = "lavachka2";
Enter = function(s,w)
pn "Александра откинулась на спинку лавочки и удовлетворённо выдохнула.";
move(me(), 'lavachka2');
end;

before_Take = function () p [[Зачем это делать?]] return true end;

bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'gazeta':enable()
p "Зелёная лавочка прислоняется спинкой к стволу липы."
return false
else
p "Зелёная лавочка прислоняется спинкой к стволу липы."
return false
end
end;
dsc = "За липой притулилась лавочка.";
before_Touch = [[Краска на лавочке давно не подновлялась, понемногу осыпается уже.]];
found_in = 'sad_i_lipa';
}:attr 'enterable,supporter,static'

obj {
-"дорожки, тропки, тропинки/мн";
description = "Серые узенькие ленточки вытоптанной земли затейливо вьются между клумбами туда-сюда. По ним можно блуждать часами, когда мысли накатывают.";
found_in = { 'sad_i_lipa' };
}:attr 'scenery'

obj {
-"клумбы, цветы, розы, ирисы, ромашки/мн";
description = "Тут кусты роз пылают алым, там -- густо-лиловые ирисы, словно вечернее небо оставило платок. А вон мило белеет делянка садовых ромашек. Тонкие лепестки трепещут под ласковым ветерком.";
found_in = { 'sad_i_lipa' };
}:attr 'scenery'

--аб'екты сад і вязы
--пах фарбы ў лакацыі. службовы аб'ект
obj {
nam = "pah";
deskripshen = "Пахнет свежей краской.";
dsc = "Пахнет свежей краской.";
found_in = 'sad_i_vyazy';
}:attr 'атрибут'

--лавачка каля веранды
obj {
-"лавочка,лавка,скамья,скамейка/жр";
nam = "lavachka";
before_Enter = function () p [[Э нет, лавочка недавно выкрашена!]] return true end;

before_Take = function () p [[Зачем это делать?]] return true end;

bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'pah':disable()
p "Деревянная лавочка со спинкой, выкрашенная в белый цвет. На ней так замечательно читать Гёте!"
return false
else
p "Деревянная лавочка со спинкой, выкрашенная в белый цвет. На ней так замечательно читать Гёте!"
return false
end
end;

before_Touch = [[Липковатая на ощупь. Краска ещё не подсохла как следует.]];
found_in = 'sad_i_vyazy';
}:attr 'enterable,supporter,static,transparent'

--веранда. --двое аднабаковых дзвярэй, каб зладзіць веранду
door {
-"веранда, терраса/жр|вход/мр|входная дверь, дверь/жр|крыльцо/ср";
nam = "veranda";
description = "Вход в дом устроили в виде застеклённой веранды. Она тянется вдоль всей северной стены. Там, внутри, есть даже небольшой камин. Так чудесно в холодную порузажечь в нём огонь и посматривать из тепла на аллею, занимаясь вышивкой или рисованием, или просто чаёк с Казимиром пить.";
found_in = 'sad_i_vyazy';
door_to = function(s)
if here() ^ "sad_i_vyazy" and not have ('shal') then
pn "Поставив ногу на ступеньку, Александра вспомнила, что оставила в саду шаль. Не нужно оставлять любимую вещь лишь бы где: наберётся влаги -- надо забрать с собой.";
elseif here() ^ "sad_i_vyazy" and have ('shal') then
walk 'kalidor'
pn "Александра поднялась по ступеням, прошла сквозь веранду и зашла в дом.";
end
end;

}:attr 'static, open, concealed';

--выхад з дому
door {
-"выход на веранду, выход/мр|дверь на веранду, дверь веранды, застеклённая дверь, застеклённая, дверь, веранда/жр";
nam = "veranda2";
description = "Сквозь матовые стёклышки, вставленные в дверь, просматривается веранда.";
found_in = 'kalidor';
door_to = function(s)
if here() ^ "kalidor" and _'dzen_drugi':hasnt'visited' then
pn "Александре не хочется выходить из дома. Лучше побыть в гостиной вместе с мужем и дождём за окном.";
elseif here() ^ "kalidor" and _'dzen_drugi':has'visited' and not have ('shal') then
pn "После ночного дождя в саду слишком свежо. Нужно накинуть шаль.";
elseif here() ^ "kalidor" and _'dzen_drugi':has'visited' and have ('shal') then
pn "Пройдя сквозь веранду, Александра сбежала по ступеням и очутилась на улице.";
walk 'sad_i_vyazy'
end
end;

}:attr 'static, open, concealed';

--аб'екты Сад і альтанка
--альтанка. уяўляе сабой комплекс аб'ектаў. дзверы для ўваходу ў лакацыю "у альтанцы". сама лакацыя "у альтанцы і выхад з яе назад у лакацыю "сад і альтанка"". 
-- а таксама група аб'ектаў, якія апісваюць яе часткі
--спачатку аб'ект-уваход для саду, каб прайсці ў альтанцы
door {
-"беседка, постройка/жр";
nam = "altanka";
before_Take = function () p [[Зачем это делать?]] return true end;

description = "Шатровая крыша беседки опирается на шесть деревянных столбов, соединённых балюстрадой. ^Вход в беседку на востоке.";
dsc = "Ажурная белая постройка прячется среди кустов сирени.";
found_in = 'sad_i_altanka';

door_to = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
pn "Александра переступает через порожец и входит в беседку. ^Ветка с шелестом вернулась на место.";
walk 'u_altancy'
else
pn "Ветка сирени мешает пройти.";
end
end;

}:attr 'static, open, openable';

--аб'ект-выхад для локі "у альтанцы", каб трапіць вонкі ў локу "сад і альтанка"
door {
-"выхад/мр";
nam = "altanka2";
before_Take = function () p [[Зачем это делать?]] return true end;

description = "Выход из беседки на западе.";
found_in = 'u_altancy';

door_to = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
pn "Александра выходит наружу. ^Ветка с шелестом вернулась на место.";
_'player':move'sad_i_altanka'
else
pn "Ветка сирени мешает пройти.";
end
end;

}:attr 'static, open, concealed';

--кусты бэзу. --бэз
obj {
-"кусты сирени, кусты, заросли/мн|сирень/жр|проход, вход/мр";
nam = "bez";
before_Take = function () p [[Зачем это делать?]] return true end;

description = function(s)
pn "Высокие кусты сирени обступают беседку со всех сторон. В мае, когда на ветвях полно лиловых соцветий от аромата кружится голова: дышать не надышаться. В одном месте кусты расступаются, создавая неширокий проход, позволяющий пробраться внутрь беседки. Александра наказала Семёну, чтобы он не слишком увлекался тут с ножницами, поэтому кусты выглядят диковато, сущие заросли."
return false
end;
dsc = function(s)
p "";
return false
end;
found_in = { 'sad_i_altanka', 'u_altancy' };
}:attr 'static, transparent, supporter, container, open'

--галінка бэзу
obj {
-"ветка сирени, ветка, ветвь/жр";
nam = "galinka";
before_Take = function () p [[Зачем это делать?]] return true end;
before_Touch = [[Александра трогает ветку. Листья сирени глянцевитые и приятно-прохладные.]];
description = "Ветка сирени не позволяет войти в беседку.";
dsc = "Ветка наклонилась, загораживая проход.";

adsunuu = false;
['before_Push,Pull'] = function(s)
if not s.adsunuu then
s.adsunuu = true;
p "Александра отодвинула ветку в сторону, чтобы освободить путь.";
else
s.adsunuu = false;
p "Ветка снова свесилась поперёк прохода.";
end
end;

found_in = {'sad_i_altanka', 'u_altancy'};
}:attr 'static'

--дах і слупы альтанкі
obj {
-"крыша беседки, крыша/жр";
description = "Гонтовая крыша беседки опирается на шесть деревянных столбов.";
found_in = 'sad_i_altanka';
}:attr 'scenery'

--слупы альтанкі
obj {
-"столбы/мн";
nam = "slupy";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'pah2':disable()
p [[Столбы беседки выкрашены в белый цвет. Их соединяет резная балюстрада высотой по-пояс.]];
else
p [[Столбы беседки выкрашены в белый цвет. Их соединяет резная балюстрада высотой по-пояс.]];
end
end;
before_Touch = [[Столбы ещё липкие. Краска свежая.]];
found_in = {'sad_i_altanka', 'u_altancy'} ;
}:attr 'scenery'

--балюстрада альтанкі
obj {
-"балюстрада/жр|поручни/мн";
description = "Резная балюстрада окружает беседку. Сквозь фигурные столбики то там, то здесь заглядывают внутрь ветки сирени.";
found_in = 'sad_i_altanka';
}:attr 'scenery'

--аб'екты у альтанцы
--пах фарбы ў лакацыі. службовы аб'ект
obj {
nam = "pah2";
dsc = "Пахнет свежей краской.";
found_in = 'u_altancy';
}:attr 'static'

--стол у альтанцы
obj {
-"стол/мр";
nam = "stol3";
before_Take = function () p [[Зачем это делать?]] return true end;

description = function(s)
pn "Шестиугольная столешница опирается на одну толстую ногу, вкопанную в землю."
return false
end;

found_in = 'u_altancy';
}:attr 'static, transparent, supporter, container, open'

--лавачкі ў альтанцы
obj {
-"лавочки,лавки,скамьи,скамейки/мн|лавочка,лавка,скамья,скамейка/жр";
nam = "lavachki";
before_Enter = function () p [[Но лавочки недавно выкрашены. Краска совсем свежая.]] return true end;

before_Take = function () p [[Зачем это делать?]] return true end;

bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'pah2':disable()
p "Пять лавочек окружают стол. Только со стороны входа свободно. Вместо спинок -- резная балюстрада."
return false
else
p "Пять лавочек окружают стол. Только со стороны входа свободно. Вместо спинок -- резная балюстрада."
return false
end
end;

before_Touch = [[Лавочки ещё липкие. Краска свежая.]];
found_in = 'u_altancy';
}:attr 'enterable,supporter,static,transparent'

--белая фарба
obj {
-"белая краска, белая, краска, банка/жр";
nam = "belaya";
description = "В банке достаточно много белой масляной краски.";
init_dsc = "Банка, выпачканая в белую краску, стоит под лавочкой.";
found_in = 'u_altancy';

--функцыя дазваляе абмакнуць пэндзлік у белую фарбу. Усё астатняе абмакваць забараняе
after_Receive = function(s, w)
if not _'pendzlik'.abmaknuu and w ^ "pendzlik" then
_'pendzlik':move'player'
_'pendzlik'.abmaknuu = true
pn "Александра обмакнула кисть в белую краску.";
elseif s.abmaknuu and w ^ "pendzlik" then
pn "Не нужно -- белая краска на кисти и так есть.";
elseif not w ^ "pendzlik" then
 return "Не нужно совать в краску что попало!", true
 end
end

}:attr '~animate, open, container, transparent'

--аб'екты лакацыі "Сад і слівы"
--слівы
obj {
-"сливы, деревья, деревца, ветви, ветки, веточки/мн";
nam = "slivy";
before_Take = function () p [[Зачем это делать?]] return true end;

description = "Деревья купаются в белых цветах. В августе их ветви будут синими от богатого урожая.";
found_in = 'sad_i_slivy';
}:attr 'scenery'

--галінка слівы
obj {
-"ветка сливы, ветка, ветвь, веточка/жр";
nam = "galinka2";
before_Take = function () p [[Зачем это делать?]] return true end;

description = function(s)
pn "На безлистой по этому времени ветке полным полно белых пушистых соцветий."
return false
end;

dsc = function(s)
p "";
return false
end;

found_in = 'sad_i_slivy';
}:attr 'enterable,supporter,static,transparent'

--квецень сліў
obj {
-"цветы слив, цветы, цветочки, соцветия/мн";
description = "Белые лепестки цветов шевелятся под ветром. .";
found_in = 'sad_i_slivy';
}:attr 'scenery'

--алея
obj {
-"аллея вязов, аллея/жр|вязы/мн";
description = "Отсюда видно, как на север от дома тянутся два ряда старых деревьев. Чтобы попасть туда, нужно пройти на северо-восток.";
found_in = 'sad_i_slivy';
}:attr 'scenery'

--бэз у слівовым садзе
obj {
-"заросли сирени, заросли, кусты/мн|кустарник/мр|сирень/жр";
description = "На юго-востоке видны густые заросли сирени, над которыми выглядывает покатая крыша беседки.";
found_in = 'sad_i_slivy';
}:attr 'scenery'

--аб'екты лужок каля алеі
--барбарыс
obj {
-"куст, барбарис/мр|ветки, ветви, веточки, листья/мн";
nam = "barbarys";
before_Take = function () p [[Зачем это делать?]] return true end;

bachyu = false;
description = function(s)
if _'kupa'.bachyu then
pn "Куст с листьями красивого бардового цвета растёт посреди лужайки. Это барбарис. Александре очень нравится, как он пахнет. Может, чёрная краска потерялась где-то здесь?"
else
pn "Куст с листьями красивого бардового цвета растёт посреди лужайки. Это барбарис. Александре очень нравится, как он пахнет."
end
end;

--функцыя абшукаць, каб можна было знайсці чорную фарбу пад кустом
znayshou_chornuyu = false;
['Search,LookUnder'] = function(s)
if _'kupa'.bachyu then
s.znayshou_chornuyu = true;
_'chornaya':enable()
pn "Александра обошла куст кругом, внимательно присматриваясь, и нашла пропажу."
else
pn "Александра заглянула под нижние ветви куста, но ничего особенного там не заметила.";
end
end;

found_in = 'sad_i_barbarys';
}:attr 'static'

--разнатраўе на лужку
obj {
-"разнотравье/ср|трава/жр|травы, цветы/мн";
nam = "raznatraue";
before_Take = function () p [[Зачем это делать?]] return true end;

description = "Траву на этом лужке не трогает коса и поэтому головки неброских цветов качаются чуть ли не у самых колен.";
dsc = "Травы качаются под ветром.";
found_in = 'sad_i_barbarys';
}:attr 'static'

--алея
obj {
-"аллея/жр|вязы, деревья/мн";
description = "Строй старых вязов тянется на востоке. Пробравшись между стволами, можно попасть на дорожку аллеи.";
found_in = 'sad_i_barbarys';
}:attr 'scenery'

--чорная фарба
obj {
-"чёрная краска, чёрная, краска, баночка чёрной краски, баночка чёрной, баночка краски, баночка/жр";
nam = "chornaya";
description = "Небольшая керамическая посудинка с чёрной масляной краской.";
init_dsc = "Баночка чёрной краски стоит под ветвями барбариса.";

--функцыя дазваляе паспрабаваць абмакнуць пэндзлік у чорную фарбу. Усё астатняе абмакваць забараняе
after_Receive = function(s, w)
if w ^ "pendzlik" then
_'pendzlik':move'player'
pn "Нет-нет, сначала нужно раскрасить карниз в белый цвет! ";
elseif not w ^ "pendzlik" then
 return "Не нужно совать в краску что попало!", true
 end
end;

found_in = 'sad_i_barbarys';
}:attr '~animate, open, container, transparent':disable()

--каманда пісаць распісаць, размаляваць для аркуша і карніза
Verb {
"#Touch2",
"[|на|за|рас]пи[сать|сала|шет|сывает|шем],[|раз|за|под]рис[овать|овала|овывать|овывает|ует|уем],[|за|по|под]кра[сить|сила|шивает|шивай|сь]";
"по {noun}/пр : Touch2",
"на {noun}/пр : Touch2",
" {noun}/вн : Touch2",
}

--катсцэна пасля разглядвання адбітку клавіятуры. Надыходзіць новы дзень. --дзень другі
cutscene {
nam = 'dzen_drugi',
title = "День второй";
text = {
[[]];
[[Честно сказать, Александра едва дождалась следующего дня. Крутилась под одеялом пол-ночи, воображая, как будет выглядеть дом снаружи и внутри с карнизами, расписанными под фортепианную клавиатуру, и ей всё больше и больше казалось, что это будет просто сказочно, хотелось подпрыгнуть и бежать за красками просто сейчас-же, но ночь тянулась и тянулась. Незаметно Александра заснула…]];
[[И вот он -- долгожданный день! После завтрака Казимир закрылся в кабинете и там то говорит, то замолкает рояль муж занялся творчеством. Время и Александре браться за краски. Пальцы аж чешутся от нетерпения..]];
};
exit = function(s, t)
walk 'maysternya'
_'kazimir':move'zedlik'
_'arkush':move'stol2'
_'gascyounya_i_pounya':disable()
_'gascyounya_i_pounya2':disable()
_'gascyounya_i_kropli':disable()
_'gascyounya_i_kropli2':disable()
_'piyanina_i_shklo':disable()
_'kalidor_i_rayal':enable()
_'shal':enable()
DaemonStart('maysternya') -- пачынае працаваць дэман, які дае гульцу падказку ў другі дзень
end;
}

--катсцэна пасля таго, як гулец пачне размалёўваць карніз
cutscene {
nam = 'razmalyavala_karniz',
title = "";
text = {
[[Александра замурлыкала под нос песенку. Кисть начала гулять по карнизу. И вот вся поверхность белеет свежей краской.]];
[[Кисть нырнула в чёрную краску и начала аккуратно выписывать чёрные клавиши и щели между белыми.]];
[[Закончив работу над карнизом, Александра перешла к следующему, потом к ещё одному Остановилась только тогда, когда все карнизы дома весело оскалились пианинными клавишами. ^Художница направилась в дом и довольно вздохнула: "Ну вот, а теперь можно вернуться в гостиную и закончить стихотворение. Теперь это можно сделать."]];
};
exit = function(s, t)
walk 'gascyounya'
_'kazimir':move'zedlik'
_'karniz1'.bachyu = false;
DaemonStart('gascyounya') -- дэман падказвае дапісаць верш
end;
}

--катсцэна пасля таго, як гулец аддасць аркуш казіміру
cutscene {
nam = 'dzen_treci',
title = "Новый вечер и новый дождь";
text = {
[[]];
[[А в следующий вечер снова был дождь: краска как раз успела хорошо просохнуть. Александра и Казимир сидели рядышком, пили чай и молча наблюдали, как капли азартно молотят по нарисованным клавишам. Казимир не отрывал глаз от карниза, иной раз улыбался, наверное, слышал в мыслях свою музыку.]];
};
exit = function(s, t)
walk 'kanec'
end;
}

room {
nam = "kanec";
title = "КОНЕЦ";
dsc = [[Поздравляю! Вы прошли игру. ^^Во время написания игры я часто улыбался. Черты неуёмной героини я во многом списал с характера моей любимой. ^Спасибо Петру Косых за замечательный бета-тестинг! Благодаря его замечаниям и предложениям игра стала лучше.^Гомель. Декабрь 2025 года.]];
noparser = true; -- цалкам адключаем увод каманд
}

game : dict {
["Казимир/рд"] = "Казимира";
["Казимир/вн"] = "Казимира";
["Казимир/дт"] = "Казимиру";
["Казимир/тв"] = "Казимиром";
["Казимир/пр"] = "Казимире";
}


game : dict {
["карниз/рд"] = "карниза";
["карниз/вн"] = "карниз";
["карниз/дт"] = "карнизу";
["карниз/тв"] = "карнизом";
["карниз/пр"] = "карнизе";
}

game : dict {
["газета/рд"] = "газеты";
["газета/вн"] = "газету";
["газета/дт"] = "газете";
["газета/тв"] = "газетой";
["газета/пр"] = "газете";
}

