--$Name: Дождж месяцовы ізноў завітаў у мой сад…$
--$Version: 1.3$
--$Author: Uladzimir$
--$Info: Сапраўдны творца ў парыве натхнення здольны на неверагодныя рэчы$

--Абавязковая ініцыялізацыя неабходных модуляў
require "parser/mp-be"
require "fmt"
fmt.dash = true
fmt.quotes = true

function init()
move(pl, 'intro')
pl.description = "Аляксандры трыццаць гадоў. Яна гаспадыня сядзібы з домам і садам, каханне і натхненне мужа-кампазітара і, самае найгалоўнае, мастачка. Яна, кажуць, нарадзілася з пэндзлікам у руках. Напэўна не маняць. У яе светлыя валасы, якія да таго ж выгараюць на сонцы падчас пастаянных эцюдаў на свежым паветры. На гожых шчоках раз-пораз гасцююць пісягі фарбы, то зялёнай, то блакітнай. Муж кажа, што гэта ёй вельмі пасуе. І лісточкі ліпы ў кудзерках -- таксама."
pl.word = -"Аляксандра/жр,3л,нст"

end

--пакой для прайгравання стартавага інтра
room {
nam = "start";
title = "Вечар і дождж";
before_Look = function() move (pl, "intro") end;
}

--аб'ект-катсцэна з уступам
cutscene {
nam = 'intro',
--блок title = "Вечер и дождь";
title = "";
text = {
[[Ад аўтара ^Асаблівасці гэтай гульні: пры першым наведванні любога пакоя вам паказваецца яго доўгае апісанне. Пры наступных наведваннях вы будзеце бачыць толькі кароткія апісанні. Каб яшчэ раз прачытаць поўнае апісанне пакоя, напрыклад гасцёўні ці пляцоўкі перад верандай, вам трэба, знаходзячыся ў пакоі, набраць каманду: "агледзець гасцёўню" альбо проста "гасцёўня" і "агледзець пляцоўку" альбо проста "пляцоўка". У астатніх месцах логіка такая ж. Звярніце ўвагу на загаловак пакоя і падбярыце прыдатнае слова. ^Поспехаў вам!]];
[[Ціхі сямейны адвячорак. Аляксандра сядзіць у крэсле, слухае дождж. Муж сядзіць ля піяніна, мроіць пра нешта. Пальцы задуменна гуляюць па клавішах. Так добра проста быць побач і пазіраць у акно.]];
[[Вочы маладой жанчыны вывучаюць зааконны краявід. У душы асцярожнай рыбкай плавае нейкая няпэўная ідэя, але не атрымліваецца яе злавіць. Варухнецца, мільгне на ўскрайку думкі і зноў схаваецца. Застаецца замерці і пазіраць, быць уважлівай. Можа так атрымаецца зразумець -- што гэта: тэма для новай карціны, ці, можа, для новага верша? І ў чым яе сутнасць? ]];
};
next_to = 'kresla';
}
--пакой з інтра скончаны

--лакацыі дома
--кабінет 
room {
nam = "kabinet";
title = "Кабінет";
init_dsc = "Сцены гэтага пакоя часта поўняцца гукамі раяля. Адсюль кампазітар выпраўляецца ў свае музычныя палёты. На поўначы дзверы ў калідор.";
dsc = "На поўначы дзверы ў калідор.";
n_to = 'kalidor';
}

--аб'ект для доўгага апісання пакоя
obj {
-"кабінет,пакой/мр|памяшканне/ср";
description = "Сцены гэтага пакоя часта поўняцца гукамі раяля. Адсюль кампазітар выпраўляецца ў свае музычныя палёты.";
found_in = 'kabinet';
}:attr 'scenery'

--калідор
room {
nam = "kalidor";
title = "Калідор";
init_dsc = "Калідор цягнецца з поўначы на поўдзень. У дзённую пару крыху святла трапляе з поўначы, праз зашклёныя дзверы веранды, а таксама праз арачны ўваход у гасцёўню на захадзе. На ўсходзе дзверы майстэрні. З поўдня калідор замыкаюць глухія дзверы ў Казіміраў кабінет.";
dsc = "Калідор цягнецца з поўначы на поўдзень. На поўдні дзверы ў кабінет, на захадзе арачны праход у гасцёўню, на ўсходзе дзверы майстэрні, на поўначы выхад на веранду.";
s_to = 'u_kabinet';
e_to = 'maysternya';
w_to = 'gascyounya';
n_to = 'veranda2';

--робім функцыю, каб гулец мог выйсці камандай "вонкі"
out_to = function(s)
if here() ^ "kalidor" and _'dzen_drugi':hasnt'visited' then
pn "Аляксандры не хочацца выходзіць з дому. Лепей пабыць у гасцёўні разам з мужам і дажджом у акне.";
elseif here() ^ "kalidor" and _'dzen_drugi':has'visited' and not have ('shal') then
pn "Пасля начнога дажджу ў садзе занадта свежа. Трэба накінуць шаль.";
elseif here() ^ "kalidor" and _'dzen_drugi':has'visited' and have ('shal') then
pn "Прайшоўшы скрозь веранду, Аляксандра збегла з прыступак і апынулася на вуліцы.";
walk 'sad_i_vyazy'
end
end;

}

--аб'ект для доўгага апісання пакоя
obj {
-"калідор/мр";
description = "Калідор цягнецца з поўначы на поўдзень. У дзённую пару крыху святла трапляе з поўначы, праз зашклёныя дзверы веранды, а таксама праз арачны ўваход у гасцёўню на захадзе. На ўсходзе дзверы майстэрні. З поўдня калідор замыкаюць глухія дзверы ў Казіміраў кабінет.";
found_in = 'kalidor';
}:attr 'scenery'

--праход у кабінет. каб забараніць гульцу заходзіць у другі дзень
door {
nam = "u_kabinet";
found_in = 'kalidor';
door_to = function(s)
if _'dzen_drugi':has'visited' and not _'arkush'.fragment5 then
pn "Казімір працуе. За дзвярамі не змаўкае раяль. Не трэба замінаць.";
else
walk 'kabinet'
end
end;
}:attr 'static, open, concealed';

--гасцёўня
room {
nam = "gascyounya";
title = "Гасцёўня";

before_Listen = function(s, w)
if _'dzen_drugi':hasnt'visited' and 
w ^ 'piyanina' then
pn "Аляксандра ўслухоўваецца ў прахалодныя гукі піяніна.";
else
pn "Піяніна маўчыць.";
end
end;

padkazka2 = false;
--дэман у гасцёўні, які ў залежнасці ад ужо пабачаных аб'ектаў запускае жаданне пісаць
daemon = function(s)
--пяты крок. скончылі верш. Казімір папрасіў прачытаць
if here() ^ "gascyounya" and _'arkush'.fragment5 then
pn "Трэба даць аркушык Казіміру. Што ён скажа?";
end
--чацвёрты крок. Пасля размалёўвання карнізаў гульня падказвае дапісаць верш
if _'razmalyavala_karniz':has'visited' and not s.padkazka2 then
s.padkazka2 = true;
p [["Цяпер можна і дапісаць верш…"]]
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
end
--трэці крок. бачым кроплі, карніз і шкло
if here() ^ "gascyounya" and 
(_'karniz1'.bachyu or _'gascyounya_i_kropli'.bachyu or _'gascyounya_i_shklo'.bachyu) 
and not _'arkush'.fragment3 
then
_'nathnenne'.pisham3 = true;
pn "Аляксандра задуменна кусае губу і ківае сваім думкам. Гэта трэба запісаць.";
end
--другі крок. бачым поўню і голле
if here() ^ "gascyounya" and 
(_'gascyounya_i_pounya'.bachyu or _'gascyounya_i_golle'.bachyu)
and not _'arkush'.fragment2 
then
_'nathnenne'.pisham2 = true;
pn "Аляксандра задаволена ўсміхаецца. Ёй падабаецца ідэя, што прыйшла ў галаву. Трэба запісаць.";
end
--першы крок. бачым дождж і сад. без прыладаў
if here() ^ "gascyounya" and 
(_'gascyounya_i_dojdj'.bachyu or _'gascyounya_i_sad'.bachyu)
and not _'arkush'.fragment1 
then
_'nathnenne'.pisham1 = true;
pn "Аляксандра адчувае ў душы знаёмы павеў нетутэйшага ветру: радкі просяцца на паперу. Трэба хутчэй знайсці чысты аркуш і аловак.";
end
end;

init_dsc = "Вялікая квадратная зала з двума вокнамі, што выходзяць на захад. Выхад у калідор на ўсходзе.";
dsc = "Выхад у калідор на ўсходзе.";
e_to = 'u_kalidor';
}

--аб'ект для доўгага апісання пакоя
obj {
-"гасцёўня,зала/жр|памяшканне/ср";
description = "Вялікая квадратная зала з двума вокнамі, што выходзяць на захад.";
found_in = 'gascyounya';
}:attr 'scenery'

--праход у у калідор, каб забараніць гульцу выхад пасля таго, як ён размалюе карнізы
door {
nam = "u_kalidor";
found_in = 'gascyounya';
door_to = function(s)
if _'arkush'.fragment5 then
pn "Аляксандры зусім не хочацца пакідаць гасцёўню.";
elseif _'razmalyavala_karniz':has'visited' 
and have ('gazeta') 
then
pn "Не-не, трэба дапісаць верш.";
else
walk 'kalidor'
end
end;
}:attr 'static, open, concealed';

--майстэрня
room {
nam = "maysternya";
title = "Майстэрня";
init_dsc = "Светлае памяшканне. З першага позірку зразумела, што тут -- уладарства мастака. Выхад на захадзе.";
dsc = "Светлы пакой. Выхад на захадзе.";
w_to = 'kalidor';

padkazka = false;
--дэман у майстэрні. --дэман і майстэрня
daemon = function(s)
--задаем задачу гульцу у пачатку другога дня
if here() ^ "maysternya" and not s.padkazka then
s.padkazka = true;
pn [["Трэба ўзяць у эцюдніку белую і чорную фарбы і выпраўляцца на двор -- карнізы чакаюць не дачакаюцца."]];
DaemonStop('maysternya') -- падказку зрабілі, спыняем дэмана
end
end;
}

--аб'ект для доўгага апісання пакоя
obj {
-"майстэрня/жр|,пакой/мр|памяшканне/ср";
description = "Прасторнае ўтульнае памяшканне са сценамі, пафарбаванымі ў светлы колер.";
found_in = 'maysternya';
}:attr 'scenery'

--лакацыі саду
--сад і ліпа
room {
nam = "sad_i_lipa";
title = "Кветнік пад ліпай";
init_dsc = "Адкрыты і малўнічы ўчастак саду. Ва ўсе бакі разбягаюцца вузенькія дарожкі, паабапал якіх стракацяць рознымі колерамі клумбы, зелянее роўна пакошаны мурог. ^Алея старых дрэў на паўночным захадзе адсюль; на паўднёвым захадзе з-за кустоў выглядвае лёгкая пабудова.";
dsc = "Алея старых дрэў на паўночным захадзе адсюль; на паўднёвым захадзе з-за кустоў выглядвае лёгкая пабудова.";
nw_to = 'sad_i_vyazy';
sw_to = 'sad_i_altanka';
}

--аб'ект для доўгага апісання пакоя
obj {
-"кветнік, сад/мр";
description = "Адкрыты і малўнічы ўчастак саду. Ва ўсе бакі разбягаюцца вузенькія дарожкі, паабапал якіх стракацяць рознымі колерамі клумбы, зелянее роўна пакошаны мурог.";
found_in = 'sad_i_lipa';
}:attr 'scenery'

--сад і альтанка
room {
nam = "sad_i_altanka";
title = "Закуток каля альтанкі";
init_dsc = "Тут, у паўднёвым куце сада, самае зацішнае месца. ^ На паўночным усходзе ліпа, на паўночным захадзе слівовы сад.";
dsc = "На паўночным усходзе кветнік і ліпа, на паўночным захадзе слівовы сад.";
ne_to = 'sad_i_lipa';
nw_to = 'sad_i_slivy';
e_to = 'altanka';

--робім функцыю, каб гулец мог увайсці ў альтанку, калі галінка адсунутая
Enter = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
_'player':move'altanka'
pn "Аляксандра пераступае праз парожак і заходзіць у альтанку. ^Галінка з шолахам вярнулася на месца.";
else
pn "Галінка бэзу замінае прайсці.";
end
end;

--робім функцыю, каб гулец мог увайсці ўнутр
in_to = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
_'player':move'u_altancy'
pn "Аляксандра пераступае праз парожак і заходзіць у альтанку. ^Галінка з шолахам вярнулася на месца.";
else
pn "Галінка бэзу замінае прайсці.";
end
end;

}

--аб'ект для доўгага апісання пакоя
obj {
-"закуток, сад/мр";
description = "Тут, у паўднёвым куце сада, самае зацішнае месца.";
found_in = 'sad_i_altanka';
}:attr 'scenery'

--у альтанцы
room {
nam = "u_altancy";
title = "У альтанцы";
init_dsc = "Надзвычай утульнае месцейка, асабліва, калі па лісці кустоў шапоча дождж, а тут, пад пакатым дахам альтанкі зацішна і суха, толькі пахкі ветрык павявае. ^ На захадзе выхад.";
dsc = "Выхад на захадзе.";
w_to = 'altanka2';

before_Smell = function(s, w)
if w ^ 'slupy' then
_'pah2':disable()
pn "Ад слупоў альтанкі пахне свежай фарбай.";
else
pn "Пахне свежай фарбай.";
end
end;

--робім функцыю, каб гулец мог выйсці з альтанкі
Exit = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
_'player':move'sad_i_altanka'
pn "Аляксандра выходзіць вонкі. ^Галінка з шолахам вярнулася на месца.";
else
pn "Галінка бэзу замінае выйсці.";
end
end;

--робім функцыю, каб гулец мог выйсці камандай "вонкі"
out_to = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
_'player':move'sad_i_altanka'
pn "Аляксандра выходзіць вонкі. ^Галінка з шолахам вярнулася на месца.";
else
pn "Галінка бэзу замінае выйсці.";
end
end;

}

--аб'ект для доўгага апісання пакоя
obj {
-"альтанка, пабудова/жр";
description = "Надзвычай утульнае месцейка, асабліва, калі па лісці кустоў шапоча дождж, а тут, пад пакатым дахам альтанкі зацішна і суха, толькі пахкі ветрык павявае.";
found_in = 'u_altancy';
}:attr 'scenery'

--сад і слівы
room {
nam = "sad_i_slivy";
title = "Слівовы сад";
init_dsc = "Гэты участак надзелу аддадзены пад слівовы сад. Зараз, у пару квецені, гэта самае чароўнае месца на свеце. ^Зарасці бэзу на паўднёвым усходзе адсюль, Алея вязаў на паўночным усходзе.";
dsc = "Зарасці бэзу на паўднёвым усходзе адсюль, алея вязаў на паўночным усходзе.";
ne_to = 'sad_i_vyazy';
se_to = 'sad_i_altanka';
}

--аб'ект для доўгага апісання пакоя
obj {
-"сад/мр";
description = "Гэты участак надзелу аддадзены пад слівовы сад. Зараз, у пару квецені, гэта самае чароўнае месца на свеце.";
found_in = 'sad_i_slivy';
}:attr 'scenery'

--сад і вязы. --алея вязаў
room {
nam = "sad_i_vyazy";
title = "Пляцоўка ля веранды";
init_dsc = "Каля ўваходу ў дом раскінуўся невялікі пакошаны лужок. Свежая густая трава радуе вочы. ^На поўнач цягнецца алея вязаў. На паўднёвым усходзе кветнік і ліпа. На паўднёвым захадзе бялеюць слівы.";
dsc = "На поўнач цягнецца алея вязаў. На паўднёвым усходзе кветнік і ліпа. На паўднёвым захадзе бялеюць слівы.";

Listen = "Дрэвы бясконца шапочуць над галавой.";

before_Smell = function(s, w)
if w ^ 'lavachka' then
_'pah':disable()
pn "Ад лавачкі пахне свежай фарбай.";
else
pn "Пахне свежай фарбай.";
end
end;

n_to = 'sad_i_vyazy2';
s_to = 'veranda';
se_to = 'sad_i_lipa';
sw_to = 'sad_i_slivy';

--робім функцыю, каб гулец мог увайсці ўнутр
in_to = function(s)
if here() ^ "sad_i_vyazy" and not have ('shal') then
pn "Паставіўшы нагу на прыступку, Аляксандра ўспомніла, што кінула недзе шаль. Не трэба пакідаць любімую рэч абы дзе: набярэцца вільгаці -- трэба забраць з сабой.";
elseif here() ^ "sad_i_vyazy" and have ('shal') then
walk 'kalidor'
pn "Аляксандра ўзнялася па прыступках, прамінула веранду і зайшла ў дом.";
end
end;

}

--аб'ект для доўгага апісання пакоя
obj {
-"Пляцоўка, лугавіна, лугавінка/жр|лужок/мр";
description = "Каля выхаду з дома раскінуўся невялікі пакошаны лужок. Свежая густая трава радуе вочы.";
found_in = 'sad_i_vyazy';
}:attr 'scenery'

--алея. у глыбіні алеі
room {
nam = "sad_i_vyazy2";
title = "У глыбіні алеі";
init_dsc = "Магутныя дрэвы з патрэсканай карой сплятаюць галіны ўверсе, утвараючы скляпеністы зялёны тунэль. Промням удаецца то там, то тут пратачыцца скрозь густыя шаты, і на дарожцы варушацца плямы святла. ^Алея вядзе з поўдня на поўнач. Яшчэ, праціснуўшыся між камлёў, можна прабрацца на захад.";
dsc = "Вязы стаяць паабапал дарожкі. Алея вядзе з поўдня на поўнач. Яшчэ, праціснуўшыся між камлёў, можна прабрацца на захад.";
Smell = "Пахне волкай зямлёй і зелянінай.";
Listen = "Дрэвы бясконца шапочуць над галавой.";

n_to = 'pa_alei';
s_to = 'sad_i_vyazy';
w_to = 'sad_i_barbarys';
}

--аб'ект для доўгага апісання пакоя
obj {
-"алея/жр";
description = "Магутныя дрэвы з патрэсканай карой сплятаюць галіны ўверсе, утвараючы скляпеністы зялёны тунэль. Промням удаецца то там, то тут пратачыцца скрозь густыя шаты, і на дарожцы варушацца плямы святла.";
found_in = 'sad_i_vyazy2';
}:attr 'scenery'

--праход, каб зрабіць бясконцы шпацыр па алеі
door {
nam = "pa_alei";
found_in = 'sad_i_vyazy2';

door_to = function(s)
if _'dzen_drugi':has'visited' then
pn "Па гэтым зялёным засені можна ісці і ісці цэлую бясконцасць.";
walk 'sad_i_vyazy2'
end
end;
}:attr 'static, open, concealed';

--сад і барбарыс
room {
nam = "sad_i_barbarys";
title = "Лужок каля алеі";
init_dsc = "Лужок зарос высокімі травамі. З усходу яго аблямоўваюць вязы.";
dsc = "Пайшоўшы на ўсход, можна выбрацца на алею.";
e_to = 'sad_i_vyazy2';
}

--аб'ект для доўгага апісання пакоя
obj {
-"лужок/мр";
description = "Лужок зарос высокімі травамі. З усходу яго аблямоўваюць вязы.";
found_in = 'sad_i_barbarys';
}:attr 'scenery'

--аб'екты кабінету
--газета
obj {
-[["Віленскі лісток",Віленскі лісток/мр|ком паперы,ком/мр|газета/жр]];
nam = "gazeta";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
p [[Аляксандра разгладзіла паперу. Гэта нумар "Віленскага лістка" за мінулы тыдзень. Казік дужа хмурыўся, калі гартаў яго. Пад назвай газеты набрана: "9 чысла месяца кастрычніка".]];
else
p [[Нумар "Віленскага лістка" за мінулы тыдзень. Пад назвай газеты набрана: "9 чысла месяца кастрычніка".]];
end
end;

init_dsc = "Пад лавачкай валяецца ком паперы.";
found_in = 'lavachka2';
}:attr 'атрибут':disable()

--акно
obj {
-"акно/ср|шыбы/мн";
nam = "akno";
before_Touch2 = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "З чаго б гэта?";
else
pn "Аляксандра намерваецца размаляваць карнізы, а не вокны.";
end
end;

before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Высокае двухстворкавае акно выходзіць на поўдзень. За акном цёмна."
return false
elseif _'dzen_drugi':has'visited' then
pn "Высокае двухстворкавае акно выходзіць на поўдзень. За шыбамі бачны зарасці бэзу і дах альтанкі, што хаваецца за імі."
return false
end
end;

dsc = function(s)
p "";
return false
end;
when_open = "Адна створка акна прачынена і ў пакой плыве казачны водар.";
found_in = 'kabinet';
}:attr 'static,container,openable,transparent'

--стол у кабінеце
obj {
-"стол/мр";
nam = "stol";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = function(s)
pn "Масіўны стол, пакрыты зялёным сукном."
return false
end;
dsc = function(s)
p "Пры акне стаіць стол.";
end;
found_in = 'kabinet';
}:attr 'static, transparent, supporter, container, open'

--кніжныя шафы --шафы
obj {
-"кніжныя шафы,шафы,кнігі/мн";
nam = "shafy";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = function(s)
pn "Паліцы шафаў угінаюцца ад цяжару кніг."
return false
end;

dsc = function(s)
p "Кніжныя шафы грувасцяцца ўздоўж сцен.";
end;
found_in = 'kabinet';
}:attr '~animate, static, container,transparent,open'

--аркуш --папера
obj {
-"аркуш паперы,аркуш/мр|папера,паперчына/жр";
nam = "arkush";
fragment1 = false;
fragment2 = false;
fragment3 = false;
fragment4 = false;
fragment5 = false;

--функцыя, каб у другі дзень пакінуць аркуш на стале
before_Take = function (s) 
if _'dzen_drugi':has'visited' 
and not s.fragment5 
then
p [[Няхай пакуль паляжыць на стале.]]
else
return false
end
end;

--функцыя, каб даць аркуш Казіміру
before_Give = function(s, w)
if _'arkush'.fragment5 
then
_'arkush':disable()
pn "Аляксандра падала аркуш мужу. Той прабег вачамі па радках, потым яшчэ раз, зірнуў паўз верх паперкі на карніз, патрусіў у ашалапенні галавой, шырока ўсміхнуўся і згроб жонку ў абдымкі, цмокнуў у пушыстую макаўку: -- Віват, мая князёўна! Цудоўна атрымалася. Цяпер я чакаю не дачакаюся наступнай непагадзі! ";
walk 'dzen_treci'
end
end;

description = function(s)
if s.fragment5 then
p "Аркуш з толькі што скончаным вершам. ^^*** ^Дождж месяцовы ізноў завітаў у мой сад. ^Скрозь пушыстае голле квітнеючых сліў ^Ліецца святло. ^І рэдкія, важкія кроплі ^Сыплюцца ўніз, ^Проста на гулкі бляшаны карніз, ^Звоняць у шыбу бязважкім стаката. ^Я прыслухоўваюся да перарывістых тактаў ^Маркотнага Ліста. ^Каб дапамагчы дажджу ^Я намалявала на гэтым карнізе калісь-ці ^Белыя клавішы. ^16 чысла месяца кастрычніка. ";
elseif s.fragment1 or s.fragment2 or s.fragment3 or s.fragment4 then
p "Аркуш з няскончаным вершам.";
else
p "Аркуш чыстай паперы.";
end
end;

--функцыя пісаць для аркуша
before_Touch2 = function(s, t)
if not here() ^ "gascyounya" then
pn "Трэба вярнуцца ў гасцёўню.";
elseif not have ('alovak') and not have ('pyaro') then
pn "Трэба знайсці якую-небудзь прыладу для пісьма.";
elseif have ('alovak') and have ('pyaro') then
pn "Альбо пяро, альбо аловак трэба адкласці ўбок.";
elseif have ('alovak') and _'alovak'.zlamausya then
pn "Аловак зламаўся. Трэба навастрыць яго.";
elseif s.fragment5 then
pn "Праца скончана. Верш дапісаны. Можна выдыхнуць і атрымліваць асалоду ад моманту.";
--спачатку фрагменты для алоўка
--Аляксандра піша пяты, завяршальны фрагмент
elseif have ('alovak') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham5 and _'gazeta'.bachyu then
_'nathnenne'.pisham5 = false;
s.fragment5 = true;
s.fragment1 = true;
_'kazimir':move'gascyounya'
_'kalidor_i_rayal':disable()
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
pn [[Аляксандра імкліва дапісала: "14 дня месяца кастрычніка" і паставіла тлустую кропку, праткнуўшы аркуш. ^Быццам чакаючы гэтага моманту, у пакой зайшоў Казімір і соладка пацягнуўся: ^--Як жа я хораша сёння папрацаваў! А чым ты займалася, мая князёўна? -- заўважыў спісаны аркуш, -- што гэта ў цябе, можна зірнуць?]];
--Аляксандра піша чацвёрты, перадапошні фрагмент
elseif have ('alovak') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham4 and not _'gazeta'.bachyu then
_'nathnenne'.pisham4 = false;
s.fragment4 = true;
_'nathnenne'.pisham5 = true;
pn [[Аловак выводзіць: ^"Каб дапамагчы дажджу, ^Я намалявала на гэтым карнізе калісьці ^Белыя клавішы." ^Аляксандра задаволена хмыкнула: "Ну вось, нарэшце скончыла. Застаецца дату паставіць. Якое сёння чысло? -- кусае вусны. -- М-м-м, не памятаю, згубіла лік дням. Дзе б гэта дату падгледзець? Трэба ў Казікавых газетах зірнуць. Ён не так даўно пошту атрымліваў.".]];
--дублірую на выпадак, калі гулец ужо зазіраў у газету
elseif have ('alovak') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham4 and _'gazeta'.bachyu then
_'nathnenne'.pisham4 = false;
s.fragment4 = true;
_'nathnenne'.pisham5 = true;
pn [[Аловак выводзіць: ^"Каб дапамагчы дажджу, ^Я намалявала на гэтым карнізе калісьці ^Белыя клавішы." ^Аляксандра задаволена хмыкнула: "Ну вось, нарэшце скончыла. Застаецца дату паставіць. Якое сёння чысло? -- кусае вусны. -- М-м-м, не памятаю, згубіла лік дням. Дзе б гэта дату падгледзець? Ага! Я бачыла нядаўнюю Казікаву газету. Трэба там яшчэ раз зірнуць.".]];
--Аляксандра піша трэці фрагмент
elseif have ('alovak') and 
(_'karniz1'.bachyu or _'gascyounya_i_kropli'.bachyu or _'gascyounya_i_shklo'.bachyu)
and not s.fragment3 
 and _'nathnenne'.pisham3 then
_'nathnenne'.pisham3 = false;
s.fragment3 = true;
_'nathnenne'.pisham4 = true;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
pn [[Аловак паспешліва бяжыць па паперы: ^"І рэдкія, важкія кроплі ^Сыплюцца ўніз, ^Проста на гулкі бляшаны карніз, ^Звоняць у шыбу бязважкім стаката. ^Я прыслухоўваюся да перарывістых тактаў ^Маркотнага Ліста…"]];
--Аляксандра піша другі радок
elseif have ('alovak') and 
(_'gascyounya_i_pounya'.bachyu or _'gascyounya_i_golle'.bachyu) 
and not s.fragment2 
and _'nathnenne'.pisham2 then
_'nathnenne'.pisham2 = false;
s.fragment2 = true;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
_'alovak'.zlamausya = true;
pn [[На паперы хутка з'яўляюцца словы: ^"Скрозь пушыстае голле квітнеючых сліў ^Ліецца святло…". ^Кончык алоўка з ціхім трэскам адламаўся. "Ну вось!.. Шкада. Трэба знайсці сцізорык ды завастрыць грыфель. І хутчэй, пакуль натхненне не сыйшло!"]];
--Аляксандра піша першы радок
elseif have ('alovak') and 
(_'gascyounya_i_dojdj'.bachyu or _'gascyounya_i_sad'.bachyu) 
and not s.fragment1 
and _'nathnenne'.pisham1 then
_'nathnenne'.pisham1 = false;
s.fragment1 = true;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
pn [[Аляксандра таропка піша: ^"Дождж месяцовы ізноў завітаў у мой сад…"]];
--цяпер радкі функцыі для пяра
elseif have ('pyaro') and not _'pyaro'.abmaknuu then
pn "На дзюбцы пяра няма чарніла. Перш чым пісаць, трэба абмакнуць пяро ў чарніліцу.";
--Аляксандра піша пяты, завяршальны фрагмент
elseif have ('pyaro') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham5 and _'gazeta'.bachyu then
_'nathnenne'.pisham5 = false;
s.fragment5 = true;
s.fragment1 = true;
_'pyaro'.abmaknuu = false;
_'kazimir':move'gascyounya'
_'kalidor_i_rayal':disable()
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
pn [[Аляксандра імкліва дапісала: "14 дня месяца кастрычніка" і паставіла тлустую кропку, праткнуўшы пяром аркуш. ^Быццам чакаючы гэтага моманту, у пакой зайшоў Казімір і соладка пацягнуўся: ^--Як жа я хораша сёння папрацаваў! А чым ты займалася, мая князёўна? -- заўважыў спісаны аркуш, -- што гэта ў цябе, можна зірнуць?]];
--Аляксандра піша чацвёрты, перадапошні фрагмент
elseif have ('pyaro') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham4 and not _'gazeta'.bachyu then
_'nathnenne'.pisham4 = false;
s.fragment4 = true;
_'nathnenne'.pisham5 = true;
_'pyaro'.abmaknuu = false;
pn [[Пяро выводзіць: ^"Каб дапамагчы дажджу ^Я намалявала на гэтым карнізе калісьці ^Белыя клавішы." ^Аляксандра задаволена хмыкнула: "Ну вось, нарэшце скончыла. Застаецца дату паставіць. Якое сёння чысло? -- кусае вусны. -- М-м-м, не памятаю, згубіла лік дням. Дзе б гэта дату падгледзець? Трэба ў Казікавых газетах зірнуць. Ён не так даўно пошту атрымліваў.".]];
--дублірую на выпадак, калі гулец ужо зазіраў у газету
elseif have ('pyaro') and _'razmalyavala_karniz':has'visited' and _'nathnenne'.pisham4 and _'gazeta'.bachyu then
_'nathnenne'.pisham4 = false;
s.fragment4 = true;
_'nathnenne'.pisham5 = true;
_'pyaro'.abmaknuu = false;
pn [[Пяро выводзіць: ^"Каб дапамагчы дажджу ^Я намалявала на гэтым карнізе калісьці ^Белыя клавішы." ^Аляксандра задаволена хмыкнула: "Ну вось, нарэшце скончыла. Застаецца дату паставіць. Якое сёння чысло? -- кусае вусны. -- М-м-м, не памятаю, згубіла лік дням. Дзе б гэта дату падгледзець? Ага! Я бачыла нядаўнюю Казікаву газету. Трэба там яшчэ раз зірнуць.".]];
--Аляксандра піша трэці фрагмент
elseif have ('pyaro') and 
(_'karniz1'.bachyu or _'gascyounya_i_kropli'.bachyu or _'gascyounya_i_shklo'.bachyu)
and not s.fragment3 
 and _'nathnenne'.pisham3 then
_'nathnenne'.pisham3 = false;
s.fragment3 = true;
_'nathnenne'.pisham4 = true;
_'pyaro'.abmaknuu = false;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
pn [[Пяро выпісвае на паперы: ^"І рэдкія, важкія кроплі ^Сыплюцца ўніз, ^Проста на гулкі бляшаны карніз, ^Звоняць у шыбу бязважкім стаката. ^Я прыслухоўваюся да перарывістых тактаў ^Маркотнага Ліста…"]];
--Аляксандра піша другі радок
elseif have ('pyaro') and 
(_'gascyounya_i_pounya'.bachyu or _'gascyounya_i_golle'.bachyu)
and not s.fragment2 
 and _'nathnenne'.pisham2 then
_'nathnenne'.pisham2 = false;
s.fragment2 = true;
_'pyaro'.abmaknuu = false;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
pn [[На паперы пад шолах пяра з'яўляюцца словы: ^"Скрозь пушыстае голле квітнеючых сліў ^Ліецца святло…".]];
--Аляксандра піша першы радок
elseif have ('pyaro') and 
(_'gascyounya_i_dojdj'.bachyu or _'gascyounya_i_sad'.bachyu)
and not s.fragment1 
 and _'nathnenne'.pisham1 then
_'nathnenne'.pisham1 = false;
s.fragment1 = true;
_'pyaro'.abmaknuu = false;
DaemonStop('gascyounya') -- спыняецца дэман, які апісвае жаданне пісаць верш
pn [[Аляксандра таропка піша: ^"Дождж месяцовы ізноў завітаў у мой сад…"]];
else
pn "Удалая думка яшчэ не прыйшла да Аляксандры. Трэба пашукаць натхнення ў акне.";
end
end;

found_in = 'palica';

}:attr 'supporter':disable()

--зэдлік
obj {
-"зэдлік/мр";
nam = "zedlik";
Enter = function(s,w)
pn "Аляксандра апусцілася на зэдлік.";
move(me(), 'zedlik');
end;

before_Take = function () p [[Аляксандры гэта зараз не трэба.]] return true end;

description = function(s)
pn "Зэдлік з круглым сядзеннем стаіць перад раялем."
return false
end;
found_in = 'kabinet';
}:attr 'enterable,supporter,static,transparent'

--пейзаж з садам і ліпай
obj {
-"карціна з садам,карціна,ліпа/жр|сад/мр";
['before_Push,Pull'] = function(s) p [[Аляксандра вырашыла не чапаць карціны. За ёй усё адно нічога няма акром сцяны. Хай вісіць сабе.]] return true end;

description = "Над раялем вісіць карціна, выпісаная сакавітым чэрвеньскім днём. Шмат-шмат кароткіх мазкоў чырвонага, светлага і цёмна-зялёнага паказваюць кусты ружаў. За імі бачна пазнавальная купчастая постаць ліпы. Нідзе такой няма. Яе пасадзіў прапрадзед Аляксандры. Гэта дзіва, а не дрэва: амаль ля самай зямлі комель разыходзіцца на шэсць ствалоў, якія трымаюць на суках шырозную крону. Цень гэтага цар-дрэва ахінае ці не палову нашага надзелу.";
dsc = "На сцяне вісіць карціна.";
found_in = 'kabinet';
}:attr 'static'

--падлога
obj {
-"падлога/жр";
nam = "padloga";
description = "Падлога зроблена з цёмных дошак.";
found_in = {'kabinet', 'kalidor', 'gascyounya', 'maysternya'};
}:attr 'scenery'

--пісьмовы прыбор --прыбор
obj {
-"пісьмовы прыбор,прыбор/мр";
nam = "prybor";
before_Take = function () p [[Аляксандры гэта зараз не трэба.]] return true end;

bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'charnilica':enable()
_'pyaro':enable()
pn "Цяжкі пісьмовы прыбор з адпаліраванага дубу, аздоблены меднымі накладкамі."
return false
else
pn "Цяжкі пісьмовы прыбор з адпаліраванага дубу, аздоблены меднымі накладкамі."
return false
end
end;

dsc = function(s)
p "На стале стаіць пісьмовы прыбор.";
return false
end;
found_in = 'stol';
}:attr 'static, open, transparent, container'

--пяро
obj {
-"пяро/ср";
nam = "pyaro";
bachyu = false;
abmaknuu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
p "У драўляны дзяржак устаўлена сталёвае пяро для пісьма. Апошнім часам такія пёркі ўвайшлі ў моду. Надзіва зручная рэч: вастрыць не трэба, почырк атрымліваецца акуратным.";
elseif s.abmaknuu then
p "На вострай дзюбцы пяра цямнее чарніла -- можна пісаць.";
else
p "У драўляны дзяржак устаўлена сталёвае пяро для пісьма.";
end
end;

found_in = 'prybor';
}:disable()

--каманда. пашыраем спіс дадатковых дзеясловаў для дзеяння уставіць, уваткнуць. для пяра і пэндзліка
VerbExtendWord {"#Insert",
"абмак[нуць|нула|вае|не|вай],апу[сціць|сціла|скае|скаю|скай|шчу],акун[уць|ула|ае|ні|най],[|на|па]мач[ыць|ыла|у|аю|ы]"}

--раяль
obj {
-"раяль,музычны інструмент,інструмент/мр|клавішы/мн";
nam = "rayal";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Інструмент з цёмнага лакіраванага дрэва. Панэлі мякка пабліскваюць. Клавішы, белыя і чорныя, чакаюць дотыкаў."
return false
else
pn "Лакіраваныя панэлі інструмента мякка пабліскваюць."
return false
end
end;

before_Touch3 = function(s, w)
if _'dzen_drugi':hasnt'visited' 
then
pn "Аляксандра націснула некалькі нот, прыслухалася да голаса раяля і вырашыла пакінуць інструмент у спакоі.";
else
pn "Аляксандра націснула некалькі нот, прыслухалася да голаса раяля і вырашыла пакінуць інструмент у спакоі.";
end
end;

found_in = 'kabinet';
}:attr 'static, open, openable, supporter'

--столь
obj {
-"столь/жр";
description = "Высокая белая столь надае больш прасторы.";
found_in = {'kabinet', 'kalidor', 'gascyounya', 'maysternya'};
}:attr 'scenery'

--стул
obj {
-"стул/мр";
nam = "stul";
Enter = function(s,w)
pn "Аляксандра трохі пакруцілася, уладкоўваючыся на не надта зручным стуле.";
move(me(), 'stul');
end;

before_Take = function () p [[Аляксандры гэта зараз не трэба.]] return true end;

description = function(s)
pn "Стул з высокай цвёрдай спінкай стаіць пры стале."
return false
end;
found_in = 'kabinet';
}:attr 'enterable,supporter,static,transparent'

--сцены кабінета
obj {
-"сцены/мн";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
p "Ад сценаў нібыта сыходзіць цёплае святло. Бліжэй да кутоў Аляксандра надала ім крыху больш аранжавых і карычневатых адценняў. Гэтыя гульні з фарбамі зрабілі пакой больш скругленым -- як на карціне. Разам з цёмнай мэбляй усё выглядае вельмі і вельмі ўтульна. Аляксандра нічога не хацела чуць ні пра якіх нанятых майстроў-маляроў і расфарбавала, размалявала ўсе сцены і падлогі ў доме сваімі ўласнымі рукамі.";
else
p "Ад сценаў нібыта сыходзіць цёплае святло. Разам з цёмнай мэбляй усё выглядае вельмі і вельмі ўтульна.";
end
end;

found_in = 'kabinet';
}:attr 'scenery'

--чарніліца
obj {
-"фарфоравая чарніліца,чарніліца/жр|чарніла/ср";
nam = "charnilica";
description = function(s)
pn "Пузаценькая фарфоравая чарніліца з адкідным вечкам. Яе бакі упрыгожаны тонкімі зеленаватымі візарункамі. Казімір часта пагладжвае гэтую прыемную на дотык рэч, калі думае."
return false
end;
-- when_closed = "Вечка чарніліцы зачыненае.";
when_open = "Вечка чарніліцы адкінутае.";
found_in = 'prybor';

--функцыя дазваляе абмакнуць пяро ў чарніліцу, калі тая адкрытая. Усё астатняе абмакваць забараняе
after_Receive = function(s, w)
if not s:attr 'open' then
p "Але чарніліца закрытая.";
elseif not s.abmaknuu and w ^ "pyaro" then
_'pyaro':move'player'
_'pyaro'.abmaknuu = true
p "Аляксандра абмакнула пяро ў чарніліцу.";
elseif s.abmaknuu and w ^ "pyaro" then
pn "Не трэба -- чарніла на дзюбцы пяра і так ёсць.";
elseif not w ^ "pyaro" then
 return "Не трэба пхаць у чарніліцу што папала!", true
 end
end

}:attr 'openable, container, transparent':disable()

--аб'екты калідору
--пейзаж з ратушай
obj {
-"карціна з ратушай,карціна,ратуша,вежа,царква,сінагога/жр|прадмесці,дахі,вулкі,прысады, званніцы/мн|касцёл/мр";

['before_Push,Pull'] = function(s) p [[Аляксандра вырашыла не чапаць карціны. За ёй усё адно нічога няма акром сцяны. Хай вісіць сабе.]] return true end;

description = "Насупраць уваходу ў гасцёўню вісіць пейзаж з гарадскімі прадмесцямі. Дахі дамоў ламанымі шнурочкамі цягнуцца ўдалячынь, размываючыся ў смузе. Над імі пануе зграбны сілуэт гарадской ратушы.";
found_in = 'kalidor';
dsc = "На сцяне вісіць карціна.";
}:attr 'static'

--аб'екты гасцёўні
--адбітак клавіятуры ў акне. --адлюстраванне клавіятуры
obj {
-"адбітак піяніна, адбітак клавіятуры, адбітак/мр|адлюстраванне піяніна,адлюстраванне клавіятуры,адлюстраванне/ср|клавішы/мн|рукі казіміра,рукі/мн";
nam = "piyanina_i_shklo";
bachyu = false;
description = function(s)
if not s.bachyu and _'nathnenne'.pisham4 and _'dzen_drugi':hasnt'visited' then
s.bachyu = true;
p "Позірк Аляксандры спыніўся на адлюстраванні піяніна ў вакне, дакладней, на шэрагу белых і чорных клавіш, што наклаліся на карніз і яе вусны расцягнуліся ў задаволенай усмешцы: цудоўна! Дык вось да чаго ўсё ішло! Такі цудоўны верш напісаўся. Цяпер зразумела, чым яго скончыць, але мастацтва не мусіць хлусіць. Трэба будзе заўтра намаляваць на карнізе клавішы і дапісаць верш.";
walk 'dzen_drugi'
else
p "Піяніна люструецца ў аконным шкле.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--шыбы ў гасцёўні
obj {
-"шыбы,шыбкі/мн|шкло/ср";
nam = "gascyounya_i_shklo";
bachyu = false;
description = function(s)
if _'dzen_drugi':hasnt'visited' and not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
p "Па шыбах збягаюць дарожкі дажджавой вады. Праз гэта сад выглядае крыху нетутэйшым, містычным. У шкле бачна паўпразрыстае адлюстраванне пакоя, белаватыя клавішы піяніна і рукі Казіміра на іх.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu then
p "Па шыбах збягаюць дарожкі дажджавой вады. Праз гэта сад выглядае крыху нетутэйшым, містычным. У шкле бачна паўпразрыстае адлюстраванне пакоя, белаватыя клавішы піяніна і рукі Казіміра на іх.";
elseif _'dzen_drugi':has'visited' then
p "Скрозь шыбы бачны белы сад.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--карніз у акне
obj {
-"карніз/мр|бляха/жр|падваконне/ср";
nam = "karniz1";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

before_Touch2 = [[Карніз знаходзіцца звонку. Каб размаляваць яго, трэба выйсці з дома. ]];

bachyu = false;
description = function(s)
if _'dzen_drugi':hasnt'visited' and not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
p "Аляксандра пазірае на карніз скрозь мокрае шкло. На яго, быццам спецыяльна, накладваецца адлюстраванне клавіятуры і рукі Казіміра на ёй.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu then
p "Аляксандра пазірае на карніз скрозь мокрае шкло. На яго, быццам спецыяльна, накладваецца адлюстраванне клавіятуры і рукі Казіміра на ёй.";
elseif _'dzen_drugi':has'visited' and _'razmalyavala_karniz':has'visited' and not s.bachyu then
s.bachyu = true;
p "Карніз нахабна шчэрыцца белазубай усмешкай, з канца ў канец размаляваны ў белыя клавішы, паміж якімі чарнеюць паўтаны: Ён так і просіць, каб па клавішах пабарабанілі пальцы. Адразу відаць, што гэта -- дом кампазітара. У якога нават дождж не проста так стукае, а музыку грае.";
elseif _'razmalyavala_karniz':has'visited' and s.bachyu then
p "Карніз з канца ў канец размаляваны ў белыя клавішы, паміж якімі чарнеюць паўтаны.";
else
p "Бляшаны карніз пафарбаваны някідкай шэрай фарбай, каб яго не ела іржа.";
end
end;

found_in = {'vokny', 'akno2'};
}:attr 'scenery'

--службовы аб'ект. святло поўні для гасцёўні
obj {
nam = "gascyounya_i_pounya2";
bachyu = false;
dsc = function(s)
if not s.bachyu then
s.bachyu = true;
pn "Аляксандра зачаравана пазірае ў вакно."
else
pn "Святло поўні залівае пакой."
end
end;

found_in = 'gascyounya';
}:attr 'static'

--службовы аб'ект. --гукі раяля для калідора
obj {
nam = "kalidor_i_rayal";
dsc = "З-за дзвярэй кабінета даносіцца прыглушаны голас раяля.";
found_in = 'kalidor';
}:attr 'static':disable()

--рандомныя гукі кропель і піяніна для гасцёўні
obj {
nam = "gascyounya_i_kropli2";
{ -- масіў выпадковых фраз
dyn_part = {
[1] = "Прыгаршча дажджынак сыпанула ў акно. Шыбы ціхенька зазвінелі.",
[2] = "Цяжкая кропля гулка бумкнула ў карніз.",
[3] = "Кроплі прастукацелі па карнізе, быццам музыкант прабегся пальцамі па клавішах.",
[4] = "За акном буйныя кропелькі бліснулі, быццам расплаўленае срэбра.",
[5] = "За акном буйныя кропелькі бліснулі, быццам расплаўленае срэбра.",
[6] = "Піяніна выдала некалькі нізкіх нот, быццам Казімір паўтарыў следам за дажджынкамі.",
[7] = "Па пакоі прабеглася лёгкае-лёгкае, амаль бязгучнае стаката.",
[8] = "Абрывак цьмяна знаёмай музыкі загучаў у пакоі. Можа, Казімір неяк іграў гэта пры Аляксандры з выпісанага з-за мяжы сшытка. Ліст, ці нешта такое…",
[9] = "Цяжкая кропля гулка бумкнула ў карніз.",
[10] = "Прыгаршча дажджынак сыпанула ў акно. Шыбы ціхенька зазвінелі.",
},
};
dsc = function(s) p ""; -- тут мусіў быць тэкст для пакоя
local r = rnd(#s.dyn_part); -- круцім генератар выпадковых лікаў
p(s.dyn_part[r]); --выводзім выпадковую фразу
end;

found_in = 'gascyounya';
}:attr 'static'

--кроплі ў акне
obj {
-"кроплі,кропелькі,дажджынкі/мн";
nam = "gascyounya_i_kropli";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
p "Кроплі срэбнымі знічкамі раз-пораз зрываюцца ўніз.";
else
p "Кроплі срэбнымі знічкамі раз-пораз зрываюцца ўніз.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--поўня ў акне
obj {
-"поўня/жр|месяц/мр";
nam = "gascyounya_i_pounya";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
_'nathnenne'.pisham2 = true;
p "Поўня плыве нізка-нізка над даляглядам. Яна вялізная і зіхоткая: дожджык недарма стараўся -- адмыў да люстранога бляску.";
else
p "Поўня плыве нізка-нізка над даляглядам. Яна вялізная і зіхоткая: дожджык недарма стараўся -- адмыў да люстранога бляску.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--галіны сліў
obj {
-"галіны сліў,галіны,галінкі/мн|голле/ср|квецень/мр";
nam = "gascyounya_i_golle";
bachyu = false;
description = function(s)
if _'dzen_drugi':hasnt'visited' and not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
_'nathnenne'.pisham2 = true;
p "Чорныя абрысы абсыпаных квеценню галінак на фоне поўні выразныя, як на гравюры.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu then
p "Чорныя абрысы абсыпаных квеценню галінак на фоне поўні выразныя, як на гравюры.";
elseif _'dzen_drugi':has'visited' then
p "Кветак так шмат, што між імі амаль не відно галін. Ад гэтага здаецца, што дрэвы пульхныя і лёгкія, як аблокі.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--натхненне, якое падштурхоўвае пісаць верш. службовы аб'ект
--да гэтага аб'екта нельга звярнуцца, але ў яго ёсць нам і сцяжок для логікі пісання
obj {
nam = "nathnenne";
vee = false;
pisham1 = false;
pisham2 = false;
pisham3 = false;
pisham4 = false;
pisham5 = false;
found_in = 'gascyounya';
}:attr 'scenery'

--дождж
obj {
-"дождж,дожджык/мр";
nam = "gascyounya_i_dojdj";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
_'nathnenne'.pisham1 = true;
p "Лагодны травеньскі дожджык не, не ідзе -- хутчэй, басанож крадзецца па садзе. Рэдкія буйныя кроплі мякка плёхаюць па карнізе, пагойдваюць галінкі дрэў.";
else
p "Лагодны травеньскі дожджык не, не ідзе -- хутчэй, басанож крадзецца па садзе. Рэдкія буйныя кроплі мякка плёхаюць па карнізе, пагойдваюць галінкі дрэў.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--сад з гасцёўні
obj {
-"слівовы сад,сад/мр|слівы,дрэвы,дрэўцы/мн";
nam = "gascyounya_i_sad";
bachyu = false;
description = function(s)
if _'dzen_drugi':hasnt'visited' and not s.bachyu then
s.bachyu = true;
DaemonStart('gascyounya') -- пачынае працаваць дэман, які апісвае жаданне пісаць верш
_'nathnenne'.pisham1 = true;
p "Дрэвы ў квецені бялеюць на фоне сіняга прыцемку. А вось калі глянуць на поўню, то на яе фоне яны малююцца ўжо цёмнымі сілуэтамі. Цікава.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu then
p "Дрэвы ў квецені бялеюць на фоне сіняга прыцемку. А вось калі глянуць на поўню, то на яе фоне яны малююцца ўжо цёмнымі сілуэтамі. Цікава.";
elseif _'dzen_drugi':has'visited' and s.bachyu then
p "Сад красуе ў святочным уборы, радуецца сонцу, ветрыку і жыццю.";
end
end;

found_in = 'vokny';
}:attr 'scenery'

--нотны сшытак
obj {
-"нотны сшытак,сшытак/мр|ноты/мн";
nam = "noty";

description = "Нотны сшытак разгорнуты на чыстай старонцы. Аляксандра бачыць пустыя радкі. Казімір намерваўся нешта пісаць, але пакуль не пакінуў на лінейках ніводнай ноткі.";
before_Take = function () p [[Не трэба. Няхай ляжыць, дзе ляжыць.]] return true end;
found_in = 'piyanina';
}

--Казімір. --муж
obj {
-"Казімір, Казік, муж, мужчына, музыкант, кампазітар/мр";
nam = "kazimir";
description = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Кудлатая галава Казіміра схілена. Ён слухае дождж за акном. Пальцы задуменна перабіраюць клавішы."
elseif _'dzen_drugi':has'visited' then
pn "Казімір апрануты ў ваўняную кашулю. Ён глядзіць на жонку шырока расплюшчанымі вачамі, любуецца."
end
end;

dsc = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Казімір Сядзіць за інструментам."
elseif _'dzen_drugi':has'visited' then
pn "Казімір стаіць пасярод пакоя."
end
end;

['before_Talk,Answer,Ask,AskTo,AskFor,Tell'] = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Не варта яму замінаць."
elseif _'dzen_drugi':has'visited' then
pn "Аляксандра задумалася."
end
end;

before_Touch= function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Аляксандра перадумала: не трэба зараз выторгваць Казіміра з думак.";
else
pn "Казімір усміхнуўся і абняў Аляксандру ў адказ.";
end
end;

before_Kiss = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Добра б, але лепей зараз ад гэтага ўстрымацца.";
else
pn "Аляксандра цалуе мужа.";
end
end;

found_in = 'zedlik2';
}:attr 'animate'

--зэдлік у гасцёўні
obj {
-"зэдлік/мр";
nam = "zedlik2";
Enter = function(s,w)
if _'dzen_drugi':hasnt'visited' then
pn "На зэдліку зараз сядзіць Казімір."
else
pn "Аляксандра апусцілася на зэдлік."
move(me(), 'zedlik2');
end
end;

before_Take = function () p [[Аляксандры гэта зараз не трэба.]] return true end;

description = function(s)
pn "Зэдлік з круглым сядзеннем стаіць перад піяніна."
return false
end;
found_in = 'gascyounya';
}:attr 'enterable,supporter,static,transparent'

--аловак
obj {
-"аловак/мр";
nam = "alovak";
description = "Просты аловак Ну так, крыху пагрызены з незавостранага канца. Ну і што? Час ад часу ён апынаецца за вухам Аляксандры. Даме так рабіць не да твару, але куды яго падзець, калі трэба папрацаваць з сангінай, а праз хвілінку ён спатрэбіцца ізноў?";
zlamausya = false;

--функцыя рэзаць для нажа, каб завастрыць зламаны аловак
before_Cut = function(s, w)
if _'alovak'.zlamausya then
--блок if w ^ 'alovak' then
_'alovak'.zlamausya = false;
pn "Хуткімі рухамі ляза Аляксандра завастрыла аловак.";
else
pn "Пакуль не трэба гэта рабіць.";
end
end;

found_in = 'palica';
}:attr 'атрибут':disable()

--вокны гасцёўні
obj {
-"вокны, рамы, нябёсы, аблокі/мн|акно, неба, сутонне/ср|вечар, адвячорак/мр";
nam = "vokny";
before_Touch2 = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "З чаго б гэта?";
else
pn "Аляксандра намерваецца размаляваць карнізы, а не вокны.";
end
end;

krok = 1; -- пачатковая пераменная
bachyu = false;
description = function(s)
if _'dzen_drugi':hasnt'visited' and not s.bachyu and s.krok==1 then -- дождж сад
s.bachyu = true;
pn "За вокнамі ўжо прыцемкі. Нейк неўпрыкмет падабраўся дожджык. Відаць, аблокі стаяць толькі над дахам, бо кроплі сыплюцца на шыбы і слівы, а далей відно чыстае неба і поўня.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu and s.krok==1 then -- дождж сад
pn "За вокнамі ўжо прыцемкі. Нейк неўпрыкмет падабраўся дожджык. Відаць, аблокі стаяць толькі над дахам, бо кроплі сыплюцца на шыбы і слівы, а далей відно чыстае неба і поўня.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu and s.krok==2 then -- поўня і слівы
pn "Поўня плыве нізка-нізка, зазіраючы ў пакой скрозь пушыстыя галіны дрэў.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu and s.krok==3 then -- кроплі
pn "Кроплі срэбнымі знічкамі раз-пораз зрываюцца ўніз, тоненька пазвоньваюць у шыбы, тукаюць у карніз.";
elseif _'dzen_drugi':hasnt'visited' and s.bachyu and s.krok==4 then -- адлюстраванне
s.krok = 0; -- пераменная скідваецца і лічыльнік пачынае спачатку
pn "У акне люструюцца клавішы адкрытага піяніна і Казіміравы рукі на іх.";
elseif _'dzen_drugi':has'visited' then 
pn "Вокны глядзяць на захад. Там бялеюць слівы. Высока-высока над імі плывуць празорыстыя аблокі.";
end
s.krok = s.krok+1
return false
end;
dsc = function(s)
p "";
return false
end;
when_open = "Адна створка акна прачынена і ў пакой плыве казачны водар.";
found_in = 'gascyounya';
}:attr 'static,container,openable, transparent'

--пейзаж з домам
obj {
-"карціна з домам, карціна/жр|дом/мр|дарожкі, сцежкі, клумбы|мн";
['before_Push,Pull'] = function(s) p [[Аляксандра вырашыла не чапаць карціны. За ёй усё адно нічога няма акром сцяны. Хай вісіць сабе.]] return true end;

description = "Аляксандра разглядае карціну. На ёй выпісаны іхні з Казімірам дом. Аднапавярховы, з чатырохскатным чарапічным дахам, сцены пафарбаваны ў вохрысты колер, скрозь зялёныя зарасці плюшчу праглядваецца пераплёт акна, шыба люструе неба.";
dsc = "Над інструментам вісіць карціна.";
found_in = 'gascyounya_i_scyana';
}:attr 'static'

--канапа
obj {
-"канапа/жр";
nam = "kanapa";
Enter = function(s,w)
pn "Аляксандра ўладкавалася на канапе.";
move(me(), 'kanapa');
end;

before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = function(s)
pn "Канапа выштукавана з вішнёвага дрэва. Спінка плаўна выгінаецца. На сядзенне кінута некалькі вышытых падушачак для зручнасці."
return false
end;
found_in = 'gascyounya';
}:attr 'enterable,supporter,static,transparent'

--крэсла
obj {
-"крэсла/ср|фатэль/мр";
nam = "kresla";
Enter = function(s,w)
pn "Аляксандра ўселася ў крэсла.";
move(me(), 'kresla');
end;

before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = function(s)
pn "Драўлянае крэсла з разьблёнай спінкай і падлакотнікамі."
return false
end;

dsc = function(s)
p "";
return false
end;

found_in = 'gascyounya';
}:attr 'static,enterable,supporter,transparent'

--крэслы. службовы аб'ект для адлюстравання ў пакоі
obj {
nam = "kresly";
dsc = "Абапал століка стаяць два крэслы.";
found_in = 'gascyounya';
}:attr 'static'

--папараць
obj {
-"папараць,расліна,кветка/жр|вайі,сцябліны,лісты/мн|лісце/ср";
nam = "paparac";

before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = "У куце гасцёўні стаіць квадратны драўляны вазон. Цэлы абярэмак лапчастых сцяблін папараці тапырыцца ва ўсе бакі, плаўна апускаецца долу. Зялёныя вайі падобны на шнурочкі птушак, якія адлятаюць прэч.";
dsc = "У куце расце папараць.";
before_Touch = [[Зубчастыя краёчкій вайі злёгку драпаюць скуру.]];

found_in = 'gascyounya_i_scyana';
}:attr 'static'

--піяніна
obj {
-"піяніна,фартэпіяна/ср|музычны інструмент,інструмент/мр";
nam = "piyanina";

description = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Піяніна паблісквае лакам у святле поўні. На ім часта музіцыруюць, калі ў гасцёўні ладзяцца сямейныя канцэрты, збіраюцца госці."
return false
else
pn "Лакіраваныя панэлі інструмента мякка пабліскваюць."
return false
end
end;

dsc = function(s)
p "Піяніна стаіць ля сцяны.";
return true
end;

before_Touch3 = function(s, w)
if _'dzen_drugi':hasnt'visited' then 
pn "Казімір зараз ля інструмента. Не трэба яму замінаць.";
else
pn "Аляксандра націснула некалькі нот, прыслухалася да голасу піяніна і вырашыла пакінуць інструмент у спакоі.";
end
end;

before_Take = function () p [[Навошта гэта рабіць?]] return true end;

found_in = 'gascyounya';
}:attr 'static, open, openable, supporter'

--каманда "іграць" для піяніна
Verb {
"#Touch3",
"[|і|пай|най|прай|зай]гра[ць|й|е|ю|ла]";
"на {noun}/пр : Touch3",
}

--столік у гасцёўні
obj {
-"часопісны столік,столік,стол/мр";
nam = "stol2";
description = function(s)
pn "Нізкі столік з наваскаванай стальніцай."
return false
end;
dsc = function(s)
p "";
end;

before_Take = function () p [[Навошта гэта рабіць?]] return true end;
found_in = 'gascyounya';
}:attr 'enterable,supporter,static,transparent'

--сцены гасцёўні
obj {
-"сцены/мн|сцяна/жр";
nam = "gascyounya_i_scyana";
description = function(s)
pn "Сцены гасцёўні пафарбаваны ў колер лаванды."
return false
end;
found_in = 'gascyounya';
}:attr 'enterable,supporter,static, concealed'

--шаль
obj {
-"шаль/жр";
nam = "shal";
description = "Блакітная ваўняная шаль.";
init_dsc = "Праз падлакотнік канапы перакінута шаль.";
found_in = 'kanapa';
}:attr 'worn,clothing':disable()

game : dict {
["Аляксандра/рд"] = "Аляксандры";
["Аляксандра/вн"] = "Аляксандру";
["Аляксандра/дт"] = "Аляксандры";
["Аляксандра/тв"] = "Аляксандрай";
["Аляксандра/пр"] = "Аляксандры";
}

--аб'екты майстэрні
--акно
obj {
-"акно,дрэва/ср|кветнік/мр|ліпа/жр";
nam = "akno2";
before_Touch2 = [[Аляксандра намерваецца размаляваць карнізы, а не вокны.]];

description = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "Высокае двухстворкавае акно выходзіць на ўсход. За акном цёмна."
return false
elseif _'dzen_drugi':has'visited' then
pn "Высокае двухстворкавае акно выходзіць на ўсход. За шыбамі бачны кветнік і высознае дрэва."
return false
end
end;
dsc = function(s)
p "";
return false
end;

when_open = "Адна створка акна прачынена і ў пакой плыве казачны водар.";
found_in = 'maysternya';
}:attr 'static,container,openable, transparent'

--мальберт
obj {
-"мальберт,падрамнік/мр|палатно/ср";
nam = "malbert";
['before_Push,Pull'] = function(s) p [[Навошта? Аляксандра вырашыла не чапаць мальберт.]] return true end;

before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = "Аляксандра плануе напісаць від збоку на алею вязаў. Ужо гатова колькі акварэльных і алоўкавых замалёвак на паперы, але на палатне пакуль няма нават накіду вугалем.";
dsc = "Мальберт павернуты палатном да акна.";
found_in = 'maysternya';
}:attr 'static'

--паліцы --паліца
obj {
-"паліца/жр";
nam = "palica";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'arkush':enable()
_'alovak':enable()
pn "Паліца для розных рэчаў і інструментаў, патрэбных у працы мастака."
return false
else
pn "Паліца для розных рэчаў і інструментаў, патрэбных у працы мастака."
return false
end
end;

dsc = function(s)
p "На сцяне вісіць паліца.";
return false
end;
found_in = 'maysternya';
}:attr 'static, supporter, container, open'

--стул у майстэрні
obj {
-"стул/мр";
nam = "stul2";
Enter = function(s,w)
pn "Аляксандра апусцілася на стул. Той рыпнуў.";
move(me(), 'stul2');
end;

before_Take = function () p [[Аляксандры гэта зараз не трэба.]] return true end;

description = function(s)
pn "Стул з простай спінкай. На ім можна пасядзець, калі ногі стаміліся ад доўгай працы стоячы, альбо на яго можна пакласці што--небудзь, каб пад рукой было."
return false
end;

dsc = function(s)
p "Аляксандра бачыць тут стул.";
return false
end;

found_in = 'maysternya';
}:attr 'enterable,supporter,static,transparent'

--пэндзлік
obj {
-"пэндзлік,пэндзаль/мр";
nam = "pendzlik";

--для пэндзліка
abmaknuu = false;
description = function(s)
if s.abmaknuu then
p "На шчэцці пэндзліка бялее фарба. Можна размалёўваць карніз.";
else
p "Пэндзлік з грубым свіным шчэццем. Інструмент для не надта тонкай працы.";
end
end;

found_in = 'ecyudnik';
}

--эцюднік
obj {
-"эцюднік/мр";
nam = "ecyudnik";
description = function(s)
pn "Драўляная скрынка з вечкам і скураной лямкай, што перакідваецца праз плячо."
return false
end;
init_dsc = "У куце ляжыць эцюднік.";
before_Take = function () p [[Эцюднік Аляксандры не патрэбны.]] return true end;
found_in = 'maysternya';
}:attr '~animate, container,openable'

--фарбы ў эцюдніку
obj {
-"фарбы,слоікі,слоічкі,рэчы, інструменты/мн|драбяза/жр";
nam = "farby";
bachyu = false;
description = function(s)
if not _'piyanina_i_shklo'.bachyu then
p "У эцюдніку можна знайсці ўсё, што толькі можа спатрэбіцца мастаку на свежым паветры, варта толькі добра пашукаць.";
elseif _'piyanina_i_shklo'.bachyu and _'dzen_drugi':has'visited' and not s.bachyu then
s.bachyu = true;
p [[Аляксандра абводзіць позіркам фарбы: "Хм, а белай засталося не так і шмат. На тое, каб размаляваць карнізы не хопіць, -- заклапочана хмурыцца, раздумваючы, потым твар яе святлее. -- Ведаю, што рабіць. Сямён збіраўся на днях асвяжыць сёе-тое ў садзе. Трэба ўзяць фарбу ў яго, калі яму не трэба! А чорнай у скрынцы наогул няма. Дзе я ёй карысталася апошнім разам? Мусіць, там і пакінула.".]];
elseif s.bachyu then
p "У эцюдніку можна знайсці ўсё, што толькі можа спатрэбіцца мастаку на свежым паветры, варта толькі добра пашукаць.";
end
end;

dsc = "У эцюдніку ляжаць слоічкі з алейнымі фарбамі і розная драбяза.";

before_Take = function () p [[У эцюдніку няма патрэбных фарбаў.]] return true end;

--функцыя абшукаць, каб можна было знайсці ў фарбах сцізорык
znayshou_scizoryk = false;
['Search,LookUnder'] = function(s)
if not s.znayshou_scizoryk then
s.znayshou_scizoryk = true;
_'noj':enable()
pn "Аляксандра парылася ў змесціве эцюдніка і знайшла сцізорык."
else
pn "Нічога карыснага тут больш няма.";
end
end;

found_in = 'ecyudnik';
}:attr 'static'

--сцізорык --ножык
obj {
-"сцізорык,ножык,нож/мр";
nam = "noj";
description = "Ножык з пажоўклай касцяной рукаяткай і вострым лязом.";
init_dsc = "Між слоічкаў з фарбай ляжыць, паблісквае невялікі ножык.";
found_in = 'ecyudnik';
}:attr 'атрибут':disable()

--пашыраем спіс дадатковых дзеясловаў для дзеяння рэзаць
VerbExtendWord {"#Cut",
"[|на|за]вастр[ыць|ыла|ы|у],[|за]тач[ыць|ыла|у|ы],рэ[заць|зала|жу|ж]"
}

--стос карцін
obj {
-"стос карцін,стос/мр|карціны/мн";
nam = "stos";
before_Take = function () p [[Аляксандры гэта зараз не трэба.]] return true end;

['before_Push,Pull'] = function(s)
p [[За карцінамі нічога няма. Хай стаяць сабе.]] return true end;

description = "Гатовыя карціны на лёгкіх падрамніках састаўлены стосам. На іх пераважна краявіды, што атачаюць сядзібу, віды гарадскіх вулачак, ёсць колькі нацюрмортаў.";
dsc = "Да сцяны прыхінуты стос карцін.";
found_in = 'maysternya';
}:attr 'static'

--чарнавікі
obj {
-"купа чарнавікоў,купа/жр|чарнавікі,накіды,малюнкі,эцюды/мн";
nam = "kupa";
before_Take = function () p [[Аляксандры гэта зараз не трэба.]] return true end;

bachyu = false;
description = function(s)
--калі гулец разглядаў фарбы ў эцюдніку і ў першы раз глядзіць на купу чарнавікоў
if _'farby'.bachyu and not s.bachyu then
s.bachyu = true;
p "Цэлая купа накідаў, зробленых алоўкам, акварэльныя замалёўкі, невялічкія алейныя эцюды на картонках. ^На самым верхнім эцюдзе паказаны від на пад'яздную алею. ^На малюнку шмат зялёнага і чорнага. Аляксандра адпрацоўвала спалучэнні зялёнай лістоты і ценяў у глыбіні шатаў. Вось дзе, хутчэй за ўсё, чорная фарба згубілася! Трэба схадзіць туды і пашукаць.";
else
p "Цэлая купа накідаў, зробленых алоўкам, акварэльныя замалёўкі, невялічкія алейныя эцюды на картонках. ^На самым верхнім эцюдзе паказаны від на пад'яздную алею. ^На малюнку шмат зялёнага і чорнага.";
end
end;
dsc = "На паліцы ляжыць купа чарнавікоў і эцюдаў.";
found_in = 'palica';
}:attr 'static'

--сцены майстэрні і калідора
obj {
-"сцены/мн";
description = "Сцены пафарбаваны ў светлы колер.";
found_in = {'maysternya', 'kalidor'};
}:attr 'scenery'


--аб'екты алеі. лакацыі сад і вязы
obj {
-"плямы святла, плямы, промні/мн";
description = "расплывістыя жаўтлявыя плямы святла з'яўляюцца і знікаюць, поўзаюць па зацененай дарожцы, паслухмяныя настрою лістоты, што варушыцца ўверсе.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"дарожка,сцежка/жр|жвір,пясок/мр";
description = "Дарожка алеі пасыпана буйным жвірам, што парыпвае пад нагамі.";
Touch = "Пясок вільготны і зярністы.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"неба/ср";
description = "Блакіт неба на секундачку ўзнікае ў прагалах варухлівага лісця і тут-жа знікае, каб з'явіцца ў іншым месцы.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"лісце/ср|лістота/жр|шаты, кроны/мн|засень,цень,паўзмрок,змрок/мр";
description = "Уверсе цягнуцца і скрыжоўваюцца цені сукоў. Лістота вязаў настолькі густая, што промням цяжка пратачыцца да зямлі. Усё вакол патанае ў цёмна-зялёным засені, бы на дне возера.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"ліст,лісток,лісточак|мр";
description = "Лісце зубчастае па краі.";
Touch = "Ліст вяза шчыльны і прахалодны на дотык. Зубчыкі злёгку драпаюць далонь.";
found_in = {'sad_i_vyazy', 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"сонечны зайчык, зайчык/мр|комель дрэва, комель/мр|ствол дрэва, ствол/мр|кара,трэшчына,трэшчынка,шчыліна,шчылінка/жр";
description = "Сонечны зайчык паўзе па камлі ўніз, высвечваючы кожную трэшчынку на шэрай кары.";
Touch = "Кара дрэва вельмі шорсткая і грубая на дотык. Сонечны зайчык імгненна пераскочыў на далонь. Аляксандра цешыцца ласкавым цяплом травеньскага сонейка.";
found_in = {'sad_i_vyazy', 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"трава/жр";
description = "Трава пад дрэвамі вельмі высокая і густая.";
Touch = "Трава пругкая і вільготная надотык.";
found_in = { 'sad_i_vyazy2'} ;
}:attr 'scenery'

obj {
-"вязы,дрэвы/мн";
description = "Гэтыя дрэвы, а яшчэ ліпа-волат на паўднёвым усходзе, напэўна, самыя старыя насельнікі гэтай сядзібы, старэйшыя нават за дом. Ад старой гасподы нічога не засталося, акром каменнага падмурка. Яна пайшла дымам сто гадоў таму, калі горад спалілі казакі.";
found_in = {'sad_i_vyazy', 'sad_i_vyazy2'} ;
}:attr 'scenery'

--аб'екты саду. Спачатку універсальныя
--дрэвы
obj {
-"дрэвы/мн";
description = "Зеляніна па-травеньску яркая і свежая.";
found_in = {'sad_i_lipa', 'sad_i_altanka'};
}:attr 'scenery'

obj {
-"неба/ср|воблака/ср|аблокі,аблачынкі,хмаркі,хмурынкі/мн|аблачынка,хмурынка/жр";
description = "Неба зацягнута смугой лёгкіх-лёгкіх, амаль празрыстых аблокаў. Дзе-нідзе пракідваецца лапік-другі блакіту. Сонца вызірне на хвіліну якую і тут-жа хаваецца за аблачынку. Не сказаць каб цёпла, хутчэй прахалодна, таму лепей накінуць што-небудзь на плечы, тады зусім добра.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy', 'sad_i_barbarys' };
}:attr 'scenery'

obj {
-"сонца,сонейка,свяціла/ср";
description = "Сонца амаль заўсёды хаваецца за высокімі празорыстымі аблокамі.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy', 'sad_i_barbarys' };
}:attr 'scenery'

obj {
-"зямля,глеба/жр|дол/мр";
description = "Зямля шэраватая, цёмная ад вільгаці.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy', 'sad_i_barbarys' };
}:attr 'scenery'

obj {
-"мурог, дзірван/мр|трава/жр";
description = "Трава ахайна падкошаная. Зяленіва выглядае свежа і радуе вочы.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

--дом знадворку
obj {
-"дом, будынак/мр|сядзіба, гаспода/жр";
nam = "dom";
description = function(s)
pn "Аднапавярховы дом з чарапічным дахам. Ашаляваныя сцены зараслі плюшчам. У шыбах люструецца неба."
return false
end;
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'enterable,supporter,static, concealed'

obj {
-"дах/мр";
description = "Пакаты чатырохскатны дах пакрыты цёмна-чырвонай чарапіцай.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"чарапіца, гліна/жр";
description = "У чарапіцы дыхтоўны цёмна-чырвоны колер, які вельмі добра глядзіцца на фоне неба.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"коміны, трубы/мн|комін/мр|труба/жр";
description = "З даху вытыркаюцца чатыры коміны.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"сцены/мн|шалёўка/жр";
description = "Сцены дома абшыты шалёўкай, пафарбаванай у вохрысты колер.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"плюшч/мр|";
description = "Зялёныя сэрцайкі лістоў плюшчу варушацца ад ветру.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"акно/ср|пераплёт/мр|вокны/мн";
description = "Акно ўзята ў прастакутны двухстворкавы пераплёт на шэсць шыбак.";

before_Touch2 = function(s)
if _'dzen_drugi':hasnt'visited' then
pn "С какой стати?";
else
pn "Александра намерена разрисовать карнизы, а не окна.";
end
end;

found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"шыбы,шыбкі/мн|шкло/ср";
description = "У шыбах люструюцца аблокі і зусім трошкі чыстага блакіту.";
found_in = { 'sad_i_lipa', 'sad_i_altanka', 'sad_i_slivy', 'sad_i_vyazy' };
}:attr 'scenery'

--карніз знадворку
obj {
-"карніз/мр|бляха/жр";
nam = "karniz2";

before_Take = function () p [[Навошта гэта рабіць?]] return true end;
bachyu = false;
description = function(s)
if _'razmalyavala_karniz':has'visited' and not s.bachyu then
s.bachyu = true;
p "Карніз нахабна шчэрыцца белазубай усмешкай, з канца ў канец размаляваны ў белыя клавішы, паміж якімі чарнеюць паўтаны: Ён так і просіць, каб па клавішах пабарабанілі пальцы. Адразу відаць, што гэта -- дом кампазітара. У якога нават дождж не проста так стукае, а музыку грае.";
elseif _'razmalyavala_karniz':has'visited' and s.bachyu then
p "Карніз з канца ў канец размаляваны ў белыя клавішы, паміж якімі чарнеюць паўтаны.";
else
p "Бляшаны карніз пафарбаваны някідкай шэрай фарбай, каб яго не ела іржа.";
end
end;

dsc = "Аляксандра бачыць тут карніз.";
nanyos_beluyu = false;
Touch2 = function(s, t)
if not have ('pendzlik') or not have ('belaya') or not have ('chornaya') then
pn "Для працы патрэбны пэндзлік, а таксама белая і чорная фарбы.";
elseif not _'pendzlik'.abmaknuu then
pn "Спачатку трэба абмакнуць пэндзлік у фарбу.";
elseif _'pendzlik'.abmaknuu and not s.nanyos_beluyu then
s.nanyos_beluyu = true
walk 'razmalyavala_karniz'
end
end;

found_in = {'dom' };
}:attr 'static'

obj {
-"алея/жр|вязы/мн";
description = "Два шэрагі высокіх купчастых дрэў вядуць на поўнач, паступова робячыся ніжэй. Аляксандра шмат разоў малявала іх -- на вязах алеі цудоўна практыкавацца ў маляванні перспектывы.";
found_in = { 'sad_i_lipa', 'sad_i_vyazy' };
}:attr 'scenery'

obj {
-"альтанка, пабудова/жр";
description = "На поўдзень адсюль, ды крыху правей дікаватыя кусты бэзу, за якімі бялее зграбная альтанка.";
found_in = { 'sad_i_lipa' };
}:attr 'scenery'

--ліпа ў кветніку
obj {
-"ліпа, дрэва, крона/жр|комель,ствол/мр";
nam = "lipa";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

dsc = "Ліпа затуляе палову неба.";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
pn "Звычайна ліпы не такія, а гэта - проста цар-дрэва. Крона вялікая і пульхная, як зялёнае воблака. Ад самай зямлі комель дзеліцца на шэсць ствалоў, якія паволі разыходзяцца ва ўсе бакі. Бацька казаў, што гэтую ліпу пасадзілі яшчэ пры ягоным прадзедзе."
return false
else
pn "Крона ліпы вялікая і пульхная, як зялёнае воблака. Ад самай зямлі комель дзеліцца на пяць ствалоў, якія паволі разыходзяцца ва ўсе бакі."
return false
end
end;
found_in = { 'sad_i_lipa' };
}:attr 'enterable,supporter,static'

--лавачка пад ліпай
obj {
-"лавачка/жр";
nam = "lavachka2";
Enter = function(s,w)
pn "Аляксандра адкінулася на спінку лавачкі і задаволена ўздыхнула.";
move(me(), 'lavachka2');
end;

before_Take = function () p [[Навошта гэта рабіць?]] return true end;

bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'gazeta':enable()
p "Зялёная лавачка прыхінаецца спінкай да камля ліпы."
return false
else
p "Зялёная лавачка прыхінаецца спінкай да камля ліпы."
return false
end
end;
dsc = "За ліпай прытулілася лавачка.";
before_Touch = [[Фарба на лавачцы даўно не паднаўлялася, памалу абсыпаецца ўжо.]];
found_in = 'sad_i_lipa';
}:attr 'enterable,supporter,static'

obj {
-"дарожкі, сцежкі/мн";
description = "Шэрыя вузенькія стужкі вытаптанай зямлі прыхаматліва віюцца між клумбаў туды-сюды. Па іх можна блукаць гадзінамі, калі одум находзіць.";
found_in = { 'sad_i_lipa' };
}:attr 'scenery'

obj {
-"клумбы, кветкі, астры, касачы, рамонкі/мн";
description = "Тут клумба астраў буяе чырванню, там -- густа-ліловыя касачы, быццам вечаровае неба пакінула хусціну. А вунь міла бялее дзялянка садовых рамонкаў. Тонкія пялёсткі трымцяць пад лагодным ветрыкам.";
found_in = { 'sad_i_lipa' };
}:attr 'scenery'

--аб'екты сад і вязы
--пах фарбы ў лакацыі. службовы аб'ект
obj {
nam = "pah";
deskripshen = "Пахне свежай фарбай.";
dsc = "Пахне свежай фарбай.";
found_in = 'sad_i_vyazy';
}:attr 'атрибут'

--лавачка каля веранды
obj {
-"лавачка/жр";
nam = "lavachka";
before_Enter = function () p [[Э не, лавачка нядаўна пафарбаваная!]] return true end;

before_Take = function () p [[Навошта гэта рабіць?]] return true end;

bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'pah':disable()
p "Драўляная лавачка са спінкай, пафарбаваная ў белы колер. На ёй так хораша чытаць Гётэ."
return false
else
p "Драўляная лавачка са спінкай, пафарбаваная ў белы колер. На ёй так хораша чытаць Гётэ."
return false
end
end;

before_Touch = [[Ліпкаватая навобмацак. Фарба яшчэ не падсохла як след.]];
found_in = 'sad_i_vyazy';
}:attr 'enterable,supporter,static,transparent'

--веранда. --двое аднабаковых дзвярэй, каб зладзіць веранду
door {
-"веранда, тэраса/жр|уваход, ганак/мр|уваходныя дзверы, дзверы/мн";
nam = "veranda";
description = "Уваход у дом зладзілі ў выглядзе зашклёнай веранды, што цягнецца ўздўж усёй паўночнай сцяны. Там, усярэдзіне, ёсць нават невялікі камін. Так хораша ў халодную пару запаліць у ім агонь і паглядваць з цяпла на алею, бавячыся вышыўкай ці маляваннем, ці проста гарбатку з Казімірам піць.";
found_in = 'sad_i_vyazy';
door_to = function(s)
if here() ^ "sad_i_vyazy" and not have ('shal') then
pn "Паставіўшы нагу на прыступку, Аляксандра ўспомніла, што кінула недзе шаль. Не трэба пакідаць любімую рэч абы дзе: набярэцца вільгаці -- трэба забраць з сабой.";
elseif here() ^ "sad_i_vyazy" and have ('shal') then
walk 'kalidor'
pn "Аляксандра ўзнялася па прыступках, прамінула веранду і зайшла ў дом.";

end
end;

}:attr 'static, open, concealed';

--выхад з дому
door {
-"выхад на веранду, выхад/мр|дзверы на веранду, дзверы веранды, зашклёныя дзверы, дзверы/мн";
nam = "veranda2";
description = "Скрозь каламутныя шыбкі, устаўленыя ў дзверы, крыху праглядаецца веранда. З веранды ёсць выхад у сад.";
found_in = 'kalidor';
door_to = function(s)
if here() ^ "kalidor" and _'dzen_drugi':hasnt'visited' then
pn "Аляксандры не хочацца выходзіць з дому. Лепей пабыць у гасцёўні разам з мужам і дажджом у акне.";
elseif here() ^ "kalidor" and _'dzen_drugi':has'visited' and not have ('shal') then
pn "Пасля начнога дажджу ў садзе занадта свежа. Трэба накінуць шаль.";
elseif here() ^ "kalidor" and _'dzen_drugi':has'visited' and have ('shal') then
pn "Прайшоўшы скрозь веранду, Аляксандра збегла з прыступак і апынулася на вуліцы.";
walk 'sad_i_vyazy'
end
end;

}:attr 'static, open, concealed';

--аб'екты Сад і альтанка
--альтанка. уяўляе сабой комплекс аб'ектаў. дзверы для ўваходу ў лакацыю "у альтанцы". сама лакацыя "у альтанцы і выхад з яе назад у лакацыю "сад і альтанка"". 
-- а таксама група аб'ектаў, якія апісваюць яе часткі
--спачатку аб'ект-уваход для саду, каб прайсці ў альтанцы
door {
-"альтанка, пабудова/жр|збудаванне/ср";
nam = "altanka";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = "Шатровы дах альтанкі абапіраецца на шэсць драўляных слупоў, злучаных балюстрадай. ^Уваход у альтанку на ўсходзе.";
dsc = "Вытанчаная белая пабудова стаілася сярод кустоў бэзу.";
found_in = 'sad_i_altanka';
door_to = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
pn "Аляксандра пераступае праз парожак і заходзіць у альтанку. ^Галінка з шолахам вярнулася на месца.";
walk 'u_altancy'
else
pn "Галінка бэзу замінае прайсці.";
end
end;

}:attr 'static, open, openable';

--аб'ект-выхад для локі "у альтанцы", каб трапіць вонкі ў локу "сад і альтанка"

door {
-"выхад/мр";
nam = "altanka2";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = "Выхад з альтанкі на захадзе.";
found_in = 'u_altancy';
door_to = function(s)
if _'galinka'.adsunuu then
_'galinka'.adsunuu = false;
pn "Аляксандра выходзіць вонкі. Галінка з шолахам вярнулася на месца.";
_'player':move'sad_i_altanka'
else
pn "Галінка бэзу замінае выйсці.";
end
end;

}:attr 'static, open, concealed';

--кусты бэзу. --бэз
obj {
-"кусты бэзу, кусты, зарасці/мн|бэз, зараснік/мр|праход, уваход, ўваход/мр|кустоўе/ср";
nam = "bez";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = function(s)
pn "Высокія кусты бэзу абступаюць альтанку з усіх бакоў. У траўні, калі на галінках поўна ліловых суквеццяў ад водару кружыцца галава: дыхаць не надыхацца. У адным месцы яны расступаюцца, утвараючы нешырокі праход, які дазваляе прайсці ўсярэдзіну альтанкі. Аляксандра наказала Сямёну, каб ён не надта шчыраваў з нажніцамі, таму кусты выглядаюць крыху дзікавата, сапраўднны зараснік."
return false
end;
dsc = function(s)
p "";
return false
end;
found_in = { 'sad_i_altanka', 'u_altancy' };
}:attr 'static, transparent, supporter, container, open'

--галінка бэзу
obj {
-"галінка,галіна/жр";
nam = "galinka";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = "Галінка бэзу замінае зайсці ў альтанку.";
dsc = "Галінка нахілілася, загароджваючы праход.";

adsunuu = false;
['before_Push,Pull'] = function(s)
if not s.adsunuu then
s.adsunuu = true;
p "Аляксандра адсунула галінку ўбок, каб вызваліць шлях.";
else
s.adsunuu = false;
p "Галінка зноў звесілася ўпоперак праходу.";
end
end;

found_in = {'sad_i_altanka', 'u_altancy'};
}:attr 'static'

--дах і слупы альтанкі
obj {
-"дах альтанкі, дах/мр";
description = "Гонтавы дах альтанкі абапіраецца на шэсць драўляных слупоў.";
found_in = 'sad_i_altanka';
}:attr 'scenery'

--слупы альтанкі
obj {
-"слупы/мн";
nam = "slupy";
bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'pah2':disable()
p [[Слупы альтанкі пафарбаваны ў белы колер. Іх злучае празорыстая балюстрада вышынёй па-пояс.]];
else
p "Слупы альтанкі пафарбаваны ў белы колер. Іх злучае празорыстая балюстрада вышынёй па-пояс.";
end
end;
before_Touch = [[Слупы яшчэ ліпкія. Фарба свежая.]];
found_in = {'sad_i_altanka', 'u_altancy'} ;
}:attr 'scenery'

--балюстрада альтанкі
obj {
-"балюстрада/жр|парэнчы,поручні/мн";
description = "Разная балюстрада атачае альтанку. Паўз фігурныя слупкі дзе-нідзе зазіраюць усярэдзіну галінкі бэзу.";
found_in = 'sad_i_altanka';
}:attr 'scenery'

--аб'екты у альтанцы
--пах фарбы ў лакацыі. службовы аб'ект
obj {
nam = "pah2";
dsc = "Пахне свежай фарбай.";
found_in = 'u_altancy';
}:attr 'атрибут'

--стол у альтанцы
obj {
-"стол/мр";
nam = "stol3";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = function(s)
pn "Шасцікутная стальніца абапіраецца на адну тоўстую нагу, укапаную ў зямлю."
return false
end;

found_in = 'u_altancy';
}:attr 'static, transparent, supporter, container, open'

--лавачкі ў альтанцы
obj {
-"лавачкі, лаўкі/мн|лавачка, лаўка/жр";
nam = "lavachki";
before_Enter = function () p [[Але лавачкі нядаўна пафарбаваныя. Фарба зусім свежая.]] return true end;

before_Take = function () p [[Навошта гэта рабіць?]] return true end;

bachyu = false;
description = function(s)
if not s.bachyu then
s.bachyu = true;
_'pah2':disable()
p "Пяць лавачак атачаюць стол. Толькі з боку ўвахода вольна. Замест спінак - разная балюстрада."
return false
else
p "Пяць лавачак атачаюць стол. Толькі з боку ўвахода вольна. Замест спінак - разная балюстрада."
return false
end
end;

before_Touch = [[Лавачкі яшчэ ліпкія. Фарба свежая.]];

found_in = 'u_altancy';
}:attr 'enterable,supporter,static,transparent'

--белая фарба
obj {
-"белая фарба, фарба, белая/жр|слоік/мр";
nam = "belaya";
description = "У слоіку дастаткова шмат белай алейнай фарбы.";
init_dsc = "Слоік, уквэцаны ў белую фарбу, стаіць пад лавачкай.";
found_in = 'u_altancy';

--функцыя дазваляе абмакнуць пэндзлік у белую фарбу. Усё астатняе абмакваць забараняе
after_Receive = function(s, w)
if not _'pendzlik'.abmaknuu and w ^ "pendzlik" then
_'pendzlik':move'player'
_'pendzlik'.abmaknuu = true
pn "Аляксандра абмакнула пэндзлік у белую фарбу.";
elseif s.abmaknuu and w ^ "pendzlik" then
pn "Не трэба -- белая фарба на пэндзліку і так ёсць.";
elseif not w ^ "pendzlik" then
 return "Не трэба соваць у фарбу што папала!", true
 end
end

}:attr '~animate, open, container, transparent'

--аб'екты лакацыі "Сад і слівы"
--слівы
obj {
-"слівы, дрэвы, дрэўцы,галіны,галінкі/мн";
nam = "slivy";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = "Зграбныя невысокія дрэвы купаюцца ў белай квецені. У жніўні іх галіны будуць сінімі ад багатага ўраджаю.";
found_in = 'sad_i_slivy';
}:attr 'scenery'

--галінка слівы
obj {
-"галінка слівы, галінка/жр";
nam = "galinka2";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = function(s)
pn "На бязлістай па гэтым часе галінцы поўна пушыстых белых суквеццяў."
return false
end;

dsc = function(s)
p "";
return false
end;

found_in = 'sad_i_slivy';
}:attr 'enterable,supporter,static,transparent'

--квецень сліў
obj {
-"квецень/жр|суквецці,кветкі,кветачкі/мн";
description = "Белыя пялёсткі кветак варушацца пад ветрыкам. .";
found_in = 'sad_i_slivy';
}:attr 'scenery'

--алея
obj {
-"алея вязаў,алея/жр|вязы/мн";
description = "Адсюль відаць, як на поўнач ад дома цягнуцца два шэрагі старых дрэў. Каб трапіць туды, трэба прайсціся на паўночны ўсход.";
found_in = 'sad_i_slivy';
}:attr 'scenery'

--бэз у слівовым садзе
obj {
-"зарасці бэзу,зарасці,кусты/мн|кустоўе/ср|бэз/мр";
description = "На паўднёвым усходзе бачны густыя зарасці бэзу, па-над якімі вытыркаецца пакаты дах альтанкі.";
found_in = 'sad_i_slivy';
}:attr 'scenery'

--аб'екты лужок каля алеі
--барбарыс
obj {
-"куст барбарысу,куст,барбарыс/мр|галіны,галінкі,лісты/мн";
nam = "barbarys";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

bachyu = false;
description = function(s)
if _'kupa'.bachyu then
pn "Куст з лістамі прыгожага бурачковага колеру расце пасярод лужка. Гэта барбарыс. Аляксандры дужа падабаецца, як ён пахне. Можа, чорная фарба згубілася недзе тут?"
else
pn "Куст з лістамі прыгожага бурачковага колеру расце пасярод лужка. Гэта барбарыс. Аляксандры дужа падабаецца, як ён пахне."
end
end;

--функцыя абшукаць, каб можна было знайсці чорную фарбу пад кустом
znayshou_chornuyu = false;
['Search,LookUnder'] = function(s)
if _'kupa'.bachyu then
s.znayshou_chornuyu = true;
_'chornaya':enable()
pn "Аляксандра абыйшла куст кругом, пільна прыглядаючыся, і знайшла прапажу."
else
pn "Аляксандра зазірнула пад ніжнія галіны куста, але нічога асаблівага там не заўважыла.";
end
end;

found_in = 'sad_i_barbarys';
}:attr 'static'

--разнатраўе на лужку
obj {
-"разнатраўе/ср|трава/жр|травы,кветкі/мн";
nam = "raznatraue";
before_Take = function () p [[Навошта гэта рабіць?]] return true end;

description = "Траву на гэтым лужку не чапае каса і таму галоўкі някідкіх кветак пагойдваюцца ці не ля самых каленяў.";

dsc = "Травы калываюца пад ветрам.";
found_in = 'sad_i_barbarys';
}:attr 'static'

--алея
obj {
-"алея/жр|вязы,дрэвы/мн";
description = "Строй старых вязаў цягнеццана ўсходзе. Прабраўшыся між камлямі, можна трапіць на дарожку алеі.";
found_in = 'sad_i_barbarys';
}:attr 'scenery'

--чорная фарба
obj {
-"чорная фарба, фарба, чорная/жр|слоічак чорнай фарбы, слоік чорнай фарбы, слоічак/мр";
nam = "chornaya";
description = "Невялікая керамічная пасудзінка з чорнай алейнай фарбай.";
init_dsc = "Слоічак чорнай фарбы стаіць пад галінамі барбарысу.";

--функцыя дазваляе паспрабаваць абмакнуць пэндзлік у чорную фарбу. Усё астатняе абмакваць забараняе
after_Receive = function(s, w)
if w ^ "pendzlik" then
_'pendzlik':move'player'
pn "Не-не, спачатку трэба расфарбаваць карніз у белы колер! ";
elseif not w ^ "pendzlik" then
 return "Не трэба соваць у фарбу што папала!", true
 end
end;

found_in = 'sad_i_barbarys';
}:attr '~animate, open, container, transparent':disable()

--каманда пісаць распісаць, размаляваць для аркуша і карніза
Verb {
"#Touch2",
"[|на|за]пі[саць|сала|ша|свае|шам],[|раз]мал[яваць|явала|ёўваць|ёўвае|юе|юем],[|па|за|пад|рас]фарб[аваць|авала|уе|уй|уем|оўвае|оўваем]";
"па {noun}/пр : Touch2",
"на {noun}/пр : Touch2",
" {noun}/вн : Touch2",
}

--катсцэна пасля разглядвання адбітку клавіятуры. Надыходзіць новы дзень. --дзень другі
cutscene {
nam = 'dzen_drugi',
title = "Дзень другі";
text = {
[[]];
[[Шчыра сказаць, Аляксандра ледзьве дачакалася наступнага дня. Круцілася пад коўдрай палову ночы, уяўляючы, як будзе выглядаць дом звонку і з сярэдзіны з карнізамі, распісанымі пад фартэпіянную клавіятуру, і ёй ўсё больш і больш здавалася, што гэта будзе проста казачна, хацелася падскочыць і бегчы па фарбы проста зараз жа, але ноч цягнулася і цягнулася. Неўпрыкмет Аляксандра заснула.]];
[[І вось ён -- доўгачаканы дзень. Пасля сняданку Казімір замкнуўся ў кабінеце і адтуль то гамоніць, то замаўкае раяль: муж заняўся творчасцю. Пара і ёй брацца за фарбы. Пальцы аж смыляць ад нецярплівасці..]];
};
exit = function(s, t)
walk 'maysternya'
_'kazimir':move'zedlik'
_'arkush':move'stol2'
_'gascyounya_i_pounya':disable()
_'gascyounya_i_pounya2':disable()
_'gascyounya_i_kropli':disable()
_'gascyounya_i_kropli2':disable()
_'piyanina_i_shklo':disable()
_'kalidor_i_rayal':enable()
_'shal':enable()
DaemonStart('maysternya') -- пачынае працаваць дэман, які дае гульцу падказку ў другі дзень
end;
}

--катсцэна пасля таго, як гулец пачне размалёўваць карніз
cutscene {
nam = 'razmalyavala_karniz',
title = "";
text = {
[[Аляксандра замуркала пад нос песеньку. Пэндзлік пачаў гойсаць па карнізе. І вось уся паверхня бялее свежай фарбай.]];
[[Пэндзлік нырнуў у чорную фарбу і пачаў акуратна выпісваць чорныя клавішы і шчыліны між белымі.]];
[[Скончыўшы працу над карнізам, Аляксандра перайшла да наступнага, потым да яшчэ аднаго… Спынілася толькі тады, калі ўсе карнізы дома весела вышчэрыліся піяніннымі клавішамі. ^Мастачка скіравалася ў дом і задаволена ўздыхнула: "Ну вось, а цяпер можна вярнуцца ў гасцёўню і скончыць верш. Цяпер гэта можна зрабіць."]];
};
exit = function(s, t)
walk 'gascyounya'
_'kazimir':move'zedlik'
_'karniz1'.bachyu = false;
DaemonStart('gascyounya') -- дэман падказвае дапісаць верш
end;
}

--катсцэна пасля таго, як гулец аддасць аркуш казіміру
cutscene {
nam = 'dzen_treci',
title = "Новы вечар і новы дождж";
text = {
[[]];
[[А ў наступны вечар ізноў быў дождж: фарба акурат паспела добра высахнуць. Аляксандра з Казімірам сядзелі поруч, пілі гарбату і моўчкі назіралі, як кроплі азартна малоцяць па намаляваных клавішах. Казімір не адрываў вачэй ад карнізу, іншым разам усміхаўся, мусіць, чуў у думках сваю музыку.]];
};
exit = function(s, t)
walk 'kanec'
end;
}

room {
nam = "kanec";
title = "КАНЕЦ";
dsc = [[Віншую! вы прайшлі гульню. ^^Падчас напісання гульні я шмат усміхаўся. Рысы няўрымслівай гераіні я шмат у чым спісаў з характару маёй каханай. ^Дзякуй Пятру Касых за выдатны бэта-тэстынг! Ягоныя заўвагі і прапановы зрабілі гульню лепшай. ^Гомель. Снежань 2025 года.]];
noparser = true; -- цалкам адключаем увод каманд
}

game : dict {
["фарфоравая чарніліца/рд"] = "фарфоравай чарніліцы";
["фарфоравая чарніліца/вн"] = "фарфоравую чарніліцу";
["фарфоравая чарніліца/дт"] = "фарфоравай чарніліцы";
["фарфоравая чарніліца/тв"] = "фарфоравай чарніліцай";
["фарфоравая чарніліца/пр"] = "фарфоравай чарніліцы";
}

