-- $Name:Возрождение: Проект АЛЬФА$
-- $Version:0.03$
-- $Name(ru):Возрождение: Проект АЛЬФА$

require 'fmt' -- некоторые функции форматирования
fmt.para = true -- включить режим параграфов (отступы)
require 'noinv'
require 'snd'
require 'sprite'
require 'theme'

game.act = 'Не работает.';
game.use = 'Это не поможет.';
game.inv = 'Зачем мне это?';

global {
	Str = 4;
	Agl = 4;
	Int = 4;
	Life = 8;
	Points = 5;
	Bruiser = 0;
	FastShot = 0;
	FourEyes = 0;
	HeavyHanded = 0;
	OneHander = 0;
	SmallFrame = 0;
	Berserk = 0;
	Safecracker = 0;
	Hacker = 0;
	Tinkerer = 0;
	Enemy = 0;
	UN = 4; -- unarmed
	SG = 0; --small guns
	BG = 0; --big guns
	EG = 0; --energy guns
	ammo10mm = 20;
	ammo12ga = 0;
	ammo223fmj = 0;
	se_cell = 0;
	flare = 0;
	stimpack = 0;
	gecko_pelt = 0;
	salt = 0;
	malur = 0;
	traiders = 0;
	power = 29;
	n1 = 0;
	n2 = 0;
	n3 = 0;
	n4 = 0;
	n5 = 0;
	n6 = 0;
	n7 = 0;
	n0 = 0;
	brain = 7;
};

function make_item(img, txt)
   local i = sprite.new(img)
   local fnt = sprite.fnt(theme.get 'win.fnt.name', sprite.font_scaled_size(theme.get 'win.fnt.size'))
   local text1 = fnt:text(txt, 'black')
   local text = fnt:text(txt, 'white')
   local w1, h1 = i:size()
   local w2, h2 = text:size()
   if w1 > w2 then
		text1:draw(i, (w1 - w2), (h1 - h2))
		text:draw(i, (w1 - w2 - 1), (h1 - h2 - 1))
		return i
   end
end

function init()
	std.phrase_show = false;
	instead.hinv_delim = fmt.nb '  ';
end;

dofile "weapon.lua"
dofile "stuff.lua"

-------начало

dlg {
	nam = 'main';
	disp = false;
	pic = 'pic/display_main.png';
	onenter = function()
		pn (fmt.r(fmt.b('Инициализация протокола пробуждения - ОК')));
		snd.music 'bgm/Enclave.mp3';
		p 'Проснись!';
	end;
	phr = {
		{'Ещё минуточку.', function() pn (fmt.r(fmt.b('Физическое состояние - ОК'))); pn (fmt.r(fmt.b('Ментальное состояние - ОК'))); p 'Проснись!'; end;
			{'У меня выходной, отстань.', function() pn (fmt.r(fmt.b('Идентификация - ERROR'))); pn (fmt.r(fmt.b('База данных недоступна/повреждена'))); pn (fmt.r(fmt.b('Присвоен идентификатор J'))); p 'Проснись!'; end;
				{'Что происходит?', function() pn (fmt.r(fmt.b('Открытие капсулы - ОК'))); p 'Теплая жидкость окружающая меня внезапно стала исчезать. Потом крышка моего убежища открылась и я вывалился наружу. Через пару минут я смог встать на ноги и осмотреться.'; walk('Лаборатория Альфа'); end;};};};
	};
};

room {
	nam = 'Лаборатория Альфа';
	pic = 'pic/display_main.png';
	dsc = 'Какое-то помещение с металлическими стенами. Видны следы ржавчины. Тут есть две двери, над одной из них табличка "ВЫХОД".';
	obj = {'Капсулы', 'Шкафчики', 'Терминал'};
	way = {'Серверная', 'Тамбур'};
};

room {
	nam = 'Серверная';
	pic = 'pic/death2.png';
	dsc = 'Я вошёл в обширное помещение заполненное компьютерным оборудованием.';
	obj = {'Мозги'};
	way = {'Тамбур'};
}:disable();

dlg {
	nam = 'Терминал А';
	pic = 'pic/coding.gif';
	onenter = function()
		p 'Добро пожаловать в лабораторию Альфа, пользователь J.';
		if Str == 4 and Agl == 4 and Int == 4 then p 'Рекомендуется подключить Пип-Бой к терминалу и настроить показатели.' end;
	end;
	phr = {
		{cond = function() if Str == 4 and Agl == 4 and Int == 4 then return true end end, 'Настройка Пип-Боя.', function() p('Настройте жизненные показатели и укажите ваши особенности, если они есть. У вас есть '..Points..' свободных очков.') end;
			{true, cond = function() if Points > 0 then return true end end, function() p('Сила - '..Str..'. Добавить?'); end, function() Str = Str + 1; Life = Str*2; UN = Str; Points = Points - 1; p('Осталось свободных очков - '..Points); end};
			{true, cond = function() if Points > 0 then return true end end, function() p('Ловкость - '..Agl..'. Добавить?'); end, function() Agl = Agl + 1; Points = Points - 1; p('Осталось свободных очков - '..Points); end};
			{true, cond = function() if Points > 0 then return true end end, function() p('Интеллект - '..Int..'. Добавить?'); end, function() Int = Int + 1; Points = Points - 1; p('Осталось свободных очков - '..Points); end};
			{'Выбрать особенность.', 'Только одна особенность может быть выбрана.', only = true,
				{'Крушила - Движемся медленнее, зато повнушительнее. Плюс 2 к силе, минус 1 к ловкости. Противники всегда атакуют первыми.', function() Str = Str + 2; if Str > 10 then Str = 10; end; Agl = Agl - 1; Bruiser = 1; UN = Str; snd.play 'weapon_sounds/level_up.ogx'; end};
				{'Стрелок - Вы стреляете не раздумывая. Ваш палец всегда на спусковом крючке. Вы всегда атакуете первым.', function() FastShot = 1; snd.play 'weapon_sounds/level_up.ogx'; end};
				{'Очкарик - Вы получаете +1 к интеллекту, но только если наденете очки.', function() FourEyes = 1; snd.play 'weapon_sounds/level_up.ogx'; end};
				{'Тяжёлая рука - Главное — хорошо размахнуться, а целиться — дело десятое. Вы получаете +1 к силе, но только в рукопашном бою или с оружием ближнего боя.', function() HeavyHanded = 1; UN = Str + 1; snd.play 'weapon_sounds/level_up.ogx'; end};
--				{'Однорукий - Вы отлично управляетесь одной рукой, но двуручное оружие вызывает проблемы. Увеличенный урон для пистолетов и ножей, но большой штраф на урон для винтовок и пулеметов.', function() OneHander = 1; SG = SG + 2; BG = BG - 3; snd.play 'weapon_sounds/level_up.ogx'; end};
--				{'Миниатюрный - Возможно, вы несколько уступаете по комплекции своим собратьям, но это никогда вас не останавливало. Вы получаете +1 к ловкости, но не можете использовать тяжелое оружие.', function() Agl = Agl + 1; SmallFrame = 1; snd.play 'weapon_sounds/level_up.ogx'; end};
				{'Берсерк - Неистовая ярость охватывает вас при виде крови. Вы получаете +2 к силе в рукопашном бою, если вашего здоровья осталось меньше половины.', function() Berserk = 1; snd.play 'weapon_sounds/level_up.ogx'; end};
				{'Медвежатник - Щёлк, щёлк, скрип. Вы любите копаться в замках. Вы получаете +1 к ловкости при взломе любых механических замков.', function() Safecracker = 1; snd.play 'weapon_sounds/level_up.ogx'; end};
				{'Хакер - Зеленые цифры отражаются в ваших глазах, вы в своей стихии. Вы получаете +2 к интеллекту при работе с любыми электронными устройствами.', function() Hacker = 1; snd.play 'weapon_sounds/level_up.ogx'; end};
			};};
		{true, 'Медицинские операции.', 'Эта функция на данный момент недоступна. Библиотека неполна. Необходим модуль памяти, описывающий данную медицинскую процедуру. У вас есть такой модуль?',
			{cond = function() return have 'Красный модуль памяти' end, 'Вставить красный модуль памяти (увеличение силы).', function() p 'Процесс открытия капсулы запущен... Пожалуйста, ложитесь в капсуле и расслабьтесь.'; Str = Str + 1; if Str > 10 then Str = 10; end; snd.play 'weapon_sounds/level_up.ogx'; remove 'Красный модуль памяти'; walkout(); end};
			{true, 'Назад.', function() pop(); end};};
		{true, cond = function() if n2 == 1 and n3 == 1 and n4 == 1 and n5 == 1 and n6 == 1 and n7 == 1 then return true end end, 'Статус.', function() p('Лаборатория Альфа функционирует на '..(power - 8)..'%. Энергопитание - '..power..'%.'); end,
			{true, 'Управление энергоснабжением.', 'Основной источник питания - отключён. Резервный источник питания - включён.',
				{true, 'Перезапуск основного источника питания.', function() p 'ЗАПУСК - УСПЕШНО!^АКТИВИРОВАН ПРОТОКОЛ АЛЬФА^Пользователь J, займите место в капсуле и ожидайте.^^Одновременно дверь в тамбур закрылась, а внутренняя дверь открылась и оттуда вышел робот-часовой. Стволы его миниганов угрожающе нацелились на меня.'; walkout(); ways():disable(); objs():add 'Робот-часовой'; lifeon('Робот-часовой'); end};};};
		{true, cond = function() if n2 == 0 or n3 == 0 or n4 == 0 or n5 == 0 or n6 == 0 or n7 == 0 then return true end end, 'Статус.', function() p('Лаборатория Альфа функционирует на '..(power - 8)..'%. Энергопитание - '..power..'%.'); end,
			{true, 'Управление энергоснабжением.', 'Основной источник питания - отключён. Резервный источник питания - включён.',
				{true, 'Перезапуск основного источника питания.', 'Основной источник питания: ОШИБКА! ОШИБКА! ОШИБКА! Ошибка перезапуска системы.',
					{true, 'Диагностика.', 'Источник неисправности: отсутствует вода для генератора, нет ответа от насосов. Статус: отключен. Требуется ремонт. Активирован объект J. Сформировано задание.',
						{true, 'Вывести задание на экран.', function() p 'Исследовать пункты Лима, Новембер, Ромео. Восстановить связь, восстановить работу насосов. Поставлены отметки на карте в Пип-бой.'; pop(); end};};
					{true, 'Назад.', function() pop(); end};};
				{true, 'Статус резервного источника питания.', 'Деградация батарей 89%. Требуется ремонт. Активирован объект J. Сформировано задание.',
					{true, 'Вывести задание на экран.', function() p 'Исследовать окружающие населенные пункты. Обнаружить ядерные и микроядерные батареи. Заменить батареи в резервном источнике питания.'; pop(); end};};
				{true, 'Назад.', function() pop(); end};};
			{true, 'Управление насосами.', 'ОШИБКА! НЕТ СВЯЗИ!'};
			{true, 'Уровень воды.', function() p('Текущий уровень '..(115 - power)..'.'); end};
			{true, 'Назад.', function() pop(); end};};
		{true, cond = function() if Points > 0 then return true end end, 'Управление дверьми.', 'Доступ запрещён. Необходимо настроить Пип-Бой.'};
		{true, cond = function() if Points == 0 then return true end end, 'Управление дверьми.', 'Внутренняя дверь лаборатории - ОК. Внешняя дверь - ОШИБКА. Нет ответа.',
			{true, 'Открыть дверь в лабораторию.', function() p 'НЕДОСТАТОЧНЫЙ УРОВЕНЬ ДОСТУПА!'; end};
			{true, 'Открыть дверь в тамбур.', function() p 'ОК.'; enable('Тамбур'); end};
			{true, 'Открыть внешнюю дверь.', 'ОШИБКА. Нет ответа.'};
			{true, 'Назад.', function() pop(); end};};
		{true, 'Личные дела сотрудников.', 'ОШИБКА. Ошибка чтения памяти.'};
		{true, 'Исследования.', 'ОК',
			{true, 'Проект Альфа.', 'Я пролистал довольно большой файл с описанием "консервации", чтобы это не подразумевало, и возрождения человеческой цивилизации через 200 лет. Планируется клонировать несколько тысяч человек, что должно быть достаточно для восстановления популяции. Часто упоминается проект "АЛЬФА", а также проект "НОВЫЙ РАССВЕТ". Такое ощущение, что я уже это читал.'};
			{true, 'Назад.', function() pop(); end};};
		{true, 'Выход из программы.', function() walkout(); end};
	};
};

room {
	nam = 'Тамбур';
	pic = 'theme/display.png;pic/map.png@c210,325;pic/triangle.png@85,90';
	onenter = function()
		snd.music 'bgm/Gecko.mp3';
	end;
	dsc = 'Я вошёл в темный коридор. Только небольшой пятачок перед входом освещен мерцающей лампочкой над дверью.';
	obj = {'Стенной шкафчик', 'Темнота'};
	way = {'Лаборатория Альфа', path {'В лаз', 'Руины'}, path {'В лаз', 'Руины города'}};
	onexit = function(s, w)
		if w^'Руины' then
			p 'Обдирая плечи я выполз в какой-то подвал, а из него вышел на улицу.';
			return true;
		end;
	end;
}:disable();

room {
	nam = 'Руины';
	pic = 'theme/display.png;pic/map.png@c177,325;pic/triangle.png@85,90';
	dsc = 'Когда-то это был небольшой городок, но сейчас от большей части зданий остались только ободранные стены. Теперь надо решить куда я все-таки отправлюсь. В Пип-Бое отмечено три точки, на западе, юге и востоке.';
	way = {path {'В подвал', 'Тамбур'}, path {'На запад', 'Гекко'}, path {'На юг', 'Гекко'}, path {'На восток', 'Гекко'}};
	onexit = function(s, w)
		if w^'Гекко' then
			p 'Далеко я не ушёл. Город всё-таки оказался обитаемым, а я слишком невнимательным. На меня напали!';
			ways():disable();
			objs():add 'Гекко';
			here().pic = 'pic/gecko.png';
			if Bruiser == 1 then p 'Ящерица успела цапнуть меня за ногу.'; Life = Life - 2; end;
			if FastShot == 1 then
				snd.play 'weapon_sounds/10mm.ogg';
				p 'Но моя быстрая рука меня не подвела и ящерица верещит от боли!';
				Enemy = Enemy + SG;
				ammo10mm = ammo10mm - 1;
			end;
			return false;
		end;
	end;
}:disable();

room {
	nam = 'Смерть';
	pic = 'pic/death.png';
	dsc = 'Вы находите свою смерть в пустошах.';
	noinv = true;
};

room {
	nam = 'Конец';
	pic = 'pic/death2.png';
	dsc = 'Это оказалось последним моим решением. Следующие сто лет мой мозг служил в качестве вспомогательного процессора. Что причиняло бесконечные страдания остаткам личности в нём.';
	noinv = true;
};

room {
	nam = 'Титры';
	pic = 'pic/terminal.png';
	dsc = 'Этот квест с элементами РПГ написан специально для ЗОК2026. Надеюсь вам понравилось. Спасибо за прохождение.^^Irremann 14.02.2026';
	way = {path {'Побродить ещё по пустошам', 'Руины города'}};
	noinv = true;
};

dlg {
	nam = 'Разговор с Джейкобом';
	pic = 'theme/display.png;pic/map.png@c177,325;pic/triangle.png@85,90';
	onenter = 'Из-за угла вышел старик в потертой кожаной одежде, двухстволка в его руках ещё дымилась.^-- Эй парень, какого чёрта ты тут забыл? Гекко тут стадами бродят и только зевнёшь, как твою задницу откусили. Эй, ты же ранен. Пойдём, я подлатаю тебя.';
	phr = {
		{'Стоп, спасибо конечно за помошь, но кто ты?', '-- Я Джейкоб, это все знают.',
			{'Какой ещё Джейкоб?!', '-- Ха, а что есть ещё Джейкобы в нашей долине? Я думал я один с этим именем. Ферма у меня тут недалеко от города, я вот брамина своего искал, да видно уже не стоит искать. Да думал чего полезного в развалинах посмотреть. Но это зря, тут давно всё растащили. Так что ты зря парнишка тут рыщешь.',
				{'Долина?', '-- Благословенная наша долина. С севера и запада горы и скалы, на востоке пустошь необитаемая, на юге большие солёные топи. А мы тут посерёдке, как у Иисуса за пазухой.'};
				{'Брамин?', '-- Верёвку перегрыз и убёг, скотина двухголовая. По следам до города дошёл, а дальше увы. Достался на обед гекко, как пить дать. О, почти пришли уже.'};};};
		{true, 'Пойти за стариком.', function() p 'Идти было недалеко. Через час пути показалось потрепанное здание с плоской крышей.^-- Вот так и готово. -- Старик обработал мои раны и закрыл потрёпанный медицинский чемоданчик. -- Держи вот, поешь. И можешь отдохнуть на сеновале, там тебя никто не потревожит.'; take 'Мясо малура'; malur = 1; if Berserk == 1 and Life < Str then UN = UN - 3; end; Life = Str*2; walk('Ферма Джейкоба') end};
	};
};

room {
	nam = 'Ферма Джейкоба';
	pic = 'theme/display.png;pic/map.png@c23,273;pic/triangle.png@85,90';
	onenter = function()
		snd.music 'bgm/Klamath.mp3';
	end;
	dsc = 'Ферма Джейкоба - это небольшое одноэтажное здание, окна защищены решётками, дверь усилена стальным листом. На металле видны глубокие царапины. Перед входом есть небольшой навес.';
	obj = {'Джейкоб', 'Злаки'};
	way = {path {'На запад (Руины)', 'Руины города'}, path {'На юг', 'Перекрёсток'}, path {'На восток', 'Ферма Салливан'}, path {'На север', 'Водонапорная башня'}, path {'В дом', 'Дом Джейкоба'}, path {'В амбар', 'Амбар'}};
	onexit = function(s, w)
		if w^'Ферма Салливан' then
			p 'По пути мне встретились лишь пара ржавых остовов и какое-то существо, похожее на крупную крысу. Оно быстро спряталось в норе. Наконец я вышел к покосившемуся забору и пустым воротам с табличкой сверху "Ферма Салливан".';
		end;
	end;
};

dlg {
	nam = 'Разговор с Джейкобом2';
	disp = 'Разговор с Джейкобом';
	pic = 'theme/display.png;pic/map.png@c23,273;pic/triangle.png@85,90';
	onenter = '-- А, что? Тебя опять покусали?';
	phr = {
		{true, 'Да, мне нужна помощь.', function() p '-- Эй, парень. Я помог тебе в прошлый раз! Но это не значит, что нужно теперь сюда таскаться с каждой царапиной! Проклятье, что там у тебя?'; if Life > Str then p 'Это действительно царапина! Само заживет, иди поспи.'; else p 'О, тут нужна нитка с иголкой. Вот так, будешь красавчиком с этими шрамами.'; if Berserk == 1 and Life < Str then UN = UN - 3; end; Life = Str*2; end walk('Ферма Джейкоба'); end,};
		{true, 'Нет, просто у меня пара вопросов.', '-- Ха, спрашивай. Старый Джейкоб знает всё про нашу счастливую долину.',
			{true, 'Долина?', '-- Благословенная наша долина. С севера и запада горы и скалы, на востоке пустошь необитаемая, на юге большие солёные топи. А мы тут посерёдке, как у Иисуса за пазухой.'};
			{true, 'Расскажи подробнее что на севере?', '-- Скалы и скалы. Ничего там нет.'};
			{true, 'А что скажешь про запад?', '-- На запад от моей фермы когда-то был город, единственный город в нашей долине, там целых две тысячи народу жило когда-то. Дальше на запад через плоскогорье шло шоссе. Но землю иногда трясёт и дороги не осталось. Еще по слухам в тех местах завёлся монстр, ночной ужас.',
				{true, 'Ночной ужас?', function() p '-- Несколько охотников пропали с концами. А больше я и не знаю. В Солёном посёлке спроси, там расскажут.'; pop(); end};};
			{true, 'Что находится на востоке?', '-- Ещё фермы, немного болота, потом опять фермы. Некоторые заброшены, земля прохо родить стала. Мало воды, болото высыхает. Совсем далеко на востоке торговое место. Но последний караван видели в наших местах лет десять назад, так что там скорее всего пусто.'};
			{true, 'А на юге?', '-- Там большое солёное болото. Люди в Солёном посёлке добывают соль и охотятся на малуров. Какой-то огромный слизняк, закапывающийся в грязь. На вкус так себе.'};
			{true, 'Больше вопросов нет.', function() p '-- Ну тогда давай топай, не отвлекай от работы! -- Старик снова вернулся в дрёму.'; walk('Ферма Джейкоба') end};};
		{cond = function() if traiders > 0 then return true end end, 'Джейкоб, на ярмарке новый караван! У тебя есть провизия на продажу?', function() p '-- Благие новости. Кое-что у меня было. Я посмотрю и привезу немного попозже. Путь неближний, надо подготовиться.'; traiders = traiders + 1; end};
		{true, 'Просто решил поздороваться.', function() p '-- А, ну и тебе привет. -- Старик вернулся в дрёму.'; walk('Ферма Джейкоба') end};
	};
};

room {
	nam = 'Дом Джейкоба';
	pic = 'theme/display.png;pic/map.png@c23,273;pic/triangle.png@85,90';
	dsc = 'В доме всего несколько комнат, заставленных старой мебелью.';
	obj = {'Проигрыватель'};
	way = {path {'Наружу', 'Ферма Джейкоба'}};
};

room {
	nam = 'Амбар';
	pic = 'theme/display.png;pic/map.png@c23,273;pic/triangle.png@85,90';
	dsc = 'Здесь сильно пахнет навозом, но сейчас пусто.';
	obj = {'Сено'};
	way = {path {'Наружу', 'Ферма Джейкоба'}};
};

room {
	nam = 'Руины города';
	pic = 'theme/display.png;pic/map.png@c177,325;pic/triangle.png@85,90';
	onenter = function()
		snd.music 'bgm/Gecko.mp3';
	end;
	dsc = 'Когда-то это был небольшой городок, но сейчас от большей части зданий остались только ободранные стены. Не стоит тут задерживаться. Это место любят гекко.';
	way = {path {'В подвал', 'Тамбур'}, 'На запад', path {'На юг', 'Лагерь охотника'}, path {'На восток', 'Водонапорная башня'}};
	onexit = function(s, w)
		if w^'На запад' then
			p 'Шоссе привело меня на холм и увидел впереди обширное пустое пространство с редкими скалами торчащими из песка. И счетчик щелкает всё активнее и карта в Пип-Бой сбоит. Возвращаюсь назад.';
			Life = Life - 1;
			return false;
		end;
	end;
}:disable();

room {
	nam = 'На запад';
};

room {
	nam = 'На юг';
};

room {
	nam = 'На восток';
};

room {
	nam = 'На север';
};

room {
	nam = 'Перекрёсток';
	pic = 'theme/display.png;pic/map.png@c25,170;pic/triangle.png@85,90';
	enter = function()
		if rnd(2) == 1 and not seen 'Гекко' then 
			objs():add('Гекко');
		end;
	end;
	dsc = 'На земле видны пересекающиеся следы от повозок. Видимо это довольно оживлённое место.';
	obj = {'Столб', 'Кости', 'Гекко'};
	way = {path {'На запад', 'Лагерь охотника'}, path {'На юг (Солёный посёлок)', 'Солёный Посёлок'}, path {'На восток', 'Ферма Салливан'}, path {'На север (Ферма Джейкоба)', 'Ферма Джейкоба'}};
};

room {
	nam = 'Водонапорная башня';
	pic = 'theme/display.png;pic/map.png@c50,340;pic/triangle.png@85,90';
	enter = function()
		snd.music 'bgm/DesertWind.mp3';
		if rnd(2) == 1 and not seen 'Гекко' then 
			objs():add('Гекко');
		end;
	end;
	dsc = 'Около дороги я вижу старую водонапорную башню. Наверх ведёт лестница, на вид довольно ветхая.';
	obj = {};
	way = {path {'На запад (Руины)', 'Руины города'}, path {'На юг (Ферма Джейкоба)', 'Ферма Джейкоба'}, path {'На восток', 'Заброшенная ферма'}, path {'Наверх', 'На башне'}};
	onexit = function(s, w)
		if w^'На башне' then
			if Agl > 7 then
				p 'Старая лестница страшно скрипела и в один момент я только чудом удержался, когда одна из ступеней обломалась под моим весом. Но я же ловкач! Наконец я залез наверх.';
			else
				p 'Я полез по старой лестнице, но несколько ступеней с хрустом обломились и я свалился вниз. Хорошо хоть не так высоко залез и отделался испугом. Надо быть очень ловким чтобы туда забраться.';
				Life = Life - 1;
				return false;
			end;
		end;
	end;
};

room {
	nam = 'На башне';
	pic = 'theme/display.png;pic/map.png@c50,340;pic/triangle.png@85,90';
	dsc = 'Я стою на помосте, окружающем бочку водонапорной башни. Отсюда видно руины на западе и фермы в окрестностях.';
	obj = {'Старые кости'};
	way = {path {'Вниз', 'Водонапорная башня'}};
};

room {
	nam = 'Заброшенная ферма';
	pic = 'theme/display.png;pic/map.png@c-50,360;pic/triangle.png@85,90';
	onenter = function()
		snd.music 'bgm/DesertWind.mp3';
		p 'Спустя некоторое время я заметил впереди строение.';
	end;
	dsc = 'Это ещё одна ферма, но поля заросли сорняками и дом похоже заброшен.';
	obj = {'Колодец', 'Хищное растение'};
	way = {path {'На запад', 'Водонапорная башня'}, path {'На юг (Ферма Джейкоба)', 'Ферма Джейкоба'}, path {'На восток', 'Перевернувшийся грузовик'}, path {'В дом', 'Заброшенный дом'}, path {'В колодец', 'На дне'}};
};

room {
	nam = 'Заброшенный дом';
	pic = 'theme/display.png;pic/map.png@c-50,360;pic/triangle.png@85,90';
	dsc = 'В доме я обнаружил песок на полу и на мебели, который намело через выбитые окна.';
	obj = {'Шкаф', 'Стол'};
	way = {path {'Наружу', 'Заброшенная ферма'}};
};

room {
	nam = 'На дне';
	pic = 'theme/display.png;pic/map.png@c-50,390;pic/triangle.png@85,90';
	onenter = 'По веревке я спустился на дно. Воды тут нет.';
	dsc = 'Колодец давно высох, на дне лежит сухой песок и ржавые остатки ведра.';
	obj = {'Скелет'};
	way = {path {'Наверх', 'Заброшенная ферма'}};
}:disable();

room {
	nam = 'Ферма Салливан';
	pic = 'theme/display.png;pic/map.png@c-100,170;pic/triangle.png@85,90';
	dsc = 'Это ещё одна ферма и тут явно кто-то живёт.';
	obj = {};
	way = {path {'На запад', 'Перекрёсток'}, path {'На юг (Солёный посёлок)', 'Солёный Посёлок'}, path {'На восток', 'Низина'}, path {'На север (Ферма Джейкоба)', 'Ферма Джейкоба'}, path {'В дом', 'Разговор с фермершей'}, path {'В дом', 'Разговор с Салливаном3'}};
};

dlg {
	nam = 'Разговор с фермершей';
	disp = 'Ферма Салливан';
	pic = 'theme/display.png;pic/map.png@c-100,170;pic/triangle.png@85,90';
	onenter = function()
		p 'Я не успел войти в ворота, как мимо ушей просвистела пуля. Я в панике отпрыгнул и укрылся в канаве.^-- Убирайся, чёртов мутант! -- Кто-то прокричал из дома. Голос похож на женский.';
		snd.play 'weapon_sounds/12ga.ogg';
	end;
	phr = {
		{true, 'Я не мутант!', function() p '-- Так я тебе и поверила, мутант!'; snd.play 'weapon_sounds/12ga.ogg'; end};
		{true, cond = function() if Int > 6 or FourEyes == 1 and have 'Очки' and Int > 5 then return true end end, 'Совершенно очевидно я не мутант!', '-- Эй ты правда не мутант?',
			{true, 'Абсолютно!', 'Тогда встань и покажись!',
				{'Показаться.', 'Дверь с хрустом распахнулась и в проёме показалась женщина средних лет с дробовиком наперевес. Она близоруко прищурилась и внимательно осмотрела меня.^-- О, и правда одна голова всего. Послушай, мой муж с сыном ушли на восток за проклятым мутантом и их уже сутки нет. Если ты сходишь и найдешь их, то получишь награду! Еда, соль, патроны, всё что хочешь!',
					{'О, конечно. Я рад помочь!', function() p '-- Да? -- прищурилась женщина. Я взглянул на судорожно сжатый дробовик в её руках и снова кивнул, растянув губы в улыбке.^-- Хорошо. Иди прямо на восток. -- И дверь снова с хрустом захлопнулась.'; walk('Ферма Салливан'); end};};
				{'Тихо свалить, пока эта сумасшедшая не стреляет.', function() walk('Ферма Салливан'); end};};};
		{true, 'Но мутанты страшные и рычат, а не разговаривают!', function() p '-- Не заговаривай мне зубы!'; snd.play 'weapon_sounds/12ga.ogg'; end};
		{true, 'Кажется переговоры зашли в тупик.', function() walk('Ферма Салливан'); end};
	};
};

dlg {
	nam = 'Разговор с Салливаном3';
	disp = 'Разговор с Салливаном';
	pic = 'theme/display.png;pic/map.png@c-100,170;pic/triangle.png@85,90';
	enter = function()
		p '-- Наш спаситель! Снова спасибо тебе!';
		if visits() == 0 then
			p 'Вот немного мяса тебе в дорогу!';
			take 'Мясо малура';
			malur = malur + 1;
		end;
	end;
	phr = {
		{cond = function() if traiders > 0 then return true end end, 'Я разведал местность на востоке. На торговую площадь прибыл караван. Да, там есть мутанты, но они мирные и им нужна еда.', function() p '-- Нет, нет, нет! Вдруг это заразное? Или они каннибалы?'; end};
		{true, 'Ладно, я пошёл.', function() walk 'Ферма Салливан'; end};
	};
}:disable();

room {
	nam = 'Лагерь охотника';
	pic = 'theme/display.png;pic/map.png@c177,170;pic/triangle.png@85,90';
	onenter = function()
		snd.music 'bgm/Klamath.mp3';
	end;
	dsc = 'Здесь на поверхность показалась часть древнего шоссе.';
	obj = {'Охотник'};
	way = {'На запад', path {'На юг', 'На берегу'}, path {'На восток', 'Перекрёсток'}, path {'На север (Руины)', 'Руины города'}};
	onexit = function(s, w)
		if w^'На запад' then
			p 'Сначала дорога была несложной. Но потом песка становилось всё больше и карта в Пип-Бой начала сбоить. Через некоторое время я понял что хожу кругами. Да, вот и стоянка охотника впереди.';
			return false;
		end;
	end;
};

dlg {
	nam = 'Разговор с охотником';
	pic = 'theme/display.png;pic/map.png@c177,170;pic/triangle.png@85,90';
	onenter = '-- Да, приятель. Так громко топая ты к добыче не подкрадёшься. -- Не отрываясь от своего занятия, сказал охотник.';
	phr = {
		{'Я и не подкрадывался!', '-- И это хорошо. Чего ты хотел?'};
		{true, 'Чем ты занимаешься?', '-- Снимаю шкуру с гекко, из них хорошие ремни и сапоги получаются.',
			{true, cond = function() if Tinkerer == 0 then return true end end, 'Сможешь меня научить?', '-- Да, но вот беда, горло совсем пересохло. -- Охотник стучит себя пальцем по горлу. И что это должно означать? -- В общем приходи с бутылкой базза, хорошо?',
				{true, cond = function() return have 'Базз' end, 'Я принёс!', function() p '-- О, как! Ладно слушай, берёшь острый нож..(получен навык "Скорняк")'; Tinkerer = 1; remove 'Базз'; snd.play 'weapon_sounds/level_up.ogx'; walk('Лагерь охотника'); end};
				{true, cond = function() return not have 'Базз' end, 'Да, я всё понял!', function() walk('Лагерь охотника'); end};};
			{true, 'А что ты делаешь с мясом?', function() p 'В основном выкидываю. Его даже падальщики не едят, слишком вонючее. Эй, хватит меня отвлекать! Иди уже.'; walk('Лагерь охотника'); end};};
		{true, cond = function() return not have 'Кожаная броня' end, 'Как получить такую же броню как у тебя?', '-- Это возможно. Но мне нужны как минимум три шкуры геккона и соль. И ты видишь? Мой нож уже совсем старый, мне нужен новый. Намёк понятен?'};
		{true, cond = function() if have 'Соль' and gecko_pelt >= 3 and have 'Боевой нож' then return true end end, 'Я собрал всё нужное для кожаной брони.', function() p '-- Давай посмотрим.. Вот держи!'; salt = salt - 1; if salt == 0 then remove('Соль'); end; replace('Боевой нож', 'Нож'); gecko_pelt = gecko_pelt - 3; if gecko_pelt == 0 then remove('Шкурка гекко'); end; take 'Кожаная броня'; end};
		{cond = function() if traiders > 0 then return true end end, 'Я нашёл парней, которые купят у тебя мясо гекко.', '-- Оно же смердит! И где мне их искать?',
			{'На востоке, на старой торговой площадке. Только палить сразу не начинай, кажется они все мутанты.', function() p '-- Да кто из нас без лишнего пальца? Знаешь, у меня как раз пара свежих тушек. Пойду я проверю, что ты мне заливаешь. -- И охотник быстро собрался и ушёл.'; walk('Лагерь охотника'); remove 'Охотник'; objs('Ярмарка'):add('Охотник2'); traiders = traiders + 1; end};};
		{true, 'Можешь рассказать мне про окрестности?', '-- Ладно, спрашивай.',
			{true, 'Что на севере?', '-- Ты же оттуда и пришёл? Нет? Там развалины старого города. Смотри там во все стороны и под ноги.'};
			{true, 'На востоке?', '-- Там фермы. Народ в основном мирный, но стрелять умеют. Так что не размахивай стволом просто так.'};
			{true, 'На западе?', '-- Песок и скалы. И я видел следы. Что-то крупное там поселилось. Не стоит там оставаться после наступления темноты.'};
			{true, 'На юге?', '-- Там большое солёное болото и поселение. Если хочешь выпить, то годную выпивку делают только там.'};
			{true, 'Больше вопросов нет.', function() walk('Лагерь охотника') end};};
		{true, 'Просто шёл мимо. Не обращай на меня внимания.', function() walk('Лагерь охотника'); end};
	};
};

room {
	nam = 'На берегу';
	pic = 'theme/display.png;pic/map.png@c120,-30;pic/triangle.png@85,90';
	enter = function()
		snd.music 'bgm/DesertWind.mp3';
		if rnd(2) == 1 and not seen 'Гекко' then 
			objs():add('Гекко');
		end;
		if visits() == 0 then
			p 'Кажется вдалеке я увидел парус. Но нет, показалось..';
		end;
	end;
	dsc = 'Я на берегу высохшего озера. Здесь кто-то построил лачугу из листов жести и шифера.';
	obj = {'Грязь', 'Гекко'};
	way = {'На запад', 'На юг', path {'На восток (Солёный посёлок)', 'Солёный Посёлок'}, path {'На север', 'Лагерь охотника'}, path {'В лачугу', 'Лачуга'}};
	onexit = function(s, w)
		if w^'На запад' then
			p 'Отвесные скалы преграждают мне путь. Они уходят прямо в болото покрытое белой солью. Надо найти другой путь.';
			return false;
		elseif w^'На юг' then
			p 'Впереди большое солёное болото. По нему не пройдёшь!';
			return false;
		end;
	end;
};

room {
	nam = 'Лачуга';
	pic = 'theme/display.png;pic/map.png@c120,-30;pic/triangle.png@85,90';
	dsc = 'Внутри я нашёл очаг из камней и грубую лежанку.';
	obj = {'Патроны', 'Шкурка гекко'};
	way = {path {'Наружу', 'На берегу'}};
};

room {
	nam = 'Солёный Посёлок';
	pic = 'theme/display.png;pic/map.png@c-80,-80;pic/triangle.png@85,90';
	onenter = function()
		snd.music 'bgm/Den.mp3';
	end;
	dsc = 'На твердом участке между болот расположились убогие хижины собранные из всякого мусора. На одной из них приколочена древняя побитая вывеска со знаком доллара. На другой постройке прибита табличка со словом "BAR".';
	obj = {'Раковины', 'Буер'};
	way = {path {'На запад', 'На берегу'}, 'На юг', path {'На восток', 'В устье'}, path {'На север', 'Перекрёсток'}, path {'В лавку', 'Разговор с торговцем'}, path {'В бар', 'Бар'}};
	onexit = function(s, w)
		if w^'На юг' then
			p 'Я пошёл на юг. Но вскоре счетчик гейгера в моём Пип-Бое начал трещать всё сильнее и сильнее. Надо поискать другой путь. Возвращаюсь в посёлок.';
			snd.play 'bgm/geiger-counter.mp3';
			return false;
		end;
	end;
};

dlg {
	nam = 'Разговор с торговцем';
	pic = 'theme/display.png;pic/map.png@c-80,-80;pic/triangle.png@85,90';
	onenter = 'Я толкнул дверь и вошёл. Как и ожидалось это оказалась торговая лавка. Ассортимент правда не очень. Мешочки с солью, пласты белого мяса и веревка.';
	phr = {
		{true, 'А что вы хотите вот за это?', '-- Шкурки гекко или какие-то редкости из развалин. Приноси всё.'};
		{true, cond = function() return have 'Стимпак' end, 'Поменять стимпак на соль.', function() take 'Соль'; salt = salt + 1; stimpack = stimpack - 1; if stimpack == 0 then remove 'Стимпак'; end; end};
		{true, cond = function() if ammo10mm >= 10 then return true end end, 'Купить веревку за 10 патронов.', function() take 'Верёвка'; ammo10mm = ammo10mm - 10; end};
		{true, cond = function() if ammo10mm >= 5 then return true end end, 'Купить мясо за 5 патронов.', function() take 'Мясо малура'; malur = malur + 1; ammo10mm = ammo10mm - 5; end};
		{true, cond = function() return have 'Монета' end, 'Поменять монету на соль.', function() replace('Монета', 'Соль'); salt = salt + 1; end};
		{true, cond = function() return have 'Монета' end, 'Поменять монету на мясо.', function() replace('Монета', 'Мясо малура'); malur = malur + 1; end};
		{true, cond = function() return have 'Шкурка гекко' end, 'Поменять шкурку на соль.', function() take 'Соль'; salt = salt + 1; gecko_pelt = gecko_pelt - 1; if gecko_pelt == 0 then remove 'Шкурка гекко'; end; end};
		{true, cond = function() return have 'Шкурка гекко' end, 'Поменять шкурку на мясо.', function() take 'Мясо малура'; malur = malur + 1; gecko_pelt = gecko_pelt - 1; if gecko_pelt == 0 then remove 'Шкурка гекко'; end; end};
		{true, cond = function() return have 'Шкурка гекко' end, 'Поменять шкурку на 10 патронов для пистолета.', function() ammo10mm = ammo10mm + 10; gecko_pelt = gecko_pelt - 1; if gecko_pelt == 0 then remove 'Шкурка гекко'; end; end};
		{true, cond = function() return have 'Шкурка гекко' end, 'Поменять шкурку на 5 патронов для дробовика.', function() ammo12ga = ammo12ga + 5; gecko_pelt = gecko_pelt - 1; if gecko_pelt == 0 then remove 'Шкурка гекко'; end; end};
		{true, cond = function() return have 'Соль' end, 'Поменять соль на 5 патронов для дробовика.', function() ammo12ga = ammo12ga + 5; salt = salt - 1; if salt == 0 then remove 'Соль'; end; end};
		{true, 'Поменять пять шкурок на кожаную броню.', function() if gecko_pelt >= 5 then take 'Кожаная броня'; gecko_pelt = gecko_pelt - 5; if gecko_pelt == 0 then remove 'Шкурка гекко'; end; else p '-- У тебя нет нужного количества для обмена!'; end; end};
		{true, 'А есть у вас что-то стреляющее?', '-- Кое-что завалялось, но не просто так. Обменяю с доплатой. Есть шкурки?',
			{true, 'Поменять 10мм пистолет на Дезерт Игл с доплатой в три шкурки.', function() if have '10мм пистолет' and gecko_pelt > 2 then replace('10мм пистолет', 'Дезерт Игл'); gecko_pelt = gecko_pelt - 3; if gecko_pelt == 0 then remove 'Шкурка гекко'; end; else p '-- У тебя нет нужного количества для обмена!'; end; end};
			{true, 'Поменять 10мм пистолет на Дезерт Игл с доплатой в четыре куска мяса малура.', function() if have '10мм пистолет' and malur > 3 then replace('10мм пистолет', 'Дезерт Игл'); malur = malur - 4; if malur == 0 then remove 'Мясо малура'; end; else p '-- У тебя нет нужного количества для обмена!'; end; end};
			{true, 'Поменять что-то ещё.', function() pop(); end};};
		{cond = function() if traiders > 0 then return true end end, 'На ярмарке появились люди и им нужна провизия.', '-- Я не оказываю услуг доставки. Да и сейчас нет особых запасов, межсезонье.'};
		{true, 'Молча выйти.', function() walk('Солёный Посёлок'); end};
	};
};

room {
	nam = 'Бар';
	pic = 'pic/bar.png';
	onenter = 'Я вошёл внутрь. Люди за столиками оглянулись и подозрительно посмотрели.. Нет, конечно. Никто не посмотрел. Всем плевать.';
	dsc = 'Вдоль одной из стен располагается стойка, за ней полки с подозрительными бутылками.';
	obj = {'Бармен'};
	way = {path {'Наружу', 'Солёный Посёлок'}};
};

dlg {
	nam = 'Разговор с барменом';
	pic = 'pic/bar.png';
	onenter = '-- Пойла или базза? - Бармен выставил на стойку две замызганные бутылки.';
	phr = {
		{'А чем они отличаются?', 'Кто-то сзади меня засмеялся. Бармен же невозмутимо сказал: Это за четыре патрона, а это за пять.'};
		{true, cond = function() if ammo10mm >= 4 then return true end end, 'Взять пойло за четыре.', function() take 'Пойло'; ammo10mm = ammo10mm - 4; walk('Бар'); end};
		{true, cond = function() if ammo10mm >= 5 then return true end end, 'Взять базз за пять.', function() take 'Базз'; ammo10mm = ammo10mm - 5; walk('Бар'); end};
		{true, 'Не, я как-нибудь в следующий раз.', function() walk('Бар'); end};
	};
};

dlg {
	nam = 'Разговор с сёрфером';
	pic = 'theme/display.png;pic/map.png@c-80,-80;pic/triangle.png@85,90';
	onenter = 'Это оказалось что-то типа лодки на широких колёсах. Внутри лежит сложенная мачта с парусом.^-- Эй, ты чего трёшься возле моего буера?! -- Мои исследования прервал потрёпанный человек с палкой в руках.';
	phr = {
		{true, cond = function() if Int > 6 or FourEyes == 1 and have 'Очки' and Int > 5 then return true end end, 'Интересная конструкция, широкие колёса увеличивают пятно контакта и распределяют удельное давление на поверхность, что не даёт проваливаться на поверхности солончака..', '-- Эээ, -- мой собеседник немного завис, но быстро пришёл в себя. -- Эт, чтоб не провалиться, да!', -- Очки!
			{'И хорошо идёт? Я думаю 60-80км/час можно выжать..', function() p '-- Ээ, летит как птица, это лучший буер в посёлке! Я тебе сейчас расскажу как попал в пыльную бурю.. Что мы вообще здесь стоим? Пошли в бар!^За парой рюмок лодочник рассказал что его зовут Шкипер и он сможет отвезти меня на западный берег большого солончака за микроядерную батарею. И то она ему нужна для сканера, без которого соваться в солончаковое болото верное самоубийство. -- Сожрут нас малуры, как пить дать сожрут!'; walk 'Бар'; objs():add 'Шкипер'; end};};
		{'Привет, мне нужно попасть на западный берег!', '-- Лады, ковбой. С тебя микроядерная батарея! Две батареи!',
			{'И где я возьму эту батарею?', function() p '-- Не мои проблемы, ковбой. Найдёшь меня в баре.'; walk 'Солёный Посёлок'; objs('Бар'):add 'Шкипер'; end};};
	};
};

dlg {
	nam = 'Разговор со шкипером';
	pic = 'pic/bar.png';
	onenter = '-- Ну что нашел батарейку?';
	phr = {
		{true, cond = function() return have 'Микроядерная батарея' end, 'Да, вот она!', function() remove 'Микроядерная батарея'; walk('Солончак 1'); end};
		{true, 'Пока нет, шкипер.', function() p '-- Эх.'; walk('Бар'); end};
	};
};

room {
	nam = 'Низина';
	pic = 'theme/display.png;pic/map.png@c-230,170;pic/triangle.png@85,90';
	onenter = function()
		snd.music 'bgm/DesertWind.mp3';
	end;
	dsc = 'Здесь течёт река. Вернее ручей, жалкая струйка воды течет посередине широкой полосы грязевых наносов и песчаных кос. Из земли торчат неизвестно куда ведущие трубы, образуя шаткий мост над водой.';
	obj = {'Люк'};
	way = {path {'На запад (Ферма Салливан)', 'Ферма Салливан'}, path {'На юг', 'Стойбище'}, 'На восток', path {'На север (Ярмарка)', 'Ярмарка'}, path {'В люк', 'Туннель'}};
	onexit = function(s, w)
		if w^'На восток' then
			p 'Дальше дороги нет, топкое речное русло непроходимо.';
			return false;
		elseif w^'Туннель' then
			p 'По скобам вбитым в бетон я спустился вниз. Нескольких последних скоб не хватало, но до дна было уже недалеко и я просто спрыгнул. Хлюпнула вода.';
		end;
	end;
};

room {
	nam = 'Туннель';
	pic = 'theme/display.png;pic/map.png@c-230,170;pic/triangle.png@85,90';
	dsc = 'Я оказался в туннеле. Под ногами хлюпает грязь и вода, видимо этот бункер не очень герметичен. По стенам идут трубы и провода. Редкие лампы не горят, но хватает света падающего из люка.';
	obj = {'Дверь', 'Тушка таракана'};
	way = {path {'Наверх', 'Низина'}, path {'На запад', 'Генераторная'}, path {'На восток', 'Контрольная комната'}};
}:disable();

room {
	nam = 'Генераторная';
	pic = 'pic/generator.png';
	dsc = 'Я вошёл в небольшую комнату, тут посуше.';
	obj = {'Генератор', 'Стенной шкафчик2'};
	way = {path {'Назад', 'Туннель'}};
}:disable();

room {
	nam = 'Контрольная комната';
	onenter = function()
		if visits() == 0 then
			p 'На подходе я услышал какой-то шум и крики.';
		end;
		if _'Генератор'.start == true and visits('Разговор с Салливаном2') == 0 then
			p 'Войдя в комнату я увидел как щупальце корчится под ударами электричества, а потом исчезло в провале в стене. Парочка быстро перебралась ко мне по остаткам пандуса.^^';
			walk 'Разговор с Салливаном2';
		end;
	end;
	pic = 'theme/display.png;pic/map.png@c-230,170';
	dsc = 'Я оказался в большом помещении частично залитом водой. В одной из стен большой пролом через который сюда попадает вода и солнечный свет. Когда-то металлический пандус окружал комнату, а по лесенке можно было спуститься вниз. Но сейчас остались лишь некоторые участки, у входа и у противоположной стены.';
	obj = {'Салливан', 'Малур', 'Компьютеры'};
	way = {path {'Назад', 'Туннель'}};
};

dlg {
	nam = 'Разговор с Салливаном';
	disp = 'Разговор с Салливаном';
	pic = 'theme/display.png;pic/map.png@c-230,170;pic/triangle.png@85,90';
	onenter = function()
		if have 'Отмычки' then
			p '-- Прошу тебя, поспеши!';
			walk('Контрольная комната');
		else
			p '-- Эй, друг. Эй, послушай! -- Закричал мужчина. -- Помоги нам! Нас загнал сюда малур. У тебя есть динамит? Или что-то горючее? Они боятся огня!';
		end;
	end;
	phr = {
		{'Что такое малур?', '-- Малур! Вот он внизу. Если он схватит нас, то утащит в свою раковину и растворит в кислоте.'};
		{true, cond = function() return have 'Коктейль Молотова' end, 'Есть зажигательная бомба.', function() p '-- Да, это годится, бросай в него!'; walk('Контрольная комната'); end};
		{true, cond = function() return not have 'Коктейль Молотова' end, 'Нет, ничего такого нет.', function() p '-- Проклятье! Стой! Там есть еще комната, я не смог её взломать, но там наверняка что-то есть! Вот отмычки, лови!'; take 'Отмычки'; walk('Контрольная комната'); end};
	};
};

dlg {
	nam = 'Разговор с Салливаном2';
	disp = 'Разговор с Салливаном';
	pic = 'theme/display.png;pic/map.png@c-230,170;pic/triangle.png@85,90';
	onenter = '-- Спасибо тебе, странник. Мы всегда будем тебе благодарны. Я Джек, а это мой сын Джефф, мы Салливаны. Наша ферма на запад отсюда, приходи в любое время!';
	phr = {
		{'Как вы здесь оказались?', '-- Это странная история. Несколько дней назад возле фермы младший заметил страшного мутанта..^-- Двухголового! Как брамин! -- вмешался Джефф.^-- Тихо! В общем он выстрелил в него, но тот убежал. И мы решили догнать его и шли по следам. Но тут возле речки мы увидели что из воды выступил люк этого бункера. А бункер это хорошо, это всякие ценные вещи. Тут правда ничего и не было.. А дальше ты сам всё видел..'};
		{'Ладно, я пошёл.', function() p '-- Постой, у нас почти ничего нет, '; if not have 'Дробовик' then take 'Дробовик'; p 'но вот этот дробовик тебе явно пригодится.'; else p 'но вот эти патроны для дробовика тебе явно нужнее. '; end; ammo12ga = ammo12ga + 6; p 'Заходи на нашу ферму на запад отсюда. Прощай.'; walk 'Контрольная комната'; remove 'Малур';	remove 'Салливан'; disable 'Разговор с фермершей'; enable 'Разговор с Салливаном3'; end};
	};
};

room {
	nam = 'Перевернувшийся грузовик';
	onenter = function()
		snd.music 'bgm/DesertWind.mp3';
	end;
	pic = 'theme/display.png;pic/map.png@c-130,360;pic/triangle.png@85,90';
	dsc = 'Вокруг только высохшая земля и сухие клочки травы.';
	obj = {'Грузовик', 'Ящик'};
	way = {path {'На запад', 'Заброшенная ферма'}, path {'На юг (Ярмарка)', 'Ярмарка'}, 'На восток'};
	onexit = function(s, w)
		if w^'На восток' then
			p 'Счетчик Гейгера в моём Пип-Бое начал трещать как сумасшедший. Вернусь я лучше назад.';
			snd.play 'bgm/geiger-counter.mp3';
			return false;
		end;
	end;
};

room {
	nam = 'Ярмарка';
	onenter = function()
		snd.music 'bgm/NCR.mp3';
		if visits() == 0 then
			p '-- Эй, мистер! Добро пожаловать на ярмарку! Посетите наш цирк! Лучший цирк и возможно последний цирк в Пустошах! -- На меня набросился ярко раскрашенный весёлый клоун. -- У нас есть говорящий пони!^Откуда-то появился ещё один клоун, на этот раз грустный и попытался оттащить первого. -- Джерри, отцепись от посетителя. А пони мы съели год назад.^-- Тогда девушка с удавами! Такого вы точно не видели!^-- Джерри пойдём, удавы мутировали, а девушка тоже уже не девушка.. -- Наконец грустный смог увести своего приятеля и я смог осмотреться.';
		end;
	end;
	pic = 'theme/display.png;pic/map.png@c-230,210;pic/triangle.png@85,90';
	dsc = 'Вокруг множество палаток и телег. Поодаль установлен большой цветной купол.';
	obj = {'Палатка', 'Кузня', 'Ворота'};
	way = {path {'На запад', 'Ферма Салливан'}, path {'На юг', 'Низина'}, 'На восток', path {'На север', 'Перевернувшийся грузовик'}, 'В купол', path {'В ворота', 'Бункер Лима'}};
	onexit = function(s, w)
		if w^'На восток' then
			p 'Счетчик Гейгера в моём Пип-Бое начал трещать как сумасшедший. Вернусь я лучше назад.';
			snd.play 'bgm/geiger-counter.mp3';
			return false;
		elseif w^'В купол' then
			p '-- Извини, приятель, представление ещё не началось. Приходи попозже. -- Остановил меня человек на входе. Лицо его раскрашено, на руках когда-то белые перчатки, а какое-то перекособоченное тело скрыто под просторной хламидой. Что-то подозрительное.';
			return false;
		end;
	end;
};

room {
	nam = 'В купол';
};

dlg {
	nam = 'Торговец на ярмарке';
	pic = 'theme/display.png;pic/map.png@c-230,210;pic/triangle.png@85,90';
	onenter = function()
		if visits() == 0 then
			p 'Вздувшиеся консервы, какие-то бутылки и банки, в общем один мусор. Я уже хотел отвернуться, как за руку меня схватил торговец. Лицо его скрыто глубоким капюшоном и какие у него странные костлявые пальцы..^-- Постой, есть и кое-что особенное для тебя. Вот смотри.';
		end;
	end;
	phr = {
		{true, cond = function() return have 'Мясо малура' and not have 'Верёвка' end, 'Поменять кусок мяса на верёвку.', function() take 'Верёвка'; malur = malur - 1; if malur == 0 then remove 'Мясо малура'; end; end};
		{true, cond = function() if malur >= 3 then return true end end, 'Купить стимпак за три куска мяса.', function() take 'Стимпак'; stimpack = stimpack + 1; malur = malur - 3; if malur == 0 then remove 'Мясо малура'; end; end};
		{true, cond = function() return have 'Отмычки' end, 'Поменять отмычки на стимпак.', function() replace('Отмычки', 'Стимпак'); stimpack = stimpack + 1; end};
		{true, cond = function() if not have 'Отмычки' then return true end end, 'Купить отмычки за два куска мяса.', function() if malur >= 2 then take 'Отмычки'; malur = malur - 2; if malur == 0 then remove 'Мясо малура'; end; else p '-- Нужно больше мяссса! -- Прошипел торговец.'; end; end};
		{true, cond = function() return have 'Мясо малура' end, 'Поменять мясо на шкурку гекко.', function() take 'Шкурка гекко'; malur = malur - 1; gecko_pelt = gecko_pelt + 1; if malur == 0 then remove 'Мясо малура'; end; end};
		{true, cond = function() return have 'Монета' end, 'Поменять серебряную монету на научную книгу.', function() replace('Монета', 'Научная книга'); end};
		{true, cond = function() return have 'Журнал Кошачья лапка' end, 'Поменять журнал "Кошачья лапка" на научную книгу.', function() replace('Журнал Кошачья лапка', 'Научная книга'); end};
		{true, cond = function() if traiders == 0 and not have 'Электронные отмычки' then return true end end, 'Что насчёт этих электронных отмычек?', function() p '-- Ты принёс мясо, но этого мало. Очень мало. Местные не хотят с нами торговать. Наш мастер Билли Боб ходил к фермам, но в него начали стрелять. А Билли Боб и мухи не обидит. Найди мне поставщиков и ты получишь эти отмычки.'; traiders = 1; end};
		{true, cond = function() if traiders > 1 and not have 'Электронные отмычки' then return true end end, 'Я нашёл тебе поставщика провизии.', function() p '-- Да и теперь эти электронные отмычки твои. Сделка выполнена.'; take 'Электронные отмычки'; end};
		{'Где мне найти оружие и патроны?', '-- Иди на звук молота, найдёшь там мастера Билли Боба. У него всё есть.'};
		{'Расскажи откуда вы приехали?', '-- С востока. Но там только пустые города, сожжённые радиацией поля, жестокие летучие мыши и невкусные насекомые. Принеси мне ещё мяса и я тебе всё продам.'};
		{true, 'Уйти.', function() walk('Ярмарка'); end};
	};
};

dlg {
	nam = 'Разговор с Билли Бобом';
	pic = 'theme/display.png;pic/map.png@c-230,210;pic/triangle.png@85,90';
	onenter = function()
		if visits() == 0 then
			p 'Я вошёл в фургон и попал в кузницу. Всякие инструменты, обрезки металла вокруг. А потом я увидел хозяина и рука сама потянулась к кобуре. Он был огромен, весь покрыт какими-то наростами и пятнами, одет в закопченный кожаный фартук и у него было две головы. Мутант!^-- Так, никакой стрельбы в моём фургоне! -- Грозно заявила правая голова.^-- Нашем фургоне, братишка. -- Добавила левая голова. -- Я Боб, а это Билли. Мы Билли Боб. Что тебе нужно? Патронов? Есть ещё пара стволов на продажу.';
		end;
	end;
	phr = {
		{'Ты мутант?!', '-- О, нет. Ты нас раскрыл! Теперь нам придётся тебя убить! А-ха-ха! Надо же пройти через целый лагерь мутантов и ничего не заметить.',
			{'Весь лагерь?', '-- Да, а что ты думал? Там на великих равнинах простых людей и не осталось. Вирусы, радиация.. Такие как ты наверное и остались только в этих изолированных долинах.'};};
		{'Что ты хочешь за все эти вещи?', '-- Принеси мне еды. Лучше мяса. И много!'};
		{true, cond = function() return have 'Мясо малура' end, 'Поменять мясо на 5 патронов для пистолета (10mm).', function() ammo10mm = ammo10mm + 5; malur = malur - 1; if malur == 0 then remove 'Мясо малура'; end; end};
		{true, cond = function() return have 'Мясо малура' end, 'Поменять мясо на 5 патронов для дробовика (12GA).', function() ammo12ga = ammo12ga + 5; malur = malur - 1; if malur == 0 then remove 'Мясо малура'; end; end};
		{true, cond = function() return have 'Мясо малура' end, 'Поменять мясо на 5 патронов для ружья (.223FMJ).', function() ammo223fmj = ammo223fmj + 5; malur = malur - 1; if malur == 0 then remove 'Мясо малура'; end; end};
		{true, cond = function() if ammo10mm >= 10 then return true end end, 'Поменять 10 патронов 10мм на 5 патронов для дробовика (12GA).', function() ammo10mm = ammo10mm - 10; ammo12ga = ammo12ga + 5; end};
		{true, cond = function() if ammo10mm >= 10 then return true end end, 'Поменять 10 патронов 10мм на 5 патронов для ружья (.223FMJ).', function() ammo10mm = ammo10mm - 10; ammo223fmj = ammo223fmj + 5; end};
		{true, cond = function() if have 'Кожаная броня' then return true end end, 'Добавь пару стимпаков и я поменяю твою дурацкую кожанку на металлическую броню.', function() if stimpack >= 2 then replace('Кожаная броня', 'Металлическая броня'); stimpack = stimpack - 2; if stimpack == 0 then remove 'Стимпак'; end; else p '-- Я говорю, два стимпака, принеси две штуки!'; end; end};
		{true, cond = function() if not have 'Кожаная броня' then return true end end, 'Давай пару стимпаков и и четыре мяса и я отдам тебе эту металлическую броню.', function() if malur >= 4 and stimpack >= 2 then take 'Металлическая броня'; stimpack = stimpack - 2; if stimpack == 0 then remove 'Стимпак'; end; malur = malur - 4; if malur == 0 then remove 'Мясо малура'; end; else p '-- Маловато этого, надо больше!'; end; end};
		{true, cond = function() if have 'Нож' and ammo10mm >= 10 then return true end end, 'Добавь 10 патронов 10мм и я поменяю твой кухонный ножик на боевой.', function() replace('Нож', 'Боевой нож'); ammo10mm = ammo10mm - 10; end};
		{true, cond = function() if have '10мм пистолет' then return true end; end, 'Поменять 10мм пистолет на Дезерт Игл с доплатой в три куска мяса.', function() if malur > 2 then replace('10мм пистолет', 'Дезерт Игл'); malur = malur - 3; if malur == 0 then remove 'Мясо малура'; end; else p '-- У тебя маловато для обмена. Принеси ещё.'; end; end};
		{true, cond = function() if have 'Дробовик' then return true end; end, 'Поменять дробовик на охотничье ружьё с доплатой в три куска мяса.', function() if malur > 2 then replace('Дробовик', 'Охотничье ружьё'); malur = malur - 3; if malur == 0 then remove 'Мясо малура'; end; SG = 20; ammo223fmj = ammo223fmj + ammo12ga; ammo12ga = 0; else p '-- Надо больше мяса. Билли голоден. -- Произнесла левая голова.'; end; end};
		{true, cond = function() if have 'Охотничье ружьё' then return true end; end, 'Поменять охотничье ружьё на боевой дробовик с доплатой в пять кусков мяса.', function() if malur > 4 then replace('Охотничье ружьё', 'Боевой дробовик'); malur = malur - 5; if malur == 0 then remove 'Мясо малура'; end; ammo12ga = ammo12ga + ammo223fmj; ammo223fmj = 0; else p '-- Принеси побольше мяса, этого недостаточно.'; end; end};
		{true, cond = function() if have 'Металлическая броня' and have 'Мусор' then return true end end, 'Билли Боб, я тут нашёл какие-то запчасти.', function() p '-- О, этого мне как раз недоставало! Давай-ка сюда!^Спустя полчаса.^-- А теперь примерь вот это! Моя усиленная гидравлическими приводами суперброня!'; replace('Металлическая броня', 'Экзоскелетная броня'); remove 'Мусор'; Str = Str + 1; if Str > 10 then Str = 10 end; end};
		{true, 'Выйти из фургона.', function() walk('Ярмарка'); end};
	};
};

room {
	nam = 'Бункер Лима';
	pic = 'theme/display.png;pic/map.png@c-230,210;pic/triangle.png@85,90';
	onenter = function()
		snd.music 'bgm/Enclave.mp3';
		p 'Я прошёл по длинному коридору и попал в большое помещение.';
	end;
	dsc = 'Это просторное техническое помещение. Везде трубы, насосы и вентили.';
	obj = {'Терминал 2'};
	way = {path {'Наружу', 'Ярмарка'}};
}:disable();

dlg {
	nam = 'Терминал Л';
	pic = 'pic/coding.gif';
	onenter = function()
		p 'Добро пожаловать в бункер Лима, пользователь.';
	end;
	phr = {
		{true, 'Статус.', function() p('Насосы - '..(n1 + n2 + n3 + n4 + n5 + n6 + n7)..'/7. Энергопитание - '..power..'%.'); end,
			{true, 'Управление насосами.', 'ОК',
				{true, 'Насос 1 - отключен.', 'Ошибка. Нет данных.',
					{true, 'Включить.', 'Ошибка. Ошибка. Ошибка.'};
					{true, 'Диагностика.', 'Источник неисправности: Нет связи!'};
					{true, 'Назад.', function() pop(); end};};
				{true, function() if n2 == 0 then p 'Насос 2 - отключен.'; else p 'Насос 2 - включен.'; end; end, 'Устройство исправно.',
					{true, cond = function() if n2 == 0 then return true end end, 'Включить.', function() p 'Готово.'; n2 = 1; power = power + 10; end};
					{true, cond = function() if n2 == 1 then return true end end, 'Выключить.', function() p 'Готово.'; n2 = 0; power = power - 10; end};
					{true, 'Назад.', function() pop(); end};};
				{true, function() if n3 == 0 then p 'Насос 3 - отключен.'; else p 'Насос 3 - включен.'; end; end, 'Устройство исправно.',
					{true, cond = function() if n3 == 0 then return true end end, 'Включить.', function() p 'Готово.'; n3 = 1; power = power + 10; end};
					{true, cond = function() if n3 == 1 then return true end end, 'Выключить.', function() p 'Готово.'; n3 = 0; power = power - 10; end};
					{true, 'Назад.', function() pop(); end};};
				{true, 'Выход из программы.', function() walk('Бункер Лима') end};};
			{true, 'Уровень воды.', function() p('Текущий уровень '..(115 - power)..'.'); end};
			{true, 'Выход из программы.', function() walkout(); end};};
		{true, 'Связь.', 'Сетевые протоколы загружены.',
			{'Включить синхронизацию.', 'Успешно! Связь с бункером Альфа восстановлена.'};
			{true, 'Назад.', function() pop(); end};};
		{true, 'Записи.', 'Обнаружена 1 запись.',
			{true, 'Для Джека.', 'Джек, я отрубил связь с Альфой и поставил уровень на 60. Если качать ниже этого горизонта, то озера высохнут и вся живность в них погибнет. Нет, может быть она погибнет и от радиации, но кто знает? В конце концов мы же собираемся вернуться на поверхность? И было бы грустно обнаружить тут пустыню. Я отправляюсь в бункер Новембер. У меня есть ещё сутки или около того.^^Крис. 25 10 2077'};
			{true, 'Назад.', function() pop(); end};};
		{true, 'Выход из программы.', function() walk('Бункер Лима'); end};
	};
};

room {
	nam = 'В устье';
	enter = function()
		snd.music 'bgm/DesertWind.mp3';
		if visits() == 0 then
			p 'На берегу какой-то парень с копьём пытается отбиться от здоровенного скорпиона. Но вот жало вонзается в тело и парень падает, теперь скорпион бежит ко мне!';
			ways():disable();
			if FastShot == 1 then
				snd.play 'weapon_sounds/10mm.ogg';
				p 'Но я выстрелил первым.';
				ammo10mm = ammo10mm - 1;
				Enemy = Enemy + SG;
			end;
		end;
	end;
	pic = 'pic/scorp.png';
	dsc = 'Я вышел к засохшему озеру. Здесь в него впадает речка, сейчас тоже почти высохшая.';
	obj = {'Радскорпион'};
	way = {path {'На запад (Солёный Посёлок)', 'Солёный Посёлок'}, 'На юг', 'На восток', path {'На север', 'Стойбище'}, path {'Вниз в коллектор ', 'Сектор 3'}};
	onexit = function(s, w)
		if w^'На юг' then
			p 'Я пошёл на юг. Но вскоре счетчик гейгера в моём Пип-Бое начал трещать всё сильнее и сильнее. Надо поискать другой путь. Возвращаюсь назад.';
			snd.play 'bgm/geiger-counter.mp3';
			return false;
		elseif w^'На восток' then
			p 'Дальше на восток только топкие солончак. Не пройти.';
			return false;
		end;
	end;
};

dlg {
	nam = 'Разговор с индейцем';
	pic = 'theme/display.png;pic/map.png@c-220,-90;pic/triangle.png@85,90';
	onenter = function()
		if visits() == 0 then
			p 'Смуглая кожа, перья в волосах, татуировки на теле. Сущий дикарь. Эй, он ещё жив!';
		end;
	end;
	phr = {
		{'Очнись парень!', '-- Ох, моя нога! -- простонал индеец.',
			{'Осмотреть ногу.', function() p 'В ноге небольшая дыра, только вот вокруг раны распространяется опухоль. Это яд!^-- Большой жук сильно укусил меня. Посмотри там в песке, там вход в старое место. Там можно найти лечебную вещь. Посмотри!^Я пошёл в указанную сторону и увидел провал вниз. Что тут? Канализационный коллектор? Какая там лечебная вещь?'; enable 'Сектор 3'; end,
				{cond = function() return not have 'Стимпак' end, 'Эй, что там за лечебная вещь?', function() p 'Похоже он отрубился.'; walk('В устье'); end};
				{cond = function() return have 'Стимпак' end, 'Вколоть стимпак.', function() stimpack = stimpack - 1; if stimpack == 0 then remove 'Стимпак'; end; p 'Довоенная медицина быстро помогла. Парень спустя пару минут встал на ноги.^-- Слушай, чужак. Я, Облачко, теперь должен тебе жизнь. Посмотри, там в песке люк. Наверное там старый бункер. И ещё! Теперь ты всегда можешь прийти в наше стойбище на севере и жить в моём типи. Цаку миа! -- После чего захромал куда-то на север.'; walkout(); remove 'Индеец'; enable 'Сектор 3'; end};};};
	};
};

room {
	nam = 'Сектор 3';
	enter = function()
		snd.music 'bgm/Navarro.mp3';
		if visits() == 0 then
			p 'Свинокрыс бежит ко мне!';
			ways():disable();
			if FastShot == 1 then
				snd.play 'weapon_sounds/10mm.ogg';
				p 'Но я выстрелил первым.';
				ammo10mm = ammo10mm - 1;
				Enemy = Enemy + SG;
			end;
		elseif rnd(2) == 1 then 
			objs():add('Свинокрыс');
			ways():disable();
			if FastShot == 1 then
				snd.play 'weapon_sounds/10mm.ogg';
				p 'Я снова стреляю первым!';
				ammo10mm = ammo10mm - 1;
				Enemy = Enemy + SG;
			end;
		end;
	end;
--	pic = 'pic/map.png@c-220,-90;pic/triangle.png@85,90';
	pic = 'pic/sector.png';
	dsc = 'Я оказался в водосточном туннеле. Под ногами хлюпает грязь и вода. По стенам идут трубы и провода. Редкие лампы не горят, но хватает света падающего из люка. На стене написано "03".';
	obj = {'Свинокрыс'};
	way = {path {'Наверх', 'В устье'}, path {'На запад', 'Сектор 2'}, path {'На восток', 'Сектор 4'}};
}:disable();

room {
	nam = 'Сектор 4';
	enter = function()
		if rnd(2) == 1 then 
			objs():add('Свинокрыс');
			ways():disable();
			if FastShot == 1 then
				snd.play 'weapon_sounds/10mm.ogg';
				p 'Я снова стреляю первым!';
				ammo10mm = ammo10mm - 1;
				Enemy = Enemy + SG;
			end;
		end;
	end;
--	pic = 'theme/display.png;pic/map.png@c-270,-90;pic/triangle.png@85,90';
	pic = 'pic/sector.png';
	dsc = 'Я в водосточном туннеле. Под ногами хлюпает грязь и вода. Видно что-то только из-за света поступающего через решётку.';
	obj = {'Решётка', 'Обглоданные кости'};
	way = {path {'На запад', 'Сектор 3'}};
};

room {
	nam = 'Сектор 2';
	enter = function()
		if rnd(2) == 1 then 
			objs():add('Свинокрыс');
			ways():disable();
			if FastShot == 1 then
				snd.play 'weapon_sounds/10mm.ogg';
				p 'Я снова стреляю первым!';
				ammo10mm = ammo10mm - 1;
				Enemy = Enemy + SG;
			end;
		end;
	end;
--	pic = 'theme/display.png;pic/map.png@c-80,-90;pic/triangle.png@85,90';
	pic = 'pic/sector.png';
	dsc = 'Здесь туннель разделяется. На стене написано "02".';
	obj = {'Заваленный люк'};
	way = {path {'На запад', 'Сектор 1'}, path {'На восток', 'Сектор 3'}, path {'На юг', 'Сектор 5'}};
};

room {
	nam = 'Сектор 1';
	enter = function()
		if rnd(2) == 1 then 
			objs():add('Свинокрыс');
			ways():disable();
			if FastShot == 1 then
				snd.play 'weapon_sounds/10mm.ogg';
				p 'Я снова стреляю первым!';
				ammo10mm = ammo10mm - 1;
				Enemy = Enemy + SG;
			end;
		end;
	end;
--	pic = 'theme/display.png;pic/map.png@c180,-130;pic/triangle.png@85,90';
	pic = 'pic/sector.png';
	dsc = 'Это тупик. Видно что-то только из-за света поступающего через решётку.';
	obj = {'Решётка'};
	way = {path {'На восток', 'Сектор 2'}};
};

room {
	nam = 'Сектор 5';
	enter = function()
		if rnd(2) == 1 then 
			objs():add('Кротокрыс');
			ways():disable();
			if FastShot == 1 then
				snd.play 'weapon_sounds/10mm.ogg';
				p 'Я снова стреляю первым!';
				ammo10mm = ammo10mm - 1;
				Enemy = Enemy + SG;
			end;
		end;
	end;
--	pic = 'theme/display.png;pic/map.png@c-80,-150;pic/triangle.png@85,90';
	pic = 'pic/sector.png';
	dsc = 'Путь дальше завален. На стене написано "05".';
	obj = {'Стальная дверь'};
	way = {path {'На север', 'Сектор 2'}, path {'На восток', 'Бункер Новембер'}};
};

room {
	nam = 'Бункер Новембер';
	pic = 'pic/terminal.png';
	onenter = function()
		snd.music 'bgm/Enclave.mp3';
		p 'Я прошёл по длинному коридору и попал в большое помещение.';
	end;
	dsc = 'Это просторное техническое помещение. Везде трубы, насосы и вентили.';
	obj = {'Терминал 3', 'Стенной шкафчик3', 'Мусор'};
	way = {path {'В туннель', 'Сектор 5'}};
}:disable();

dlg {
	nam = 'Терминал Н';
	pic = 'pic/coding.gif';
	onenter = 'Добро пожаловать в бункер Новембер, пользователь.';
	phr = {
		{true, 'Статус.', function() p('Насосы - '..(n1 + n2 + n3 + n4 + n5 + n6 + n7)..'/7. Энергопитание - '..power..'%.'); end,
			{true, 'Управление насосами.', 'ОК',
				{true, function() if n4 == 0 then p 'Насос 4 - отключен.'; else p 'Насос 4 - включен.'; end; end, 'Устройство исправно.',
					{true, cond = function() if n4 == 0 then return true end end, 'Включить.', function() p 'Готово.'; n4 = 1; power = power + 10; end};
					{true, cond = function() if n4 == 1 then return true end end, 'Выключить.', function() p 'Готово.'; n4 = 0; power = power - 10; end};
					{true, 'Назад.', function() pop(); end};};
				{true, function() if n5 == 0 then p 'Насос 5 - отключен.'; else p 'Насос 5 - включен.'; end; end, 'Устройство исправно.',
					{true, cond = function() if n5 == 0 then return true end end, 'Включить.', function() p 'Готово.'; n5 = 1; power = power + 10; end};
					{true, cond = function() if n5 == 1 then return true end end, 'Выключить.', function() p 'Готово.'; n5 = 0; power = power - 10; end};
					{true, 'Назад.', function() pop(); end};};
				{true, 'Назад.', function() pop(); end};};
			{true, 'Уровень воды.', function() p('Текущий уровень '..(115 - power)..'.'); end};
			{true, 'Выход из программы.', function() walk('Бункер Новембер') end};};
		{true, 'Связь.', 'Сетевые протоколы загружены.',
			{'Включить синхронизацию.', 'Успешно! Связь с бункером Альфа восстановлена.'};
			{true, 'Назад.', function() pop(); end};};
		{true, 'Записи.', 'Обнаружено 2 записи.',
			{true, 'Снова для Джека.', 'Джек, тут я тоже отрубил связь с Альфой и поставил уровень на 60. Ты же помнишь что может случиться? Еду дальше в бункер Ромео. Видел на другой стороне озера вспышки. Тех кто не успел приехать, видимо можно уже не ждать. Времени похоже осталось меньше, чем я думал.^^Крис. 26 10 2077'};
			{true, cond = function() if Hacker == 0 then return true end end, 'файл "Думай как Хакер"', function() p 'Этот большой файл оказался подробным учебником по взлому и защите компьютерных и электронных систем. Теперь я знаю и умею больше. (получен навык "Хакер")'; Hacker = 1; snd.play 'weapon_sounds/level_up.ogx'; end};
			{true, 'Назад.', function() pop(); end};};
		{true, 'Выход из программы.', function() walk('Бункер Новембер'); end};
	};
};

room {
	nam = 'Стойбище';
	pic = 'theme/display.png;pic/map.png@c-230,80;pic/triangle.png@85,90';
	onenter = function()
		snd.music 'bgm/Den.mp3';
	end;
	dsc = 'Вокруг меня десяток традиционных палаток типи установленных вокруг полуразрушенного здания.';
	obj = {'Воин Шошон'};
	way = {path {'На запад (Ферма Салливан)', 'Ферма Салливан'}, path {'На юг', 'В устье'}, 'На восток', path {'На север', 'Низина'}, path {'В типи', 'Типи'}, path {'В здание', 'Здание'}};
	onexit = function(s, w)
		if w^'На восток' then
			p 'Дальше на восток только топкие солончак. Не пройти.';
			return false;
		end;
	end;
};

room {
	nam = 'Типи';
	pic = 'theme/display.png;pic/map.png@c-230,80;pic/triangle.png@85,90';
	dsc = 'Это традиционная постройка индейцев. Сшитые шкуры натянуты на жерди. Посередине очаг обложенный камнями.';
	obj = {'Лежанка', 'Шкурка гекко'};
	way = {path {'Наружу', 'Стойбище'}};
}:disable();

room {
	nam = 'Здание';
	pic = 'theme/display.png;pic/map.png@c-230,80;pic/triangle.png@85,90';
	dsc = 'Неизвестно что тут было раньше. Но сейчас здание в полуразрушенном состоянии. Окна заделаны мусором, а перегородки внутри снесены. В дыры в крыше светит солнце и выходит дым от костров. У большого костра в центре сидят несколько человек.';
	obj = {'Вождь', 'Индеец охотник'};
	way = {path {'Наружу', 'Стойбище'}, path {'В люк', 'Гидропоника'}};
}:disable();

dlg {
	nam = 'Разговор с вождём';
	pic = 'theme/display.png;pic/map.png@c-230,80;pic/triangle.png@85,90';
	enter = function()
		if visits() == 0 then
			p '-- Маруаве, белый воин. Ты спас нашего юного охотника и можешь рассчитывать на нашу благодарность. Возьми эти припасы. Возможно тебе они нужнее. И у меня есть просьба.';
			take 'Мясо малура';
			malur = malur + 2;
			ammo10mm = ammo10mm + 7;
			take 'Сигнальная шашка';
			flare = flare + 1;
		end;
		enable 'Гидропоника';
	end;
	phr = {
		{'Какая просьба?', '-- Выслушай же историю нашего племени..',
			{'Слушать.', '-- В давние времена моё племя кочевало по разным местам. Мы продавали поделки белым людям и плясали для них..^Монотонный голос вождя наводит зевоту.',
				{'Слушать ещё.', '-- Наши охотники были лучше всех, но дичи оставалось немного. Тогда мы охотились на уток у этого озера..^Глаза слипаются от этой истории.',
					{'Слушать дальше.', '-- Быстрый Ветер принес тогда пять птиц, а Старый Койот четыре..^Если я усну прямо здесь, они обидятся?',
						{'Продолжать слушать.', '-- И мы увидели как огонь пожрал город белых на том берегу озера, и человек по имени Крис указал нам путь в укрытие..',
							{'Слушать ещё.', '-- Так мы и выжили. Выращивали грибы и водоросли. Ловили крыс и насекомых. А потом вышли на поверхность..',
								{'Так, а какая просьба то?.', function() p '-- Эх, эта юность вечно торопится. В подземелье появилось древнее зло и тебе нужно победить его. Вон там люк ведущий вниз.'; walk('Здание'); end};};
							{'Что, Крис?', '-- Да, его звали Крис. Он проезжал мимо на самоходной машине. Без брамина! Звучит смешно, но это чистая правда! Не перебивай меня!'};};};
				{'Громко зевнуть.', function() p '-- Я вижу тебе наскучил мой рассказ. Эта юность вечно торопится. В подземелье появилось древнее зло и тебе нужно победить его. Вон там люк ведущий вниз.'; walk('Здание'); end};};
			{'Остановить вождя.', function() p '-- Эх, эта юность вечно торопится. В подземелье появилось древнее зло и тебе нужно победить его. Вон там люк ведущий вниз.'; walk('Здание'); end};};};
	};
};

room {
	nam = 'Зал управления';
	pic = 'pic/terminal.png';
	dsc = 'Вдоль стен установлены старые ленточные накопители. Диски в них медленно крутятся. На стене я вижу нарисованную букву "A"';
	obj = {'Терминал 4', 'Скелет в кресле', 'Большой шкаф'};
	way = {path {'На восток', 'Казарма'}:disable()};
};

room {
	nam = 'Казарма';
	pic = 'pic/bunker.png';
	dsc = 'Здесь установлены двухярусные кровати. Я вижу множество свидетельств обитания большого количества людей. Везде разбросанные одеяла и вещи. На стене я вижу нарисованную букву "B"';
	obj = {'Усиленная дверь', 'Баллон'};
	way = {path {'На запад', 'Зал управления'}:disable(), path {'На юг', 'Гидропоника'}, path {'На восток', 'Техзал'}};
};

room {
	nam = 'Техзал';
	pic = 'pic/robot.png';
	dsc = 'В этом техническом помещении установлены зарядные устройства для роботов. На стене я вижу нарисованную букву "С"';
	obj = {'Робот-часовой', 'Стенной шкафчик4'};
	way = {path {'На запад', 'Казарма'}};
};

room {
	nam = 'Склад';
	pic = 'pic/bunker.png';
	dsc = 'В этом помещении был когда-то склад. Сейчас же остались лишь пустые железные полки и остатки упаковки. На стене я вижу нарисованную букву "D"';
	obj = {'Коробка'};
	way = {path {'На восток', 'Гидропоника'}};
};

room {
	nam = 'Гидропоника';
	pic = 'pic/hydroponics.png';
	onenter = function()
		snd.music 'bgm/Enclave.mp3';
	end;
	dsc = 'Я оказался в большом помещении заставленном большими прямоугольными ящиками с землёй и какими-то чахлыми ростками. Вдоль стен расположено какое-то оборудование со множеством труб. Потолочные лампы горят вполнакала. Подняться наверх можно по железной лестнице.';
	obj = {};
	way = {path {'На запад', 'Склад'}, path {'На север', 'Казарма'}, path {'На восток', 'Генераторная2'}, path {'Наверх', 'Здание'}};
	onexit = function(s, w)
		if w^'Здание' then
			if live('Робот-часовой') then
				lifeoff('Робот-часовой');
				place ('Робот-часовой', 'Техзал');
				p 'ЦЕЛЬ НЕДОСТИЖИМА. ВОЗВРАЩЕНИЕ НА БАЗУ';
			end;
			if have 'Коробка' then
				p 'Я оставил ящик на полу. По этой лестнице его не затащить.';
				drop 'Коробка';
			end;
		end;
	end;
}:disable();

room {
	nam = 'Генераторная2';
	disp = 'Генераторная';
	pic = 'pic/bunker.png';
	dsc = 'Поток воды вращает огромные колёса с лопастями. Они подсоеденены к генератору с массивными обмотками. Высоко на стене я вижу решётку вентиляции.';
	obj = {};
	way = {path {'На запад', 'Гидропоника'}, path {'В вентиляцию', 'Вентиляция C'}};
	onexit = function(s, w)
		if w^'Вентиляция C' then
			if live('Робот-часовой') then
				lifeoff('Робот-часовой');
				place ('Робот-часовой', 'Техзал');
				p 'ЦЕЛЬ НЕДОСТИЖИМА. ВОЗВРАЩЕНИЕ НА БАЗУ';
			end;
			if not seen 'Коробка' then
				p 'Слишком высоко. Не могу залезть.';
				return false;
			else
				p 'Я залезаю на ящик, поднимаю решётку и забираюсь в вентиляцию. Канал ведёт куда-то на север.';
			end;
		end;
	end;
};

room {
	nam = 'Вентиляция C';
	disp = 'Вентиляция';
	pic = 'pic/robot.png';
	dsc = 'Здесь в стенке вентканала есть отверстие через которую я вижу техзал. Там установлены зарядные устройства для роботов.';
	obj = {'Решётка C', 'Робот-часовой'};
	way = {path {'На запад', 'Вентиляция B'}, path {'На юг', 'Генераторная2'}, path { '#C', 'Вниз', 'Техзал' }:disable()};
};

room {
	nam = 'Вентиляция B';
	disp = 'Вентиляция';
	pic = 'pic/bunker.png';
	onenter = function()
		if visits() == 0 then
			p 'Что это, что за злобный писк? Ах ты, кусаться?';
			Life = Life - 1;
			ways():disable();
		end;
	end;
	dsc = 'Здесь в стенке вентканала есть решётка через которую я вижу большое жилое помещение. Сейчас разгромлено, как будто его покидали в спешке.';
	obj = {'Решётка B', 'Свинокрыс'};
	way = {path {'На запад', 'Вентиляция A'}, path {'На восток', 'Вентиляция C'}};
};

room {
	nam = 'Вентиляция A';
	disp = 'Вентиляция';
	pic = 'pic/terminal.png';
	dsc = 'Здесь в стенке вентканала есть решётка через которую я вижу контрольную комнату.';
	obj = {'Решётка A'};
	way = {path {'На восток', 'Вентиляция B'}, path { '#A', 'Вниз', 'Зал управления' }:disable()};
};

dlg {
	nam = 'Терминал Б';
	pic = 'pic/coding.gif';
	onenter = 'Добро пожаловать в систему. Станция Бета.';
	phr = {
		{true, 'Статус.', 'Нет данных'};
		{true, 'Связь.', 'Сетевые протоколы загружены.',
			{'Включить синхронизацию.', 'ОШИБКА. Линия связи не отвечает.'};
			{true, 'Назад.', function() pop(); end};};
		{true, 'Записи.', 'Записи повреждены. Начат процесс восстановления. Удалось восстановить 8 записей.',
			{true, 'Запись 1362', 'Этот кашель меня доконает..'};
			{true, 'Запись 620', 'Небо светлеет или мне кажется? Осталась последняя рабочая камера на поверхности.'};
			{true, 'Запись 166', 'Я хотел писать каждый день. Но полгода ничего не происходило и я не писал. Просто наблюдал за краснокожими. Один из них сошёл с ума и пытался открыть люк наружу. Просто умора.'};
			{true, 'Запись 145', 'Кажется я видел какое-то движение в одну из камер. Наверное показалось. Там ничто не могло выжить.'};
			{true, 'Запись 144', 'На поверхности по прежнему идёт снег. Небо темное и облака несутся как сумасшедшие.'};
			{true, 'Запись 86', 'Дикари разобрались с гидропоникой и выращивают помидоры. Эй, это МОИ помидоры! Открыть дверь? Нет, слишком опасно. И у меня ещё есть консервированные персики.'};
			{true, 'Запись 4', 'Нет, нет, нет! Он сумел взломать мои системы защиты! Что? Зачем он запускает этих дикарей в мой, МОЙ бункер? Но сюда они не попадут. Сюда никто не попадёт. Я заперся в пункте управления.'};
			{true, 'Запись 2', 'Они мне говорили, зачем ты закапываешь деньги в землю. Купи новую корвегу! И где теперь они? Ахаха!'};
			{true, 'Назад.', function() pop(); end};};
		{true, cond = function() if Points == 0 then return true end end, 'Управление дверьми.', 'Протокол загружен.',
			{true, 'Открыть дверь зала управления.', function() p 'ОК.'; ways('Зал управления'):enable(); ways('Казарма'):enable(); end};
			{true, 'Открыть дверь технического зала.', 'ОШИБКА. Выполнение команды невозможно. Сервоприводы не отвечают.'};
			{true, 'Назад.', function() pop(); end};};
		{true, cond = function() if Points == 0 then return true end end, 'Управление роботами.', 'Обнаружен 1 функционирующий юнит. Модель Часовой MK I.',
			{true, 'Дезактивировать.', function() p 'ОК.'; replace('Робот-часовой', 'Отключённый робот'); end};
			{true, 'Назад.', function() pop(); end};};
		{true, 'Выход из программы.', function() walkout(); end};
	};
};

room {
	nam = 'Солончак 1';
	disp = 'Солончак';
	onenter = function()
		p 'Шкипер допил свой стакан. Рывком поднялся и потопал на выход. Я пошёл следом. Немногим после, забравшись в лодку, он обратился ко мне.^-- Итак, бродяга. Смотри сюда. Это руль, крутишь его куда надо повернуть. Довольно просто. Обращай внимание на отметки на экране сенсора. Я же буду работать с парусом и посматривать вперёд. Лады?^Я согласно кивнул. Вскоре хлопнул парус и со скрипом песка под катками лодка стала набирать скорость.';
		snd.music 'bgm/DesertWind.mp3';
	end;
	pic = 'theme/display.png;pic/map.png@c-10,-100;pic/triangle.png@85,90';
	dsc = 'Лодка выкатилась на солончак. Скорость сразу увеличилась.';
	obj = {'Шкипер2', 'Сканер'};
	way = {path {'На запад', 'Солончак 2'}};
};

room {
	nam = 'Солончак 2';
	disp = 'Солончак';
	pic = 'theme/display.png;pic/map.png@c60,-130;pic/triangle.png@85,90';
	dsc = 'Строения посёлка скрылись за горизонтом и вокруг осталась только подсохшая белая поверхность, скрывающая бездонную черную грязь.';
	obj = {'Шкипер2', 'Сканер', 'Малуры'};
	way = {path {'На запад', 'Солончак 3'}};
};

room {
	nam = 'Солончак 3';
	disp = 'Солончак';
	onenter = 'Ветер стал крепчать. Шкипер с озабоченным видом начал уменьшать площадь паруса.';
	pic = 'theme/display.png;pic/map.png@c100,-130;pic/triangle.png@85,90';
	dsc = 'Вокруг вся та же белая пустота.';
	obj = {'Шкипер2', 'Сканер'};
	way = {'На запад', 'Остров'};
	onexit = function(s, w)
		if w^'На запад' then
			p '-- Нам надо найти укрытие! Это песчаная буря! -- Прокричал мне шкипер.';
			return false;
		end;
	end;
};

room {
	nam = 'Остров';
	onenter = 'Мы вкатились на небольшой песчаный островок. Посередине виднеется какое-то строение. Шкипер снял парус и начал выкидывать какие-то верёвки наружу.^-- Вбивай эти колышки поглубже и привязывай! -- Прокричал он мне с трудом перекрывая свист ветра.^Закрепив буер, мы поспешили спрятаться в строении. Овальная дверь поддалась с трудом из-за заржавевших петель, но всё же закрылась. Мы оказались внутри помещения со стенами из стальных заклёпанных листов. Это похоже на какой-то корабль.';
	pic = 'theme/display.png;pic/map.png@c120,-130;pic/triangle.png@85,90';
	dsc = 'Пол засыпан толстым слоем песка.';
	obj = {'Шкипер3', 'Хворост'};
}:disable();

dlg {
	nam = 'Разговор с гулем';
	pic = 'theme/display.png;pic/map.png@c120,-130;pic/triangle.png@85,90';
	onenter = function()
		if visits() == 0 then
			p 'Мутант руками сбивает огонь с кожаного плаща.^-- Какого хрена, вы чёртовы недоумки пытались меня спалить на моём же корабле?';
		end;
	end;
	phr = {
		{'Эй, ты разговариваешь?', '-- А ты обычно молчишь, когда тебя поджигают, да?'};
		{'Кто ты такой?', '-- Я? Кто я такой? Я капитан этой чёртовой лоханки! Я Кристофер Джонс, лучший капитан среди всех вонючих траулеров города Ангелов!',
			{'Как ты здесь оказался?', '-- Я вёз полный трюм свежемороженых морепродуктов, когда чёртова ядерная бомба взорвалась прямо под днищем!',
				{'Что было дальше?', '-- Когда я очнулся, корабль лежал среди болота, от экипажа и следа не осталось. Вокруг какое-то вонючее болото. Хочется жрать.. Кожа облезает, если закопаться в песок, то не так чешется.. У вас есть что пожрать? -- Мутант явно стал терять концентрацию и стал заговариваться.',
					{cond = function() return have 'Мясо малура' end, 'Да, вот кусок мяса!', function() p 'Мутант выхватил мясо из моих рук и практически моментально его заглотил.^-- Я пожалуй покемарю теперь, парни. Прикройте дверь, когда будете сваливать.^После чего он снова зарылся в песок.'; walkout(); remove 'Гуль'; malur = malur - 1; if malur == 0 then remove 'Мясо малура'; end; end;};
					{cond = function() return not have 'Мясо малура' end, 'Нет, у нас ничего нет.', function() p '-- Это очень зря, парни. Очень зря. Я ведь соврал про экипаж. Но что мне оставалось делать? -- Бормоча что-то, мутант резко бросился ко мне с ножом в руке!'; walkout(); end;};};};};
	};
};

room {
	nam = 'Солончак 4';
	disp = 'Солончак';
	onenter = 'Я оглянулся но островок уже скрылся позади. Наш буер оставляет за собой чёткий след от колёс.';
	pic = 'theme/display.png;pic/map.png@c200,-130;pic/triangle.png@85,90';
	dsc = 'Вокруг только солончак.';
	obj = {'Шкипер2', 'Сканер', 'Малуры'};
	way = {path {'На запад', 'Солончак 5'}};
};

room {
	nam = 'Солончак 5';
	disp = 'Солончак';
	onenter = 'На западе показался берег и шкипер прокричал мне поворачивать на север.';
	pic = 'theme/display.png;pic/map.png@c300,-80;pic/triangle.png@85,90';
	dsc = 'Вокруг только солончак.';
	obj = {'Шкипер2', 'Сканер'};
	way = {path {'На север', 'Солончак 6'}};
};

room {
	nam = 'Солончак 6';
	disp = 'Солончак';
	onenter = 'На берегу справа в скалах показалось что-то явно искусственного происхождения.';
	pic = 'theme/display.png;pic/map.png@c330,-30;pic/triangle.png@85,90';
	dsc = 'Мы катимся примерно на северо-запад.';
	obj = {'Шкипер2', 'Сканер', 'Дирижабль'};
	way = {path {'На север', 'Солончак 7'}};
};

room {
	nam = 'Солончак 7';
	disp = 'Солончак';
	onenter = 'Шкипер перекидывает парус, кажется ветер опять меняется.';
	pic = 'theme/display.png;pic/map.png@c400,50;pic/triangle.png@85,90';
	dsc = 'Мы снова выкатились на просторы высохшего солёного озера.';
	obj = {'Шкипер2', 'Сканер'};
	way = {path {'На север', 'Дальний причал'}};
	onexit = 'Мы плавно вкатились на широкую песчаную полосу и шкипер первый выпрыгнул наружу.^-- Эй, Джим, Грег, Бобби! Вы где, унылые червяки? Опять пьянствуете без меня?^Я же проверил заряжено ли оружие и не спеша последовал за ним. Что-то меня настораживало в этом месте. Слишком тихо.^-- Да ну нахер! -- С криком мимо меня пробежал шкипер.^Его преследовал здоровый гекко. Увидев меня ящерица зашипела и переключилась на меня.';
};

room {
	nam = 'Дальний причал';
	pic = 'theme/display.png;pic/map.png@c460,130;pic/triangle.png@85,90';
	enter = function()
		snd.music 'bgm/DesertWind.mp3';
		if rnd(2) == 1 and not seen 'Гекко' then 
			objs():add('Гекко');
		end;
		if visits() == 0 then
			ways():disable();
		end;
	end;
	dsc = 'Я стою на главной и единственной улице этого поселения.';
	obj = {'Хижины', 'Кабак', 'Гекко'};
	way = {'На запад', 'На юг', path {'На восток', 'На берегу2'}, path {'На север', 'Ржавый грузовик'}};
	onexit = function(s, w)
		if w^'На юг' then
			p 'Тут конечно стоят эти буеры. Но я вот вообще без понятия как с парусом управляться. Надеюсь этому шкиперу там икается. Ведь я его вспоминаю. Надо поискать другой путь.';
			return false;
		elseif w^'На запад' then
			p 'Я немного прошёл по берегу и упёрся в отвесные скалы. Надо поискать другой путь.';
			return false;
		end;
	end;
};

room {
	nam = 'На берегу2';
	disp = 'На берегу';
	pic = 'theme/display.png;pic/map.png@c300,50;pic/triangle.png@85,90';
	enter = function()
		if rnd(2) == 1 and not seen 'Гекко' then 
			objs():add('Гекко');
		end;
		if visits() == 0 then
			p 'Кажется вдалеке я увидел парус. Но скорее всего это обман зрения.';
		end;
	end;
	dsc = 'Я на берегу высохшего озера.';
	obj = {'Грязь', 'Гекко'};
	way = {'На запад', path {'На юг', 'Место крушения'}, 'На восток', path {'На север (Дальний Причал)', 'Дальний причал'}};
	onexit = function(s, w)
		if w^'На запад' then
			p 'На западе большое солёное болото. По нему не пройдёшь!';
			return false;
		elseif w^'На восток' then
			p 'На восток ведёт узкое ущелье. Но пройдя немного я увидел впереди низину, где просто кишат гекко. Там их сотни! Поищу другой путь.';
			return false;
		end;
	end;
};

room {
	nam = 'Место крушения';
	pic = 'theme/display.png;pic/map.png@c270,-20;pic/triangle.png@85,90';
	enter = function()
		if visits() == 0 then
			p 'Я вышел к месту крушения огромного дирижабля. Именно его я видел с борта буера.';
		end;
	end;
	dsc = 'Я на берегу высохшего озера.';
	obj = {'Дирижабль2'};
	way = {'На запад', 'На юг', 'На восток', path {'На север', 'На берегу2'}};
	onexit = function(s, w)
		if w^'На запад' or w^'На юг' then
			p 'Там дальше только грязь. Пешком не пройдёшь.';
			return false;
		elseif w^'На восток' then
			p 'В этом направлении отвесные скалы перекрывают дорогу.';
			return false;
		end;
	end;
};

room {
	nam = 'Ржавый грузовик';
	pic = 'theme/display.png;pic/map.png@c530,230;pic/triangle.png@85,90';
	dsc = 'Вокруг только высохшая земля и сухие клочки травы.';
	obj = {'Грузовик2'};
	way = {'На запад', path {'На юг', 'Дальний причал'}, 'На восток', path {'На север', 'Заправка'}};
	onexit = function(s, w)
		if w^'На запад' then
			p 'Путь становится всё более пересечённым. Похоже дальше в этом направлении я не пройду.';
			return false;
		elseif w^'На восток' then
			p 'Топкая низина с вялотекущим ручьём преградили мне путь.';
			return false;
		end;
	end;
};

room {
	nam = 'Заправка';
	pic = 'theme/display.png;pic/map.png@c570,320;pic/triangle.png@85,90';
	onenter = function()
		snd.music 'bgm/DesertWind.mp3';
		if n6 == 1 or n7 == 1 then
			p 'Я посмотрел на карту в Пип-Бое. Теперь мне надо на восток.';
		end;
	end;
	dsc = 'Я вышел к развалинам автозаправки. Из песка торчат обломки стен и нескольких резервуаров для топлива.';
	obj = {'Вход', 'Ржавый остов'};
	way = {'На запад', path {'На юг', 'Ржавый грузовик'}, 'На восток', 'На север', 'Лифт'};
	onexit = function(s, w)
		if w^'На запад' then
			p 'Путь становится всё более пересечённым. Похоже дальше в этом направлении я не пройду.';
			return false;
		elseif w^'На север' then
			p 'В этом направлении отвесные скалы перекрывают дорогу.';
			return false;
		elseif w^'На восток' and n6 == 1 or n7 == 1 then
			walk 'В пустоши';
			p 'Без указателя в Пип-бой я бы точно заблудился в этой пустоши. Тут нет совершенно никаких ориентиров.';
		end;
	end;
};

room {
	nam = 'Лифт';
	pic = 'theme/display.png;pic/map.png@c570,320;pic/triangle.png@85,90';
	enter = function()
		snd.music 'bgm/Enclave.mp3';
	end;
	dsc = 'Внутри лифта пахнет чем-то затхлым.';
	obj = {};
	way = {path {'Поверхность', 'Заправка'}, 'Уровень 1', 'Уровень 2'};
	onexit = function(s, w)
		snd.play 'weapon_sounds/elevator.ogg';
		if w^'Уровень 2' then
			p 'Двери лифта раскрылись и внутрь хлынула мутная вода. Уровень затоплен где-то по колено.';
			lifeon('Что-то');
		else
			lifeoff('Что-то');
		end;
	end;
}:disable();

room {
	nam = 'Уровень 1';
	pic = 'theme/display.png;pic/map.png@c570,320;pic/triangle.png@85,90';
	dsc = 'Я стою у лифта, на стене рядом нарисованы указатели. Тут есть мастерская и диспетчерская.';
	obj = {'Отключенный робомозг'};
	way = {'Лифт', 'Мастерская', 'Диспетчерская'};
};

room {
	nam = 'Мастерская';
	pic = 'theme/display.png;pic/map.png@c570,320;pic/triangle.png@85,90';
	dsc = 'В мастерской находятся несколько верстаков и станков.';
	obj = {'Разобранная броня', 'Коробка с патронами'};
	way = {path {'К лифту', 'Уровень 1'}};
};

room {
	nam = 'Диспетчерская';
	pic = 'pic/terminal.png';
	dsc = 'В диспетчерской пахнет жареной пылью. Этот специфический запах от старых конденсаторов и магнитных катушек.';
	obj = {'Терминал 5'};
	way = {path {'К лифту', 'Уровень 1'}};
};

dlg {
	nam = 'Терминал Р';
	pic = 'pic/coding.gif';
	onenter = 'Добро пожаловать в бункер Ромео, пользователь.';
	phr = {
		{true, 'Статус.', function() p('Насосы - '..(n1 + n2 + n3 + n4 + n5 + n6 + n7)..'/7. Энергопитание - '..power..'%.'); end,
			{true, 'Управление насосами.', 'ОК',
				{true, function() if n0 == 0 then p 'Насос 6 - отключен.'; end; end, 'Устройство не отвечает.'};
				{true, function() if n0 == 0 then p 'Насос 7 - отключен.'; end; end, 'Устройство не отвечает.'};
				{true, function() if n6 == 0 and n0 == 1 then p 'Насос 6 - отключен.'; elseif n6 == 1 then p 'Насос 6 - включен.'; end; end, 'Устройство исправно.',
					{true, cond = function() if n6 == 0 then return true end end, 'Включить.', function() p 'Готово.'; n6 = 1; power = power + 10; end};
					{true, cond = function() if n6 == 1 then return true end end, 'Выключить.', function() p 'Готово.'; n6 = 0; power = power - 10; end};
					{true, 'Назад.', function() pop(); end};};
				{true, function() if n7 == 0 and n0 == 1 then p 'Насос 7 - отключен.'; elseif n7 == 1 then  p 'Насос 7 - включен.'; end; end, 'Устройство исправно.',
					{true, cond = function() if n7 == 0 then return true end end, 'Включить.', function() p 'Готово.'; n7 = 1; power = power + 10; end};
					{true, cond = function() if n7 == 1 then return true end end, 'Выключить.', function() p 'Готово.'; n7 = 0; power = power - 10; end};
					{true, 'Назад.', function() pop(); end};};
				{true, 'Назад.', function() pop(); end};};
			{true, 'Уровень воды.', function() p('Текущий уровень '..(115 - power)..'.'); end};
			{true, 'Выход из программы.', function() walk('Диспетчерская') end};};
		{true, 'Связь.', 'Сетевые протоколы загружены.',
			{'Включить синхронизацию.', 'Успешно! Связь с бункером Альфа восстановлена.^Пользователь J ваша задача обновлена. Вернитесь в лабораторию Альфа для дополнительных инструкций. Маршрут загружен в Пип-Бой.'};
			{true, 'Назад.', function() pop(); end};};
		{true, 'Записи.', 'Обнаружено 2 записи.',
			{true, 'Прочти меня.', 'Джек, я добрался. Но тех двух таблеток радХ явно было недостаточно. Похоже для меня тоже всё скоро закончится. Главное: не верь ей. Марго всё это время просто врала нам всем..^PS: Я припрятал кое-что для тебя в мастерской. Надеюсь это тебе пригодится.^^Крис. 27 10 2077'};
			{true, 'не верь.', 'НЕ ВЕРЬ ЕЙ!^^Крис. 29 10 2077'};
			{true, 'Назад.', function() pop(); end};};
		{true, 'Выход из программы.', function() walkout(); end};
	};
};

room {
	nam = 'Уровень 2';
	pic = 'theme/display.png;pic/map.png@c570,320;pic/triangle.png@85,90';
	dsc = 'Свет лампы с трудом пробивается через плафон покрытый плесенью. На стене были какие-то указатели, но влажность не пощадила краску.';
	obj = {'Что-то'};
	way = {'Лифт', path {'На запад', 'Лаборатория'}, path {'На восток', 'Насосная станция'}};
	onexit = function(s, w)

	end;
};

room {
	nam = 'Лаборатория';
	pic = 'theme/display.png;pic/map.png@c570,320;pic/triangle.png@85,90';
	dsc = 'Здесь тоже воды по колено. Когда-то это было лабораторией. В мигающем свете я вижу покрытое плесенью оборудование и набухшие от влаги лабораторные журналы.';
	obj = {'Стенной шкафчик5', 'Что-то'};
	way = {path {'К лифту', 'Уровень 2'}};
};

room {
	nam = 'Насосная станция';
	pic = 'theme/display.png;pic/map.png@c570,320;pic/triangle.png@85,90';
	enter = function()
		p 'Разгребая ногами воду, я вошёл в насосную станцию.';
		if n0 == 0 and seen 'Ремонтный робомозг' then
			p 'Робомозг что-то делает в раскрытой панели управления насосами. И насосы внезапно заработали!';
			n6 = 1;
			n7 = 1;
			n0 = 1;
			power = power + 20;			
		end;
	end;
	dsc = 'Здесь так же всё затоплено.';
	obj = {'Насосы', 'Что-то'};
	way = {path {'К лифту', 'Уровень 2'}};
};

room {
	nam = 'В пустоши';
	pic = 'theme/display.png;pic/map.png@c370,320;pic/triangle.png@85,90';
	enter = function()
		ways():disable();
		p 'В мареве горячего воздуха я принял это существо за обломок камня, настолько оно хорошо сливалось с местностью.';
	end;
	dsc = 'Вокруг только песок и редкие скалы.';
	obj = {'Смертекогть'};
	way = {path {'На запад', 'Заправка'}, 'На юг', path {'На восток', 'Руины города'}, 'На север'};
	onexit = function(s, w)
		if w^'На юг' or w^'На север' then
			p 'Отклоняться от курса мне почему-то кажется плохой идеей.';
			return false;
		end;
	end;
};
