; $Name: Mobile. Big Keyboard$
; $Name(ru): Мобильная. Большая клавиатура$

define(PICEXT, `png') dnl

define(WIDTH, 540) dnl
define(HEIGTH, 980) dnl
define(FIGHEIGTH, 140) dnl

define(KEYBOARD, 41) dnl


# Некая рандомная бумажно-синяя палитра из интернета
#024489
#178fd6
#cddde8
#eeece8
#fffcf7
define(cl_most_white, `#fffcf7') dnl
define(cl_most_black, `#024489') dnl
define(cl_medium, `#178fd6') dnl
define(cl_focus, `#024489') dnl

; Окно приложения
    ; размер игрового пространства в пикселях (число)
    scr.w = WIDTH
    scr.h = HEIGTH

    scr.col.bg = cl_most_white ; цвет фона
    scr.col.brd = cl_most_white ; цвет бордюра, если он есть (по умолчанию чёрный)
    scr.gfx.scalable = 1;  ; [0|1|2] (0 - не масштабируемая тема, 1 - масштабируемая, 2 - масштабируемая без сглаживания), начиная с версии 2.2.0 доступны дополнительно [4|5|6]: 4 - полностью не масштабируемая (с не масштабируемыми шрифтами), 5 - масштабируемая, с не масштабируемыми шрифтами, 6 - масштабируемая без сглаживания, с не масштабируемыми шрифтами
    scr.scale_aware = 0 ; [0|1|2] (поддержка адаптивных тем: 0 - виртуальное разрешение, 1 - виртуальное разрешение с реальными пропорциями, 2 - реальное разрешение)
    scr.dpi = 96 ; [dpi|dpi1-dpi2] (задать DPI для которого создана тема, по умолчанию 96)
    scr.gfx.scale = 0.5 ; масштаб (задать масштабирование графики, 1.0 по умолчанию)
    scr.gfx.bg = fon.png ; путь к картинке фонового изображения (строка)
    scr.gfx.cursor.x = 1 ; x координата активной точки курсора (число)
    scr.gfx.cursor.y = 1 ; y координата активной точки курсора (число)
    ; scr.gfx.cursor.normal = cursor.PICEXT ; путь к картинке-курсору (строка)
    ; scr.gfx.cursor.use = cursor-use.PICEXT ; путь к картинке-курсору режима использования (строка)
    ; scr.gfx.use = ; путь к картинке-индикатору режима использования (строка)
    scr.gfx.pad = 10 ; размер отступов к скролл-барам и краям меню (число)
    ; координаты, ширина и высота окна изображений. Области, в которой располагается картинка сцены. Интерпретация зависит от режима расположения (числа)
    scr.gfx.x = eval(0)
    scr.gfx.y = eval(HEIGTH - FIGHEIGTH)
    scr.gfx.w = eval(WIDTH)
    scr.gfx.h = eval(FIGHEIGTH)
    ; win.gfx.h - синоним scr.gfx.h (для совместимости)
    ; scr.gfx.icon = пусть к файлу-иконке игры (ОС зависимая опция, может работать некорректно в некоторых случаях)
    scr.gfx.mode = float-bottom-center ; режим расположения (строка fixed, embedded или float). Задаёт режим изображения. embedded -- картинка является частью содержимого главного окна, параметры scr.gfx.x, scr.gfx.y, scr.gfx.w игнорируются. float -- картинка расположена по указанным координатам (scr.gfx.x, scr.gfx.y) и масштабируется к размеру scr.gfx.w x scr.gfx.h если превышает его. fixed -- картинка является частью сцены как в режиме embedded, но не скроллируется вместе с текстом, а расположена непосредственно над ним. Доступны модификации режима float с модификаторами 'left/right/center/middle/bottom/top', указывающими как именно размещать картинку в области scr.gfx. Например: float-top-left;

; Основное окно с текстом
    win.scroll.mode = 2 ; [0|1|2|3] режим прокрутки области сцены. 0 - нет автоматической прокрутки, 1 - прокрутка на изменение в тексте, 2 прокрутка на изменение, только если изменение не видно, 3 - всегда в конец;
    ; координаты, ширина и высота главного окна. Области, в которой располагается описание сцены (числа)
    win.x = eval(WIDTH * 5 / 100)
    win.y = eval(HEIGTH * KEYBOARD / 100)
    win.w = eval(WIDTH * 88 / 100)
    win.h = eval(HEIGTH * (100-KEYBOARD-7) / 100 - FIGHEIGTH)
    ; win.fnt.name = путь к файлу-шрифту (строка). Здесь и далее, шрифт может содержать описание всех начертаний, например: {sans,sans-b,sans-i,sans-bi}.ttf (заданы начертания для regular, bold, italic и bold-italic). Вы можете опускать какие-то начертания, и движок сам сгенерирует их на основе обычного начертания, например: {sans,,sans-i}.ttf (заданы только regular и italic);
    win.align = justify ; center/left/right/justify (выравнивание текста в окне сцены);
    win.fnt.size = 18 ; размер шрифта главного окна (размер)
    win.fnt.height = 1.2 ; междустрочный интервал как число с плавающей запятой (1.0 по умолчанию)
    ; пути к файлам-изображениям скроллеров вверх/вниз для главного окна (строка)
    win.gfx.up = aup.PICEXT
    win.gfx.down = adown.PICEXT
    ; координаты скроллеров (координата или -1)
    win.up.x = -1
    win.up.y = -1
    win.down.x = -1
    win.down.y = -1
    win.col.fg = cl_most_black ; цвет текста главного окна (цвет)
    win.col.link = cl_focus ; цвет ссылок главного окна (цвет)
    win.col.alink = cl_medium ; цвет активных ссылок главного окна (цвет)
    win.ways.mode = top ; top/bottom (задать расположение списка переходов, по умолчанию top -- сверху сцены)

; Инвентарь
    ; координаты, высота и ширина области инвентаря. (числа)
    inv.x = eval(WIDTH * 5 / 100)
    inv.y = eval(HEIGTH * (100-7) / 100 - FIGHEIGTH)
    inv.w = eval(WIDTH * 90 / 100)
    inv.h = eval(HEIGTH * 7 / 100)
    inv.mode = horizontal-left ; строка режима инвентаря (horizontal или vertical). В горизонтальном режиме инвентаря в одной строке могут быть несколько предметов. В вертикальном режиме, в каждой строке инвентаря содержится только один предмет. Существуют модификации (-left/right/center). Вы можете задать режим disabled если в вашей игре не нужен инвентарь;
    inv.col.fg = cl_medium ; цвет текста инвентаря (цвет)
    inv.col.link = cl_most_black ; цвет ссылок инвентаря (цвет)
    inv.col.alink = cl_focus ; цвет активных ссылок инвентаря (цвет)
    ; inv.fnt.name = ; путь к файлу-шрифту инвентаря (строка)
    inv.fnt.size = 20 ; размер шрифта инвентаря (размер)
    inv.fnt.height = 1.0 ; междустрочный интервал как число с плавающей запятой (1.0 по умолчанию)
    ; пути к файлам-изображениям скроллеров вверх/вниз для инвентаря (строка)
    inv.gfx.up = aup.PICEXT
    inv.gfx.down = adown.PICEXT
    ; inv.up.x, inv.up.y, inv.down.x, inv.down.y = координаты скроллеров (координата или -1)

; Меню
    menu.col.bg = cl_most_black ; меню (цвет)
    menu.col.fg = cl_most_white ; текста меню (цвет)
    menu.col.link = cl_most_white ; цвет ссылок меню (цвет)
    menu.col.alink = cl_focus ; цвет активных ссылок меню (цвет)
    menu.col.alpha = 200 ; прозрачность меню 0-255 (число)
    menu.col.border = cl_medium ; цвет бордюра меню (цвет)
    menu.bw = 3 ; толщина бордюра меню (число)
    ; menu.fnt.name = путь к файлу-шрифту меню (строка)
    menu.fnt.size = 20 ; размер шрифта меню (размер)
    menu.fnt.height = 1.3 ; междустрочный интервал как число с плавающей запятой (1.0 по умолчанию)
    menu.gfx.button = menu.PICEXT ; путь к файлу изображению значка меню (строка)
    ; координаты кнопки меню (числа)
    menu.button.x = eval(WIDTH - 48)
    menu.button.y = eval(HEIGTH - 45 - 2)

; Звуки
; snd.click = путь к звуковому файлу щелчка (строка)

; include = имя темы (последний компонент в пути каталога) (строка)
