--$Name:Сказка про соломинку$
require "parser/mp-ru"
require "fmt"
require 'declarative' 
onc = events.once
oncst = events.onceString

require 'importManuskript' -- Модуль чтения манускрипта
declare 'MainMenu' (readManuskriptDir(instead_gamepath().."/outline/01--------_----/"))
declare 'Intro' (readManuskriptDir(instead_gamepath().."/outline/02-------/"))
declare 'InPit' (readManuskriptDir(instead_gamepath().."/outline/03--_---/"))
declare 'NearPit' (readManuskriptDir(instead_gamepath().."/outline/04------_-_----/"))
declare 'InField' (readManuskriptDir(instead_gamepath().."/outline/05--_----/"))
declare 'InTown' (readManuskriptDir(instead_gamepath().."/outline/06--_---------/"))
declare 'AtSlope' (readManuskriptDir(instead_gamepath().."/outline/07--_-----_-_------/"))
declare 'InCave' (readManuskriptDir(instead_gamepath().."/outline/08--_------/"))
declare 'NearGarbage' (readManuskriptDir(instead_gamepath().."/outline/09---_------/"))
declare 'NearMill' (readManuskriptDir(instead_gamepath().."/outline/10--_------/"))
declare 'InForest' (readManuskriptDir(instead_gamepath().."/outline/11--_----/"))
declare 'InForestNight' (readManuskriptDir(instead_gamepath().."/outline/12--_----_-----/"))
declare 'InTownEvening' (readManuskriptDir(instead_gamepath().."/outline/13--------_-_---------/"))
declare 'Epilogue' (readManuskriptDir(instead_gamepath().."/outline/14-------/"))


fmt.para = true -- включить отступы параграфов

-- mp.errhints = false
game.dsc = [[]]

---------------------- Глобальные переменные ---------------------------
global {
    scoreExam = 0;
}

addScore = function(st)
	--scoreExam = scoreExam + 1
	--pn('{$fmt em|{$fmt r|(Счёт увеличился на 1)}}')
end  -- func

-- Сообщение о потере предмета из инвентаря
printLooseObj = function(st)
	pn('{$fmt em|Потеряно: '..st..'}')
end  -- func

-- Сообщение о добавлении предмета в инвентарь
printTakeObj = function(st)
	pn('{$fmt em|Получено: '..st..'}')
end  -- func

const {
    tBlink = 2;
}

---------------------- Добавляем свои глаголы -------------------------
include "myverbs.lua"

---------------------- Специальный класс для комнат -------------------

Ma = Class ({
    --manuskriptName=''; -- Строка с именем декларации, куда подгружается комната в манускрипт
    --description=''; -- Развернутое описание комнаты
    pic = function(s) return 'img/'..s.manuskriptName..'.png' end;
    dsc = function(s)
			if s:once() then return s:description()
							else return _G[s.manuskriptName]["Сокращенное описание"]
							end --if
			end;--func
    description = function(s) return _G[s.manuskriptName]['Полное описание'] end;
    cant_go = function(s) if _G[s.manuskriptName]["Нельзя идти"] then return _G[s.manuskriptName]["Нельзя идти"] else return false end end;
    after_Listen = function(s,w)
					if w then return false end
					if _G[s.manuskriptName]["Слушать"] then return _G[s.manuskriptName]["Слушать"] else return false end
					end;
    after_Smell = function(s,w)
					if w then return false end
					if _G[s.manuskriptName]["Нюхать"] then return _G[s.manuskriptName]["Нюхать"] else return false end
					end;
}, room)

------------------------------------------------------------------------
----------------------- Вступление -------------------------------------
cutscene {
    nam = 'STARTGAME';
    next_to = 'В яме';
    text = {Intro['Приветствие 1'],
			Intro['Приветствие 2'],
			Intro['О парсере'],
			Intro['Про героя 1'],
			Intro['Про героя 2'],
			Intro['Про героя 3'],
			Intro['Отправление'],
			Intro['Завязка'],
			};
	pic = function(s)
			if s.__num == 1 then return 'img/Teller.png'
			elseif s.__num == 2 then return 'img/Teller.png'
			elseif s.__num == 3 then return 'img/Teller.png'
			elseif s.__num == 4 then return 'img/Mopa.png'
			elseif s.__num == 5 then return 'img/Mopa.png'
			elseif s.__num == 6 then return 'img/Town.png'
			elseif s.__num == 7 then return 'img/Teller.png'
			elseif s.__num == 8 then return 'img/InPit.png'
			else return false
			end --if
			end;--func
	dsc = function(s)
		mp:clear()
		if type(s.text) == 'function' then
			local t = std.call(s, 'text', s.__num)
			if not t then s:Next(true) end
			p (t)
		else
			if type(s.text) == 'string' then p (s.text)
			else p (s.text[s.__num])
			end
		end --if
		if mp.msg.CUTSCENE_MORE then
			p("^", mp.msg.CUTSCENE_MORE)
		end --if
	end;--func
}

mp.msg.HELP = MainMenu['Помощь']


----------------------- Инвентарь -----------------------
game:dict {
	["Мопа/рд"] = "Мопы";
	["Мопа/вн"] = "Мопу";
	["Мопа/дт"] = "Мопе";
	["Мопа/тв"] = "Мопой";
	["Мопа/пр"] = "Мопе";}
	
obj {
	-"Мопа/мр";
	nam = "Мопа";
	before_Default = 'Ничего не произошло.';
	before_Exam = function(s)
			p(InPit["Осмотреть Мопу"])
			if have 'Соломинка' then pn 'Во рту соломинка.' end
			return true
			end;
	before_Talk = InPit["Говорить с Мопой"];
	before_Drop = InPit["Выбросить Мопу"];
	before_Smell = 'Пахнет героизмом. Едва-едва, самую малость. Но пахнет.';
}:attr "concealed"



obj {
	-"шляпа";
	nam = "Шляпа";
	before_Default = 'Ничего не произошло.';
	before_Exam = InPit["Осмотреть шляпу"];
	before_Disrobe = InPit["Снять шляпу"];
	before_WearOn = 'Мопа по доброй воле ни за что не расстанется со своей шляпой.';
	before_Talk = InPit["Говорить со шляпой"];
	before_Drop = InPit["Снять шляпу"];
	before_Give = 'И не проси, читатель. Мопа никогда, ни при каких обстоятельствах не расстанется со своей шляпой!';
	before_Show = 'Мопе не было никакой необходимости специально демонстрировать свою шляпу; ее и так всякому отлично видно.';
	['before_Eat,Tear,Attack'] = "Как бы мне объяснить тебе, дорогой читатель, почему Мопа никак не мог этого сделать... Видишь ли, шляпа для Мопы это не просто одежда для головы. Это его статус, его принадлежность к право-имеющим. Самое дорогое, что у него есть, и самое важное."; 
	before_Touch = "Шляпа была теплая и слегка ворсистая на ощупь.";
	before_Smell = "Шляпа не пахла ничем особенным.";
	before_Listen = "Шляпа беззвучна.";
}:attr "concealed"



Patience = Class ({
	before_Exam = InPit["Осмотреть терпение"];
	['before_Eat,Taste'] = InPit["Съесть терпение"];
	before_Drop = "Мопа не хотел разбрасываться терпением, оно могло ему еще пригодиться.";
	['before_Pull,Push,Transfer'] = "Как ни перемещай терпение, больше его от этого не станет.";
	before_Touch = "Гладкое и слегка упругое.";
	before_Smell = "У каждого терпения запах особый. Мопино пахло свежей травой.";
	before_Listen = 'Если очень-очень сильно прислушаться, можно было услышать протяжный звук "О-у-м".';
	['before_Tear,Cut'] = "Зачем Мопе половинка терпения? Она ведь не годится ни на что.";
}, obj)

t1 = Patience {
	-"кусок терпения|терпение";
	nam = "#Терпение";}
t2 = Patience {
	-"кусок терпения|терпение";
	nam = "#Терпение";}
t3 = Patience {
	-"кусок терпения|терпение";
	nam = "#Терпение";}
t4 = Patience {
	-"кусок терпения|терпение";
	nam = "#Терпение";}

obj {
	-"соломинка";
	nam = "Соломинка";
	before_Default = 'Мопе не по душе эта идея.';
	before_Give = 'Мопе нужны очень веские причины, чтобы отдать кому-либо свою любимую соломинку.';
	before_Show = 'В соломинке нет ничего интересного для окружающих.';
	before_Exam = 'Полый стебелёк без листьев пшенично золотого цвета. Довольно прочный.';
	before_Drop = "Мопа не хотел выбрасывать соломинку, он боялся, что она испачкается.";
	before_Taste = "Травянистый сладковатый вкус.";
	before_Tear = "Мопа не хотел разрывать соломинку, она и так была не слишком длинна.";
	before_Touch = "Гладкая.";
	before_Smell = "Мопа не почувствовал никакого особенного запаха.";
	before_Listen = "Соломинка беззвучна.";
	before_Blow = 'Мопа подул в соломинку. Воздух легко проходил через отверстие внутри.';
	before_Insert = function(s, v)
			if v^'Перчатка' then
					events:add('Вставили соломинку')
					move('Соломинка', 'Перчатка')
					printLooseObj 'соломинка'
					pn(NearGarbage["Вставить соломинку"])
					return true
			else return false
			end --if
			end;--func
}

obj {
	-"дурацкая идея, идея";
	nam = "Идея";
	before_Default = 'Ничего не произошло.';
	before_Drop = "Идея пускай и не самая лучшая из тех, что посещала Мопу, но все-таки выбрасывать ее просто так -- опрометчиво.";
	before_Exam = function(s)
			if events:check('Нет такого события') then 
			elseif events:check('Пришли в деревню') then return 'Мопа достал идею и покрутил ее так и этак. Со всех сторон выходило, что надо пообщаться с местными жителями и понять, что тут вообще происходит.'
			elseif events:check('Нашли пуговицу') then return 'Мопа изучил идею. Если он все правильно понял, идея предлагала ему двигаться вперед. С какой стороны находился перед, идея не уточняла.'
			elseif events:check('Поговорили с кустом') then return 'Идея подсказывала, что если найти тот самый талисман, о котором говорил куст, он может пригодиться.'
			elseif events:check('Пришли на затоптанное место') then return 'Мопа сверился с идеей.^-- Что же здесь произошло? -- вопрошала она.^-- Не знаю, -- честно отвечал Мопа. -- Надо узнать.'
			--elseif events:check('Поговорили с жучком') then return ''
			--elseif events:check('Дали жучку терпение') then return ''
			elseif events:check('Вылезли из ямы') then return 'Идея убеждала Мопу, что так это оставлять нельзя и с жучком надо что-то решать. Те, кто любят непонятные слова, называют такое "незавершенный гештальт".'
			elseif events:check('Подождали прихода жучка') then return 'Мопа внимательно изучил идею, даже потряс ее слегка. "Надо выбираться наверх", -- твердила идея.'
			else return 'Идея всем своим видом намекала сбегать за лестницей. Мопа точно помнил, что когда выходил из дома, при нем была еще одна идея -- по-лучше. Но, видимо, эта вторая идея в яму не поместилась. Вот что называется, грамотно сделанная ловушка: жертва падает внутрь, а спасительная идея -- не пролазит. Умно!'
			end -- if 
			end; --func
	before_Give = function(s, v)
			if v^'Жучок' then return false
			elseif v^'Растроенный' then return 'Человечек не проникся идеей Мопы. Видимо, идея была недостаточно дурацкая для него.'
			else return 'Чтобы кому-то дать дурацкую идею, этот кто-то должен быть способен ее воспринять. Хорошие дурацкие идеи — они, знаете ли, не для всех!';
			end --if
			end;--func
}

obj {
	-"честное слово, слово";
	nam = "Слово";
	before_Exam = InPit["Осмотреть слово"];
	before_Taste = 'Немного сладкое на вкус.';
	before_Eat = 'Мопа сомневался, что ему удастся такое переварить.';
	before_Drop = 'Мопа хоть и маленький, но всё-таки Главный Герой. А настоящие герои словами не разбрасываются.';
	before_Listen = "Ми-лон. Примерно так звучало честное слово.";
}

-----------------------------------------------------------

function init()
	--pl.word = -"ты/мр,2л"
	pl.word = -"Мопа/мр,3л"
	pl.room = 'STARTGAME'
	pl.before_Exam = function(s)
			p(InPit["Осмотреть Мопу"])
			if have 'Соломинка' then pn 'Во рту соломинка.' end
			return true
			end;
	pl.before_Talk = '-- Ну же, Мокупан! -- сказал Мопа себе самому. -- Придумай уже что-нибудь.';
	pl.before_Drop = InPit["Выбросить Мопу"];
	pl.before_Smell = 'Пахнет героизмом. Едва-едва, самую малость. Но пахнет.';
	--pl.before_Default = 'Ничего не произошло.';
	--pl.capacity = 1
	take "Шляпа"
	move(t1, pl)
	move(t2, pl)
	move(t3, pl)
	move(t4, pl)
	take "Идея"
	take "Соломинка"
	take "Слово"
	take "Мопа"
	take "hintSystem"
end

game.hint_verbs = { "#Exam", "#Walk", "#Take", "#Tell", "#Inv" }

include "act1.lua"
include "act2.lua"
include "act3.lua"
include "act4.lua"
include "act5.lua"
include "epilog.lua"
include "hintSystem.lua"
