-- Модуль для загрузки файлов Manuskript

-- Загрузка файла
readManuskriptFile = function(fileName)
	local f = io.open(fileName, "r")
	local blank1 = false -- Флаги ловли двух пустых строк подряд
	local blank2 = false
	local title=nil -- Переменная для записи заголовка карточки манускрипт
	local text = '' -- Переменная для записи текста карточки
	for line in f:lines() do 
		
		if not title then 
					 if string.sub(line, 1, 16) == "title:          " then title = string.sub(line, 17, -1) end
					 end
		if blank1 and blank2 then text = text .. line .. '^'
							 else
								if line == "" then blank1=true else blank1=false end
								if line == "" and blank1 then blank2=true else blank2=false end
								end
					end
	f:close()
	--dprint(title)
	return {["title"] = title, ["text"] = text}
end

-- Загрузка каталога
readManuskriptDir = function(dirName)
	local rez = {}
	--dprint(dirName)
	for f in stead.readdir(dirName) do
		if string.sub(f, -3)=='.md' then
									--dprint(f)
									local rec = readManuskriptFile(dirName..f)
									if rez[rec.title] then  dprint('Ошибка при чтении каталога '.. dirName)
															dprint('Ключ '..rec.title.. ' повторяется!')
															--exit
															end
									rez[rec.title] = rec.text
									end
		end
	return rez
end

-- Загрузка конкретных блоков данных. Так как рекурсивный обход не работает (может и к лучшему), каждый каталог кладется в отдельную таблицу через деклэр


