# Вы можете расположить сценарий своей игры в этом файле.

# Определение персонажей игры.
define d = Character('???', color="#099268")
define k = Character('Клуж', color="#099268")
define doc = Character('Доктор', color="#00ffff")
define a = Character('Айра', image="aira", color="#9e529c")
define nvle = Character(None, kind=nvl, style="centered_nvl_text")  # ← Обратите внимание: справа — встроенный объект режима!
#define narrator = nvl_narrator
image sheet1 = "paper1.png"
image sheet2 = "paper2.png"
image sheet3 = "paper3.png"
image hand2 = "hand2.png"
image hand3 = "hand3.png"
image monster = "monster.png"
image elevator2 = "elevator2.png"
image elevator3 = "elevator3.png"
image maze = "maze.png"
image damage = "damage.png"

image define aira normal = "side aira normal.png"
image define aira look away = "side aira look away.png"
image define aira scared = "side aira scared.png"
image define aira very scared = "side aira very scared.png"
image define aira smile = "side aira smile.png"
image define aira smile up = "side aira smile brows up.png"
image define aira smile down = "side aira smile brows down.png"
image define aira tired = "side aira tired.png"
image define aira unhappy = "side aira unhappy.png"

define audio.floor1 = "audio/1floor.mp3"
define audio.floor2 = "audio/2floor.mp3"
define audio.floor3 = "audio/3rd_floor.mp3"
define audio.figure = "audio/figure.mp3"
define audio.manual = "audio/dark_century.mp3"
define audio.maze = "audio/maze.mp3"
define audio.free = "audio/free.mp3"
define audio.elevator = "audio/elevator.mp3"
define audio.hospital = "audio/hospital.mp3"
define audio.elevator_door = "audio/elevator_door.mp3"
define audio.think = "audio/think.mp3"
define audio.book_open = "audio/book_open.mp3"
define audio.book_close = "audio/book_close.mp3"
define audio.hole = "audio/hole.mp3"
define audio.breath = "audio/breath.mp3"
define audio.breath_fast = "audio/breath_fast.mp3"
define audio.cut = "audio/cut.mp3"
define audio.breaking = "audio/breaking.mp3"
define audio.hrust = "audio/beze.mp3"
define audio.yummy = "audio/yummy.mp3"
define audio.roar1 = "audio/roar1.mp3"
define audio.roar2 = "audio/roar2.mp3"
define audio.hripq = "audio/hripq.mp3"
define audio.hrip1 = "audio/hrip1.mp3"
define audio.hrip2 = "audio/hrip2.mp3"
define audio.list = "audio/list.mp3"
define audio.groul1 = "audio/groul1.mp3"
define audio.groul2 = "audio/groul2.mp3"
define audio.lamp = "audio/lamp.mp3"
define audio.bloodblow = "audio/bloodblow.mp3"
define audio.clothdie = "audio/clothdie.mp3"
define audio.moblojo = "audio/moblojo.mp3"
define audio.funnyjoke = "audio/funnyjoke.mp3"

style centered_nvl_text is nvl_text:
    text_align 0.5

# Вместо использования оператора image можете просто
# складывать все ваши файлы изображений в папку images.
# Например, сцену bg room можно вызвать файлом "bg room.png",
# а eileen happy — "eileen happy.webp", и тогда они появятся в игре.

# Игра начинается здесь:
default rune_draw = draw_logic.Draw("#ded3bf00")

define flashbulb = Fade(0.2, 0.0, 0.8, color='#fff')
define sunstrike = Fade(0.4, 1.2, 1.8, color='#fff')
define flashblood = Fade(0.2, 0.0, 0.8, color='#610909ff') 
define fast_fade = Fade(0.2, 0.0, 0.2, color='#000000ff')
transform shaking: 
    linear 0.05 xoffset -5 yoffset 5
    linear 0.05 xoffset 7 yoffset -7 
    linear 0.05 xoffset 5 yoffset -5 
    linear 0.05 xoffset -7 yoffset 7 
    linear 0.05 xoffset 0 yoffset 0 


define RUNE_CHECKPOINTS1 = [
    (318, 162),
    (342, 298),
    (312, 404),
    (295, 520)
]
define RUNE_CHECKPOINTS2 = [
    (280, 269),
    (277, 323),
    (331, 302),
    (295, 349)
]
define RUNE_CHECKPOINTS3 = [
    (137, 305),
    (437, 462),
    (215, 278),
    (277, 372)
]

define win = 0
define lose = 0
define use = 0

init python in draw_logic:

    import store
    import pygame_sdl2 as pygame

    class Point(object):

        __author__ = "Vladya"

        def __init__(self, x, y, st, color, width):

            self.__x, self.__y = map(int, (x, y))
            self.__st = abs(float(st))

            self.__color = renpy.color.Color(color)
            self.__width = abs(int(width))

        @property
        def x(self):
            return self.__x

        @property
        def y(self):
            return self.__y

        @property
        def st(self):
            return self.__st

        @property
        def color(self):
            return self.__color

        @property
        def width(self):
            return self.__width


    class Draw(renpy.Displayable, store.NoRollback):

        __author__ = "Vladya"

        DRAW_BUTTON = 1

        def __init__(self, background, **properties):

            super(Draw, self).__init__(**properties)
            print("Draw создан. ID:", id(self))
            self.__background = self._get_displayable(background)
            self.__is_pressed = False

            self.__curves = []
            self.__active_curve = None

            self.__color = renpy.color.Color("#9a0000")
            self.__width = 5

        @staticmethod
        def _get_displayable(data):
            result = renpy.displayable(data)
            if not isinstance(result, renpy.display.core.Displayable):
                raise ValueError("{0} isn't a displayable.".format(data))
            return result

        def draw_all(self, canvas):

            for curve in self.__curves:
                print(curve)
                if not curve:
                    print("Лузер")
                    continue

                elif len(curve) == 1:
                    print("Лузер2")
                    point = curve[0]
                    canvas.circle(
                        point.color,
                        (point.x, point.y),
                        (point.width // 2)
                    )

                else:
                    print("Лузер3")
                    prev = None
                    for point in curve:
                        if prev:
                            canvas.line(
                                prev.color,
                                (prev.x, prev.y),
                                (point.x, point.y),
                                prev.width
                            )
                        prev = point

        def add_point(self, x, y, st):
            print("Рисую в Draw ID:", id(self))
            point = Point(x, y, st, self.__color, self.__width)
            if self.__active_curve is None:
                self.__active_curve = []
                self.__curves.append(self.__active_curve)
                
            self.__active_curve.append(point)
           
            renpy.redraw(self, .0)

        def set_color(self, color):
            self.__color = renpy.color.Color(color)

        def set_width(self, width):
            self.__width = width

        def visit(self):
            return [self.__background]

        def event(self, ev, x, y, st):

            if ev.type == pygame.MOUSEMOTION:
                if self.__is_pressed:
                    self.add_point(x, y, st)
                    raise renpy.IgnoreEvent()

            elif ev.type == pygame.MOUSEBUTTONDOWN:
                if ev.button == self.DRAW_BUTTON:
                    self.__is_pressed = True
                    self.add_point(x, y, st)
                    raise renpy.IgnoreEvent()

            elif ev.type == pygame.MOUSEBUTTONUP:
                if ev.button == self.DRAW_BUTTON:
                    self.__is_pressed = False
                    self.__active_curve = None
                    raise renpy.IgnoreEvent()

        def per_interact(self):
            self.__is_pressed = False
            self.__active_curve = None
            renpy.redraw(self, .0)

        def check_rune_success(self, checkpoints, tolerance=40):
            print("Точек:", len([(p.x, p.y) for curve in self.__curves for p in curve]))
            tol_sq = tolerance ** 2
            print("курвы")
            print(self.__curves)
            user_points = [(p.x, p.y) for curve in self.__curves for p in curve]
            if not user_points:
                #print(user_points)
                #print("Лох")
                return False
            for cx, cy in checkpoints:
                print(user_points)
                print(checkpoints)
                if not any((cx - ux) ** 2 + (cy - uy) ** 2 < tol_sq for ux, uy in user_points):
                    return False
            return True

        def reset(self):
            self.__curves = []
            self.__active_curve = None
            self.__is_pressed = False
            renpy.redraw(self, 0)


        def render(self, *rend_args):

            back = renpy.render(self.__background, *rend_args)
            w, h = map(int, back.get_size())

            result = renpy.Render(w, h)
            result.blit(back, (0, 0))

            canvas = result.canvas()
            print("Я есть")
            self.draw_all(canvas)
            return result
define fade = Fade(1.0, 0.5, 1.9)
define dis_start = Dissolve(3.0)

init python:
    def check_and_return():
        if sh == 1:
            success = rune_draw.check_rune_success(RUNE_CHECKPOINTS1, tolerance=12)
        if sh == 2:
            success = rune_draw.check_rune_success(RUNE_CHECKPOINTS2, tolerance=12)
        if sh == 3:
            success = rune_draw.check_rune_success(RUNE_CHECKPOINTS3, tolerance=12)
        print("Проверка выполнена:", success)
        renpy.end_interaction(success)

init -3 python:
    maze = '' 
    mis = 0
    sh = 0
label start:
    stop music
    scene bg darkness
    with dis_start
    play music floor1 loop fadein 1.0

    "Темно. Ну, а чего я ещё ожидала, закрыв глаза? И-и-и-и, оп! Я разомкнула веки."

    scene bg red
    with fade

    a look away "Нет, не помогло..."

    "Всё осталось таким же, как и было, когда я здесь очнулась."

    "Как там называют подобные места в современных фандомах? Закулисье?"

    "Место, которого нет."

    "Место, которого и не было."

    "Плод фантазии, выдумка."

    "Но сейчас оно здесь - прямо передо мной. Пошарпанные стены, тусклый свет, будто кто-то ленится поменять лампочку в плафоне."

    "Да, я будто попала в арт какого-то помешанного на крипипастах художника."

    a normal "Заб-а-авно."

    "Хотя, что здесь забавного? Я чувствую своё тело, как и в обычной жизни. У меня болит голова. Пыль, медленно плавающая в воздухе, щекотит нос."
    
    "Слишком много деталей."

    "Мне ни разу не снились такие подробные сны. Пора принять, что вокруг меня реальность, и перестать пытаться убедить себя в обратном."

    "Реальность, в которой я нахожусь здесь и сейчас. Которая не должна давать повода для улыбки."

    a normal "Ладно, мне следует осмотреться."

    a normal "Не знаю, как я сюда попала, но выход здесь точно должен быть!"

    "То-ли от накопившейся за последние дни усталости, то-ли из-за цветовой гаммы этого места, гнетущей, раздражающей," 
    
    "у меня не получается всмотреться в эти длиннющие коридоры."

    "Чёрное пятно - раз." 
    
    "Чёрное пятно - два." 
    
    "Нет, так не получится."

    a unhappy "Здесь всё одинаковое! Хоть бы указатель был какой!"

    "Невыносимо! Ну, конечно, когда всё было просто? Я всегда жду, что ответы и решения мне преподнесут на блюдечке, с голубой каёмочкой."

    "Я каждый раз, затаив дыхание, надеюсь, что получу какие-то объяснения, намёк, инструкцию."
    
    "И всё равно я каждый раз ищу выход сама."

    "Никакой помощи! Будто я раскалённая печная плита, от которой все боязливо отдёргивают руку."

    a unhappy "Хорошо... Так и быть!"

    a look away "Я просто пойду и... Найду выход! Всегда ведь справлялась сама."

    a look away "Ну да..."

    "Немного пройдя вперёд, я сложила в голове более точное представление об этом месте."

    "Лабиринт, сложенный залами, коридорами, закоулками."

    "Уже не помню, где, но когда-то давно я слышала, что любой лабиринт можно пройти, передвигаясь вдоль одной из стен."

    "С тех пор я всегда так и поступала, если проходила лабиринты от первого лица, в каких-нибудь видеоиграх. Простой, но весьма надёжный способ."

    "По крайней мере, даже если я и потрачу много времени на ходьбу, то сэкономлю силы на запоминании пройденного пути и ориентировании в пространстве."
    
    "Так и поступлю сейчас."

    a normal "Хм-м, что это?"

    scene bg book lies
    with dissolve

    "В одном из закоулков лежала вычурная книга. Стены и пол вокруг неё были измазаны сажей, будто тот, кто оставил её здесь, вспыхнул, заискрился бенгальским огоньком и исчез."

    "Оставил за собой лишь продукт горения."

    "За время моего блуждания это первая и единственная хоть как-то применимая вещь, которую я увидела. Интересно, что в ней?"

    scene bg book opens with Dissolve (2)
    pause(0.5)
    scene bg without book with Dissolve (1.5)
    pause(0.5)

    "Ух-ты!"

    "Я не обманулась, книга действительно была не из простых."

    "Будучи очень похожей на часть коллекционного набора, которые обычно выпускают большие компании, чтобы с одной стороны порадовать," 
    
    "а с другой стороны заработать на фанатах, эта вещица была выполнена искусно."

    "Интересные узоры, обрамлённый контур переплёта, металлические уголки и наконец, большая буква \"М\", занимающая главенствующее место на обложке."

    "Красивая книга, хоть и изрядно потрёпанная временем. Такую было бы грешно хранить корешком к лицу на книжной полке."

    play sound book_open

    "Я расстегнула кожаные застёжки. Будто живая, книга сама распахнулась, избавившись от оков, сдерживавших множество страниц."  
    
    "Она охотно показала мне свои потёртые листы, разделённые грубой ленточкой-закладкой."

    nvle "\n
    \n
    \n
    \n
    \n
    Путь пройден не зря,\n
    Прогресс не теряй.\n
    Ведь в конце дня\n
    Ждёт тебя Рай.\n
    \n
    Чтобы трудности пройти -\n
    Оплати, раз-два-три,\n
    Жёлтые листы\n
    Красным обагри.\n
    "

    a unhappy "Отлично, ты нашла сборник стихов, Айра, молодец! Вот ОН тебе ТОЧНО поможет!"

    "Я уже понадеялась, что это какой-нибудь дневник, в котором найдутся парочка-другая записей об этом странном месте."

    "Может мне вовсе перестать думать? Без надежды нет и разочарования."

    a smile brows down "Ладно, зато будет что в руках подержать, да скуку разогнать..."

    "Вот и я заговорила рифмами. Может быть, мы поладим с этой книжонкой?"

    a scared "АЙ!"

    "Пока я закрывала сборник, что-то, прикреплённое к корешку укололо мне ладонь."

    "Это было каллиграфическое перо, удивительно острое. Подумалось, что если сильно захотеть, то им можно и не просто уколоться..."

    a smile brows down "Орудие самообороны? О-о-о, ты так щедра, книжка! Моя малы-ы-ышка!"

    "И когда я начала разговаривать с предметами? Наверное, тогда же, когда стала говорить и сама с собой."

    a normal "Ну что же, пошли искать выход."

    scene bg backrooms
    with dissolve

    "Мы вернулись в потрёпанные коридоры."

    "Я либо уже привыкла к этому месту, либо свет стал ярче, но оно стало светлее - это точно."

    "Я потупилась."

    "Коридоры и закаулки сменились просторными залами. Стратегия идти вдоль одной стены больше не будет работать!"
    
    "Иначе я попросту не дойду до конца... чем бы это пространство не являлось."

    a smile "Хорошо, я же как-то нашла эту книгу? Значит и найду что-то ещё!"

    "В очередной раз подбодрив себя в слух, я не успокоилась."

    "Я всегда начинаю себя странно вести, если накаляется обстановка."

    "Попадаю в тупик из своих мыслей, наступаю на капкан, сплавленный из острот толпы."

    "Надевая эмоциональные маски, я перестаю быть собой."

    "Я абстрагируюсь от своих страхов, своих ограничений, своих неудач, перестаю нести ответственность за действия, совершённые в маске. И это действительно удобно!"

    "У {color=#d81f1f}Маски{/color} нет страхов - её не остановить."

    "У {color=#d81f1f}Маски{/color} нет ограничений - она способна на всё."

    "У {color=#d81f1f}Маски{/color} нет неудач - она уверенна в себе."

    "{color=#d81f1f}Маска{/color} берёт на себя ответственность."

    "{color=#d81f1f}Маска{/color} портится - маска меняется."

    "Но имеет ли смысл надевать маски, когда ты совершенна одна, в месте, где нет даже зеркал?.."

    #stop music fadeout 3.0

    a normal "Яма?.."

    play music think loop fadein 3.0

    scene bg hole
    with dissolve 

    "Я так зарылась в свои мысли, что и не заметила, как из просторных залов попала в коридор, конца которого не было видно."

    "Так же и у пропасти будто не было дна."

    a normal "Если я нахожусь под землёй, на сколько глубок может быть этот туннель?.."

    "Мне нельзя возвращаться обратно. Не просто так же здесь эта пропасть?"

    "Она явно что-то прячет за собой."

    a normal "Прячет за собой..."

    screen drawing_screen():
        style_prefix "drawing"
        modal True
        python:
            store.rune_draw.reset()
        fixed:
            add rune_draw
            if sh == 1:
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(318, 162))
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(342, 298))
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(312, 404))
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(295, 520))  
            if sh == 2:
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(273, 269))
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(275, 323))
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(325, 302))
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(295, 343))
            if sh == 3:
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(132, 305))
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(428, 462))
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(205, 278))
                add Solid("#1a000000", xysize=(10,10)) at Transform(pos=(275, 370))
            
        #textbutton "Проверить" action Return(rune_draw.check_rune_success(RUNE_CHECKPOINTS, tolerance=60)) xalign 0.5 yalign 1.0
        textbutton "Проверить" action Function(check_and_return) xalign 0.5 yalign 0.8
#            textbutton "Проверить" action If(
#                rune_draw.check_rune_success(RUNE_CHECKPOINTS, tolerance=80),
#                true=Return(True),
#                false=Return(False)
#            ) xalign 0.5 yalign 1.0
    style drawing_fixed:
        xalign 0.5
        yalign 0.5
        ysize 741
        xsize 600

    menu:

        "Перепрыгнуть яму":
            jump choice1_pit

        "Спрыгнуть в яму":
            jump choice1_deep
        
        "Воспользоваться книгой":
            jump choice1_manual

    label choice1_pit:

        $ menu_flag = False

        "Я вновь попыталась разглядеть у коридора за пропастью конец, но безуспешно."

        a smile "Чтобы понять есть ли там что-то, нужно... добраться туда..."

        stop music fadeout 1.0

        "Подойдя к краю ямы, я сглотнула. Не знаю что чернее, то, что передо мной или подо мной."

        "Несколько раз шагнув назад, я разбежалась и прыгнула."

        scene bg darkness
        with dissolve

        

        a scared "А-а-а-а!"

        play sound hole
        show damage with dissolve

        "Гулкий удар отразился эхом в темноте."
    
        scene bg death
        with dissolve

        "Получена концовка 1/7 - {color=#d81f1f}\"Головная боль\"{/color}."

        return

        jump choice1_done

    label choice1_deep:

        $ menu_flag = True

        "Я не смогу перепрыгнуть, точно нет!"

        a normal "До другого края метров так четыре, на такое способен лишь Райан Гослинг в фильме \"Каскадёры\"... А мне остается только один путь."

        "Я взглянула на книжку в своей руке."

        stop music fadeout 1.0

        a smile brows down "Кто-то из нас должен пойти на разведку, прости."

        "На последок сверкнув застёжками загадочный сборник стихов улетел вниз, прямо во тьму."

        play sound hole

        "Послышался глухой, даже мягкий удар."

        a smile "Со мной всё будет хорошо, точно будет..."

        "Я закрыла глаза и шагнула в пустоту."

        scene bg darkness
        with dissolve

        jump choice1_done
    
    label choice1_manual:

        $ menu_flag = True

        $ use += 1

        $ sh = 1

        "Я вспомнила слова, которыми встретила меня книга, когда я только нашла её."

        a smile "Там было что-то про трудности, точно же было?.."

        "Желая проверить свою память, я вновь распахнула перед собой потёртые листы."

        play sound list

        "Пусто?"

        "Холодеющими пальцами я переворачивала страницу за страницой, пока не наткнулась на ту, что имела хоть какое-то содержание."
        
        nvl clear
        nvle "\n
        \n
        \n
        \n
        \n
        \n
        \n
        \n
        Шаг вперёд тебе не сделать,\n
        Шаг назад забыт давно,\n
        Взяв перо, вложи ты смелость.\n
        \"Перемещение\" - дано."

        a normal "Действительно, сборник стихов. Да ещё и подначивающий к чему-то..."

        "На обратной стороне листа была вычерчена руна, словно в прописях начальных классов. Багровыми точками."

        a normal "\"Жёлтые листы - красным обагри\"..."

        "Передо мной будто сами всплыли слова, прочитанные в предыдущем стихе."

        "Неужели эта книга хочет моей крови?"

        "Отчаявшись, я решила принять этот вызов, всё равно я не допрыгну до того конца пропасти, а \"портить\" своё тело мне было уже не впервой..."

        play sound cut

        "Взяв перо и глубоко вдохнув, я сделала надрез на запястье."

        show sheet1:
            xalign 0.5
            yalign 0.5

        call screen drawing_screen
        if _return:
            hide sheet1
            with flashbulb
            $ win += 1
            play sound book_close
            
            "Когда я закончила выводить непонятную руну, кровь запеклась... Прямо на бумаге!"

            stop music fadeout 1.0

            a scared "Что это? Так не бывает..."

            "Не успела я проникнуться недоумеванием, как тут же у меня потемнело в глазах."

            scene bg darkness
            with dissolve

        else:
            hide sheet1
            with dissolve
            $ lose += 1

            play sound book_close

            "Когда я закончила выводить непонятную руну, ничего не произошло."
            
            stop music fadeout 1.0

            a unhappy "Чёрт, видимо, я сделала что-то не так."

            "Подув на искалеченную руку и небрежно вытерев кровь краем водолазки, я вернула взгляд на временно забытую проблему."

            play music think fadein 1.0

            menu:

                "Перепрыгнуть яму":
                    jump choice1_pit

                "Спрыгнуть в яму":
                    jump choice1_deep
        
        jump choice1_done
    
label choice1_done:

    scene bg darkness
    stop music fadeout 1.0
    
    "Разомкнув веки, я ничего не увидела. Темно, как и в начале моего пути."

    "Интересно, я этим действием стала ближе к выходу или лишь отсрочила встречу с дневным светом?"

    "Правая рука нащупала букву \"М\"."

    a normal "\"М\" - многоразовый?"

    "Довольно улыбнувшись о том, что не растеряла своё остроумие, я выдохнула с облегчением."

    "Терять такую интересную вещь не входило в мои планы."

    "Оперевшись на левую ногу, я встала." 
    
    play sound hrust

    "Под подошвой послышался хруст."

    a look away "Не хочу знать, что это..."

    "Отринув всякие предположения и догадки о том, по чему ступают мои ноги, я продвинулась вперёд."

    scene bg piping hole
    with fade
    play music floor2 loop fadein 3.0

    "Спустя некоторое время начали проявляться очертания стен. Сходясь где-то вдалеке они составляли технический коридор."

    "Ржавые трубы, оплетали стены, подобно каппиляры, пронизывающие прямую кишку."

    "Туннель действительно был очень длинным."

    "Изнурённая скитаниями по жёлтоватым помещениям, я еле перебирала ногами."

    "Капелька за капелькой падали на пол, стекали по стенам, образовывая небольшие лужицы."

    "Так хотелось подставить под них свой язык, ловить их, как белоснежные хлопья в снегопад, избавляясь от сухости во рту."

    "Но не хватало мне подцепить какой-нибудь столбняк, уталяя жажду в непонятном месте непонятным способом."

    "Подойдя ближе к одной из стен, я провела по первой попавшейся трубе пальцем." 

    "Пыльно."

    "Сначала я думала, что меня похитили и встреча с незнакомцем могла означать завершение моего пути."

    "Но теперь я искала хоть малейшую надежду на то, что моё одиночество лишь временная преграда."
    
    "Что вот ещё немного пройти вперёд, и меня встретит свет налобного фонарика, а за ним - дедушка в жёлтом рабочем жилете."

    "Окликнет, отведёт в свою коморку, предложит чай с печеньем."

    "Расскажет, что после воя сирен, люди спустились в бункер, а я потерялась в толпе."

    "Что меня ищут родные, что нечего больше бояться..."

    "Пока я была погружена в свои бредовые фантазии, пыталась вновь найти объяснения происходящему, я не заметила, как дошла до конца туннеля."

    scene bg maze_one
    with dissolve

    "Труб больше не было."

    stop music fadeout 1.0

    "Не было и звука текущей воды."

    "Коридор оборвался и расплылся в развилку. Красный свет, сочившийся из за углов окрасил стены в уже забытый мной цвет."

    "Я будто попала в начало своего пути, когда ещё не нашла ту книгу..."

    "Взглянув на неё я обратила внимание на выделяющийся заломанный уголок листа. Видимо, результат моего неаккуратного обращения с книгой."

    "Я отстегнула ремешки, желая вернуть бумаге изначальный вид, но лист оказался оторван от переплёта. На нём было что-то написанно."
    nvl clear
    nvle"\n
    \n
    \n
    \n
    \n
    \n
    \n
    \n
    Я сначала шёл {i}налево{/i},\n
    потом {i}вправо{/i}, потом - {i}влево{/i},\n
    Выбрал путь {i}направо{/i} вновь,\n
    {b}Вправо-влево{/b}, вновь и вновь." 

    a normal "Снова стишочки?"

    a unhappy "Вот оно как, книжка предложила перерыв на поэзию!"

    a unhappy "Ты уж извини, но в прошлый раз твоя рифма была поинтереснее."

    "Я поправила лист, и застегнула книгу на ремешки, как было."

    "Передо мной всё ещё была развилка."

    a tired "Влево-вправо, ха-ха-ха..."

    a smile "Погодите..."

    play music maze loop fadein 1.0

    play sound groul2

    "Оглушающий вой раздался за моей спиной."

    "Дрожь пробежала по всему телу, пришло осознание, что я не смогу долго бежать."

    "Что мне делать!?"

    menu:
        "Искать дорогу":
            jump choice2_maze
        
        "Воспользоваться книгой":
            jump choice2_book 

    label choice2_maze:
        scene bg maze_one
        with fast_fade
        if maze == '10100101':

            "Я завернула в очередной поворот, но развилки не было."

            "Вдалеке мерцала лампа. Из последних сил я рванула к этому теплому прерывающемуся свету."

            "Неровно ступив в проем, я пошатнулась и упала."

            scene bg elevator2
            show elevator2 at shaking

            play sound elevator_door

            "Раздался грохот."

            "Это был потрёпанный лифт."

            jump choice2_done

        if len(maze)==8 and maze != '10100101':
            $ maze = ''
            $ mis += 1
            #if mis == 1:
            #   "В моей голове пронеслись мысли, что я здесь уже была. Стоит начать путь {b}сначала{/b}."
            
            if mis == 1:
                "В моей голове пронеслись мысли, что я здесь уже была. Стоит начать путь {b}сначала{/b}."
                
                play sound groul1

                "За спиной пронёсся хриплый крик существа."

                "ОНО меня догоняет."

                "Мне нельзя ошибиться в выборе поворота {b}ещё раз{b}."
            if mis == 2:
                play sound hole
                "Что-то налетело на меня сзади, повалив на пол."
                
                scene bg darkness
                play sound bloodblow
                with flashblood

                play sound bloodblow
                play sound clothdie
                "Острые когти впились в спину. Треск разрывающейся ткани практически полностью заглушал мои крики."

                play sound bloodblow
                scene bg darkness
                with flashblood

                "Лопатки будто ошпарило кипятком, водолазку обагрила кровь, но я не могла этого видеть."

                
                scene bg darkness
                play sound bloodblow
                with flashblood
                play sound hole
                "Существо, вцепившись ещё глубже в мою плоть, швырнуло меня в стену."

                "Я больше не чувствовала книгу в сжатой руке."

                "Тело сделалось парализованным. Не пошевелиться."

                "Только сейчас я открыла глаза, налившиеся слезами, и увидела его."

                scene bg monster
                with dissolve

                play sound roar2

                "Сутулое чудище, стояло надо мной, оскалившись в злобной улыбке."
                
                play sound moblojo
                "Слюна капнула мне на лицо."

                "Это был не человек."

                "Скоро и я перестану быть им, преобразившись остывающим телом."

                a scared "П-простите..."

                "Я хотела извиниться за всё. Перед всем миром."

                "Но мой последний хрип услышит лишь этот кошмар."

                show monster at hpunch

                play sound bloodblow
                "Пасть существа открылась неестественно широко и вцепилась в моё горло."

                scene bg darkness
                with fade
                play sound yummy

                "В глазах потемнело, по глотке потекла моя же кровь."

                stop music fadeout 1.0
                "Кашель с силой отдал в затылок и мои веки схлопнулись."

                scene bg meat 
                with dissolve

                "Получена концовка 2/7 - {color=#d81f1f}\"Пища\"{/color}."

                return
            jump choice2_maze
        menu:
            "Пойти налево":
                jump choice2_left
            "Пойти направо":
                jump choice2_right
           
        label choice2_left:
            scene bg maze trail left
            with fast_fade
            "Я побежала налево..."
            $ maze += '1'
            "Пока не уткнулась в очередную развилку."
            jump choice2_maze

        label choice2_right:
            scene bg maze trail right
            with fast_fade
            "Я побежала направо..."
            $ maze += '0'
            "Пока не уткнулась в очередную развилку."  
            jump choice2_maze              
        
    label choice2_book: 

        $ sh = 2

        if use == 0:

            $ use += 1
            "Я вспомнила слова, которыми встретила меня книга, когда я только нашла её."

            a smile "Там было что-то про трудности, точно же было?.."

            "Желая проверить свою память, я вновь распахнула перед собой потёртые листы."

            play sound list

            "Пусто?"

            "Холодеющими пальцами я переворачивала страницу за страницой, пока не наткнулась на ту, что имела хоть какое-то содержание."

            nvl clear
            nvle"\n
            \n
            \n
            \n
            \n
            \n
            \n
            \n
            Путь забыть здесь может каждый,\n
            Чтоб от Этого сбежать,\n
            Тебе может Друг отважный\n
            \"Ясновидение\" дать."

            a normal "Действительно, сборник стихов. Да ещё и подначивающий к чему-то..."

            "На обратной стороне листа была вычерчена руна, словно в прописях начальных классов. Багровыми точками."

            a normal "\"Жёлтые листы - красным обагри\"..."

            "Передо мной будто сами всплыли слова, прочитанные в предыдущем стихе."

            "Неужели эта книга хочет моей крови?"

            "Отчаявшись, я решила принять этот вызов, всё равно я не допрыгну до того конца пропасти, а \"портить\" своё тело мне было уже не впервой..."

            play sound cut

            "Взяв перо и глубоко вдохнув, я сделала надрез на запястье."

            show sheet2:
                xalign 0.5
                yalign 0.5

            call screen drawing_screen
            if _return:
                hide sheet2
                with flashbulb
                $ win += 1
                play sound book_close
                "Когда я закончила выводить непонятную руну, кровь запеклась... Прямо на бумаге!"

                a scared "Что это? Так не бывает..."

                "Я не успела договорить. Мои губы будто бы онемели, а ноги зашагали сами собой."

                show maze with fast_fade

                "Я не заметила, как уже бежала по лабиринту, минуя одну развилку за другой."

                show maze with fast_fade

                "В голове было пусто."
                    
                show maze with fast_fade

                "Так продолжалось до тех пор, пока я не увидела мерцающую вдалеке лампу."

                "Неровно ступив в проем, я пошатнулась и упала."

                scene bg elevator2
                show elevator2 at shaking
                play sound elevator_door

                "Раздался грохот."

                "Это был потрёпанный лифт."

                jump choice2_done

            else:
                hide sheet2
                with dissolve
                $ lose += 1
                play sound book_close
                "Когда я закончила выводить непонятную руну, ничего не произошло."
                
                a unhappy "Чёрт, видимо, я сделала что-то не так."

                "Подув на искалеченную руку и небрежно вытерев кровь краем водолазки, я вернула взгляд на временно забытую проблему."

                menu:
                    "Искать дорогу":
                        jump choice2_maze

        if use == 1:

            $ use += 1 
        
            if win == 1:
                
                "Один раз я уже доверилась книге, и это сработало. К тому же тогда всё обошлось \"малой кровью\"."

                a look away "Не хочу рисковать..."

                "Вдруг сейчас иного пути нет? Лучше снова истерзать себя самолично."

                "Я вновь нашла страницу со стихом."

                nvl clear
                nvle"\n
                \n
                \n
                \n
                \n
                \n
                \n
                \n
                Путь забыть здесь может каждый,\n
                Чтоб от Этого сбежать,\n
                Тебе может Друг отважный\n
                \"Ясновидение\" дать."

                a unhappy "Выходит, книга даёт новую руну под каждую ситуацию."

                a normal "Мне просто нужно повторить то, что я сделала в прошлый раз, верно?"

                play sound cut

                "Взяв перо, я сделала надрез на запястье."

                show sheet2:
                    xalign 0.5
                    yalign 0.5

                call screen drawing_screen
                if _return:
                    hide sheet2
                    with flashbulb
                    $ win += 1
                    play sound book_close
                    "Когда я закончила выводить новую руну, кровь вновь запеклась на листе."

                    a normal "Отлично! Значит я всё сделала.."

                else:
                    hide sheet2
                    with dissolve
                    $ lose += 1
                    play sound book_close
                    "Когда я закончила выводить непонятную руну, ничего не произошло."
                    
                    a "- Чёрт, видимо, я сделала что-то не так."

                    "Подув на искалеченную руку и небрежно вытерев кровь краем водолазки, я вернула взгляд на временно забытую проблему."

                    menu:
                        "Искать дорогу":
                            jump choice2_maze

                "Я не успела договорить. Мои губы будто бы онемели, а ноги зашагали сами собой."

                show maze with fast_fade

                "Я не заметила, как уже бежала по лабиринту, минуя одну развилку за другой."

                show maze with fast_fade

                "В голове было пусто."
                
                show maze with fast_fade

                "Так продолжалось до тех пор, пока я не увидела мерцающую вдалеке лампу."

                "Неровно ступив в проем, я пошатнулась и упала."

                scene bg elevator2
                show elevator2 at shaking
                play sound elevator_door

                "Раздался грохот."

                "Это был потрёпанный лифт."

            if lose == 1:

                "Я никогда не училась на своих ошибках."

                "Меняя маску, я очищала свою \"историю\" и надеялась, что всё сложится иначе." 

                "Так, по всей видимости, произошло и сейчас."

                a normal "В тот раз я вывела руну неаккуратно, я хочу верить в волшебство этой книги."

                "Я ещё быстрее нашла страницу со стихом, чем раньше."

                nvl clear
                nvle"\n
                \n
                \n
                \n
                \n
                \n
                \n
                \n
                Путь забыть здесь может каждый,\n
                Чтоб от Этого сбежать,\n
                Тебе может Друг отважный\n
                \"Ясновидение\" дать."

                a unhappy "Выходит, книга даёт новую руну под каждую ситуацию."

                a smile "Главное не ошибиться во второй раз."

                play sound cut

                "Взяв перо и глубоко вдохнув, я сделала надрез на запястье."

                show sheet2:
                    xalign 0.5
                    yalign 0.5

                call screen drawing_screen
                if _return:
                    hide sheet2
                    with flashbulb
                    $ win += 1

                    if win == 1:

                        play sound book_close

                        "Когда я закончила выводить непонятную руну, кровь запеклась... Прямо на бумаге!"
                        
                        a normal "Что это? Так не бывает..."

                    if win == 2:

                        play sound book_close
                    
                        "Когда я закончила выводить новую руну, кровь вновь запеклась на листе."

                        a normal "Отлично! Значит я всё сделала.."

                    "Я не успела договорить. Мои губы будто бы онемели, а ноги зашагали сами собой."

                    show maze with fast_fade

                    "Я не заметила, как уже бежала по лабиринту, минуя одну развилку за другой."

                    show maze with fast_fade

                    "В голове было пусто."
                    
                    show maze with fast_fade

                    "Так продолжалось до тех пор, пока я не увидела мерцающую вдалеке лампу."

                    "Неровно ступив в проем, я пошатнулась и упала."

                    scene bg elevator2
                    show elevator2 at shaking
                    play sound elevator_door

                    "Раздался грохот."

                    "Это был потрёпанный лифт."

                    jump choice2_done

                else:
                    hide sheet2
                    with dissolve
                    $ lose += 1

                    play sound book_close

                    "Когда я закончила выводить непонятную руну, ничего не произошло."
                    
                    stop music fadeout 1.0

                    a unhappy "Опять!? Что я снова делаю не так?"

                    scene bg hand1
                    with dissolve

                    "Переведя взгляд на свою руку, я увидела ужасающую картину."

                    play sound bloodblow
                    scene bg hand2
                    show hand2 at shaking

                    "Видимо, насколько я глубоко погрузилась в свои мысли, настолько же и глубоко прошла пером по запястью."

                    play sound bloodblow
                    scene bg hand3
                    show hand3 at hpunch

                    "Густая кровь медленно залила собой всё предплечие."

                    play sound bloodblow
                    scene bg hand3
                    show hand3 at hpunch

                    "В спешке, я попыталась оторвать рукав своей водолазки, чтобы перевязать руку, но мне не хватило сил."

                    "Да и чем бы это помогло?"

                    "В глазах помутнело, а вой, ничем не похожий на собачий, всё приближался."

                    play sound hole

                    "Перестав чувствовать кончики пальцев, я упала на колени."

                    scene bg darkness
                    with fade

                    "А вскоре за этим, лишилась всяких чувств."

                    "Получена концовка 4/7 - {color=#d81f1f}\"Жертва самой себя\"{/color}."

                    return
            
label choice2_done:

    scene bg elevator2
    play sound elevator_door

    "Дверцы, будто ждали меня, ведь начали закрываться, когда я уже без сил сидела в нём."

    play music elevator loop

    scene bg elevator
    with dissolve

    "Дыхание сбилось."

    "Сердце так и хочет выпрыгнуть из груди."

    'Я глотала воздух, но ощущала лишь солоноватый вкус своей слюны.'

    play sound breaking

    "Что-то, что преследовало меня, с силой ударилось в двери лифта." 
    
    "Донёсся скрежет, оно ломится внутрь."

    scene bg elevator3
    show elevator3 at shaking
    play sound funnyjoke
    "Показалась багровая рука."

    "Затем сверкнул глаз. Животный взгляд..."

    "Когда он пробежался по моему трясущемуся телу, я почувствовала себя загнанной в угол куропаткой."

    play sound roar1

    "Раздался рык."

    "Или это смех?"

    "Как зверь может смеяться?"

    a scared "Н-не трогай меня!"

    "Набрав побольше воздуха в грудь, я продолжила."

    a scared "Оставь меня! Отпусти!"

    play sound groul1

    "Почему-то мне показалось, что существо слышит меня. Как-то сможет понять, а затем - отпустит."

    "Теплилась толика надежды, что ему хватит простой игры в догонялки."

    show elevator3 at vpunch
    play sound lamp

    "Лифт тряхнуло ещё сильнее." 

    scene bg darkness 
    with fast_fade
    
    "Я зажмурилась, чтобы не видеть его перед собой, закрыла руки ушами, чтобы не слышать, и закричала."

    "Вторя моему визгу, зажужжал двигатель."

    scene bg elevator
    with dissolve

    "Осмелившись посмотреть, добралось ли чудище до меня, я обнаружила, что лифтовая дверь закрыта."

    "Я была одна, под мерцающей лампой, под защитой хлипких механических дверей."

    scene bg darkness
    with fade

    "Обессиленная, я легла на потёртый пол и провалилась в сон."

    scene bg elevator
    with dissolve
    play sound elevator_door

    "Пришла в себя я только тогда, когда лифт приехал на новый для меня этаж."

    "Подобрав и отряхнув книгу, что я в панике выпустила из рук ранее, я вышла из спасшего меня короба."

    scene bg elevator2

    a normal "Т-трава?.."

    scene bg garden
    with fade
    play music floor3 loop fadein 3.0

    "Солнечный свет, пробивался через широкие панорамные окна, устилая собой зацветший этаж. 
    Серые бетонные стены контрастировали на фоне зелени, сверкающей под лучами."

    "Я обратила внимание на лампы, притаившиеся у потолка. \"Интересно, они здесь вообще нужны?\" - пронеслось в голове."

    "Это был первый коридор, который вызвал во мне какие-либо приятные чувства."

    "Я вспомнила, как в средней школе носилась с друзьями по заброшкам."

    "Как мы пугались теней, с опаской обходили шприцы неизвесного происхождения."

    "Как встретили однажды группу пьяных старшеклассников, а потом удирали от неё, сверкая пятками."

    a smile brows up "С тех пор многое изменилось..."

    "Травка приминалась подо мной. Было жаль оставлять в месте, не тронутом человеком, какие-либо свои следы."

    "Но я шла дальше."

    "Хотелось скорее добраться домой... Именно, что домой."

    "Место, где я жила, я уже не могла назвать домом."

    "Постоянные ругань, недопонимания, ощущение, что я обязана всем на свете, а мне никто ничего не должен."

    "Родительская отстранённость от моей жизни, но в то же время их надзор и контроль в вещах, с которыми хочется разобраться самой..."

    "После того, как я перестала ночевать у него, ситуация накалилась ещё сильней..."

    "Меня передёрнуло."

    a unhappy "Чёрт!"

    a "Ну вот почему как только вокруг всё стало спокойней, так в мою голову начала лезть всякая дрянь!"

    "В попытках подумать о чём-то хорошем, я снова вспомнила его. Вспомнила нас."

    "Наши посиделки до утра."

    "Наши ежедневные звонки."

    "Как мы гуляли в парке, катались на аттракционах."

    "Его тёплый взгляд, крепкие, доводящие до мурашек и ускоряющие сердцебиение объятия." 
    
    "Без его поддержки я бы до сих пор боялась высоты..."

    "Я любила в нём всё: от того, как он пахнет, до того, как он умеет подбирать нужные слова."

    "А потом он умело придумал, с какими словами всё закончить."

    scene bg garden monster1
    with dissolve
    play music figure loop fadein 3.0

    "Вдалеке появилась фигура."

    "Скаканувший адреналин вышиб из меня все преждние ностальгические порывы."

    a normal "А это ещё что?"

    "Я прищурила глаза, чтобы ответить на свой вопрос, но ненароком сомкнула их."

    scene bg garden monster2
    with fast_fade

    "Открыла."

    a scared "А-А-А!"

    "Я подскочила на месте. Неизвестное за долю секунды добралось до меня с другого конца коридора."

    play sound hrip2

    d "Шщхр!"

    "Существо, облоченное в некое подобие мантии, перетекающей в головной убор, прерывисто захрипело. Его руки были сложены в замок."

    "Сравнивая со зверем, что преследовал меня до лифта, это не выглядело так устрашающе. Но его способности были за пределами человеческих."

    "Желает ли фигура причинить мне вред?"

    "Нет времени думать, нужно действовать. Иначе может быть поздно."

    menu:
        "Убежать":
            jump choice3_run
        
        "Спросить":
            jump choice3_talk
        
        "Воспользоваться книгой":
            jump choice3_manual
    label choice3_run:

        "Нет, это место мне не радо."

        "Естественный свет, растительность, уют - это всё здесь для того, чтобы ослабить мою бдительность. Заставить поверить в чудо."

        "Я не успела далеко уйти от лифта. Только там есть двери. Двери, уже защитившие меня однажды."

        "План таков: развернуться и побежать к спасительному коробу, единственному месту здесь, где я чувствую себя в безопасности."

        scene bg garden monster3
        with fast_fade

        play sound hripq

        d "Цхюлуъ щв фл штъяжляг?"

        "Мантия возникла в метре от меня. Пора бежать!"

        scene bg garden mirrored
        with fast_fade

        "Я развернулась."

        play sound hrust

        "И раздался хруст."

        scene bg darkness
        with fast_fade
        play sound hrip2

        d "Щлзл шщхптх цхйхихчпщг шх уфхр."

        scene bg dead girl 
        with dissolve 

        "Получена концовка 3/7 - {color=#d81f1f}\"Сломанная\"{/color}."

        return

    label choice3_talk:

        "Мне пришлось приложить усилия, чтобы поднять застывший от ужаса язык."

        a scared "К-кто т-ты?"

        "Мои губы дрожали. Зачем я вообще решилась на это?"

        "\"Разговор\" в лифте должен был дать понять, что здесь нельзя рассчитывать на то, что тебя услышат, поймут."

        "Прям как дома."

        play sound hrip2

        d "Ё - шухщчпщлтг дщхйх улшщж. Клуж."

        "То, что одето в мантию, ответило мне. Точно ответило!"

        "Значит, интуиция меня не подвела?"

        a normal "Т-тебя {color=#099268}К-клуж{/color} зовут?"

        "Я всё ещё не могла говорить ровно."

        play sound hripq

        k "Кж."

        "Хрип существа прозвучал одобрительно."

        play music floor3 loop fadein 3.0

        play sound hrip2

        k "Ё кжифх штлкпт ож щхзхр, щв цхющп ъ элтп."

        "Я не понимала его речь, но мне почему-то стало спокойнее."

        "Меня будто ткнули носом в реальность и сказали: \"Смотри, ещё не всё поглотило отчаяние!\""

        a smile "Значит, ты не желаешь меня убить?"

        play sound hrip1

        k "Щхщ Ужфъжт, ющх щв фжятж и фжюжтл цъщп..."

        if win == 0:

            k "Ё чжк, ющх щв лйх фл пшцхтгохижтж."

        if win == 1:

            k "Хф шихкпщ щлзё ш илчфхйх цъщп."

        if win == 2:

            k "Ихшцхтгохижияпшг пу п шлрюжш, щв зв шхятж ш цъщп фжишлйкж."

        "В этом хрипе нельзя было ничего разобрать. Совсем."

        "Посчитав, что он уже сказал всё, что хотел, я попрощалась."

        a smile "Было прятно встретить Вас, {color=#099268}Клуж{/color}, досвидания!"

        play sound hripq

        k "Шщъцжр, {color=#9e529c}Жрчж{/color}, фл ожзъкг съцпщг тлсжчшщиж."

        scene bg garden
        with dissolve

        "Обойдя существо, я пошла дальше по дивному саду, заключённому в бетонных стенах."

        jump choice3_done



    label choice3_manual:
    
        $ sh = 3

        if use == 0:
            $ use += 1
            "Я вспомнила слова, которыми встретила меня книга, когда я только нашла её."

            a smile "Там было что-то про трудности, точно же было?.."

            "Желая проверить свою память, я вновь распахнула перед собой потёртые листы."

            play sound list

            "Пусто?"

            "Холодеющими пальцами я переворачивала страницу за страницой, пока не наткнулась на ту, что имела хоть какое-то содержание."

            nvl clear
            nvle"\n
            \n
            \n
            \n
            \n
            \n
            \n
            \n
            Эта руна - силы олицетворение,\n
            Всё, что хочешь, сможет дать.\n
            Не окажет ей никто сопротивление,\n
            И название ей - \"Власть\"."

            a normal "Действительно, сборник стихов. Да ещё и подначивающий к чему-то..."

            "На обратной стороне листа была вычерчена руна, словно в прописях начальных классов. Багровыми точками."

            a normal "\"Жёлтые листы - красным обагри\"..."

            "Передо мной будто сами всплыли слова, прочитанные в предыдущем стихе."

            "Неужели эта книга хочет моей крови?"

            "Отчаявшись, я решила принять этот вызов, всё равно я не допрыгну до того конца пропасти, а \"портить\" своё тело мне было уже не впервой..."

            play sound cut

            "Взяв перо и глубоко вдохнув, я сделала надрез на запястье."

            show sheet3:
                xalign 0.5
                yalign 0.5

            call screen drawing_screen
            if _return:
                hide sheet3
                with flashbulb
                $ win += 1
                play sound book_close
                "Когда я закончила выводить непонятную руну, кровь запеклась... Прямо на бумаге!"

                a scared "Что это? Так не бывает..."

                scene bg garden monster2
                with fast_fade

                "Мысли всегда быстрее слов." 
                        
                "Даже те люди, о которых говорят \"сначала делают - потом думают\", имеют в подсознании выверенный план, список желаний, ожидающий своего исполнения."

                play sound hripq

                d "Щв пшцхтгохижтж лйх? Ш сжсхр элтге щв йъзпяг шлзё?"

                "Фигура вновь захрипела, но прямо сейчас я хотела одного - избавиться от неё. Разнести в пух и прах преграду, что стоит на моём пути."

                scene bg garden
                with dissolve

                "И стоило мне представить, что мантия растворяется в воздухе, как она и в самом деле исчезла."

                a smile "Ха! Получилось!"

                "Устранив помеху, я вприпрыжку пошла дальше по дивному саду, заключённому в бетонных стенах."

                jump choice3_done
                    

            else:
                hide sheet3
                with dissolve
                $ lose += 1
                play sound book_close
                "Когда я закончила выводить непонятную руну, ничего не произошло."
                    
                a unhappy "Чёрт, видимо, я сделала что-то не так."

                "Подув на искалеченную руку и небрежно вытерев кровь краем водолазки, я вернула взгляд на временно забытую проблему."

                menu:
                    "Убежать":
                        jump choice3_run
                        
                    "Спросить":
                        jump choice3_talk
        
        if use == 1:
            
            $ use += 1

            if win == 1:
                
                "Один раз я уже доверилась книге, и это сработало. К тому же тогда всё обошлось \"малой кровью\"."

                a look away "Не хочу рисковать..."

                "Вдруг сейчас иного пути нет? Лучше снова истерзать себя самолично."

                "Я вновь нашла страницу со стихом."

                nvl clear
                nvle"\n
                \n
                \n
                \n
                \n
                \n
                \n
                \n
                Эта руна - силы олицетворение,\n
                Всё, что хочешь, сможет дать.\n
                Не окажет ей никто сопротивление,\n
                И название ей - \"Власть\"."

                a unhappy "Выходит, книга даёт новую руну под каждую ситуацию."

                a normal "Мне просто нужно повторить то, что я сделала в прошлый раз, верно?"

                play sound cut

                "Взяв перо, я сделала надрез на запястье."

                show sheet3:
                    xalign 0.5
                    yalign 0.5

                call screen drawing_screen
                if _return:
                    hide sheet3
                    with flashbulb
                    $ win += 1
                    play sound book_close
                    "Когда я закончила выводить новую руну, кровь вновь запеклась на листе."

                    a normal "Отлично! Значит я всё сделала.."

                    "Мысли всегда быстрее слов." 
                        
                    "Даже те люди, о которых говорят \"сначала делают - потом думают\", имеют в подсознании выверенный план, список желаний, ожидающий своего исполнения."

                    play sound hripq

                    d "Щв пшцхтгохижтж лйх? Ш сжсхр элтге щв йъзпяг шлзё?"

                    "Фигура вновь захрипела, но прямо сейчас я хотела одного - избавиться от неё. Разнести в пух и прах преграду, что стоит на моём пути."

                    scene bg garden
                    with dissolve

                    "И стоило мне представить, что мантия растворяется в воздухе, как она и в самом деле исчезла."

                    a smile "Ха! Получилось!"

                    "Устранив помеху, я вприпрыжку пошла дальше по дивному саду, заключённому в бетонных стенах."

                    jump choice3_done

                else:
                    hide sheet3
                    with dissolve
                    $ lose += 1
                    play sound book_close
                    "Когда я закончила выводить непонятную руну, ничего не произошло."
                        
                    a "- Чёрт, видимо, я сделала что-то не так."

                    "Подув на искалеченную руку и небрежно вытерев кровь краем водолазки, я вернула взгляд на временно забытую проблему."

                    menu:
                        "Убежать":
                            jump choice3_run
                            
                        "Спросить":
                            jump choice3_talk

            if lose == 1:

                    "Я никогда не училась на своих ошибках."

                    "Меняя маску, я очищала свою \"историю\" и надеялась, что всё сложится иначе." 

                    "Так, по всей видимости, произошло и сейчас."

                    a normal "В тот раз я вывела руну неаккуратно, я хочу верить в волшебство этой книги."

                    "Я ещё быстрее нашла страницу со стихом, чем раньше."

                    nvl clear
                    nvle"\n
                    \n
                    \n
                    \n
                    \n
                    \n
                    \n
                    \n
                    Эта руна - силы олицетворение,\n
                    Всё, что хочешь, сможет дать.\n
                    Не окажет ей никто сопротивление,\n
                    И название ей - \"Власть\"."

                    a unhappy "Выходит, книга даёт новую руну под каждую ситуацию."

                    a smile "Главное не ошибиться во второй раз."

                    play sound cut

                    "Взяв перо и глубоко вдохнув, я сделала надрез на запястье."

                    show sheet3:
                        xalign 0.5
                        yalign 0.5

                    call screen drawing_screen
                    if _return:
                        hide sheet3
                        with flashbulb
                        $ win += 1

                        play sound book_close

                        "Когда я закончила выводить непонятную руну, кровь запеклась... Прямо на бумаге!"
                            
                        a normal "Что это? Так не бывает..."

                        "Мысли всегда быстрее слов." 
                        
                        "Даже те люди, о которых говорят \"сначала делают - потом думают\", имеют в подсознании выверенный план, список желаний, ожидающий своего исполнения."

                        play sound hripq

                        d "Щв пшцхтгохижтж лйх? Ш сжсхр элтге щв йъзпяг шлзё?"

                        "Фигура вновь захрипела, но прямо сейчас я хотела одного - избавиться от неё. Разнести в пух и прах преграду, что стоит на моём пути."

                        scene bg garden
                        with dissolve

                        "И стоило мне представить, что мантия растворяется в воздухе, как она и в самом деле исчезла."

                        a smile "Ха! Получилось!"

                        "Устранив помеху, я вприпрыжку пошла дальше по дивному саду, заключённому в бетонных стенах."

                    else:
                        hide sheet3
                        with dissolve
                        $ lose += 1

                        play sound book_close

                        "Когда я закончила выводить непонятную руну, ничего не произошло."
                        
                        stop music fadeout 1.0

                    a unhappy "Опять!? Что я снова делаю не так?"

                    scene bg hand1
                    with dissolve

                    "Переведя взгляд на свою руку, я увидела ужасающую картину."

                    play sound bloodblow
                    scene bg hand2
                    show hand2 at shaking

                    "Видимо, насколько я глубоко погрузилась в свои мысли, настолько же и глубоко прошла пером по запястью."

                    play sound bloodblow
                    scene bg hand3
                    show hand3 at hpunch

                    "Густая кровь медленно залила собой всё предплечие."

                    play sound bloodblow
                    scene bg hand3
                    show hand3 at hpunch

                    "В спешке, я попыталась оторвать рукав своей водолазки, чтобы перевязать руку, но мне не хватило сил."

                    "Да и чем бы это помогло?"

                    "В глазах помутнело, а вой, ничем не похожий на собачий, всё приближался."

                    play sound hole

                    "Перестав чувствовать кончики пальцев, я упала на колени."

                    scene bg darkness
                    with fade

                    "А вскоре за этим, лишилась всяких чувств."

                    "Получена концовка 4/7 - {color=#d81f1f}\"Жертва самой себя\"{/color}."

                    return

        if use ==  2:
            $ use += 1
            if win == 2:
                "Я использую книгу. Иначе быть не может. Это единственное верное решение, гарантия успеха."
                
                a smile brows up "Я уже предвкушаю сладость победы."
                
                "Без лишних мыслей, я уже читала новый стих."
                
                nvl clear
                nvle"\n
                \n
                \n
                \n
                \n
                \n
                \n
                \n
                Эта руна - силы олицетворение,\n
                Всё, что хочешь, сможет дать.\n
                Не окажет ей никто сопротивление,\n
                И название ей - \"Власть\"."

                a smile brows up "Третья руна оправдала все мои ожидания!"

                "Самое мощное заклинание было оставлено на последок. Не могу ждать!"

                play sound cut
                
                "Взяв перо, я пустила кровь."

                show sheet3:
                    xalign 0.5
                    yalign 0.5

                call screen drawing_screen
                if _return:
                    hide sheet3
                    with flashbulb
                    $ win += 1
                    play sound book_close
                    
                    "Когда я закончила выводить символ своего превосходства, кровь утвердила моё положение."
                    
                    a smile "Да! Вот так! Теперь я..."

                    "Мысли всегда быстрее слов." 
                        
                    "Даже те люди, о которых говорят \"сначала делают - потом думают\", имеют в подсознании выверенный план, список желаний, ожидающий своего исполнения."

                    play sound hripq

                    d "Щв пшцхтгохижтж лйх? Ш сжсхр элтге щв йъзпяг шлзё?"

                    "Фигура вновь захрипела, но прямо сейчас я хотела одного - избавиться от неё. Разнести в пух и прах преграду, что стоит на моём пути."

                    scene bg garden
                    with dissolve

                    "И стоило мне представить, что мантия растворяется в воздухе, как она и в самом деле исчезла."

                    a smile "Ха! Получилось!"

                    "Устранив помеху, я вприпрыжку пошла дальше по дивному саду, заключённому в бетонных стенах."

                    jump choice3_done
                    

                else:
                    hide sheet3
                    with dissolve
                    $ lose += 1
                    play sound book_close
                    "Когда я закончила выводить непонятную руну, ничего не произошло."
                    
                    a unhappy "Чёрт, видимо, я сделала что-то не так."

                    "Подув на искалеченную руку и небрежно вытерев кровь краем водолазки, я вернула взгляд на временно забытую проблему."

                    menu:
                        "Убежать":
                            jump choice3_run
                        
                        "Спросить":
                            jump choice3_talk



            if win == 1 and lose == 1:

                a normal "Одна победа, одно поражение - вот моя статистика."
                
                "Даже если я допущу ошибку, книга не даст мне пропасть. Она и так берёт взамен на волшебство кровь. Справедливая плата."
                
                "Полностью вверив свою судьбу книге, я читала новый стих."

                nvl clear
                nvle"\n
                \n
                \n
                \n
                \n
                \n
                \n
                \n
                Эта руна - силы олицетворение,\n
                Всё, что хочешь, сможет дать.\n
                Не окажет ей никто сопротивление,\n
                И название ей - \"Власть\"."

                a smile brows up "Третья руна оправдала все мои ожидания!"

                "Власть... Интересно, какая же сила заключена в этой руне?"

                play sound cut 

                "Взяв перо, я сделала надрез на запястье."

                show sheet3:
                        xalign 0.5
                        yalign 0.5

                call screen drawing_screen
                if _return:
                    hide sheet3
                    with flashbulb
                    $ win += 1

                    play sound book_close

                    "Когда я закончила выводить непонятную руну, кровь запеклась... Прямо на бумаге!"
                            
                    a normal "Что это? Так не бывает..."

                    "Мысли всегда быстрее слов." 
                        
                    "Даже те люди, о которых говорят \"сначала делают - потом думают\", имеют в подсознании выверенный план, список желаний, ожидающий своего исполнения."

                    play sound hripq

                    d "Щв пшцхтгохижтж лйх? Ш сжсхр элтге щв йъзпяг шлзё?"

                    "Фигура вновь захрипела, но прямо сейчас я хотела одного - избавиться от неё. Разнести в пух и прах преграду, что стоит на моём пути."

                    scene bg garden
                    with dissolve

                    "И стоило мне представить, что мантия растворяется в воздухе, как она и в самом деле исчезла."

                    a smile "Ха! Получилось!"

                    "Устранив помеху, я вприпрыжку пошла дальше по дивному саду, заключённому в бетонных стенах."

                    jump choice3_done

                else:
                    hide sheet3
                    with dissolve
                    $ lose += 1

                    play sound book_close

                    "Когда я закончила выводить непонятную руну, ничего не произошло."
                    
                    stop music fadeout 1.0

                    a unhappy "Опять!? Что я снова делаю не так?"

                    scene bg hand1
                    with dissolve

                    "Переведя взгляд на свою руку, я увидела ужасающую картину."

                    play sound bloodblow
                    scene bg hand2
                    show hand2 at shaking

                    "Видимо, насколько я глубоко погрузилась в свои мысли, настолько же и глубоко прошла пером по запястью."

                    play sound bloodblow
                    scene bg hand3
                    show hand3 at hpunch

                    "Густая кровь медленно залила собой всё предплечие."

                    play sound bloodblow
                    scene bg hand3
                    show hand3 at hpunch

                    "В спешке, я попыталась оторвать рукав своей водолазки, чтобы перевязать руку, но мне не хватило сил."

                    "Да и чем бы это помогло?"

                    "В глазах помутнело, а вой, ничем не похожий на собачий, всё приближался."

                    play sound hole

                    "Перестав чувствовать кончики пальцев, я упала на колени."

                    scene bg darkness
                    with fade

                    "А вскоре за этим, лишилась всяких чувств."

                    "Получена концовка 4/7 - {color=#d81f1f}\"Жертва самой себя\"{/color}."

                    return



label choice3_done:

    "Что же это за место такое?"

    "Чудоковатые коридоры, таинственная книга, что до сих пор путешествует со мной." 

    "Различные монстры..."

    scene bg darkness
    stop music fadeout 1.2
    with sunstrike

    "Следующий мой шаг был сопровождён яркой вспышкой, со стороны окна. Солнце погасло."


    scene bg darkness

    "Темно."

    "Ну, а чего я ещё ожидала, закрыв глаза?"

    scene bg ending neutral
    with fade
    play music hospital loop fadein 3.0

    "Я сидела в кабинете врача."

    "Треск ламп наполнял комнату, усиливая напряжение, которую создавало молчание." 
    
    "Из коридора доносились шаги, стук дверей, что всё открываются и закрываются недовольными тётушками в белых халатах."

    "Куда они вечно торопятся? Зачем бегают из кабинета в кабинет?"

    "Все документы уже давно перенесены в электронный формат, а работа врача - это сидеть в своей белой комнате с синей кушеткой, компьютером и помогать больным."

    "Может они так отлынивают от работы?"

    doc "Айра, всё хорошо?"

    a normal "Да, я просто задумалась..."

    "Незадолго до этого я ещё раз прокрутила всё, что произошло со мной за последний день."

    doc "Ты купила те таблетки, которые я выписал?"

    if use == 1 or use == 2 or (use == 3 and lose != 0):

        a smile "Таблетки?.."

        "Врач выдохнул, снял круглые очки и начал медленно массировать виски."

        doc "Я же на листочке тебе написал, что нужно купить!"

        "Его голос звучал так, будто он обвиняет меня в пренебрежении чем-то очень важным."

        "Нахмурившись, он направил на меня серьёзный взгляд."

        doc "Ты вообще спала сегодня?"

        a tired "Не знаю, может если совсем немного."

        a look away "Перед тем, как попала в технический коридор, в лифте... А потом я оказалась у себя дома."

        "Если я ему расскажу всё, как есть, меня точно отправят в палату номер шесть."

        "Этих монстров видела только я, единственное доказательство, что всё это было реальным - мои свежие порезы на руках."

        "Книга, что волшебным образом избавляла меня от проблем исчезла без следа."

        "Мне стоит как можно скорее закончить этот разговор, чтобы не сболтнуть лишнего."

        a normal "Простите, если Вам от меня больше ничего не нужно, я пойду."

        doc "Мне-то? Это тебе было нужно, чтобы мы разобрались с твоей болезнью, не привлекая родителей. Между прочим, я нарушаю законодательство, помогая тебе."

        "От слова \"болезнь\" по моему телу пробежались мурашки."

        "Мы правда говорили об этом раньше?"

        "Видимо, слово \"болезнь\" подействовало и на доктора, сейчас он смотрел на меня даже как-то грустно, с сожалением."

        doc "Ладно, возьми эти бумаги. Здесь всё написано."

        scene bg ending neutral
        with fast_fade

        "Послушно взяв пару скреплённых листов у доктора, я поднялась со стула и направилась к выходу."

        doc "Айра, зайди сразу в аптеку, не оттягивай на этот раз."

        a normal "Хорошо, доктор. До свидания!"

        scene bg darkness
        with dissolve

        "Он проводил меня глазами. А я пошла в то место, которое хочу называть домом."

        "Аптека как раз по пути."

        scene bg titles5
        with dissolve
        ""

    if use == 3 and lose == 0:

        a smile brows up "Нет, они мне больше не нужны."

        scene bg ending manual
        with dissolve
        play music dark_century loop fadein 3.0

        "Я положила Мануал на стол доктора."

        doc "Не нужны лекарства? С чего это ради?"

        "Врач с недоумением посмотрел на мою книгу."

        doc "И что это вообще такое? Ты стала читать книги о расстройствах?"

        "Его слова вызвали у меня смех. Какая глупость!"

        a smile "ХА-ХА-ХА! Нет, это не просто книга!"

        a smile brows up "Это не сборник стихов, не дневник сумашедшего. В ней есть сила!"

        doc "О чем ты говоришь? О знаниях?"

        scene bg ending neutral
        with dissolve

        play sound book_open

        "Он расстегнул кожаные застёжки. Я была вне терпения от того, чтобы узнать, как доктор удивится моей находке!"

        "С чего мне начать свой рассказ? Может с магического телепорта, осуществлённом книгой?" 
        
        "Или с чудищ, что были мной побеждены?"

        "Нет, всё же стоит поведать ему о всех этажах, на каких я успела побывать, о месте, которое не должно существовать!"

        "Доктор прервал мои размышления сам."

        doc "Чья это кровь, Айра?"

        a smile "Моя, конечно, чья же ещё? Мануал требует пищи, за силу."

        doc "Покажи мне свои руки, быстро!"

        "Наверное, он хочет удостовериться, что чудо-книжка моя. Я засучила рукава."

        scene bg darkness
        with fast_fade

        "Что?"

        "Почему они обе изрезаны по локти? Я же рисовала всего 3 раза..."

        scene bg ending neutral
        with dissolve

        "Я опустила рукава, пока врач что-то говорил." 
        
        "Нет, он ругался, размахивая мануалом прямо перед моим лицом."

        scene bg darkness
        with fast_fade

        play sound bloodblow
        "Я набросилась на него, будто ведомая инстинктом, и укусив за кисть, вырвала Мануал из ослабившей хватку руки доктора."

        "Не оборачиваясь на глупца, я выбежала из кабинета."

        "Это {color=#d81f1f}мой Мануал{/color}."
        "Это {color=#d81f1f}моя сила{/color}." 
        "И я её заполучила {color=#d81f1f}сама{/color}."

        scene bg titles6
        with dissolve
        ""

    if use == 0:

        a normal "Да, вот они."

        scene bg ending pills
        with dissolve
        play music free fadein 3.0

        "Я положила баночку на стол доктора."

        doc "Как твой сон?"

        "Если я ему расскажу всё, как есть, меня точно поставят на учёт."

        "Закулисье? Монстры? Книга, которая способна решить все проблемы и требует за это кровь?"

        "Моё состояние ничуть не облегчается с течением времени."

        "А ещё говорят: \"Время лечит\"..."

        a tired "Ужасно, доктор."

        a "В нём отразились все мои личные переживания, да и к тому же до жути гиперболизированые. Я так и не смогла смириться с одиночеством, найти общий язык с близкими."

        "А может я и зря переживаю. У меня самые обычные проблемы, от которых страдает каждый третий человек."

        "Нужно перестать выдумывать лишнего."

        "Жить сегодняшним, настоящим днём."

        doc "Хорошо, что ты понимаешь важность этого."

        "Врач выдохнул, снял круглые очки и начал медленно массировать виски."

        doc "Таблетки помогут тебе снизить влияние парасомний, снять стресс, но корень проблем способна решить лишь ты сама. Оно может вернуться, понимаешь?"

        "Надеюсь, что не сможет."

        a smile "Спасибо за наставление! Я уже решила, что буду делать дальше."

        scene bg ending neutral
        with dissolve

        "Взяв баночку со стола, я собралась уходить."

        doc "Айра, зайди ко мне через неделю в это же время."

        a smile "Хорошо, дядечка!"

        scene bg darkness
        with dissolve

        "Он улыбнулся мне в след. А я пошла домой."

        scene bg titles7
        with dissolve
        ""
    
    return
